/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.contribution.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "monthlyContributions", "upfrontContributions", "basedOn", "upliftApplied", "effectiveDate", "calcDate"})
public class ApiContributionSummary {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="The contribution ID")
    @NotNull
    private Integer id;
    @JsonProperty(value="monthlyContributions")
    @JsonPropertyDescription(value="The monthly contribution amount")
    private BigDecimal monthlyContributions;
    @JsonProperty(value="upfrontContributions")
    @JsonPropertyDescription(value="The upfront contributions required")
    private BigDecimal upfrontContributions;
    @JsonProperty(value="basedOn")
    @JsonPropertyDescription(value="Indicates what the contributions are based on (e.g. Means assessment)")
    private String basedOn;
    @JsonProperty(value="upliftApplied")
    @JsonPropertyDescription(value="Indicates if an income uplift was applied")
    private String upliftApplied;
    @JsonProperty(value="effectiveDate")
    @JsonPropertyDescription(value="The date the contribution record became effective")
    private LocalDateTime effectiveDate;
    @JsonProperty(value="calcDate")
    @JsonPropertyDescription(value="The date the contribution record was calculated")
    private LocalDateTime calcDate;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiContributionSummary() {
    }

    public ApiContributionSummary(Integer id, BigDecimal monthlyContributions, BigDecimal upfrontContributions, String basedOn, String upliftApplied, LocalDateTime effectiveDate, LocalDateTime calcDate) {
        this.id = id;
        this.monthlyContributions = monthlyContributions;
        this.upfrontContributions = upfrontContributions;
        this.basedOn = basedOn;
        this.upliftApplied = upliftApplied;
        this.effectiveDate = effectiveDate;
        this.calcDate = calcDate;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public ApiContributionSummary withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="monthlyContributions")
    public BigDecimal getMonthlyContributions() {
        return this.monthlyContributions;
    }

    @JsonProperty(value="monthlyContributions")
    public void setMonthlyContributions(BigDecimal monthlyContributions) {
        this.monthlyContributions = monthlyContributions;
    }

    public ApiContributionSummary withMonthlyContributions(BigDecimal monthlyContributions) {
        this.monthlyContributions = monthlyContributions;
        return this;
    }

    @JsonProperty(value="upfrontContributions")
    public BigDecimal getUpfrontContributions() {
        return this.upfrontContributions;
    }

    @JsonProperty(value="upfrontContributions")
    public void setUpfrontContributions(BigDecimal upfrontContributions) {
        this.upfrontContributions = upfrontContributions;
    }

    public ApiContributionSummary withUpfrontContributions(BigDecimal upfrontContributions) {
        this.upfrontContributions = upfrontContributions;
        return this;
    }

    @JsonProperty(value="basedOn")
    public String getBasedOn() {
        return this.basedOn;
    }

    @JsonProperty(value="basedOn")
    public void setBasedOn(String basedOn) {
        this.basedOn = basedOn;
    }

    public ApiContributionSummary withBasedOn(String basedOn) {
        this.basedOn = basedOn;
        return this;
    }

    @JsonProperty(value="upliftApplied")
    public String getUpliftApplied() {
        return this.upliftApplied;
    }

    @JsonProperty(value="upliftApplied")
    public void setUpliftApplied(String upliftApplied) {
        this.upliftApplied = upliftApplied;
    }

    public ApiContributionSummary withUpliftApplied(String upliftApplied) {
        this.upliftApplied = upliftApplied;
        return this;
    }

    @JsonProperty(value="effectiveDate")
    public LocalDateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonProperty(value="effectiveDate")
    public void setEffectiveDate(LocalDateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public ApiContributionSummary withEffectiveDate(LocalDateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @JsonProperty(value="calcDate")
    public LocalDateTime getCalcDate() {
        return this.calcDate;
    }

    @JsonProperty(value="calcDate")
    public void setCalcDate(LocalDateTime calcDate) {
        this.calcDate = calcDate;
    }

    public ApiContributionSummary withCalcDate(LocalDateTime calcDate) {
        this.calcDate = calcDate;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("id".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"id\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setId((Integer)value);
            return true;
        }
        if ("monthlyContributions".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"monthlyContributions\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setMonthlyContributions((BigDecimal)value);
            return true;
        }
        if ("upfrontContributions".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"upfrontContributions\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setUpfrontContributions((BigDecimal)value);
            return true;
        }
        if ("basedOn".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"basedOn\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setBasedOn((String)value);
            return true;
        }
        if ("upliftApplied".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"upliftApplied\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUpliftApplied((String)value);
            return true;
        }
        if ("effectiveDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"effectiveDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setEffectiveDate((LocalDateTime)value);
            return true;
        }
        if ("calcDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"calcDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setCalcDate((LocalDateTime)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("monthlyContributions".equals(name)) {
            return this.getMonthlyContributions();
        }
        if ("upfrontContributions".equals(name)) {
            return this.getUpfrontContributions();
        }
        if ("basedOn".equals(name)) {
            return this.getBasedOn();
        }
        if ("upliftApplied".equals(name)) {
            return this.getUpliftApplied();
        }
        if ("effectiveDate".equals(name)) {
            return this.getEffectiveDate();
        }
        if ("calcDate".equals(name)) {
            return this.getCalcDate();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiContributionSummary with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiContributionSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("monthlyContributions");
        sb.append('=');
        sb.append(this.monthlyContributions == null ? "<null>" : this.monthlyContributions);
        sb.append(',');
        sb.append("upfrontContributions");
        sb.append('=');
        sb.append(this.upfrontContributions == null ? "<null>" : this.upfrontContributions);
        sb.append(',');
        sb.append("basedOn");
        sb.append('=');
        sb.append(this.basedOn == null ? "<null>" : this.basedOn);
        sb.append(',');
        sb.append("upliftApplied");
        sb.append('=');
        sb.append(this.upliftApplied == null ? "<null>" : this.upliftApplied);
        sb.append(',');
        sb.append("effectiveDate");
        sb.append('=');
        sb.append(this.effectiveDate == null ? "<null>" : this.effectiveDate);
        sb.append(',');
        sb.append("calcDate");
        sb.append('=');
        sb.append(this.calcDate == null ? "<null>" : this.calcDate);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.monthlyContributions == null ? 0 : this.monthlyContributions.hashCode());
        result = result * 31 + (this.upliftApplied == null ? 0 : this.upliftApplied.hashCode());
        result = result * 31 + (this.upfrontContributions == null ? 0 : this.upfrontContributions.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.calcDate == null ? 0 : this.calcDate.hashCode());
        result = result * 31 + (this.basedOn == null ? 0 : this.basedOn.hashCode());
        result = result * 31 + (this.effectiveDate == null ? 0 : this.effectiveDate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiContributionSummary)) {
            return false;
        }
        ApiContributionSummary rhs = (ApiContributionSummary)other;
        return (this.monthlyContributions == rhs.monthlyContributions || this.monthlyContributions != null && this.monthlyContributions.equals(rhs.monthlyContributions)) && (this.upliftApplied == rhs.upliftApplied || this.upliftApplied != null && this.upliftApplied.equals(rhs.upliftApplied)) && (this.upfrontContributions == rhs.upfrontContributions || this.upfrontContributions != null && this.upfrontContributions.equals(rhs.upfrontContributions)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.calcDate == rhs.calcDate || this.calcDate != null && this.calcDate.equals(rhs.calcDate)) && (this.basedOn == rhs.basedOn || this.basedOn != null && this.basedOn.equals(rhs.basedOn)) && (this.effectiveDate == rhs.effectiveDate || this.effectiveDate != null && this.effectiveDate.equals(rhs.effectiveDate));
    }
}

