/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.contribution.maat_api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import uk.gov.justice.laa.crime.enums.contribution.TransferStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"contributionFileId", "effectiveDate", "calcDate", "contributionCap", "monthlyContributions", "upfrontContributions", "upliftApplied", "basedOn", "transferStatus", "dateUpliftApplied", "dateUpliftRemoved", "createContributionOrder", "correspondenceId"})
public class ContributionRequest {
    @JsonProperty(value="contributionFileId")
    @JsonPropertyDescription(value="The contribution file ID")
    private Integer contributionFileId;
    @JsonProperty(value="effectiveDate")
    @JsonPropertyDescription(value="The date the contribution record became effective")
    @NotNull
    private LocalDate effectiveDate;
    @JsonProperty(value="calcDate")
    @JsonPropertyDescription(value="The date the contribution record was calculated")
    @NotNull
    private LocalDate calcDate;
    @JsonProperty(value="contributionCap")
    @JsonPropertyDescription(value="The cap that was used when calculating contribution amounts")
    @NotNull
    private BigDecimal contributionCap;
    @JsonProperty(value="monthlyContributions")
    @JsonPropertyDescription(value="The monthly contribution amount")
    @NotNull
    private BigDecimal monthlyContributions;
    @JsonProperty(value="upfrontContributions")
    @JsonPropertyDescription(value="The upfront contributions required")
    private BigDecimal upfrontContributions;
    @JsonProperty(value="upliftApplied")
    @JsonPropertyDescription(value="Indicates if an income uplift was applied")
    private String upliftApplied;
    @JsonProperty(value="basedOn")
    @JsonPropertyDescription(value="Indicates what the contributions are based on (e.g. Means assessment)")
    private String basedOn;
    @JsonProperty(value="transferStatus")
    @JsonPropertyDescription(value="The transfer status of the contribution record")
    @Valid
    private TransferStatus transferStatus;
    @JsonProperty(value="dateUpliftApplied")
    @JsonPropertyDescription(value="The date that an income uplift was applied")
    private LocalDate dateUpliftApplied;
    @JsonProperty(value="dateUpliftRemoved")
    @JsonPropertyDescription(value="The date that an income uplift was removed")
    private LocalDate dateUpliftRemoved;
    @JsonProperty(value="createContributionOrder")
    @JsonPropertyDescription(value="Indicates whether a contribution order should be created")
    private String createContributionOrder;
    @JsonProperty(value="correspondenceId")
    @JsonPropertyDescription(value="The associated correspondence ID")
    private Integer correspondenceId;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ContributionRequest() {
    }

    public ContributionRequest(Integer contributionFileId, LocalDate effectiveDate, LocalDate calcDate, BigDecimal contributionCap, BigDecimal monthlyContributions, BigDecimal upfrontContributions, String upliftApplied, String basedOn, TransferStatus transferStatus, LocalDate dateUpliftApplied, LocalDate dateUpliftRemoved, String createContributionOrder, Integer correspondenceId) {
        this.contributionFileId = contributionFileId;
        this.effectiveDate = effectiveDate;
        this.calcDate = calcDate;
        this.contributionCap = contributionCap;
        this.monthlyContributions = monthlyContributions;
        this.upfrontContributions = upfrontContributions;
        this.upliftApplied = upliftApplied;
        this.basedOn = basedOn;
        this.transferStatus = transferStatus;
        this.dateUpliftApplied = dateUpliftApplied;
        this.dateUpliftRemoved = dateUpliftRemoved;
        this.createContributionOrder = createContributionOrder;
        this.correspondenceId = correspondenceId;
    }

    @JsonProperty(value="contributionFileId")
    public Integer getContributionFileId() {
        return this.contributionFileId;
    }

    @JsonProperty(value="contributionFileId")
    public void setContributionFileId(Integer contributionFileId) {
        this.contributionFileId = contributionFileId;
    }

    public ContributionRequest withContributionFileId(Integer contributionFileId) {
        this.contributionFileId = contributionFileId;
        return this;
    }

    @JsonProperty(value="effectiveDate")
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonProperty(value="effectiveDate")
    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public ContributionRequest withEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @JsonProperty(value="calcDate")
    public LocalDate getCalcDate() {
        return this.calcDate;
    }

    @JsonProperty(value="calcDate")
    public void setCalcDate(LocalDate calcDate) {
        this.calcDate = calcDate;
    }

    public ContributionRequest withCalcDate(LocalDate calcDate) {
        this.calcDate = calcDate;
        return this;
    }

    @JsonProperty(value="contributionCap")
    public BigDecimal getContributionCap() {
        return this.contributionCap;
    }

    @JsonProperty(value="contributionCap")
    public void setContributionCap(BigDecimal contributionCap) {
        this.contributionCap = contributionCap;
    }

    public ContributionRequest withContributionCap(BigDecimal contributionCap) {
        this.contributionCap = contributionCap;
        return this;
    }

    @JsonProperty(value="monthlyContributions")
    public BigDecimal getMonthlyContributions() {
        return this.monthlyContributions;
    }

    @JsonProperty(value="monthlyContributions")
    public void setMonthlyContributions(BigDecimal monthlyContributions) {
        this.monthlyContributions = monthlyContributions;
    }

    public ContributionRequest withMonthlyContributions(BigDecimal monthlyContributions) {
        this.monthlyContributions = monthlyContributions;
        return this;
    }

    @JsonProperty(value="upfrontContributions")
    public BigDecimal getUpfrontContributions() {
        return this.upfrontContributions;
    }

    @JsonProperty(value="upfrontContributions")
    public void setUpfrontContributions(BigDecimal upfrontContributions) {
        this.upfrontContributions = upfrontContributions;
    }

    public ContributionRequest withUpfrontContributions(BigDecimal upfrontContributions) {
        this.upfrontContributions = upfrontContributions;
        return this;
    }

    @JsonProperty(value="upliftApplied")
    public String getUpliftApplied() {
        return this.upliftApplied;
    }

    @JsonProperty(value="upliftApplied")
    public void setUpliftApplied(String upliftApplied) {
        this.upliftApplied = upliftApplied;
    }

    public ContributionRequest withUpliftApplied(String upliftApplied) {
        this.upliftApplied = upliftApplied;
        return this;
    }

    @JsonProperty(value="basedOn")
    public String getBasedOn() {
        return this.basedOn;
    }

    @JsonProperty(value="basedOn")
    public void setBasedOn(String basedOn) {
        this.basedOn = basedOn;
    }

    public ContributionRequest withBasedOn(String basedOn) {
        this.basedOn = basedOn;
        return this;
    }

    @JsonProperty(value="transferStatus")
    public TransferStatus getTransferStatus() {
        return this.transferStatus;
    }

    @JsonProperty(value="transferStatus")
    public void setTransferStatus(TransferStatus transferStatus) {
        this.transferStatus = transferStatus;
    }

    public ContributionRequest withTransferStatus(TransferStatus transferStatus) {
        this.transferStatus = transferStatus;
        return this;
    }

    @JsonProperty(value="dateUpliftApplied")
    public LocalDate getDateUpliftApplied() {
        return this.dateUpliftApplied;
    }

    @JsonProperty(value="dateUpliftApplied")
    public void setDateUpliftApplied(LocalDate dateUpliftApplied) {
        this.dateUpliftApplied = dateUpliftApplied;
    }

    public ContributionRequest withDateUpliftApplied(LocalDate dateUpliftApplied) {
        this.dateUpliftApplied = dateUpliftApplied;
        return this;
    }

    @JsonProperty(value="dateUpliftRemoved")
    public LocalDate getDateUpliftRemoved() {
        return this.dateUpliftRemoved;
    }

    @JsonProperty(value="dateUpliftRemoved")
    public void setDateUpliftRemoved(LocalDate dateUpliftRemoved) {
        this.dateUpliftRemoved = dateUpliftRemoved;
    }

    public ContributionRequest withDateUpliftRemoved(LocalDate dateUpliftRemoved) {
        this.dateUpliftRemoved = dateUpliftRemoved;
        return this;
    }

    @JsonProperty(value="createContributionOrder")
    public String getCreateContributionOrder() {
        return this.createContributionOrder;
    }

    @JsonProperty(value="createContributionOrder")
    public void setCreateContributionOrder(String createContributionOrder) {
        this.createContributionOrder = createContributionOrder;
    }

    public ContributionRequest withCreateContributionOrder(String createContributionOrder) {
        this.createContributionOrder = createContributionOrder;
        return this;
    }

    @JsonProperty(value="correspondenceId")
    public Integer getCorrespondenceId() {
        return this.correspondenceId;
    }

    @JsonProperty(value="correspondenceId")
    public void setCorrespondenceId(Integer correspondenceId) {
        this.correspondenceId = correspondenceId;
    }

    public ContributionRequest withCorrespondenceId(Integer correspondenceId) {
        this.correspondenceId = correspondenceId;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("contributionFileId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"contributionFileId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setContributionFileId((Integer)value);
            return true;
        }
        if ("effectiveDate".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"effectiveDate\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setEffectiveDate((LocalDate)value);
            return true;
        }
        if ("calcDate".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"calcDate\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setCalcDate((LocalDate)value);
            return true;
        }
        if ("contributionCap".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"contributionCap\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setContributionCap((BigDecimal)value);
            return true;
        }
        if ("monthlyContributions".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"monthlyContributions\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setMonthlyContributions((BigDecimal)value);
            return true;
        }
        if ("upfrontContributions".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"upfrontContributions\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setUpfrontContributions((BigDecimal)value);
            return true;
        }
        if ("upliftApplied".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"upliftApplied\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUpliftApplied((String)value);
            return true;
        }
        if ("basedOn".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"basedOn\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setBasedOn((String)value);
            return true;
        }
        if ("transferStatus".equals(name)) {
            if (!(value instanceof TransferStatus)) {
                throw new IllegalArgumentException("property \"transferStatus\" is of type \"uk.gov.justice.laa.crime.enums.contribution.TransferStatus\", but got " + value.getClass().toString());
            }
            this.setTransferStatus((TransferStatus)value);
            return true;
        }
        if ("dateUpliftApplied".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"dateUpliftApplied\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setDateUpliftApplied((LocalDate)value);
            return true;
        }
        if ("dateUpliftRemoved".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"dateUpliftRemoved\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setDateUpliftRemoved((LocalDate)value);
            return true;
        }
        if ("createContributionOrder".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"createContributionOrder\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setCreateContributionOrder((String)value);
            return true;
        }
        if ("correspondenceId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"correspondenceId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setCorrespondenceId((Integer)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("contributionFileId".equals(name)) {
            return this.getContributionFileId();
        }
        if ("effectiveDate".equals(name)) {
            return this.getEffectiveDate();
        }
        if ("calcDate".equals(name)) {
            return this.getCalcDate();
        }
        if ("contributionCap".equals(name)) {
            return this.getContributionCap();
        }
        if ("monthlyContributions".equals(name)) {
            return this.getMonthlyContributions();
        }
        if ("upfrontContributions".equals(name)) {
            return this.getUpfrontContributions();
        }
        if ("upliftApplied".equals(name)) {
            return this.getUpliftApplied();
        }
        if ("basedOn".equals(name)) {
            return this.getBasedOn();
        }
        if ("transferStatus".equals(name)) {
            return this.getTransferStatus();
        }
        if ("dateUpliftApplied".equals(name)) {
            return this.getDateUpliftApplied();
        }
        if ("dateUpliftRemoved".equals(name)) {
            return this.getDateUpliftRemoved();
        }
        if ("createContributionOrder".equals(name)) {
            return this.getCreateContributionOrder();
        }
        if ("correspondenceId".equals(name)) {
            return this.getCorrespondenceId();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ContributionRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ContributionRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("contributionFileId");
        sb.append('=');
        sb.append(this.contributionFileId == null ? "<null>" : this.contributionFileId);
        sb.append(',');
        sb.append("effectiveDate");
        sb.append('=');
        sb.append(this.effectiveDate == null ? "<null>" : this.effectiveDate);
        sb.append(',');
        sb.append("calcDate");
        sb.append('=');
        sb.append(this.calcDate == null ? "<null>" : this.calcDate);
        sb.append(',');
        sb.append("contributionCap");
        sb.append('=');
        sb.append(this.contributionCap == null ? "<null>" : this.contributionCap);
        sb.append(',');
        sb.append("monthlyContributions");
        sb.append('=');
        sb.append(this.monthlyContributions == null ? "<null>" : this.monthlyContributions);
        sb.append(',');
        sb.append("upfrontContributions");
        sb.append('=');
        sb.append(this.upfrontContributions == null ? "<null>" : this.upfrontContributions);
        sb.append(',');
        sb.append("upliftApplied");
        sb.append('=');
        sb.append(this.upliftApplied == null ? "<null>" : this.upliftApplied);
        sb.append(',');
        sb.append("basedOn");
        sb.append('=');
        sb.append(this.basedOn == null ? "<null>" : this.basedOn);
        sb.append(',');
        sb.append("transferStatus");
        sb.append('=');
        sb.append((Object)(this.transferStatus == null ? "<null>" : this.transferStatus));
        sb.append(',');
        sb.append("dateUpliftApplied");
        sb.append('=');
        sb.append(this.dateUpliftApplied == null ? "<null>" : this.dateUpliftApplied);
        sb.append(',');
        sb.append("dateUpliftRemoved");
        sb.append('=');
        sb.append(this.dateUpliftRemoved == null ? "<null>" : this.dateUpliftRemoved);
        sb.append(',');
        sb.append("createContributionOrder");
        sb.append('=');
        sb.append(this.createContributionOrder == null ? "<null>" : this.createContributionOrder);
        sb.append(',');
        sb.append("correspondenceId");
        sb.append('=');
        sb.append(this.correspondenceId == null ? "<null>" : this.correspondenceId);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.transferStatus == null ? 0 : this.transferStatus.hashCode());
        result = result * 31 + (this.upliftApplied == null ? 0 : this.upliftApplied.hashCode());
        result = result * 31 + (this.upfrontContributions == null ? 0 : this.upfrontContributions.hashCode());
        result = result * 31 + (this.calcDate == null ? 0 : this.calcDate.hashCode());
        result = result * 31 + (this.contributionFileId == null ? 0 : this.contributionFileId.hashCode());
        result = result * 31 + (this.createContributionOrder == null ? 0 : this.createContributionOrder.hashCode());
        result = result * 31 + (this.contributionCap == null ? 0 : this.contributionCap.hashCode());
        result = result * 31 + (this.monthlyContributions == null ? 0 : this.monthlyContributions.hashCode());
        result = result * 31 + (this.dateUpliftRemoved == null ? 0 : this.dateUpliftRemoved.hashCode());
        result = result * 31 + (this.dateUpliftApplied == null ? 0 : this.dateUpliftApplied.hashCode());
        result = result * 31 + (this.correspondenceId == null ? 0 : this.correspondenceId.hashCode());
        result = result * 31 + (this.effectiveDate == null ? 0 : this.effectiveDate.hashCode());
        result = result * 31 + (this.basedOn == null ? 0 : this.basedOn.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ContributionRequest)) {
            return false;
        }
        ContributionRequest rhs = (ContributionRequest)other;
        return (this.transferStatus == rhs.transferStatus || this.transferStatus != null && this.transferStatus.equals((Object)rhs.transferStatus)) && (this.upliftApplied == rhs.upliftApplied || this.upliftApplied != null && this.upliftApplied.equals(rhs.upliftApplied)) && (this.upfrontContributions == rhs.upfrontContributions || this.upfrontContributions != null && this.upfrontContributions.equals(rhs.upfrontContributions)) && (this.calcDate == rhs.calcDate || this.calcDate != null && this.calcDate.equals(rhs.calcDate)) && (this.contributionFileId == rhs.contributionFileId || this.contributionFileId != null && this.contributionFileId.equals(rhs.contributionFileId)) && (this.createContributionOrder == rhs.createContributionOrder || this.createContributionOrder != null && this.createContributionOrder.equals(rhs.createContributionOrder)) && (this.contributionCap == rhs.contributionCap || this.contributionCap != null && this.contributionCap.equals(rhs.contributionCap)) && (this.monthlyContributions == rhs.monthlyContributions || this.monthlyContributions != null && this.monthlyContributions.equals(rhs.monthlyContributions)) && (this.dateUpliftRemoved == rhs.dateUpliftRemoved || this.dateUpliftRemoved != null && this.dateUpliftRemoved.equals(rhs.dateUpliftRemoved)) && (this.dateUpliftApplied == rhs.dateUpliftApplied || this.dateUpliftApplied != null && this.dateUpliftApplied.equals(rhs.dateUpliftApplied)) && (this.correspondenceId == rhs.correspondenceId || this.correspondenceId != null && this.correspondenceId.equals(rhs.correspondenceId)) && (this.effectiveDate == rhs.effectiveDate || this.effectiveDate != null && this.effectiveDate.equals(rhs.effectiveDate)) && (this.basedOn == rhs.basedOn || this.basedOn != null && this.basedOn.equals(rhs.basedOn));
    }
}

