/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.contribution.maat_api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import uk.gov.justice.laa.crime.common.model.contribution.maat_api.ContributionRequest;
import uk.gov.justice.laa.crime.enums.contribution.TransferStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"repId", "applicantId", "userCreated"})
public class CreateContributionRequest
extends ContributionRequest {
    @JsonProperty(value="repId")
    @JsonPropertyDescription(value="The associated MAAT/REP ID")
    @NotNull
    private Integer repId;
    @JsonProperty(value="applicantId")
    @JsonPropertyDescription(value="The associated applicant ID")
    @NotNull
    private Integer applicantId;
    @JsonProperty(value="userCreated")
    @JsonPropertyDescription(value="The user creating the record")
    @NotNull
    private String userCreated;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public CreateContributionRequest() {
    }

    public CreateContributionRequest(Integer repId, Integer applicantId, String userCreated, Integer contributionFileId, LocalDate effectiveDate, LocalDate calcDate, BigDecimal contributionCap, BigDecimal monthlyContributions, BigDecimal upfrontContributions, String upliftApplied, String basedOn, TransferStatus transferStatus, LocalDate dateUpliftApplied, LocalDate dateUpliftRemoved, String createContributionOrder, Integer correspondenceId) {
        super(contributionFileId, effectiveDate, calcDate, contributionCap, monthlyContributions, upfrontContributions, upliftApplied, basedOn, transferStatus, dateUpliftApplied, dateUpliftRemoved, createContributionOrder, correspondenceId);
        this.repId = repId;
        this.applicantId = applicantId;
        this.userCreated = userCreated;
    }

    @JsonProperty(value="repId")
    public Integer getRepId() {
        return this.repId;
    }

    @JsonProperty(value="repId")
    public void setRepId(Integer repId) {
        this.repId = repId;
    }

    public CreateContributionRequest withRepId(Integer repId) {
        this.repId = repId;
        return this;
    }

    @JsonProperty(value="applicantId")
    public Integer getApplicantId() {
        return this.applicantId;
    }

    @JsonProperty(value="applicantId")
    public void setApplicantId(Integer applicantId) {
        this.applicantId = applicantId;
    }

    public CreateContributionRequest withApplicantId(Integer applicantId) {
        this.applicantId = applicantId;
        return this;
    }

    @JsonProperty(value="userCreated")
    public String getUserCreated() {
        return this.userCreated;
    }

    @JsonProperty(value="userCreated")
    public void setUserCreated(String userCreated) {
        this.userCreated = userCreated;
    }

    public CreateContributionRequest withUserCreated(String userCreated) {
        this.userCreated = userCreated;
        return this;
    }

    @Override
    public CreateContributionRequest withContributionFileId(Integer contributionFileId) {
        super.withContributionFileId(contributionFileId);
        return this;
    }

    @Override
    public CreateContributionRequest withEffectiveDate(LocalDate effectiveDate) {
        super.withEffectiveDate(effectiveDate);
        return this;
    }

    @Override
    public CreateContributionRequest withCalcDate(LocalDate calcDate) {
        super.withCalcDate(calcDate);
        return this;
    }

    @Override
    public CreateContributionRequest withContributionCap(BigDecimal contributionCap) {
        super.withContributionCap(contributionCap);
        return this;
    }

    @Override
    public CreateContributionRequest withMonthlyContributions(BigDecimal monthlyContributions) {
        super.withMonthlyContributions(monthlyContributions);
        return this;
    }

    @Override
    public CreateContributionRequest withUpfrontContributions(BigDecimal upfrontContributions) {
        super.withUpfrontContributions(upfrontContributions);
        return this;
    }

    @Override
    public CreateContributionRequest withUpliftApplied(String upliftApplied) {
        super.withUpliftApplied(upliftApplied);
        return this;
    }

    @Override
    public CreateContributionRequest withBasedOn(String basedOn) {
        super.withBasedOn(basedOn);
        return this;
    }

    @Override
    public CreateContributionRequest withTransferStatus(TransferStatus transferStatus) {
        super.withTransferStatus(transferStatus);
        return this;
    }

    @Override
    public CreateContributionRequest withDateUpliftApplied(LocalDate dateUpliftApplied) {
        super.withDateUpliftApplied(dateUpliftApplied);
        return this;
    }

    @Override
    public CreateContributionRequest withDateUpliftRemoved(LocalDate dateUpliftRemoved) {
        super.withDateUpliftRemoved(dateUpliftRemoved);
        return this;
    }

    @Override
    public CreateContributionRequest withCreateContributionOrder(String createContributionOrder) {
        super.withCreateContributionOrder(createContributionOrder);
        return this;
    }

    @Override
    public CreateContributionRequest withCorrespondenceId(Integer correspondenceId) {
        super.withCorrespondenceId(correspondenceId);
        return this;
    }

    @Override
    protected boolean declaredProperty(String name, Object value) {
        if ("repId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"repId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setRepId((Integer)value);
            return true;
        }
        if ("applicantId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"applicantId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setApplicantId((Integer)value);
            return true;
        }
        if ("userCreated".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"userCreated\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUserCreated((String)value);
            return true;
        }
        return super.declaredProperty(name, value);
    }

    @Override
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("repId".equals(name)) {
            return this.getRepId();
        }
        if ("applicantId".equals(name)) {
            return this.getApplicantId();
        }
        if ("userCreated".equals(name)) {
            return this.getUserCreated();
        }
        return super.declaredPropertyOrNotFound(name, notFoundValue);
    }

    @Override
    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    @Override
    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    @Override
    public CreateContributionRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateContributionRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("repId");
        sb.append('=');
        sb.append(this.repId == null ? "<null>" : this.repId);
        sb.append(',');
        sb.append("applicantId");
        sb.append('=');
        sb.append(this.applicantId == null ? "<null>" : this.applicantId);
        sb.append(',');
        sb.append("userCreated");
        sb.append('=');
        sb.append(this.userCreated == null ? "<null>" : this.userCreated);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.applicantId == null ? 0 : this.applicantId.hashCode());
        result = result * 31 + (this.userCreated == null ? 0 : this.userCreated.hashCode());
        result = result * 31 + (this.repId == null ? 0 : this.repId.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateContributionRequest)) {
            return false;
        }
        CreateContributionRequest rhs = (CreateContributionRequest)other;
        return super.equals(rhs) && (this.applicantId == rhs.applicantId || this.applicantId != null && this.applicantId.equals(rhs.applicantId)) && (this.userCreated == rhs.userCreated || this.userCreated != null && this.userCreated.equals(rhs.userCreated)) && (this.repId == rhs.repId || this.repId != null && this.repId.equals(rhs.repId));
    }
}

