/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.evidence;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.evidence.ApiCapitalEvidence;
import uk.gov.justice.laa.crime.common.model.evidence.ApiEvidenceFee;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"repId", "magCourtOutcome", "evidenceFee", "capitalEvidence", "incomeEvidenceReceivedDate", "capitalEvidenceReceivedDate", "emstCode"})
public class ApiCalculateEvidenceFeeRequest {
    @JsonProperty(value="repId")
    @JsonPropertyDescription(value="MAAT / Rep Id")
    @NotNull
    private Integer repId;
    @JsonProperty(value="magCourtOutcome")
    @JsonPropertyDescription(value="Magistrate Court Outcome")
    @NotNull
    private String magCourtOutcome;
    @JsonProperty(value="evidenceFee")
    @JsonPropertyDescription(value="Evidence Fee")
    @Valid
    private ApiEvidenceFee evidenceFee;
    @JsonProperty(value="capitalEvidence")
    @JsonPropertyDescription(value="List of Capital Evidence")
    @Valid
    @NotNull
    private List<ApiCapitalEvidence> capitalEvidence = new ArrayList<ApiCapitalEvidence>();
    @JsonProperty(value="incomeEvidenceReceivedDate")
    @JsonPropertyDescription(value="Income Evidence Received Date")
    private LocalDateTime incomeEvidenceReceivedDate;
    @JsonProperty(value="capitalEvidenceReceivedDate")
    @JsonPropertyDescription(value="Capital Evidence Received Date")
    private LocalDateTime capitalEvidenceReceivedDate;
    @JsonProperty(value="emstCode")
    @JsonPropertyDescription(value="Applicant Employment Status Code")
    @NotNull
    private String emstCode;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiCalculateEvidenceFeeRequest() {
    }

    public ApiCalculateEvidenceFeeRequest(Integer repId, String magCourtOutcome, ApiEvidenceFee evidenceFee, List<ApiCapitalEvidence> capitalEvidence, LocalDateTime incomeEvidenceReceivedDate, LocalDateTime capitalEvidenceReceivedDate, String emstCode) {
        this.repId = repId;
        this.magCourtOutcome = magCourtOutcome;
        this.evidenceFee = evidenceFee;
        this.capitalEvidence = capitalEvidence;
        this.incomeEvidenceReceivedDate = incomeEvidenceReceivedDate;
        this.capitalEvidenceReceivedDate = capitalEvidenceReceivedDate;
        this.emstCode = emstCode;
    }

    @JsonProperty(value="repId")
    public Integer getRepId() {
        return this.repId;
    }

    @JsonProperty(value="repId")
    public void setRepId(Integer repId) {
        this.repId = repId;
    }

    public ApiCalculateEvidenceFeeRequest withRepId(Integer repId) {
        this.repId = repId;
        return this;
    }

    @JsonProperty(value="magCourtOutcome")
    public String getMagCourtOutcome() {
        return this.magCourtOutcome;
    }

    @JsonProperty(value="magCourtOutcome")
    public void setMagCourtOutcome(String magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
    }

    public ApiCalculateEvidenceFeeRequest withMagCourtOutcome(String magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
        return this;
    }

    @JsonProperty(value="evidenceFee")
    public ApiEvidenceFee getEvidenceFee() {
        return this.evidenceFee;
    }

    @JsonProperty(value="evidenceFee")
    public void setEvidenceFee(ApiEvidenceFee evidenceFee) {
        this.evidenceFee = evidenceFee;
    }

    public ApiCalculateEvidenceFeeRequest withEvidenceFee(ApiEvidenceFee evidenceFee) {
        this.evidenceFee = evidenceFee;
        return this;
    }

    @JsonProperty(value="capitalEvidence")
    public List<ApiCapitalEvidence> getCapitalEvidence() {
        return this.capitalEvidence;
    }

    @JsonProperty(value="capitalEvidence")
    public void setCapitalEvidence(List<ApiCapitalEvidence> capitalEvidence) {
        this.capitalEvidence = capitalEvidence;
    }

    public ApiCalculateEvidenceFeeRequest withCapitalEvidence(List<ApiCapitalEvidence> capitalEvidence) {
        this.capitalEvidence = capitalEvidence;
        return this;
    }

    @JsonProperty(value="incomeEvidenceReceivedDate")
    public LocalDateTime getIncomeEvidenceReceivedDate() {
        return this.incomeEvidenceReceivedDate;
    }

    @JsonProperty(value="incomeEvidenceReceivedDate")
    public void setIncomeEvidenceReceivedDate(LocalDateTime incomeEvidenceReceivedDate) {
        this.incomeEvidenceReceivedDate = incomeEvidenceReceivedDate;
    }

    public ApiCalculateEvidenceFeeRequest withIncomeEvidenceReceivedDate(LocalDateTime incomeEvidenceReceivedDate) {
        this.incomeEvidenceReceivedDate = incomeEvidenceReceivedDate;
        return this;
    }

    @JsonProperty(value="capitalEvidenceReceivedDate")
    public LocalDateTime getCapitalEvidenceReceivedDate() {
        return this.capitalEvidenceReceivedDate;
    }

    @JsonProperty(value="capitalEvidenceReceivedDate")
    public void setCapitalEvidenceReceivedDate(LocalDateTime capitalEvidenceReceivedDate) {
        this.capitalEvidenceReceivedDate = capitalEvidenceReceivedDate;
    }

    public ApiCalculateEvidenceFeeRequest withCapitalEvidenceReceivedDate(LocalDateTime capitalEvidenceReceivedDate) {
        this.capitalEvidenceReceivedDate = capitalEvidenceReceivedDate;
        return this;
    }

    @JsonProperty(value="emstCode")
    public String getEmstCode() {
        return this.emstCode;
    }

    @JsonProperty(value="emstCode")
    public void setEmstCode(String emstCode) {
        this.emstCode = emstCode;
    }

    public ApiCalculateEvidenceFeeRequest withEmstCode(String emstCode) {
        this.emstCode = emstCode;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("repId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"repId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setRepId((Integer)value);
            return true;
        }
        if ("magCourtOutcome".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"magCourtOutcome\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setMagCourtOutcome((String)value);
            return true;
        }
        if ("evidenceFee".equals(name)) {
            if (!(value instanceof ApiEvidenceFee)) {
                throw new IllegalArgumentException("property \"evidenceFee\" is of type \"uk.gov.justice.laa.crime.common.model.evidence.ApiEvidenceFee\", but got " + value.getClass().toString());
            }
            this.setEvidenceFee((ApiEvidenceFee)value);
            return true;
        }
        if ("capitalEvidence".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"capitalEvidence\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.evidence.ApiCapitalEvidence>\", but got " + value.getClass().toString());
            }
            this.setCapitalEvidence((List)value);
            return true;
        }
        if ("incomeEvidenceReceivedDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"incomeEvidenceReceivedDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidenceReceivedDate((LocalDateTime)value);
            return true;
        }
        if ("capitalEvidenceReceivedDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"capitalEvidenceReceivedDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setCapitalEvidenceReceivedDate((LocalDateTime)value);
            return true;
        }
        if ("emstCode".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"emstCode\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setEmstCode((String)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("repId".equals(name)) {
            return this.getRepId();
        }
        if ("magCourtOutcome".equals(name)) {
            return this.getMagCourtOutcome();
        }
        if ("evidenceFee".equals(name)) {
            return this.getEvidenceFee();
        }
        if ("capitalEvidence".equals(name)) {
            return this.getCapitalEvidence();
        }
        if ("incomeEvidenceReceivedDate".equals(name)) {
            return this.getIncomeEvidenceReceivedDate();
        }
        if ("capitalEvidenceReceivedDate".equals(name)) {
            return this.getCapitalEvidenceReceivedDate();
        }
        if ("emstCode".equals(name)) {
            return this.getEmstCode();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiCalculateEvidenceFeeRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiCalculateEvidenceFeeRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("repId");
        sb.append('=');
        sb.append(this.repId == null ? "<null>" : this.repId);
        sb.append(',');
        sb.append("magCourtOutcome");
        sb.append('=');
        sb.append(this.magCourtOutcome == null ? "<null>" : this.magCourtOutcome);
        sb.append(',');
        sb.append("evidenceFee");
        sb.append('=');
        sb.append(this.evidenceFee == null ? "<null>" : this.evidenceFee);
        sb.append(',');
        sb.append("capitalEvidence");
        sb.append('=');
        sb.append(this.capitalEvidence == null ? "<null>" : this.capitalEvidence);
        sb.append(',');
        sb.append("incomeEvidenceReceivedDate");
        sb.append('=');
        sb.append(this.incomeEvidenceReceivedDate == null ? "<null>" : this.incomeEvidenceReceivedDate);
        sb.append(',');
        sb.append("capitalEvidenceReceivedDate");
        sb.append('=');
        sb.append(this.capitalEvidenceReceivedDate == null ? "<null>" : this.capitalEvidenceReceivedDate);
        sb.append(',');
        sb.append("emstCode");
        sb.append('=');
        sb.append(this.emstCode == null ? "<null>" : this.emstCode);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.incomeEvidenceReceivedDate == null ? 0 : this.incomeEvidenceReceivedDate.hashCode());
        result = result * 31 + (this.magCourtOutcome == null ? 0 : this.magCourtOutcome.hashCode());
        result = result * 31 + (this.evidenceFee == null ? 0 : this.evidenceFee.hashCode());
        result = result * 31 + (this.emstCode == null ? 0 : this.emstCode.hashCode());
        result = result * 31 + (this.capitalEvidenceReceivedDate == null ? 0 : this.capitalEvidenceReceivedDate.hashCode());
        result = result * 31 + (this.capitalEvidence == null ? 0 : this.capitalEvidence.hashCode());
        result = result * 31 + (this.repId == null ? 0 : this.repId.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiCalculateEvidenceFeeRequest)) {
            return false;
        }
        ApiCalculateEvidenceFeeRequest rhs = (ApiCalculateEvidenceFeeRequest)other;
        return (this.incomeEvidenceReceivedDate == rhs.incomeEvidenceReceivedDate || this.incomeEvidenceReceivedDate != null && this.incomeEvidenceReceivedDate.equals(rhs.incomeEvidenceReceivedDate)) && (this.magCourtOutcome == rhs.magCourtOutcome || this.magCourtOutcome != null && this.magCourtOutcome.equals(rhs.magCourtOutcome)) && (this.evidenceFee == rhs.evidenceFee || this.evidenceFee != null && this.evidenceFee.equals(rhs.evidenceFee)) && (this.emstCode == rhs.emstCode || this.emstCode != null && this.emstCode.equals(rhs.emstCode)) && (this.capitalEvidenceReceivedDate == rhs.capitalEvidenceReceivedDate || this.capitalEvidenceReceivedDate != null && this.capitalEvidenceReceivedDate.equals(rhs.capitalEvidenceReceivedDate)) && (this.capitalEvidence == rhs.capitalEvidence || this.capitalEvidence != null && this.capitalEvidence.equals(rhs.capitalEvidence)) && (this.repId == rhs.repId || this.repId != null && this.repId.equals(rhs.repId));
    }
}

