/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.evidence;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import uk.gov.justice.laa.crime.common.model.evidence.ApiApplicantDetails;
import uk.gov.justice.laa.crime.common.model.evidence.ApiIncomeEvidenceMetadata;
import uk.gov.justice.laa.crime.enums.MagCourtOutcome;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"magCourtOutcome", "applicantDetails", "partnerDetails", "applicantPensionAmount", "partnerPensionAmount", "metadata"})
public class ApiCreateIncomeEvidenceRequest {
    @JsonProperty(value="magCourtOutcome")
    @JsonPropertyDescription(value="Magistrate Court Outcome")
    @Valid
    @NotNull
    private MagCourtOutcome magCourtOutcome;
    @JsonProperty(value="applicantDetails")
    @JsonPropertyDescription(value="Information about an applicants reference and employment")
    @Valid
    @NotNull
    private ApiApplicantDetails applicantDetails;
    @JsonProperty(value="partnerDetails")
    @JsonPropertyDescription(value="Information about an applicants reference and employment")
    @Valid
    private ApiApplicantDetails partnerDetails;
    @JsonProperty(value="applicantPensionAmount")
    @JsonPropertyDescription(value="Applicant pension amount")
    private BigDecimal applicantPensionAmount;
    @JsonProperty(value="partnerPensionAmount")
    @JsonPropertyDescription(value="Partner pension amount")
    private BigDecimal partnerPensionAmount;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="MAAT specific metadata required to process income evidence")
    @Valid
    @NotNull
    private ApiIncomeEvidenceMetadata metadata;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiCreateIncomeEvidenceRequest() {
    }

    public ApiCreateIncomeEvidenceRequest(MagCourtOutcome magCourtOutcome, ApiApplicantDetails applicantDetails, ApiApplicantDetails partnerDetails, BigDecimal applicantPensionAmount, BigDecimal partnerPensionAmount, ApiIncomeEvidenceMetadata metadata) {
        this.magCourtOutcome = magCourtOutcome;
        this.applicantDetails = applicantDetails;
        this.partnerDetails = partnerDetails;
        this.applicantPensionAmount = applicantPensionAmount;
        this.partnerPensionAmount = partnerPensionAmount;
        this.metadata = metadata;
    }

    @JsonProperty(value="magCourtOutcome")
    public MagCourtOutcome getMagCourtOutcome() {
        return this.magCourtOutcome;
    }

    @JsonProperty(value="magCourtOutcome")
    public void setMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
    }

    public ApiCreateIncomeEvidenceRequest withMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
        return this;
    }

    @JsonProperty(value="applicantDetails")
    public ApiApplicantDetails getApplicantDetails() {
        return this.applicantDetails;
    }

    @JsonProperty(value="applicantDetails")
    public void setApplicantDetails(ApiApplicantDetails applicantDetails) {
        this.applicantDetails = applicantDetails;
    }

    public ApiCreateIncomeEvidenceRequest withApplicantDetails(ApiApplicantDetails applicantDetails) {
        this.applicantDetails = applicantDetails;
        return this;
    }

    @JsonProperty(value="partnerDetails")
    public ApiApplicantDetails getPartnerDetails() {
        return this.partnerDetails;
    }

    @JsonProperty(value="partnerDetails")
    public void setPartnerDetails(ApiApplicantDetails partnerDetails) {
        this.partnerDetails = partnerDetails;
    }

    public ApiCreateIncomeEvidenceRequest withPartnerDetails(ApiApplicantDetails partnerDetails) {
        this.partnerDetails = partnerDetails;
        return this;
    }

    @JsonProperty(value="applicantPensionAmount")
    public BigDecimal getApplicantPensionAmount() {
        return this.applicantPensionAmount;
    }

    @JsonProperty(value="applicantPensionAmount")
    public void setApplicantPensionAmount(BigDecimal applicantPensionAmount) {
        this.applicantPensionAmount = applicantPensionAmount;
    }

    public ApiCreateIncomeEvidenceRequest withApplicantPensionAmount(BigDecimal applicantPensionAmount) {
        this.applicantPensionAmount = applicantPensionAmount;
        return this;
    }

    @JsonProperty(value="partnerPensionAmount")
    public BigDecimal getPartnerPensionAmount() {
        return this.partnerPensionAmount;
    }

    @JsonProperty(value="partnerPensionAmount")
    public void setPartnerPensionAmount(BigDecimal partnerPensionAmount) {
        this.partnerPensionAmount = partnerPensionAmount;
    }

    public ApiCreateIncomeEvidenceRequest withPartnerPensionAmount(BigDecimal partnerPensionAmount) {
        this.partnerPensionAmount = partnerPensionAmount;
        return this;
    }

    @JsonProperty(value="metadata")
    public ApiIncomeEvidenceMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(ApiIncomeEvidenceMetadata metadata) {
        this.metadata = metadata;
    }

    public ApiCreateIncomeEvidenceRequest withMetadata(ApiIncomeEvidenceMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("magCourtOutcome".equals(name)) {
            if (!(value instanceof MagCourtOutcome)) {
                throw new IllegalArgumentException("property \"magCourtOutcome\" is of type \"uk.gov.justice.laa.crime.enums.MagCourtOutcome\", but got " + value.getClass().toString());
            }
            this.setMagCourtOutcome((MagCourtOutcome)value);
            return true;
        }
        if ("applicantDetails".equals(name)) {
            if (!(value instanceof ApiApplicantDetails)) {
                throw new IllegalArgumentException("property \"applicantDetails\" is of type \"uk.gov.justice.laa.crime.common.model.evidence.ApiApplicantDetails\", but got " + value.getClass().toString());
            }
            this.setApplicantDetails((ApiApplicantDetails)value);
            return true;
        }
        if ("partnerDetails".equals(name)) {
            if (!(value instanceof ApiApplicantDetails)) {
                throw new IllegalArgumentException("property \"partnerDetails\" is of type \"uk.gov.justice.laa.crime.common.model.evidence.ApiApplicantDetails\", but got " + value.getClass().toString());
            }
            this.setPartnerDetails((ApiApplicantDetails)value);
            return true;
        }
        if ("applicantPensionAmount".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"applicantPensionAmount\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setApplicantPensionAmount((BigDecimal)value);
            return true;
        }
        if ("partnerPensionAmount".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"partnerPensionAmount\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setPartnerPensionAmount((BigDecimal)value);
            return true;
        }
        if ("metadata".equals(name)) {
            if (!(value instanceof ApiIncomeEvidenceMetadata)) {
                throw new IllegalArgumentException("property \"metadata\" is of type \"uk.gov.justice.laa.crime.common.model.evidence.ApiIncomeEvidenceMetadata\", but got " + value.getClass().toString());
            }
            this.setMetadata((ApiIncomeEvidenceMetadata)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("magCourtOutcome".equals(name)) {
            return this.getMagCourtOutcome();
        }
        if ("applicantDetails".equals(name)) {
            return this.getApplicantDetails();
        }
        if ("partnerDetails".equals(name)) {
            return this.getPartnerDetails();
        }
        if ("applicantPensionAmount".equals(name)) {
            return this.getApplicantPensionAmount();
        }
        if ("partnerPensionAmount".equals(name)) {
            return this.getPartnerPensionAmount();
        }
        if ("metadata".equals(name)) {
            return this.getMetadata();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiCreateIncomeEvidenceRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiCreateIncomeEvidenceRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("magCourtOutcome");
        sb.append('=');
        sb.append((Object)(this.magCourtOutcome == null ? "<null>" : this.magCourtOutcome));
        sb.append(',');
        sb.append("applicantDetails");
        sb.append('=');
        sb.append(this.applicantDetails == null ? "<null>" : this.applicantDetails);
        sb.append(',');
        sb.append("partnerDetails");
        sb.append('=');
        sb.append(this.partnerDetails == null ? "<null>" : this.partnerDetails);
        sb.append(',');
        sb.append("applicantPensionAmount");
        sb.append('=');
        sb.append(this.applicantPensionAmount == null ? "<null>" : this.applicantPensionAmount);
        sb.append(',');
        sb.append("partnerPensionAmount");
        sb.append('=');
        sb.append(this.partnerPensionAmount == null ? "<null>" : this.partnerPensionAmount);
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(this.metadata == null ? "<null>" : this.metadata);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.applicantPensionAmount == null ? 0 : this.applicantPensionAmount.hashCode());
        result = result * 31 + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = result * 31 + (this.applicantDetails == null ? 0 : this.applicantDetails.hashCode());
        result = result * 31 + (this.magCourtOutcome == null ? 0 : this.magCourtOutcome.hashCode());
        result = result * 31 + (this.partnerPensionAmount == null ? 0 : this.partnerPensionAmount.hashCode());
        result = result * 31 + (this.partnerDetails == null ? 0 : this.partnerDetails.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiCreateIncomeEvidenceRequest)) {
            return false;
        }
        ApiCreateIncomeEvidenceRequest rhs = (ApiCreateIncomeEvidenceRequest)other;
        return (this.applicantPensionAmount == rhs.applicantPensionAmount || this.applicantPensionAmount != null && this.applicantPensionAmount.equals(rhs.applicantPensionAmount)) && (this.metadata == rhs.metadata || this.metadata != null && this.metadata.equals(rhs.metadata)) && (this.applicantDetails == rhs.applicantDetails || this.applicantDetails != null && this.applicantDetails.equals(rhs.applicantDetails)) && (this.magCourtOutcome == rhs.magCourtOutcome || this.magCourtOutcome != null && this.magCourtOutcome.equals((Object)rhs.magCourtOutcome)) && (this.partnerPensionAmount == rhs.partnerPensionAmount || this.partnerPensionAmount != null && this.partnerPensionAmount.equals(rhs.partnerPensionAmount)) && (this.partnerDetails == rhs.partnerDetails || this.partnerDetails != null && this.partnerDetails.equals(rhs.partnerDetails));
    }
}

