/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.evidence;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import uk.gov.justice.laa.crime.enums.evidence.IncomeEvidenceType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "dateReceived", "evidenceType", "mandatory", "description"})
public class ApiIncomeEvidence {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="The ID of the income evidence item")
    private Integer id;
    @JsonProperty(value="dateReceived")
    @JsonPropertyDescription(value="The date the evidence was received")
    private LocalDate dateReceived;
    @JsonProperty(value="evidenceType")
    @JsonPropertyDescription(value="The partners details")
    @Valid
    @NotNull
    private IncomeEvidenceType evidenceType;
    @JsonProperty(value="mandatory")
    @JsonPropertyDescription(value="Indicates whether the evidence is mandatory")
    @NotNull
    private Boolean mandatory;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="The evidence description (required for certain evidence types)")
    private String description;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiIncomeEvidence() {
    }

    public ApiIncomeEvidence(Integer id, LocalDate dateReceived, IncomeEvidenceType evidenceType, Boolean mandatory, String description) {
        this.id = id;
        this.dateReceived = dateReceived;
        this.evidenceType = evidenceType;
        this.mandatory = mandatory;
        this.description = description;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public ApiIncomeEvidence withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="dateReceived")
    public LocalDate getDateReceived() {
        return this.dateReceived;
    }

    @JsonProperty(value="dateReceived")
    public void setDateReceived(LocalDate dateReceived) {
        this.dateReceived = dateReceived;
    }

    public ApiIncomeEvidence withDateReceived(LocalDate dateReceived) {
        this.dateReceived = dateReceived;
        return this;
    }

    @JsonProperty(value="evidenceType")
    public IncomeEvidenceType getEvidenceType() {
        return this.evidenceType;
    }

    @JsonProperty(value="evidenceType")
    public void setEvidenceType(IncomeEvidenceType evidenceType) {
        this.evidenceType = evidenceType;
    }

    public ApiIncomeEvidence withEvidenceType(IncomeEvidenceType evidenceType) {
        this.evidenceType = evidenceType;
        return this;
    }

    @JsonProperty(value="mandatory")
    public Boolean getMandatory() {
        return this.mandatory;
    }

    @JsonProperty(value="mandatory")
    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public ApiIncomeEvidence withMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ApiIncomeEvidence withDescription(String description) {
        this.description = description;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("id".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"id\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setId((Integer)value);
            return true;
        }
        if ("dateReceived".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"dateReceived\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setDateReceived((LocalDate)value);
            return true;
        }
        if ("evidenceType".equals(name)) {
            if (!(value instanceof IncomeEvidenceType)) {
                throw new IllegalArgumentException("property \"evidenceType\" is of type \"uk.gov.justice.laa.crime.enums.evidence.IncomeEvidenceType\", but got " + value.getClass().toString());
            }
            this.setEvidenceType((IncomeEvidenceType)value);
            return true;
        }
        if ("mandatory".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"mandatory\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setMandatory((Boolean)value);
            return true;
        }
        if ("description".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"description\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setDescription((String)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("dateReceived".equals(name)) {
            return this.getDateReceived();
        }
        if ("evidenceType".equals(name)) {
            return this.getEvidenceType();
        }
        if ("mandatory".equals(name)) {
            return this.getMandatory();
        }
        if ("description".equals(name)) {
            return this.getDescription();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiIncomeEvidence with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiIncomeEvidence.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("dateReceived");
        sb.append('=');
        sb.append(this.dateReceived == null ? "<null>" : this.dateReceived);
        sb.append(',');
        sb.append("evidenceType");
        sb.append('=');
        sb.append((Object)(this.evidenceType == null ? "<null>" : this.evidenceType));
        sb.append(',');
        sb.append("mandatory");
        sb.append('=');
        sb.append(this.mandatory == null ? "<null>" : this.mandatory);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.dateReceived == null ? 0 : this.dateReceived.hashCode());
        result = result * 31 + (this.evidenceType == null ? 0 : this.evidenceType.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.mandatory == null ? 0 : this.mandatory.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiIncomeEvidence)) {
            return false;
        }
        ApiIncomeEvidence rhs = (ApiIncomeEvidence)other;
        return (this.dateReceived == rhs.dateReceived || this.dateReceived != null && this.dateReceived.equals(rhs.dateReceived)) && (this.evidenceType == rhs.evidenceType || this.evidenceType != null && this.evidenceType.equals((Object)rhs.evidenceType)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.mandatory == rhs.mandatory || this.mandatory != null && this.mandatory.equals(rhs.mandatory));
    }
}

