/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.evidence;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.evidence.ApiApplicantDetails;
import uk.gov.justice.laa.crime.common.model.evidence.ApiIncomeEvidence;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"applicantDetails", "incomeEvidenceItems"})
public class ApiIncomeEvidenceItems {
    @JsonProperty(value="applicantDetails")
    @JsonPropertyDescription(value="Information about an applicants reference and employment")
    @Valid
    @NotNull
    private ApiApplicantDetails applicantDetails;
    @JsonProperty(value="incomeEvidenceItems")
    @JsonPropertyDescription(value="The list of associated income evidence items")
    @Valid
    private List<ApiIncomeEvidence> incomeEvidenceItems = new ArrayList<ApiIncomeEvidence>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiIncomeEvidenceItems() {
    }

    public ApiIncomeEvidenceItems(ApiApplicantDetails applicantDetails, List<ApiIncomeEvidence> incomeEvidenceItems) {
        this.applicantDetails = applicantDetails;
        this.incomeEvidenceItems = incomeEvidenceItems;
    }

    @JsonProperty(value="applicantDetails")
    public ApiApplicantDetails getApplicantDetails() {
        return this.applicantDetails;
    }

    @JsonProperty(value="applicantDetails")
    public void setApplicantDetails(ApiApplicantDetails applicantDetails) {
        this.applicantDetails = applicantDetails;
    }

    public ApiIncomeEvidenceItems withApplicantDetails(ApiApplicantDetails applicantDetails) {
        this.applicantDetails = applicantDetails;
        return this;
    }

    @JsonProperty(value="incomeEvidenceItems")
    public List<ApiIncomeEvidence> getIncomeEvidenceItems() {
        return this.incomeEvidenceItems;
    }

    @JsonProperty(value="incomeEvidenceItems")
    public void setIncomeEvidenceItems(List<ApiIncomeEvidence> incomeEvidenceItems) {
        this.incomeEvidenceItems = incomeEvidenceItems;
    }

    public ApiIncomeEvidenceItems withIncomeEvidenceItems(List<ApiIncomeEvidence> incomeEvidenceItems) {
        this.incomeEvidenceItems = incomeEvidenceItems;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("applicantDetails".equals(name)) {
            if (!(value instanceof ApiApplicantDetails)) {
                throw new IllegalArgumentException("property \"applicantDetails\" is of type \"uk.gov.justice.laa.crime.common.model.evidence.ApiApplicantDetails\", but got " + value.getClass().toString());
            }
            this.setApplicantDetails((ApiApplicantDetails)value);
            return true;
        }
        if ("incomeEvidenceItems".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"incomeEvidenceItems\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.evidence.ApiIncomeEvidence>\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidenceItems((List)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("applicantDetails".equals(name)) {
            return this.getApplicantDetails();
        }
        if ("incomeEvidenceItems".equals(name)) {
            return this.getIncomeEvidenceItems();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiIncomeEvidenceItems with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiIncomeEvidenceItems.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("applicantDetails");
        sb.append('=');
        sb.append(this.applicantDetails == null ? "<null>" : this.applicantDetails);
        sb.append(',');
        sb.append("incomeEvidenceItems");
        sb.append('=');
        sb.append(this.incomeEvidenceItems == null ? "<null>" : this.incomeEvidenceItems);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.applicantDetails == null ? 0 : this.applicantDetails.hashCode());
        result = result * 31 + (this.incomeEvidenceItems == null ? 0 : this.incomeEvidenceItems.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiIncomeEvidenceItems)) {
            return false;
        }
        ApiIncomeEvidenceItems rhs = (ApiIncomeEvidenceItems)other;
        return (this.applicantDetails == rhs.applicantDetails || this.applicantDetails != null && this.applicantDetails.equals(rhs.applicantDetails)) && (this.incomeEvidenceItems == rhs.incomeEvidenceItems || this.incomeEvidenceItems != null && this.incomeEvidenceItems.equals(rhs.incomeEvidenceItems));
    }
}

