/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.evidence;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import uk.gov.justice.laa.crime.common.model.common.ApiUserSession;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"applicationReceivedDate", "evidencePending", "notes", "userSession"})
public class ApiIncomeEvidenceMetadata {
    @JsonProperty(value="applicationReceivedDate")
    @JsonPropertyDescription(value="The date the application was received")
    @NotNull
    private LocalDate applicationReceivedDate;
    @JsonProperty(value="evidencePending")
    @JsonPropertyDescription(value="indicates whether there is still pending income evidence")
    private Boolean evidencePending;
    @JsonProperty(value="notes")
    @JsonPropertyDescription(value="Free text notes relating to the income evidence")
    private String notes;
    @JsonProperty(value="userSession")
    @JsonPropertyDescription(value="Details of a user session")
    @Valid
    @NotNull
    private ApiUserSession userSession;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiIncomeEvidenceMetadata() {
    }

    public ApiIncomeEvidenceMetadata(LocalDate applicationReceivedDate, Boolean evidencePending, String notes, ApiUserSession userSession) {
        this.applicationReceivedDate = applicationReceivedDate;
        this.evidencePending = evidencePending;
        this.notes = notes;
        this.userSession = userSession;
    }

    @JsonProperty(value="applicationReceivedDate")
    public LocalDate getApplicationReceivedDate() {
        return this.applicationReceivedDate;
    }

    @JsonProperty(value="applicationReceivedDate")
    public void setApplicationReceivedDate(LocalDate applicationReceivedDate) {
        this.applicationReceivedDate = applicationReceivedDate;
    }

    public ApiIncomeEvidenceMetadata withApplicationReceivedDate(LocalDate applicationReceivedDate) {
        this.applicationReceivedDate = applicationReceivedDate;
        return this;
    }

    @JsonProperty(value="evidencePending")
    public Boolean getEvidencePending() {
        return this.evidencePending;
    }

    @JsonProperty(value="evidencePending")
    public void setEvidencePending(Boolean evidencePending) {
        this.evidencePending = evidencePending;
    }

    public ApiIncomeEvidenceMetadata withEvidencePending(Boolean evidencePending) {
        this.evidencePending = evidencePending;
        return this;
    }

    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    public void setNotes(String notes) {
        this.notes = notes;
    }

    public ApiIncomeEvidenceMetadata withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    @JsonProperty(value="userSession")
    public ApiUserSession getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    public void setUserSession(ApiUserSession userSession) {
        this.userSession = userSession;
    }

    public ApiIncomeEvidenceMetadata withUserSession(ApiUserSession userSession) {
        this.userSession = userSession;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("applicationReceivedDate".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"applicationReceivedDate\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setApplicationReceivedDate((LocalDate)value);
            return true;
        }
        if ("evidencePending".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"evidencePending\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setEvidencePending((Boolean)value);
            return true;
        }
        if ("notes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"notes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setNotes((String)value);
            return true;
        }
        if ("userSession".equals(name)) {
            if (!(value instanceof ApiUserSession)) {
                throw new IllegalArgumentException("property \"userSession\" is of type \"uk.gov.justice.laa.crime.common.model.common.ApiUserSession\", but got " + value.getClass().toString());
            }
            this.setUserSession((ApiUserSession)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("applicationReceivedDate".equals(name)) {
            return this.getApplicationReceivedDate();
        }
        if ("evidencePending".equals(name)) {
            return this.getEvidencePending();
        }
        if ("notes".equals(name)) {
            return this.getNotes();
        }
        if ("userSession".equals(name)) {
            return this.getUserSession();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiIncomeEvidenceMetadata with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiIncomeEvidenceMetadata.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("applicationReceivedDate");
        sb.append('=');
        sb.append(this.applicationReceivedDate == null ? "<null>" : this.applicationReceivedDate);
        sb.append(',');
        sb.append("evidencePending");
        sb.append('=');
        sb.append(this.evidencePending == null ? "<null>" : this.evidencePending);
        sb.append(',');
        sb.append("notes");
        sb.append('=');
        sb.append(this.notes == null ? "<null>" : this.notes);
        sb.append(',');
        sb.append("userSession");
        sb.append('=');
        sb.append(this.userSession == null ? "<null>" : this.userSession);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.userSession == null ? 0 : this.userSession.hashCode());
        result = result * 31 + (this.applicationReceivedDate == null ? 0 : this.applicationReceivedDate.hashCode());
        result = result * 31 + (this.notes == null ? 0 : this.notes.hashCode());
        result = result * 31 + (this.evidencePending == null ? 0 : this.evidencePending.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiIncomeEvidenceMetadata)) {
            return false;
        }
        ApiIncomeEvidenceMetadata rhs = (ApiIncomeEvidenceMetadata)other;
        return (this.userSession == rhs.userSession || this.userSession != null && this.userSession.equals(rhs.userSession)) && (this.applicationReceivedDate == rhs.applicationReceivedDate || this.applicationReceivedDate != null && this.applicationReceivedDate.equals(rhs.applicationReceivedDate)) && (this.notes == rhs.notes || this.notes != null && this.notes.equals(rhs.notes)) && (this.evidencePending == rhs.evidencePending || this.evidencePending != null && this.evidencePending.equals(rhs.evidencePending));
    }
}

