/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.evidence;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import uk.gov.justice.laa.crime.common.model.evidence.ApiIncomeEvidenceItems;
import uk.gov.justice.laa.crime.common.model.evidence.ApiIncomeEvidenceMetadata;
import uk.gov.justice.laa.crime.enums.MagCourtOutcome;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"magCourtOutcome", "applicantEvidenceItems", "applicantPensionAmount", "partnerEvidenceItems", "partnerPensionAmount", "metadata", "evidenceDueDate", "evidenceReceivedDate", "previousEvidenceDueDate", "oldUpliftAppliedDate", "oldUpliftRemovedDate", "upliftAppliedDate", "upliftRemovedDate"})
public class ApiUpdateIncomeEvidenceRequest {
    @JsonProperty(value="magCourtOutcome")
    @JsonPropertyDescription(value="Magistrate Court Outcome")
    @Valid
    @NotNull
    private MagCourtOutcome magCourtOutcome;
    @JsonProperty(value="applicantEvidenceItems")
    @JsonPropertyDescription(value="Represents a list of income evidence records associated with an applicant")
    @Valid
    private ApiIncomeEvidenceItems applicantEvidenceItems;
    @JsonProperty(value="applicantPensionAmount")
    @JsonPropertyDescription(value="Applicant pension amount")
    private BigDecimal applicantPensionAmount;
    @JsonProperty(value="partnerEvidenceItems")
    @JsonPropertyDescription(value="Represents a list of income evidence records associated with an applicant")
    @Valid
    private ApiIncomeEvidenceItems partnerEvidenceItems;
    @JsonProperty(value="partnerPensionAmount")
    @JsonPropertyDescription(value="Partner pension amount")
    private BigDecimal partnerPensionAmount;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="MAAT specific metadata required to process income evidence")
    @Valid
    @NotNull
    private ApiIncomeEvidenceMetadata metadata;
    @JsonProperty(value="evidenceDueDate")
    @JsonPropertyDescription(value="The date the evidence is due")
    private LocalDateTime evidenceDueDate;
    @JsonProperty(value="evidenceReceivedDate")
    @JsonPropertyDescription(value="The date the evidence has been received")
    private LocalDateTime evidenceReceivedDate;
    @JsonProperty(value="previousEvidenceDueDate")
    @JsonPropertyDescription(value="The date evidence was previously due by")
    private LocalDateTime previousEvidenceDueDate;
    @JsonProperty(value="oldUpliftAppliedDate")
    @JsonPropertyDescription(value="The date when uplift was previously applied")
    private LocalDate oldUpliftAppliedDate;
    @JsonProperty(value="oldUpliftRemovedDate")
    @JsonPropertyDescription(value="The date when uplift was previously removed")
    private LocalDate oldUpliftRemovedDate;
    @JsonProperty(value="upliftAppliedDate")
    @JsonPropertyDescription(value="The current uplift applied date")
    private LocalDate upliftAppliedDate;
    @JsonProperty(value="upliftRemovedDate")
    @JsonPropertyDescription(value="The current uplift removed date")
    private LocalDate upliftRemovedDate;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiUpdateIncomeEvidenceRequest() {
    }

    public ApiUpdateIncomeEvidenceRequest(MagCourtOutcome magCourtOutcome, ApiIncomeEvidenceItems applicantEvidenceItems, BigDecimal applicantPensionAmount, ApiIncomeEvidenceItems partnerEvidenceItems, BigDecimal partnerPensionAmount, ApiIncomeEvidenceMetadata metadata, LocalDateTime evidenceDueDate, LocalDateTime evidenceReceivedDate, LocalDateTime previousEvidenceDueDate, LocalDate oldUpliftAppliedDate, LocalDate oldUpliftRemovedDate, LocalDate upliftAppliedDate, LocalDate upliftRemovedDate) {
        this.magCourtOutcome = magCourtOutcome;
        this.applicantEvidenceItems = applicantEvidenceItems;
        this.applicantPensionAmount = applicantPensionAmount;
        this.partnerEvidenceItems = partnerEvidenceItems;
        this.partnerPensionAmount = partnerPensionAmount;
        this.metadata = metadata;
        this.evidenceDueDate = evidenceDueDate;
        this.evidenceReceivedDate = evidenceReceivedDate;
        this.previousEvidenceDueDate = previousEvidenceDueDate;
        this.oldUpliftAppliedDate = oldUpliftAppliedDate;
        this.oldUpliftRemovedDate = oldUpliftRemovedDate;
        this.upliftAppliedDate = upliftAppliedDate;
        this.upliftRemovedDate = upliftRemovedDate;
    }

    @JsonProperty(value="magCourtOutcome")
    public MagCourtOutcome getMagCourtOutcome() {
        return this.magCourtOutcome;
    }

    @JsonProperty(value="magCourtOutcome")
    public void setMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
    }

    public ApiUpdateIncomeEvidenceRequest withMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
        return this;
    }

    @JsonProperty(value="applicantEvidenceItems")
    public ApiIncomeEvidenceItems getApplicantEvidenceItems() {
        return this.applicantEvidenceItems;
    }

    @JsonProperty(value="applicantEvidenceItems")
    public void setApplicantEvidenceItems(ApiIncomeEvidenceItems applicantEvidenceItems) {
        this.applicantEvidenceItems = applicantEvidenceItems;
    }

    public ApiUpdateIncomeEvidenceRequest withApplicantEvidenceItems(ApiIncomeEvidenceItems applicantEvidenceItems) {
        this.applicantEvidenceItems = applicantEvidenceItems;
        return this;
    }

    @JsonProperty(value="applicantPensionAmount")
    public BigDecimal getApplicantPensionAmount() {
        return this.applicantPensionAmount;
    }

    @JsonProperty(value="applicantPensionAmount")
    public void setApplicantPensionAmount(BigDecimal applicantPensionAmount) {
        this.applicantPensionAmount = applicantPensionAmount;
    }

    public ApiUpdateIncomeEvidenceRequest withApplicantPensionAmount(BigDecimal applicantPensionAmount) {
        this.applicantPensionAmount = applicantPensionAmount;
        return this;
    }

    @JsonProperty(value="partnerEvidenceItems")
    public ApiIncomeEvidenceItems getPartnerEvidenceItems() {
        return this.partnerEvidenceItems;
    }

    @JsonProperty(value="partnerEvidenceItems")
    public void setPartnerEvidenceItems(ApiIncomeEvidenceItems partnerEvidenceItems) {
        this.partnerEvidenceItems = partnerEvidenceItems;
    }

    public ApiUpdateIncomeEvidenceRequest withPartnerEvidenceItems(ApiIncomeEvidenceItems partnerEvidenceItems) {
        this.partnerEvidenceItems = partnerEvidenceItems;
        return this;
    }

    @JsonProperty(value="partnerPensionAmount")
    public BigDecimal getPartnerPensionAmount() {
        return this.partnerPensionAmount;
    }

    @JsonProperty(value="partnerPensionAmount")
    public void setPartnerPensionAmount(BigDecimal partnerPensionAmount) {
        this.partnerPensionAmount = partnerPensionAmount;
    }

    public ApiUpdateIncomeEvidenceRequest withPartnerPensionAmount(BigDecimal partnerPensionAmount) {
        this.partnerPensionAmount = partnerPensionAmount;
        return this;
    }

    @JsonProperty(value="metadata")
    public ApiIncomeEvidenceMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(ApiIncomeEvidenceMetadata metadata) {
        this.metadata = metadata;
    }

    public ApiUpdateIncomeEvidenceRequest withMetadata(ApiIncomeEvidenceMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonProperty(value="evidenceDueDate")
    public LocalDateTime getEvidenceDueDate() {
        return this.evidenceDueDate;
    }

    @JsonProperty(value="evidenceDueDate")
    public void setEvidenceDueDate(LocalDateTime evidenceDueDate) {
        this.evidenceDueDate = evidenceDueDate;
    }

    public ApiUpdateIncomeEvidenceRequest withEvidenceDueDate(LocalDateTime evidenceDueDate) {
        this.evidenceDueDate = evidenceDueDate;
        return this;
    }

    @JsonProperty(value="evidenceReceivedDate")
    public LocalDateTime getEvidenceReceivedDate() {
        return this.evidenceReceivedDate;
    }

    @JsonProperty(value="evidenceReceivedDate")
    public void setEvidenceReceivedDate(LocalDateTime evidenceReceivedDate) {
        this.evidenceReceivedDate = evidenceReceivedDate;
    }

    public ApiUpdateIncomeEvidenceRequest withEvidenceReceivedDate(LocalDateTime evidenceReceivedDate) {
        this.evidenceReceivedDate = evidenceReceivedDate;
        return this;
    }

    @JsonProperty(value="previousEvidenceDueDate")
    public LocalDateTime getPreviousEvidenceDueDate() {
        return this.previousEvidenceDueDate;
    }

    @JsonProperty(value="previousEvidenceDueDate")
    public void setPreviousEvidenceDueDate(LocalDateTime previousEvidenceDueDate) {
        this.previousEvidenceDueDate = previousEvidenceDueDate;
    }

    public ApiUpdateIncomeEvidenceRequest withPreviousEvidenceDueDate(LocalDateTime previousEvidenceDueDate) {
        this.previousEvidenceDueDate = previousEvidenceDueDate;
        return this;
    }

    @JsonProperty(value="oldUpliftAppliedDate")
    public LocalDate getOldUpliftAppliedDate() {
        return this.oldUpliftAppliedDate;
    }

    @JsonProperty(value="oldUpliftAppliedDate")
    public void setOldUpliftAppliedDate(LocalDate oldUpliftAppliedDate) {
        this.oldUpliftAppliedDate = oldUpliftAppliedDate;
    }

    public ApiUpdateIncomeEvidenceRequest withOldUpliftAppliedDate(LocalDate oldUpliftAppliedDate) {
        this.oldUpliftAppliedDate = oldUpliftAppliedDate;
        return this;
    }

    @JsonProperty(value="oldUpliftRemovedDate")
    public LocalDate getOldUpliftRemovedDate() {
        return this.oldUpliftRemovedDate;
    }

    @JsonProperty(value="oldUpliftRemovedDate")
    public void setOldUpliftRemovedDate(LocalDate oldUpliftRemovedDate) {
        this.oldUpliftRemovedDate = oldUpliftRemovedDate;
    }

    public ApiUpdateIncomeEvidenceRequest withOldUpliftRemovedDate(LocalDate oldUpliftRemovedDate) {
        this.oldUpliftRemovedDate = oldUpliftRemovedDate;
        return this;
    }

    @JsonProperty(value="upliftAppliedDate")
    public LocalDate getUpliftAppliedDate() {
        return this.upliftAppliedDate;
    }

    @JsonProperty(value="upliftAppliedDate")
    public void setUpliftAppliedDate(LocalDate upliftAppliedDate) {
        this.upliftAppliedDate = upliftAppliedDate;
    }

    public ApiUpdateIncomeEvidenceRequest withUpliftAppliedDate(LocalDate upliftAppliedDate) {
        this.upliftAppliedDate = upliftAppliedDate;
        return this;
    }

    @JsonProperty(value="upliftRemovedDate")
    public LocalDate getUpliftRemovedDate() {
        return this.upliftRemovedDate;
    }

    @JsonProperty(value="upliftRemovedDate")
    public void setUpliftRemovedDate(LocalDate upliftRemovedDate) {
        this.upliftRemovedDate = upliftRemovedDate;
    }

    public ApiUpdateIncomeEvidenceRequest withUpliftRemovedDate(LocalDate upliftRemovedDate) {
        this.upliftRemovedDate = upliftRemovedDate;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("magCourtOutcome".equals(name)) {
            if (!(value instanceof MagCourtOutcome)) {
                throw new IllegalArgumentException("property \"magCourtOutcome\" is of type \"uk.gov.justice.laa.crime.enums.MagCourtOutcome\", but got " + value.getClass().toString());
            }
            this.setMagCourtOutcome((MagCourtOutcome)value);
            return true;
        }
        if ("applicantEvidenceItems".equals(name)) {
            if (!(value instanceof ApiIncomeEvidenceItems)) {
                throw new IllegalArgumentException("property \"applicantEvidenceItems\" is of type \"uk.gov.justice.laa.crime.common.model.evidence.ApiIncomeEvidenceItems\", but got " + value.getClass().toString());
            }
            this.setApplicantEvidenceItems((ApiIncomeEvidenceItems)value);
            return true;
        }
        if ("applicantPensionAmount".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"applicantPensionAmount\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setApplicantPensionAmount((BigDecimal)value);
            return true;
        }
        if ("partnerEvidenceItems".equals(name)) {
            if (!(value instanceof ApiIncomeEvidenceItems)) {
                throw new IllegalArgumentException("property \"partnerEvidenceItems\" is of type \"uk.gov.justice.laa.crime.common.model.evidence.ApiIncomeEvidenceItems\", but got " + value.getClass().toString());
            }
            this.setPartnerEvidenceItems((ApiIncomeEvidenceItems)value);
            return true;
        }
        if ("partnerPensionAmount".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"partnerPensionAmount\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setPartnerPensionAmount((BigDecimal)value);
            return true;
        }
        if ("metadata".equals(name)) {
            if (!(value instanceof ApiIncomeEvidenceMetadata)) {
                throw new IllegalArgumentException("property \"metadata\" is of type \"uk.gov.justice.laa.crime.common.model.evidence.ApiIncomeEvidenceMetadata\", but got " + value.getClass().toString());
            }
            this.setMetadata((ApiIncomeEvidenceMetadata)value);
            return true;
        }
        if ("evidenceDueDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"evidenceDueDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setEvidenceDueDate((LocalDateTime)value);
            return true;
        }
        if ("evidenceReceivedDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"evidenceReceivedDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setEvidenceReceivedDate((LocalDateTime)value);
            return true;
        }
        if ("previousEvidenceDueDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"previousEvidenceDueDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setPreviousEvidenceDueDate((LocalDateTime)value);
            return true;
        }
        if ("oldUpliftAppliedDate".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"oldUpliftAppliedDate\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setOldUpliftAppliedDate((LocalDate)value);
            return true;
        }
        if ("oldUpliftRemovedDate".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"oldUpliftRemovedDate\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setOldUpliftRemovedDate((LocalDate)value);
            return true;
        }
        if ("upliftAppliedDate".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"upliftAppliedDate\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setUpliftAppliedDate((LocalDate)value);
            return true;
        }
        if ("upliftRemovedDate".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"upliftRemovedDate\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setUpliftRemovedDate((LocalDate)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("magCourtOutcome".equals(name)) {
            return this.getMagCourtOutcome();
        }
        if ("applicantEvidenceItems".equals(name)) {
            return this.getApplicantEvidenceItems();
        }
        if ("applicantPensionAmount".equals(name)) {
            return this.getApplicantPensionAmount();
        }
        if ("partnerEvidenceItems".equals(name)) {
            return this.getPartnerEvidenceItems();
        }
        if ("partnerPensionAmount".equals(name)) {
            return this.getPartnerPensionAmount();
        }
        if ("metadata".equals(name)) {
            return this.getMetadata();
        }
        if ("evidenceDueDate".equals(name)) {
            return this.getEvidenceDueDate();
        }
        if ("evidenceReceivedDate".equals(name)) {
            return this.getEvidenceReceivedDate();
        }
        if ("previousEvidenceDueDate".equals(name)) {
            return this.getPreviousEvidenceDueDate();
        }
        if ("oldUpliftAppliedDate".equals(name)) {
            return this.getOldUpliftAppliedDate();
        }
        if ("oldUpliftRemovedDate".equals(name)) {
            return this.getOldUpliftRemovedDate();
        }
        if ("upliftAppliedDate".equals(name)) {
            return this.getUpliftAppliedDate();
        }
        if ("upliftRemovedDate".equals(name)) {
            return this.getUpliftRemovedDate();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiUpdateIncomeEvidenceRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiUpdateIncomeEvidenceRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("magCourtOutcome");
        sb.append('=');
        sb.append((Object)(this.magCourtOutcome == null ? "<null>" : this.magCourtOutcome));
        sb.append(',');
        sb.append("applicantEvidenceItems");
        sb.append('=');
        sb.append(this.applicantEvidenceItems == null ? "<null>" : this.applicantEvidenceItems);
        sb.append(',');
        sb.append("applicantPensionAmount");
        sb.append('=');
        sb.append(this.applicantPensionAmount == null ? "<null>" : this.applicantPensionAmount);
        sb.append(',');
        sb.append("partnerEvidenceItems");
        sb.append('=');
        sb.append(this.partnerEvidenceItems == null ? "<null>" : this.partnerEvidenceItems);
        sb.append(',');
        sb.append("partnerPensionAmount");
        sb.append('=');
        sb.append(this.partnerPensionAmount == null ? "<null>" : this.partnerPensionAmount);
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(this.metadata == null ? "<null>" : this.metadata);
        sb.append(',');
        sb.append("evidenceDueDate");
        sb.append('=');
        sb.append(this.evidenceDueDate == null ? "<null>" : this.evidenceDueDate);
        sb.append(',');
        sb.append("evidenceReceivedDate");
        sb.append('=');
        sb.append(this.evidenceReceivedDate == null ? "<null>" : this.evidenceReceivedDate);
        sb.append(',');
        sb.append("previousEvidenceDueDate");
        sb.append('=');
        sb.append(this.previousEvidenceDueDate == null ? "<null>" : this.previousEvidenceDueDate);
        sb.append(',');
        sb.append("oldUpliftAppliedDate");
        sb.append('=');
        sb.append(this.oldUpliftAppliedDate == null ? "<null>" : this.oldUpliftAppliedDate);
        sb.append(',');
        sb.append("oldUpliftRemovedDate");
        sb.append('=');
        sb.append(this.oldUpliftRemovedDate == null ? "<null>" : this.oldUpliftRemovedDate);
        sb.append(',');
        sb.append("upliftAppliedDate");
        sb.append('=');
        sb.append(this.upliftAppliedDate == null ? "<null>" : this.upliftAppliedDate);
        sb.append(',');
        sb.append("upliftRemovedDate");
        sb.append('=');
        sb.append(this.upliftRemovedDate == null ? "<null>" : this.upliftRemovedDate);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.applicantEvidenceItems == null ? 0 : this.applicantEvidenceItems.hashCode());
        result = result * 31 + (this.applicantPensionAmount == null ? 0 : this.applicantPensionAmount.hashCode());
        result = result * 31 + (this.previousEvidenceDueDate == null ? 0 : this.previousEvidenceDueDate.hashCode());
        result = result * 31 + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = result * 31 + (this.upliftRemovedDate == null ? 0 : this.upliftRemovedDate.hashCode());
        result = result * 31 + (this.partnerPensionAmount == null ? 0 : this.partnerPensionAmount.hashCode());
        result = result * 31 + (this.evidenceDueDate == null ? 0 : this.evidenceDueDate.hashCode());
        result = result * 31 + (this.magCourtOutcome == null ? 0 : this.magCourtOutcome.hashCode());
        result = result * 31 + (this.oldUpliftAppliedDate == null ? 0 : this.oldUpliftAppliedDate.hashCode());
        result = result * 31 + (this.oldUpliftRemovedDate == null ? 0 : this.oldUpliftRemovedDate.hashCode());
        result = result * 31 + (this.partnerEvidenceItems == null ? 0 : this.partnerEvidenceItems.hashCode());
        result = result * 31 + (this.evidenceReceivedDate == null ? 0 : this.evidenceReceivedDate.hashCode());
        result = result * 31 + (this.upliftAppliedDate == null ? 0 : this.upliftAppliedDate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiUpdateIncomeEvidenceRequest)) {
            return false;
        }
        ApiUpdateIncomeEvidenceRequest rhs = (ApiUpdateIncomeEvidenceRequest)other;
        return (this.applicantEvidenceItems == rhs.applicantEvidenceItems || this.applicantEvidenceItems != null && this.applicantEvidenceItems.equals(rhs.applicantEvidenceItems)) && (this.applicantPensionAmount == rhs.applicantPensionAmount || this.applicantPensionAmount != null && this.applicantPensionAmount.equals(rhs.applicantPensionAmount)) && (this.previousEvidenceDueDate == rhs.previousEvidenceDueDate || this.previousEvidenceDueDate != null && this.previousEvidenceDueDate.equals(rhs.previousEvidenceDueDate)) && (this.metadata == rhs.metadata || this.metadata != null && this.metadata.equals(rhs.metadata)) && (this.upliftRemovedDate == rhs.upliftRemovedDate || this.upliftRemovedDate != null && this.upliftRemovedDate.equals(rhs.upliftRemovedDate)) && (this.partnerPensionAmount == rhs.partnerPensionAmount || this.partnerPensionAmount != null && this.partnerPensionAmount.equals(rhs.partnerPensionAmount)) && (this.evidenceDueDate == rhs.evidenceDueDate || this.evidenceDueDate != null && this.evidenceDueDate.equals(rhs.evidenceDueDate)) && (this.magCourtOutcome == rhs.magCourtOutcome || this.magCourtOutcome != null && this.magCourtOutcome.equals((Object)rhs.magCourtOutcome)) && (this.oldUpliftAppliedDate == rhs.oldUpliftAppliedDate || this.oldUpliftAppliedDate != null && this.oldUpliftAppliedDate.equals(rhs.oldUpliftAppliedDate)) && (this.oldUpliftRemovedDate == rhs.oldUpliftRemovedDate || this.oldUpliftRemovedDate != null && this.oldUpliftRemovedDate.equals(rhs.oldUpliftRemovedDate)) && (this.partnerEvidenceItems == rhs.partnerEvidenceItems || this.partnerEvidenceItems != null && this.partnerEvidenceItems.equals(rhs.partnerEvidenceItems)) && (this.evidenceReceivedDate == rhs.evidenceReceivedDate || this.evidenceReceivedDate != null && this.evidenceReceivedDate.equals(rhs.evidenceReceivedDate)) && (this.upliftAppliedDate == rhs.upliftAppliedDate || this.upliftAppliedDate != null && this.upliftAppliedDate.equals(rhs.upliftAppliedDate));
    }
}

