/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.evidence;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.LocalDate;
import uk.gov.justice.laa.crime.common.model.evidence.ApiCreateIncomeEvidenceResponse;
import uk.gov.justice.laa.crime.common.model.evidence.ApiIncomeEvidenceItems;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dueDate", "allEvidenceReceivedDate", "upliftAppliedDate", "upliftRemovedDate"})
public class ApiUpdateIncomeEvidenceResponse
extends ApiCreateIncomeEvidenceResponse {
    @JsonProperty(value="dueDate")
    @JsonPropertyDescription(value="The date the evidence is due")
    private LocalDate dueDate;
    @JsonProperty(value="allEvidenceReceivedDate")
    @JsonPropertyDescription(value="The date that all of the evidence was received")
    private LocalDate allEvidenceReceivedDate;
    @JsonProperty(value="upliftAppliedDate")
    @JsonPropertyDescription(value="The current uplift applied date")
    private LocalDate upliftAppliedDate;
    @JsonProperty(value="upliftRemovedDate")
    @JsonPropertyDescription(value="The current uplift removed date")
    private LocalDate upliftRemovedDate;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiUpdateIncomeEvidenceResponse() {
    }

    public ApiUpdateIncomeEvidenceResponse(LocalDate dueDate, LocalDate allEvidenceReceivedDate, LocalDate upliftAppliedDate, LocalDate upliftRemovedDate, ApiIncomeEvidenceItems applicantEvidenceItems, ApiIncomeEvidenceItems partnerEvidenceItems) {
        super(applicantEvidenceItems, partnerEvidenceItems);
        this.dueDate = dueDate;
        this.allEvidenceReceivedDate = allEvidenceReceivedDate;
        this.upliftAppliedDate = upliftAppliedDate;
        this.upliftRemovedDate = upliftRemovedDate;
    }

    @JsonProperty(value="dueDate")
    public LocalDate getDueDate() {
        return this.dueDate;
    }

    @JsonProperty(value="dueDate")
    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public ApiUpdateIncomeEvidenceResponse withDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @JsonProperty(value="allEvidenceReceivedDate")
    public LocalDate getAllEvidenceReceivedDate() {
        return this.allEvidenceReceivedDate;
    }

    @JsonProperty(value="allEvidenceReceivedDate")
    public void setAllEvidenceReceivedDate(LocalDate allEvidenceReceivedDate) {
        this.allEvidenceReceivedDate = allEvidenceReceivedDate;
    }

    public ApiUpdateIncomeEvidenceResponse withAllEvidenceReceivedDate(LocalDate allEvidenceReceivedDate) {
        this.allEvidenceReceivedDate = allEvidenceReceivedDate;
        return this;
    }

    @JsonProperty(value="upliftAppliedDate")
    public LocalDate getUpliftAppliedDate() {
        return this.upliftAppliedDate;
    }

    @JsonProperty(value="upliftAppliedDate")
    public void setUpliftAppliedDate(LocalDate upliftAppliedDate) {
        this.upliftAppliedDate = upliftAppliedDate;
    }

    public ApiUpdateIncomeEvidenceResponse withUpliftAppliedDate(LocalDate upliftAppliedDate) {
        this.upliftAppliedDate = upliftAppliedDate;
        return this;
    }

    @JsonProperty(value="upliftRemovedDate")
    public LocalDate getUpliftRemovedDate() {
        return this.upliftRemovedDate;
    }

    @JsonProperty(value="upliftRemovedDate")
    public void setUpliftRemovedDate(LocalDate upliftRemovedDate) {
        this.upliftRemovedDate = upliftRemovedDate;
    }

    public ApiUpdateIncomeEvidenceResponse withUpliftRemovedDate(LocalDate upliftRemovedDate) {
        this.upliftRemovedDate = upliftRemovedDate;
        return this;
    }

    @Override
    public ApiUpdateIncomeEvidenceResponse withApplicantEvidenceItems(ApiIncomeEvidenceItems applicantEvidenceItems) {
        super.withApplicantEvidenceItems(applicantEvidenceItems);
        return this;
    }

    @Override
    public ApiUpdateIncomeEvidenceResponse withPartnerEvidenceItems(ApiIncomeEvidenceItems partnerEvidenceItems) {
        super.withPartnerEvidenceItems(partnerEvidenceItems);
        return this;
    }

    @Override
    protected boolean declaredProperty(String name, Object value) {
        if ("dueDate".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"dueDate\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setDueDate((LocalDate)value);
            return true;
        }
        if ("allEvidenceReceivedDate".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"allEvidenceReceivedDate\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setAllEvidenceReceivedDate((LocalDate)value);
            return true;
        }
        if ("upliftAppliedDate".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"upliftAppliedDate\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setUpliftAppliedDate((LocalDate)value);
            return true;
        }
        if ("upliftRemovedDate".equals(name)) {
            if (!(value instanceof LocalDate)) {
                throw new IllegalArgumentException("property \"upliftRemovedDate\" is of type \"java.time.LocalDate\", but got " + value.getClass().toString());
            }
            this.setUpliftRemovedDate((LocalDate)value);
            return true;
        }
        return super.declaredProperty(name, value);
    }

    @Override
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dueDate".equals(name)) {
            return this.getDueDate();
        }
        if ("allEvidenceReceivedDate".equals(name)) {
            return this.getAllEvidenceReceivedDate();
        }
        if ("upliftAppliedDate".equals(name)) {
            return this.getUpliftAppliedDate();
        }
        if ("upliftRemovedDate".equals(name)) {
            return this.getUpliftRemovedDate();
        }
        return super.declaredPropertyOrNotFound(name, notFoundValue);
    }

    @Override
    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    @Override
    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    @Override
    public ApiUpdateIncomeEvidenceResponse with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiUpdateIncomeEvidenceResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("dueDate");
        sb.append('=');
        sb.append(this.dueDate == null ? "<null>" : this.dueDate);
        sb.append(',');
        sb.append("allEvidenceReceivedDate");
        sb.append('=');
        sb.append(this.allEvidenceReceivedDate == null ? "<null>" : this.allEvidenceReceivedDate);
        sb.append(',');
        sb.append("upliftAppliedDate");
        sb.append('=');
        sb.append(this.upliftAppliedDate == null ? "<null>" : this.upliftAppliedDate);
        sb.append(',');
        sb.append("upliftRemovedDate");
        sb.append('=');
        sb.append(this.upliftRemovedDate == null ? "<null>" : this.upliftRemovedDate);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.allEvidenceReceivedDate == null ? 0 : this.allEvidenceReceivedDate.hashCode());
        result = result * 31 + (this.upliftRemovedDate == null ? 0 : this.upliftRemovedDate.hashCode());
        result = result * 31 + (this.upliftAppliedDate == null ? 0 : this.upliftAppliedDate.hashCode());
        result = result * 31 + (this.dueDate == null ? 0 : this.dueDate.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiUpdateIncomeEvidenceResponse)) {
            return false;
        }
        ApiUpdateIncomeEvidenceResponse rhs = (ApiUpdateIncomeEvidenceResponse)other;
        return super.equals(rhs) && (this.allEvidenceReceivedDate == rhs.allEvidenceReceivedDate || this.allEvidenceReceivedDate != null && this.allEvidenceReceivedDate.equals(rhs.allEvidenceReceivedDate)) && (this.upliftRemovedDate == rhs.upliftRemovedDate || this.upliftRemovedDate != null && this.upliftRemovedDate.equals(rhs.upliftRemovedDate)) && (this.upliftAppliedDate == rhs.upliftAppliedDate || this.upliftAppliedDate != null && this.upliftAppliedDate.equals(rhs.upliftAppliedDate)) && (this.dueDate == rhs.dueDate || this.dueDate != null && this.dueDate.equals(rhs.dueDate));
    }
}

