/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.hardship;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import uk.gov.justice.laa.crime.enums.HardshipReviewResult;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"reviewResult", "postHardshipDisposableIncome", "disposableIncome"})
public class ApiCalculateHardshipResponse {
    @JsonProperty(value="reviewResult")
    @JsonPropertyDescription(value="The review result")
    @Valid
    private HardshipReviewResult reviewResult;
    @JsonProperty(value="postHardshipDisposableIncome")
    @JsonPropertyDescription(value="Post hardship disposable income")
    private BigDecimal postHardshipDisposableIncome;
    @JsonProperty(value="disposableIncome")
    @JsonPropertyDescription(value="The disposable income")
    private BigDecimal disposableIncome;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiCalculateHardshipResponse() {
    }

    public ApiCalculateHardshipResponse(HardshipReviewResult reviewResult, BigDecimal postHardshipDisposableIncome, BigDecimal disposableIncome) {
        this.reviewResult = reviewResult;
        this.postHardshipDisposableIncome = postHardshipDisposableIncome;
        this.disposableIncome = disposableIncome;
    }

    @JsonProperty(value="reviewResult")
    public HardshipReviewResult getReviewResult() {
        return this.reviewResult;
    }

    @JsonProperty(value="reviewResult")
    public void setReviewResult(HardshipReviewResult reviewResult) {
        this.reviewResult = reviewResult;
    }

    public ApiCalculateHardshipResponse withReviewResult(HardshipReviewResult reviewResult) {
        this.reviewResult = reviewResult;
        return this;
    }

    @JsonProperty(value="postHardshipDisposableIncome")
    public BigDecimal getPostHardshipDisposableIncome() {
        return this.postHardshipDisposableIncome;
    }

    @JsonProperty(value="postHardshipDisposableIncome")
    public void setPostHardshipDisposableIncome(BigDecimal postHardshipDisposableIncome) {
        this.postHardshipDisposableIncome = postHardshipDisposableIncome;
    }

    public ApiCalculateHardshipResponse withPostHardshipDisposableIncome(BigDecimal postHardshipDisposableIncome) {
        this.postHardshipDisposableIncome = postHardshipDisposableIncome;
        return this;
    }

    @JsonProperty(value="disposableIncome")
    public BigDecimal getDisposableIncome() {
        return this.disposableIncome;
    }

    @JsonProperty(value="disposableIncome")
    public void setDisposableIncome(BigDecimal disposableIncome) {
        this.disposableIncome = disposableIncome;
    }

    public ApiCalculateHardshipResponse withDisposableIncome(BigDecimal disposableIncome) {
        this.disposableIncome = disposableIncome;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("reviewResult".equals(name)) {
            if (!(value instanceof HardshipReviewResult)) {
                throw new IllegalArgumentException("property \"reviewResult\" is of type \"uk.gov.justice.laa.crime.enums.HardshipReviewResult\", but got " + value.getClass().toString());
            }
            this.setReviewResult((HardshipReviewResult)value);
            return true;
        }
        if ("postHardshipDisposableIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"postHardshipDisposableIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setPostHardshipDisposableIncome((BigDecimal)value);
            return true;
        }
        if ("disposableIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"disposableIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setDisposableIncome((BigDecimal)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("reviewResult".equals(name)) {
            return this.getReviewResult();
        }
        if ("postHardshipDisposableIncome".equals(name)) {
            return this.getPostHardshipDisposableIncome();
        }
        if ("disposableIncome".equals(name)) {
            return this.getDisposableIncome();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiCalculateHardshipResponse with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiCalculateHardshipResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("reviewResult");
        sb.append('=');
        sb.append((Object)(this.reviewResult == null ? "<null>" : this.reviewResult));
        sb.append(',');
        sb.append("postHardshipDisposableIncome");
        sb.append('=');
        sb.append(this.postHardshipDisposableIncome == null ? "<null>" : this.postHardshipDisposableIncome);
        sb.append(',');
        sb.append("disposableIncome");
        sb.append('=');
        sb.append(this.disposableIncome == null ? "<null>" : this.disposableIncome);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.disposableIncome == null ? 0 : this.disposableIncome.hashCode());
        result = result * 31 + (this.reviewResult == null ? 0 : this.reviewResult.hashCode());
        result = result * 31 + (this.postHardshipDisposableIncome == null ? 0 : this.postHardshipDisposableIncome.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiCalculateHardshipResponse)) {
            return false;
        }
        ApiCalculateHardshipResponse rhs = (ApiCalculateHardshipResponse)other;
        return (this.disposableIncome == rhs.disposableIncome || this.disposableIncome != null && this.disposableIncome.equals(rhs.disposableIncome)) && (this.reviewResult == rhs.reviewResult || this.reviewResult != null && this.reviewResult.equals((Object)rhs.reviewResult)) && (this.postHardshipDisposableIncome == rhs.postHardshipDisposableIncome || this.postHardshipDisposableIncome != null && this.postHardshipDisposableIncome.equals(rhs.postHardshipDisposableIncome));
    }
}

