/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.hardship;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.hardship.ApiHardshipDetail;
import uk.gov.justice.laa.crime.common.model.hardship.SolicitorCosts;
import uk.gov.justice.laa.crime.enums.HardshipReviewResult;
import uk.gov.justice.laa.crime.enums.HardshipReviewStatus;
import uk.gov.justice.laa.crime.enums.NewWorkReason;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "cmuId", "notes", "decisionNotes", "reviewDate", "reviewResult", "disposableIncome", "disposableIncomeAfterHardship", "newWorkReason", "solicitorCosts", "status", "reviewDetails"})
public class ApiFindHardshipResponse {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Hardship Review ID")
    private Integer id;
    @JsonProperty(value="cmuId")
    @JsonPropertyDescription(value="Case Management Unit Id")
    private Integer cmuId;
    @JsonProperty(value="notes")
    @JsonPropertyDescription(value="The review progress notes")
    private String notes;
    @JsonProperty(value="decisionNotes")
    @JsonPropertyDescription(value="The notes regarding the decision")
    private String decisionNotes;
    @JsonProperty(value="reviewDate")
    @JsonPropertyDescription(value="The hardship review date")
    private LocalDateTime reviewDate;
    @JsonProperty(value="reviewResult")
    @JsonPropertyDescription(value="The review result")
    @Valid
    private HardshipReviewResult reviewResult;
    @JsonProperty(value="disposableIncome")
    @JsonPropertyDescription(value="The disposable income")
    private BigDecimal disposableIncome;
    @JsonProperty(value="disposableIncomeAfterHardship")
    @JsonPropertyDescription(value="Disposable income post Hardship Review")
    private BigDecimal disposableIncomeAfterHardship;
    @JsonProperty(value="newWorkReason")
    @JsonPropertyDescription(value="The new work reason code")
    @Valid
    private NewWorkReason newWorkReason;
    @JsonProperty(value="solicitorCosts")
    @JsonPropertyDescription(value="Details of solicitor cost")
    @Valid
    private SolicitorCosts solicitorCosts;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="The review status")
    @Valid
    private HardshipReviewStatus status;
    @JsonProperty(value="reviewDetails")
    @JsonPropertyDescription(value="Hardship review detail items")
    @Valid
    private List<ApiHardshipDetail> reviewDetails = new ArrayList<ApiHardshipDetail>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiFindHardshipResponse() {
    }

    public ApiFindHardshipResponse(Integer id, Integer cmuId, String notes, String decisionNotes, LocalDateTime reviewDate, HardshipReviewResult reviewResult, BigDecimal disposableIncome, BigDecimal disposableIncomeAfterHardship, NewWorkReason newWorkReason, SolicitorCosts solicitorCosts, HardshipReviewStatus status, List<ApiHardshipDetail> reviewDetails) {
        this.id = id;
        this.cmuId = cmuId;
        this.notes = notes;
        this.decisionNotes = decisionNotes;
        this.reviewDate = reviewDate;
        this.reviewResult = reviewResult;
        this.disposableIncome = disposableIncome;
        this.disposableIncomeAfterHardship = disposableIncomeAfterHardship;
        this.newWorkReason = newWorkReason;
        this.solicitorCosts = solicitorCosts;
        this.status = status;
        this.reviewDetails = reviewDetails;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public ApiFindHardshipResponse withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="cmuId")
    public Integer getCmuId() {
        return this.cmuId;
    }

    @JsonProperty(value="cmuId")
    public void setCmuId(Integer cmuId) {
        this.cmuId = cmuId;
    }

    public ApiFindHardshipResponse withCmuId(Integer cmuId) {
        this.cmuId = cmuId;
        return this;
    }

    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    public void setNotes(String notes) {
        this.notes = notes;
    }

    public ApiFindHardshipResponse withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    @JsonProperty(value="decisionNotes")
    public String getDecisionNotes() {
        return this.decisionNotes;
    }

    @JsonProperty(value="decisionNotes")
    public void setDecisionNotes(String decisionNotes) {
        this.decisionNotes = decisionNotes;
    }

    public ApiFindHardshipResponse withDecisionNotes(String decisionNotes) {
        this.decisionNotes = decisionNotes;
        return this;
    }

    @JsonProperty(value="reviewDate")
    public LocalDateTime getReviewDate() {
        return this.reviewDate;
    }

    @JsonProperty(value="reviewDate")
    public void setReviewDate(LocalDateTime reviewDate) {
        this.reviewDate = reviewDate;
    }

    public ApiFindHardshipResponse withReviewDate(LocalDateTime reviewDate) {
        this.reviewDate = reviewDate;
        return this;
    }

    @JsonProperty(value="reviewResult")
    public HardshipReviewResult getReviewResult() {
        return this.reviewResult;
    }

    @JsonProperty(value="reviewResult")
    public void setReviewResult(HardshipReviewResult reviewResult) {
        this.reviewResult = reviewResult;
    }

    public ApiFindHardshipResponse withReviewResult(HardshipReviewResult reviewResult) {
        this.reviewResult = reviewResult;
        return this;
    }

    @JsonProperty(value="disposableIncome")
    public BigDecimal getDisposableIncome() {
        return this.disposableIncome;
    }

    @JsonProperty(value="disposableIncome")
    public void setDisposableIncome(BigDecimal disposableIncome) {
        this.disposableIncome = disposableIncome;
    }

    public ApiFindHardshipResponse withDisposableIncome(BigDecimal disposableIncome) {
        this.disposableIncome = disposableIncome;
        return this;
    }

    @JsonProperty(value="disposableIncomeAfterHardship")
    public BigDecimal getDisposableIncomeAfterHardship() {
        return this.disposableIncomeAfterHardship;
    }

    @JsonProperty(value="disposableIncomeAfterHardship")
    public void setDisposableIncomeAfterHardship(BigDecimal disposableIncomeAfterHardship) {
        this.disposableIncomeAfterHardship = disposableIncomeAfterHardship;
    }

    public ApiFindHardshipResponse withDisposableIncomeAfterHardship(BigDecimal disposableIncomeAfterHardship) {
        this.disposableIncomeAfterHardship = disposableIncomeAfterHardship;
        return this;
    }

    @JsonProperty(value="newWorkReason")
    public NewWorkReason getNewWorkReason() {
        return this.newWorkReason;
    }

    @JsonProperty(value="newWorkReason")
    public void setNewWorkReason(NewWorkReason newWorkReason) {
        this.newWorkReason = newWorkReason;
    }

    public ApiFindHardshipResponse withNewWorkReason(NewWorkReason newWorkReason) {
        this.newWorkReason = newWorkReason;
        return this;
    }

    @JsonProperty(value="solicitorCosts")
    public SolicitorCosts getSolicitorCosts() {
        return this.solicitorCosts;
    }

    @JsonProperty(value="solicitorCosts")
    public void setSolicitorCosts(SolicitorCosts solicitorCosts) {
        this.solicitorCosts = solicitorCosts;
    }

    public ApiFindHardshipResponse withSolicitorCosts(SolicitorCosts solicitorCosts) {
        this.solicitorCosts = solicitorCosts;
        return this;
    }

    @JsonProperty(value="status")
    public HardshipReviewStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(HardshipReviewStatus status) {
        this.status = status;
    }

    public ApiFindHardshipResponse withStatus(HardshipReviewStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="reviewDetails")
    public List<ApiHardshipDetail> getReviewDetails() {
        return this.reviewDetails;
    }

    @JsonProperty(value="reviewDetails")
    public void setReviewDetails(List<ApiHardshipDetail> reviewDetails) {
        this.reviewDetails = reviewDetails;
    }

    public ApiFindHardshipResponse withReviewDetails(List<ApiHardshipDetail> reviewDetails) {
        this.reviewDetails = reviewDetails;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("id".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"id\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setId((Integer)value);
            return true;
        }
        if ("cmuId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"cmuId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setCmuId((Integer)value);
            return true;
        }
        if ("notes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"notes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setNotes((String)value);
            return true;
        }
        if ("decisionNotes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"decisionNotes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setDecisionNotes((String)value);
            return true;
        }
        if ("reviewDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"reviewDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setReviewDate((LocalDateTime)value);
            return true;
        }
        if ("reviewResult".equals(name)) {
            if (!(value instanceof HardshipReviewResult)) {
                throw new IllegalArgumentException("property \"reviewResult\" is of type \"uk.gov.justice.laa.crime.enums.HardshipReviewResult\", but got " + value.getClass().toString());
            }
            this.setReviewResult((HardshipReviewResult)value);
            return true;
        }
        if ("disposableIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"disposableIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setDisposableIncome((BigDecimal)value);
            return true;
        }
        if ("disposableIncomeAfterHardship".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"disposableIncomeAfterHardship\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setDisposableIncomeAfterHardship((BigDecimal)value);
            return true;
        }
        if ("newWorkReason".equals(name)) {
            if (!(value instanceof NewWorkReason)) {
                throw new IllegalArgumentException("property \"newWorkReason\" is of type \"uk.gov.justice.laa.crime.enums.NewWorkReason\", but got " + value.getClass().toString());
            }
            this.setNewWorkReason((NewWorkReason)value);
            return true;
        }
        if ("solicitorCosts".equals(name)) {
            if (!(value instanceof SolicitorCosts)) {
                throw new IllegalArgumentException("property \"solicitorCosts\" is of type \"uk.gov.justice.laa.crime.common.model.hardship.SolicitorCosts\", but got " + value.getClass().toString());
            }
            this.setSolicitorCosts((SolicitorCosts)value);
            return true;
        }
        if ("status".equals(name)) {
            if (!(value instanceof HardshipReviewStatus)) {
                throw new IllegalArgumentException("property \"status\" is of type \"uk.gov.justice.laa.crime.enums.HardshipReviewStatus\", but got " + value.getClass().toString());
            }
            this.setStatus((HardshipReviewStatus)value);
            return true;
        }
        if ("reviewDetails".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"reviewDetails\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.hardship.ApiHardshipDetail>\", but got " + value.getClass().toString());
            }
            this.setReviewDetails((List)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("cmuId".equals(name)) {
            return this.getCmuId();
        }
        if ("notes".equals(name)) {
            return this.getNotes();
        }
        if ("decisionNotes".equals(name)) {
            return this.getDecisionNotes();
        }
        if ("reviewDate".equals(name)) {
            return this.getReviewDate();
        }
        if ("reviewResult".equals(name)) {
            return this.getReviewResult();
        }
        if ("disposableIncome".equals(name)) {
            return this.getDisposableIncome();
        }
        if ("disposableIncomeAfterHardship".equals(name)) {
            return this.getDisposableIncomeAfterHardship();
        }
        if ("newWorkReason".equals(name)) {
            return this.getNewWorkReason();
        }
        if ("solicitorCosts".equals(name)) {
            return this.getSolicitorCosts();
        }
        if ("status".equals(name)) {
            return this.getStatus();
        }
        if ("reviewDetails".equals(name)) {
            return this.getReviewDetails();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiFindHardshipResponse with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiFindHardshipResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("cmuId");
        sb.append('=');
        sb.append(this.cmuId == null ? "<null>" : this.cmuId);
        sb.append(',');
        sb.append("notes");
        sb.append('=');
        sb.append(this.notes == null ? "<null>" : this.notes);
        sb.append(',');
        sb.append("decisionNotes");
        sb.append('=');
        sb.append(this.decisionNotes == null ? "<null>" : this.decisionNotes);
        sb.append(',');
        sb.append("reviewDate");
        sb.append('=');
        sb.append(this.reviewDate == null ? "<null>" : this.reviewDate);
        sb.append(',');
        sb.append("reviewResult");
        sb.append('=');
        sb.append((Object)(this.reviewResult == null ? "<null>" : this.reviewResult));
        sb.append(',');
        sb.append("disposableIncome");
        sb.append('=');
        sb.append(this.disposableIncome == null ? "<null>" : this.disposableIncome);
        sb.append(',');
        sb.append("disposableIncomeAfterHardship");
        sb.append('=');
        sb.append(this.disposableIncomeAfterHardship == null ? "<null>" : this.disposableIncomeAfterHardship);
        sb.append(',');
        sb.append("newWorkReason");
        sb.append('=');
        sb.append((Object)(this.newWorkReason == null ? "<null>" : this.newWorkReason));
        sb.append(',');
        sb.append("solicitorCosts");
        sb.append('=');
        sb.append(this.solicitorCosts == null ? "<null>" : this.solicitorCosts);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append((Object)(this.status == null ? "<null>" : this.status));
        sb.append(',');
        sb.append("reviewDetails");
        sb.append('=');
        sb.append(this.reviewDetails == null ? "<null>" : this.reviewDetails);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.cmuId == null ? 0 : this.cmuId.hashCode());
        result = result * 31 + (this.notes == null ? 0 : this.notes.hashCode());
        result = result * 31 + (this.reviewResult == null ? 0 : this.reviewResult.hashCode());
        result = result * 31 + (this.newWorkReason == null ? 0 : this.newWorkReason.hashCode());
        result = result * 31 + (this.disposableIncome == null ? 0 : this.disposableIncome.hashCode());
        result = result * 31 + (this.decisionNotes == null ? 0 : this.decisionNotes.hashCode());
        result = result * 31 + (this.reviewDate == null ? 0 : this.reviewDate.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.reviewDetails == null ? 0 : this.reviewDetails.hashCode());
        result = result * 31 + (this.disposableIncomeAfterHardship == null ? 0 : this.disposableIncomeAfterHardship.hashCode());
        result = result * 31 + (this.solicitorCosts == null ? 0 : this.solicitorCosts.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiFindHardshipResponse)) {
            return false;
        }
        ApiFindHardshipResponse rhs = (ApiFindHardshipResponse)other;
        return (this.cmuId == rhs.cmuId || this.cmuId != null && this.cmuId.equals(rhs.cmuId)) && (this.notes == rhs.notes || this.notes != null && this.notes.equals(rhs.notes)) && (this.reviewResult == rhs.reviewResult || this.reviewResult != null && this.reviewResult.equals((Object)rhs.reviewResult)) && (this.newWorkReason == rhs.newWorkReason || this.newWorkReason != null && this.newWorkReason.equals((Object)rhs.newWorkReason)) && (this.disposableIncome == rhs.disposableIncome || this.disposableIncome != null && this.disposableIncome.equals(rhs.disposableIncome)) && (this.decisionNotes == rhs.decisionNotes || this.decisionNotes != null && this.decisionNotes.equals(rhs.decisionNotes)) && (this.reviewDate == rhs.reviewDate || this.reviewDate != null && this.reviewDate.equals(rhs.reviewDate)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.reviewDetails == rhs.reviewDetails || this.reviewDetails != null && this.reviewDetails.equals(rhs.reviewDetails)) && (this.disposableIncomeAfterHardship == rhs.disposableIncomeAfterHardship || this.disposableIncomeAfterHardship != null && this.disposableIncomeAfterHardship.equals(rhs.disposableIncomeAfterHardship)) && (this.solicitorCosts == rhs.solicitorCosts || this.solicitorCosts != null && this.solicitorCosts.equals(rhs.solicitorCosts)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }
}

