/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.hardship;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.gov.justice.laa.crime.enums.Frequency;
import uk.gov.justice.laa.crime.enums.HardshipReviewDetailCode;
import uk.gov.justice.laa.crime.enums.HardshipReviewDetailReason;
import uk.gov.justice.laa.crime.enums.HardshipReviewDetailType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "frequency", "amount", "dateDue", "accepted", "otherDescription", "reasonNote", "detailType", "detailCode", "detailReason", "userCreated", "active"})
public class ApiHardshipDetail {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Hardship Review Detail ID")
    private Integer id;
    @JsonProperty(value="frequency")
    @JsonPropertyDescription(value="The Frequency of Applicant")
    @Valid
    @NotNull
    private Frequency frequency;
    @JsonProperty(value="amount")
    @JsonPropertyDescription(value="The amount under consideration")
    @NotNull
    private BigDecimal amount;
    @JsonProperty(value="dateDue")
    @JsonPropertyDescription(value="The date the Hardship Review Detail item is due")
    private LocalDateTime dateDue;
    @JsonProperty(value="accepted")
    @JsonPropertyDescription(value="Indicates whether the detail item has been accepted")
    private String accepted;
    @JsonProperty(value="otherDescription")
    @JsonPropertyDescription(value="The alternative description")
    private String otherDescription;
    @JsonProperty(value="reasonNote")
    @JsonPropertyDescription(value="The reason note")
    private String reasonNote;
    @JsonProperty(value="detailType")
    @JsonPropertyDescription(value="Hardship review detail type")
    @Valid
    @NotNull
    private HardshipReviewDetailType detailType;
    @JsonProperty(value="detailCode")
    @JsonPropertyDescription(value="The Hardship Review Detail code")
    @Valid
    private HardshipReviewDetailCode detailCode;
    @JsonProperty(value="detailReason")
    @JsonPropertyDescription(value="The Hardship Review Detail reasons code")
    @Valid
    private HardshipReviewDetailReason detailReason;
    @JsonProperty(value="userCreated")
    @JsonPropertyDescription(value="ID of the user creating the progress item")
    private String userCreated;
    @JsonProperty(value="active")
    @JsonPropertyDescription(value="Indicates if the detail is currently active")
    private String active;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiHardshipDetail() {
    }

    public ApiHardshipDetail(Integer id, Frequency frequency, BigDecimal amount, LocalDateTime dateDue, String accepted, String otherDescription, String reasonNote, HardshipReviewDetailType detailType, HardshipReviewDetailCode detailCode, HardshipReviewDetailReason detailReason, String userCreated, String active) {
        this.id = id;
        this.frequency = frequency;
        this.amount = amount;
        this.dateDue = dateDue;
        this.accepted = accepted;
        this.otherDescription = otherDescription;
        this.reasonNote = reasonNote;
        this.detailType = detailType;
        this.detailCode = detailCode;
        this.detailReason = detailReason;
        this.userCreated = userCreated;
        this.active = active;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public ApiHardshipDetail withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="frequency")
    public Frequency getFrequency() {
        return this.frequency;
    }

    @JsonProperty(value="frequency")
    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
    }

    public ApiHardshipDetail withFrequency(Frequency frequency) {
        this.frequency = frequency;
        return this;
    }

    @JsonProperty(value="amount")
    public BigDecimal getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public ApiHardshipDetail withAmount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="dateDue")
    public LocalDateTime getDateDue() {
        return this.dateDue;
    }

    @JsonProperty(value="dateDue")
    public void setDateDue(LocalDateTime dateDue) {
        this.dateDue = dateDue;
    }

    public ApiHardshipDetail withDateDue(LocalDateTime dateDue) {
        this.dateDue = dateDue;
        return this;
    }

    @JsonProperty(value="accepted")
    public String getAccepted() {
        return this.accepted;
    }

    @JsonProperty(value="accepted")
    public void setAccepted(String accepted) {
        this.accepted = accepted;
    }

    public ApiHardshipDetail withAccepted(String accepted) {
        this.accepted = accepted;
        return this;
    }

    @JsonProperty(value="otherDescription")
    public String getOtherDescription() {
        return this.otherDescription;
    }

    @JsonProperty(value="otherDescription")
    public void setOtherDescription(String otherDescription) {
        this.otherDescription = otherDescription;
    }

    public ApiHardshipDetail withOtherDescription(String otherDescription) {
        this.otherDescription = otherDescription;
        return this;
    }

    @JsonProperty(value="reasonNote")
    public String getReasonNote() {
        return this.reasonNote;
    }

    @JsonProperty(value="reasonNote")
    public void setReasonNote(String reasonNote) {
        this.reasonNote = reasonNote;
    }

    public ApiHardshipDetail withReasonNote(String reasonNote) {
        this.reasonNote = reasonNote;
        return this;
    }

    @JsonProperty(value="detailType")
    public HardshipReviewDetailType getDetailType() {
        return this.detailType;
    }

    @JsonProperty(value="detailType")
    public void setDetailType(HardshipReviewDetailType detailType) {
        this.detailType = detailType;
    }

    public ApiHardshipDetail withDetailType(HardshipReviewDetailType detailType) {
        this.detailType = detailType;
        return this;
    }

    @JsonProperty(value="detailCode")
    public HardshipReviewDetailCode getDetailCode() {
        return this.detailCode;
    }

    @JsonProperty(value="detailCode")
    public void setDetailCode(HardshipReviewDetailCode detailCode) {
        this.detailCode = detailCode;
    }

    public ApiHardshipDetail withDetailCode(HardshipReviewDetailCode detailCode) {
        this.detailCode = detailCode;
        return this;
    }

    @JsonProperty(value="detailReason")
    public HardshipReviewDetailReason getDetailReason() {
        return this.detailReason;
    }

    @JsonProperty(value="detailReason")
    public void setDetailReason(HardshipReviewDetailReason detailReason) {
        this.detailReason = detailReason;
    }

    public ApiHardshipDetail withDetailReason(HardshipReviewDetailReason detailReason) {
        this.detailReason = detailReason;
        return this;
    }

    @JsonProperty(value="userCreated")
    public String getUserCreated() {
        return this.userCreated;
    }

    @JsonProperty(value="userCreated")
    public void setUserCreated(String userCreated) {
        this.userCreated = userCreated;
    }

    public ApiHardshipDetail withUserCreated(String userCreated) {
        this.userCreated = userCreated;
        return this;
    }

    @JsonProperty(value="active")
    public String getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    public void setActive(String active) {
        this.active = active;
    }

    public ApiHardshipDetail withActive(String active) {
        this.active = active;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ApiHardshipDetail withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("id".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"id\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setId((Integer)value);
            return true;
        }
        if ("frequency".equals(name)) {
            if (!(value instanceof Frequency)) {
                throw new IllegalArgumentException("property \"frequency\" is of type \"uk.gov.justice.laa.crime.enums.Frequency\", but got " + value.getClass().toString());
            }
            this.setFrequency((Frequency)value);
            return true;
        }
        if ("amount".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"amount\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setAmount((BigDecimal)value);
            return true;
        }
        if ("dateDue".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"dateDue\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setDateDue((LocalDateTime)value);
            return true;
        }
        if ("accepted".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"accepted\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setAccepted((String)value);
            return true;
        }
        if ("otherDescription".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"otherDescription\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOtherDescription((String)value);
            return true;
        }
        if ("reasonNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"reasonNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setReasonNote((String)value);
            return true;
        }
        if ("detailType".equals(name)) {
            if (!(value instanceof HardshipReviewDetailType)) {
                throw new IllegalArgumentException("property \"detailType\" is of type \"uk.gov.justice.laa.crime.enums.HardshipReviewDetailType\", but got " + value.getClass().toString());
            }
            this.setDetailType((HardshipReviewDetailType)value);
            return true;
        }
        if ("detailCode".equals(name)) {
            if (!(value instanceof HardshipReviewDetailCode)) {
                throw new IllegalArgumentException("property \"detailCode\" is of type \"uk.gov.justice.laa.crime.enums.HardshipReviewDetailCode\", but got " + value.getClass().toString());
            }
            this.setDetailCode((HardshipReviewDetailCode)value);
            return true;
        }
        if ("detailReason".equals(name)) {
            if (!(value instanceof HardshipReviewDetailReason)) {
                throw new IllegalArgumentException("property \"detailReason\" is of type \"uk.gov.justice.laa.crime.enums.HardshipReviewDetailReason\", but got " + value.getClass().toString());
            }
            this.setDetailReason((HardshipReviewDetailReason)value);
            return true;
        }
        if ("userCreated".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"userCreated\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUserCreated((String)value);
            return true;
        }
        if ("active".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"active\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setActive((String)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("frequency".equals(name)) {
            return this.getFrequency();
        }
        if ("amount".equals(name)) {
            return this.getAmount();
        }
        if ("dateDue".equals(name)) {
            return this.getDateDue();
        }
        if ("accepted".equals(name)) {
            return this.getAccepted();
        }
        if ("otherDescription".equals(name)) {
            return this.getOtherDescription();
        }
        if ("reasonNote".equals(name)) {
            return this.getReasonNote();
        }
        if ("detailType".equals(name)) {
            return this.getDetailType();
        }
        if ("detailCode".equals(name)) {
            return this.getDetailCode();
        }
        if ("detailReason".equals(name)) {
            return this.getDetailReason();
        }
        if ("userCreated".equals(name)) {
            return this.getUserCreated();
        }
        if ("active".equals(name)) {
            return this.getActive();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public ApiHardshipDetail with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiHardshipDetail.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("frequency");
        sb.append('=');
        sb.append((Object)(this.frequency == null ? "<null>" : this.frequency));
        sb.append(',');
        sb.append("amount");
        sb.append('=');
        sb.append(this.amount == null ? "<null>" : this.amount);
        sb.append(',');
        sb.append("dateDue");
        sb.append('=');
        sb.append(this.dateDue == null ? "<null>" : this.dateDue);
        sb.append(',');
        sb.append("accepted");
        sb.append('=');
        sb.append(this.accepted == null ? "<null>" : this.accepted);
        sb.append(',');
        sb.append("otherDescription");
        sb.append('=');
        sb.append(this.otherDescription == null ? "<null>" : this.otherDescription);
        sb.append(',');
        sb.append("reasonNote");
        sb.append('=');
        sb.append(this.reasonNote == null ? "<null>" : this.reasonNote);
        sb.append(',');
        sb.append("detailType");
        sb.append('=');
        sb.append((Object)(this.detailType == null ? "<null>" : this.detailType));
        sb.append(',');
        sb.append("detailCode");
        sb.append('=');
        sb.append((Object)(this.detailCode == null ? "<null>" : this.detailCode));
        sb.append(',');
        sb.append("detailReason");
        sb.append('=');
        sb.append((Object)(this.detailReason == null ? "<null>" : this.detailReason));
        sb.append(',');
        sb.append("userCreated");
        sb.append('=');
        sb.append(this.userCreated == null ? "<null>" : this.userCreated);
        sb.append(',');
        sb.append("active");
        sb.append('=');
        sb.append(this.active == null ? "<null>" : this.active);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.dateDue == null ? 0 : this.dateDue.hashCode());
        result = result * 31 + (this.amount == null ? 0 : this.amount.hashCode());
        result = result * 31 + (this.accepted == null ? 0 : this.accepted.hashCode());
        result = result * 31 + (this.active == null ? 0 : this.active.hashCode());
        result = result * 31 + (this.detailCode == null ? 0 : this.detailCode.hashCode());
        result = result * 31 + (this.userCreated == null ? 0 : this.userCreated.hashCode());
        result = result * 31 + (this.detailReason == null ? 0 : this.detailReason.hashCode());
        result = result * 31 + (this.frequency == null ? 0 : this.frequency.hashCode());
        result = result * 31 + (this.detailType == null ? 0 : this.detailType.hashCode());
        result = result * 31 + (this.reasonNote == null ? 0 : this.reasonNote.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.otherDescription == null ? 0 : this.otherDescription.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiHardshipDetail)) {
            return false;
        }
        ApiHardshipDetail rhs = (ApiHardshipDetail)other;
        return (this.dateDue == rhs.dateDue || this.dateDue != null && this.dateDue.equals(rhs.dateDue)) && (this.amount == rhs.amount || this.amount != null && this.amount.equals(rhs.amount)) && (this.accepted == rhs.accepted || this.accepted != null && this.accepted.equals(rhs.accepted)) && (this.active == rhs.active || this.active != null && this.active.equals(rhs.active)) && (this.detailCode == rhs.detailCode || this.detailCode != null && this.detailCode.equals((Object)rhs.detailCode)) && (this.userCreated == rhs.userCreated || this.userCreated != null && this.userCreated.equals(rhs.userCreated)) && (this.detailReason == rhs.detailReason || this.detailReason != null && this.detailReason.equals((Object)rhs.detailReason)) && (this.frequency == rhs.frequency || this.frequency != null && this.frequency.equals((Object)rhs.frequency)) && (this.detailType == rhs.detailType || this.detailType != null && this.detailType.equals((Object)rhs.detailType)) && (this.reasonNote == rhs.reasonNote || this.reasonNote != null && this.reasonNote.equals(rhs.reasonNote)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.otherDescription == rhs.otherDescription || this.otherDescription != null && this.otherDescription.equals(rhs.otherDescription));
    }
}

