/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.hardship;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.gov.justice.laa.crime.common.model.hardship.HardshipCost;
import uk.gov.justice.laa.crime.enums.DeniedIncomeDetailCode;
import uk.gov.justice.laa.crime.enums.Frequency;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"reasonNote", "itemCode"})
public class DeniedIncome
extends HardshipCost {
    @JsonProperty(value="reasonNote")
    @JsonPropertyDescription(value="The denied income reason note")
    private String reasonNote;
    @JsonProperty(value="itemCode")
    @JsonPropertyDescription(value="The hardship denied income codes")
    @Valid
    private DeniedIncomeDetailCode itemCode;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public DeniedIncome() {
    }

    public DeniedIncome(String reasonNote, DeniedIncomeDetailCode itemCode, Boolean accepted, Frequency frequency, BigDecimal amount, String description) {
        super(accepted, frequency, amount, description);
        this.reasonNote = reasonNote;
        this.itemCode = itemCode;
    }

    @JsonProperty(value="reasonNote")
    public String getReasonNote() {
        return this.reasonNote;
    }

    @JsonProperty(value="reasonNote")
    public void setReasonNote(String reasonNote) {
        this.reasonNote = reasonNote;
    }

    public DeniedIncome withReasonNote(String reasonNote) {
        this.reasonNote = reasonNote;
        return this;
    }

    @JsonProperty(value="itemCode")
    public DeniedIncomeDetailCode getItemCode() {
        return this.itemCode;
    }

    @JsonProperty(value="itemCode")
    public void setItemCode(DeniedIncomeDetailCode itemCode) {
        this.itemCode = itemCode;
    }

    public DeniedIncome withItemCode(DeniedIncomeDetailCode itemCode) {
        this.itemCode = itemCode;
        return this;
    }

    @Override
    public DeniedIncome withAccepted(Boolean accepted) {
        super.withAccepted(accepted);
        return this;
    }

    @Override
    public DeniedIncome withFrequency(Frequency frequency) {
        super.withFrequency(frequency);
        return this;
    }

    @Override
    public DeniedIncome withAmount(BigDecimal amount) {
        super.withAmount(amount);
        return this;
    }

    @Override
    public DeniedIncome withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public DeniedIncome withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    protected boolean declaredProperty(String name, Object value) {
        if ("reasonNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"reasonNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setReasonNote((String)value);
            return true;
        }
        if ("itemCode".equals(name)) {
            if (!(value instanceof DeniedIncomeDetailCode)) {
                throw new IllegalArgumentException("property \"itemCode\" is of type \"uk.gov.justice.laa.crime.enums.DeniedIncomeDetailCode\", but got " + value.getClass().toString());
            }
            this.setItemCode((DeniedIncomeDetailCode)value);
            return true;
        }
        return super.declaredProperty(name, value);
    }

    @Override
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("reasonNote".equals(name)) {
            return this.getReasonNote();
        }
        if ("itemCode".equals(name)) {
            return this.getItemCode();
        }
        return super.declaredPropertyOrNotFound(name, notFoundValue);
    }

    @Override
    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    @Override
    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    @Override
    public DeniedIncome with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DeniedIncome.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("reasonNote");
        sb.append('=');
        sb.append(this.reasonNote == null ? "<null>" : this.reasonNote);
        sb.append(',');
        sb.append("itemCode");
        sb.append('=');
        sb.append((Object)(this.itemCode == null ? "<null>" : this.itemCode));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.reasonNote == null ? 0 : this.reasonNote.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.itemCode == null ? 0 : this.itemCode.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DeniedIncome)) {
            return false;
        }
        DeniedIncome rhs = (DeniedIncome)other;
        return super.equals(rhs) && (this.reasonNote == rhs.reasonNote || this.reasonNote != null && this.reasonNote.equals(rhs.reasonNote)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.itemCode == rhs.itemCode || this.itemCode != null && this.itemCode.equals((Object)rhs.itemCode));
    }
}

