/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.hardship;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.gov.justice.laa.crime.common.model.hardship.HardshipCost;
import uk.gov.justice.laa.crime.enums.ExtraExpenditureDetailCode;
import uk.gov.justice.laa.crime.enums.Frequency;
import uk.gov.justice.laa.crime.enums.HardshipReviewDetailReason;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"reasonCode", "itemCode"})
public class ExtraExpenditure
extends HardshipCost {
    @JsonProperty(value="reasonCode")
    @JsonPropertyDescription(value="The hardship review details reasons code")
    @Valid
    private HardshipReviewDetailReason reasonCode;
    @JsonProperty(value="itemCode")
    @JsonPropertyDescription(value="Expenditure specific codes")
    @Valid
    private ExtraExpenditureDetailCode itemCode;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ExtraExpenditure() {
    }

    public ExtraExpenditure(HardshipReviewDetailReason reasonCode, ExtraExpenditureDetailCode itemCode, Boolean accepted, Frequency frequency, BigDecimal amount, String description) {
        super(accepted, frequency, amount, description);
        this.reasonCode = reasonCode;
        this.itemCode = itemCode;
    }

    @JsonProperty(value="reasonCode")
    public HardshipReviewDetailReason getReasonCode() {
        return this.reasonCode;
    }

    @JsonProperty(value="reasonCode")
    public void setReasonCode(HardshipReviewDetailReason reasonCode) {
        this.reasonCode = reasonCode;
    }

    public ExtraExpenditure withReasonCode(HardshipReviewDetailReason reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @JsonProperty(value="itemCode")
    public ExtraExpenditureDetailCode getItemCode() {
        return this.itemCode;
    }

    @JsonProperty(value="itemCode")
    public void setItemCode(ExtraExpenditureDetailCode itemCode) {
        this.itemCode = itemCode;
    }

    public ExtraExpenditure withItemCode(ExtraExpenditureDetailCode itemCode) {
        this.itemCode = itemCode;
        return this;
    }

    @Override
    public ExtraExpenditure withAccepted(Boolean accepted) {
        super.withAccepted(accepted);
        return this;
    }

    @Override
    public ExtraExpenditure withFrequency(Frequency frequency) {
        super.withFrequency(frequency);
        return this;
    }

    @Override
    public ExtraExpenditure withAmount(BigDecimal amount) {
        super.withAmount(amount);
        return this;
    }

    @Override
    public ExtraExpenditure withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public ExtraExpenditure withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    protected boolean declaredProperty(String name, Object value) {
        if ("reasonCode".equals(name)) {
            if (!(value instanceof HardshipReviewDetailReason)) {
                throw new IllegalArgumentException("property \"reasonCode\" is of type \"uk.gov.justice.laa.crime.enums.HardshipReviewDetailReason\", but got " + value.getClass().toString());
            }
            this.setReasonCode((HardshipReviewDetailReason)value);
            return true;
        }
        if ("itemCode".equals(name)) {
            if (!(value instanceof ExtraExpenditureDetailCode)) {
                throw new IllegalArgumentException("property \"itemCode\" is of type \"uk.gov.justice.laa.crime.enums.ExtraExpenditureDetailCode\", but got " + value.getClass().toString());
            }
            this.setItemCode((ExtraExpenditureDetailCode)value);
            return true;
        }
        return super.declaredProperty(name, value);
    }

    @Override
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("reasonCode".equals(name)) {
            return this.getReasonCode();
        }
        if ("itemCode".equals(name)) {
            return this.getItemCode();
        }
        return super.declaredPropertyOrNotFound(name, notFoundValue);
    }

    @Override
    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    @Override
    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    @Override
    public ExtraExpenditure with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ExtraExpenditure.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("reasonCode");
        sb.append('=');
        sb.append((Object)(this.reasonCode == null ? "<null>" : this.reasonCode));
        sb.append(',');
        sb.append("itemCode");
        sb.append('=');
        sb.append((Object)(this.itemCode == null ? "<null>" : this.itemCode));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.reasonCode == null ? 0 : this.reasonCode.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.itemCode == null ? 0 : this.itemCode.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ExtraExpenditure)) {
            return false;
        }
        ExtraExpenditure rhs = (ExtraExpenditure)other;
        return super.equals(rhs) && (this.reasonCode == rhs.reasonCode || this.reasonCode != null && this.reasonCode.equals((Object)rhs.reasonCode)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.itemCode == rhs.itemCode || this.itemCode != null && this.itemCode.equals((Object)rhs.itemCode));
    }
}

