/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.hardship;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.gov.justice.laa.crime.common.model.hardship.HardshipDetail;
import uk.gov.justice.laa.crime.enums.Frequency;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"accepted", "frequency"})
public class HardshipCost
extends HardshipDetail {
    @JsonProperty(value="accepted")
    @JsonPropertyDescription(value="Indicates whether the additional cost has been accepted")
    private Boolean accepted;
    @JsonProperty(value="frequency")
    @JsonPropertyDescription(value="Hardship payment frequency")
    @Valid
    private Frequency frequency;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public HardshipCost() {
    }

    public HardshipCost(Boolean accepted, Frequency frequency, BigDecimal amount, String description) {
        super(amount, description);
        this.accepted = accepted;
        this.frequency = frequency;
    }

    @JsonProperty(value="accepted")
    public Boolean getAccepted() {
        return this.accepted;
    }

    @JsonProperty(value="accepted")
    public void setAccepted(Boolean accepted) {
        this.accepted = accepted;
    }

    public HardshipCost withAccepted(Boolean accepted) {
        this.accepted = accepted;
        return this;
    }

    @JsonProperty(value="frequency")
    public Frequency getFrequency() {
        return this.frequency;
    }

    @JsonProperty(value="frequency")
    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
    }

    public HardshipCost withFrequency(Frequency frequency) {
        this.frequency = frequency;
        return this;
    }

    @Override
    public HardshipCost withAmount(BigDecimal amount) {
        super.withAmount(amount);
        return this;
    }

    @Override
    public HardshipCost withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public HardshipCost withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    protected boolean declaredProperty(String name, Object value) {
        if ("accepted".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"accepted\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setAccepted((Boolean)value);
            return true;
        }
        if ("frequency".equals(name)) {
            if (!(value instanceof Frequency)) {
                throw new IllegalArgumentException("property \"frequency\" is of type \"uk.gov.justice.laa.crime.enums.Frequency\", but got " + value.getClass().toString());
            }
            this.setFrequency((Frequency)value);
            return true;
        }
        return super.declaredProperty(name, value);
    }

    @Override
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("accepted".equals(name)) {
            return this.getAccepted();
        }
        if ("frequency".equals(name)) {
            return this.getFrequency();
        }
        return super.declaredPropertyOrNotFound(name, notFoundValue);
    }

    @Override
    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    @Override
    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    @Override
    public HardshipCost with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(HardshipCost.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("accepted");
        sb.append('=');
        sb.append(this.accepted == null ? "<null>" : this.accepted);
        sb.append(',');
        sb.append("frequency");
        sb.append('=');
        sb.append((Object)(this.frequency == null ? "<null>" : this.frequency));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.accepted == null ? 0 : this.accepted.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.frequency == null ? 0 : this.frequency.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HardshipCost)) {
            return false;
        }
        HardshipCost rhs = (HardshipCost)other;
        return super.equals(rhs) && (this.accepted == rhs.accepted || this.accepted != null && this.accepted.equals(rhs.accepted)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.frequency == rhs.frequency || this.frequency != null && this.frequency.equals((Object)rhs.frequency));
    }
}

