/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.hardship;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"amount", "description"})
public class HardshipDetail {
    @JsonProperty(value="amount")
    @JsonPropertyDescription(value="The amount under consideration")
    @NotNull
    private BigDecimal amount;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Description of the funding source.")
    private String description;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public HardshipDetail() {
    }

    public HardshipDetail(BigDecimal amount, String description) {
        this.amount = amount;
        this.description = description;
    }

    @JsonProperty(value="amount")
    public BigDecimal getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public HardshipDetail withAmount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public HardshipDetail withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public HardshipDetail withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("amount".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"amount\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setAmount((BigDecimal)value);
            return true;
        }
        if ("description".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"description\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setDescription((String)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("amount".equals(name)) {
            return this.getAmount();
        }
        if ("description".equals(name)) {
            return this.getDescription();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public HardshipDetail with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(HardshipDetail.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("amount");
        sb.append('=');
        sb.append(this.amount == null ? "<null>" : this.amount);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.amount == null ? 0 : this.amount.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HardshipDetail)) {
            return false;
        }
        HardshipDetail rhs = (HardshipDetail)other;
        return (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.amount == rhs.amount || this.amount != null && this.amount.equals(rhs.amount)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }
}

