/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.hardship;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import uk.gov.justice.laa.crime.common.model.common.ApiUserSession;
import uk.gov.justice.laa.crime.enums.HardshipReviewStatus;
import uk.gov.justice.laa.crime.enums.NewWorkReason;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"repId", "cmuId", "reviewStatus", "userSession", "reviewReason", "notes", "decisionNotes", "financialAssessmentId", "hardshipReviewId"})
public class HardshipMetadata {
    @JsonProperty(value="repId")
    @JsonPropertyDescription(value="MAAT / Rep Id")
    @NotNull
    private Integer repId;
    @JsonProperty(value="cmuId")
    @JsonPropertyDescription(value="Case Management Unit Id")
    @NotNull
    private Integer cmuId;
    @JsonProperty(value="reviewStatus")
    @JsonPropertyDescription(value="The review status")
    @Valid
    @NotNull
    private HardshipReviewStatus reviewStatus;
    @JsonProperty(value="userSession")
    @JsonPropertyDescription(value="Details of a user session")
    @Valid
    @NotNull
    private ApiUserSession userSession;
    @JsonProperty(value="reviewReason")
    @JsonPropertyDescription(value="The review reason")
    @Valid
    @NotNull
    private NewWorkReason reviewReason;
    @JsonProperty(value="notes")
    @JsonPropertyDescription(value="The review progress notes")
    private String notes;
    @JsonProperty(value="decisionNotes")
    @JsonPropertyDescription(value="The notes regarding the decision")
    private String decisionNotes;
    @JsonProperty(value="financialAssessmentId")
    @JsonPropertyDescription(value="The ID of the financial assessment being updated")
    @NotNull
    private Integer financialAssessmentId;
    @JsonProperty(value="hardshipReviewId")
    @JsonPropertyDescription(value="The ID of the Hardship Review to update")
    private Integer hardshipReviewId;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public HardshipMetadata() {
    }

    public HardshipMetadata(Integer repId, Integer cmuId, HardshipReviewStatus reviewStatus, ApiUserSession userSession, NewWorkReason reviewReason, String notes, String decisionNotes, Integer financialAssessmentId, Integer hardshipReviewId) {
        this.repId = repId;
        this.cmuId = cmuId;
        this.reviewStatus = reviewStatus;
        this.userSession = userSession;
        this.reviewReason = reviewReason;
        this.notes = notes;
        this.decisionNotes = decisionNotes;
        this.financialAssessmentId = financialAssessmentId;
        this.hardshipReviewId = hardshipReviewId;
    }

    @JsonProperty(value="repId")
    public Integer getRepId() {
        return this.repId;
    }

    @JsonProperty(value="repId")
    public void setRepId(Integer repId) {
        this.repId = repId;
    }

    public HardshipMetadata withRepId(Integer repId) {
        this.repId = repId;
        return this;
    }

    @JsonProperty(value="cmuId")
    public Integer getCmuId() {
        return this.cmuId;
    }

    @JsonProperty(value="cmuId")
    public void setCmuId(Integer cmuId) {
        this.cmuId = cmuId;
    }

    public HardshipMetadata withCmuId(Integer cmuId) {
        this.cmuId = cmuId;
        return this;
    }

    @JsonProperty(value="reviewStatus")
    public HardshipReviewStatus getReviewStatus() {
        return this.reviewStatus;
    }

    @JsonProperty(value="reviewStatus")
    public void setReviewStatus(HardshipReviewStatus reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public HardshipMetadata withReviewStatus(HardshipReviewStatus reviewStatus) {
        this.reviewStatus = reviewStatus;
        return this;
    }

    @JsonProperty(value="userSession")
    public ApiUserSession getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    public void setUserSession(ApiUserSession userSession) {
        this.userSession = userSession;
    }

    public HardshipMetadata withUserSession(ApiUserSession userSession) {
        this.userSession = userSession;
        return this;
    }

    @JsonProperty(value="reviewReason")
    public NewWorkReason getReviewReason() {
        return this.reviewReason;
    }

    @JsonProperty(value="reviewReason")
    public void setReviewReason(NewWorkReason reviewReason) {
        this.reviewReason = reviewReason;
    }

    public HardshipMetadata withReviewReason(NewWorkReason reviewReason) {
        this.reviewReason = reviewReason;
        return this;
    }

    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    public void setNotes(String notes) {
        this.notes = notes;
    }

    public HardshipMetadata withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    @JsonProperty(value="decisionNotes")
    public String getDecisionNotes() {
        return this.decisionNotes;
    }

    @JsonProperty(value="decisionNotes")
    public void setDecisionNotes(String decisionNotes) {
        this.decisionNotes = decisionNotes;
    }

    public HardshipMetadata withDecisionNotes(String decisionNotes) {
        this.decisionNotes = decisionNotes;
        return this;
    }

    @JsonProperty(value="financialAssessmentId")
    public Integer getFinancialAssessmentId() {
        return this.financialAssessmentId;
    }

    @JsonProperty(value="financialAssessmentId")
    public void setFinancialAssessmentId(Integer financialAssessmentId) {
        this.financialAssessmentId = financialAssessmentId;
    }

    public HardshipMetadata withFinancialAssessmentId(Integer financialAssessmentId) {
        this.financialAssessmentId = financialAssessmentId;
        return this;
    }

    @JsonProperty(value="hardshipReviewId")
    public Integer getHardshipReviewId() {
        return this.hardshipReviewId;
    }

    @JsonProperty(value="hardshipReviewId")
    public void setHardshipReviewId(Integer hardshipReviewId) {
        this.hardshipReviewId = hardshipReviewId;
    }

    public HardshipMetadata withHardshipReviewId(Integer hardshipReviewId) {
        this.hardshipReviewId = hardshipReviewId;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("repId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"repId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setRepId((Integer)value);
            return true;
        }
        if ("cmuId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"cmuId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setCmuId((Integer)value);
            return true;
        }
        if ("reviewStatus".equals(name)) {
            if (!(value instanceof HardshipReviewStatus)) {
                throw new IllegalArgumentException("property \"reviewStatus\" is of type \"uk.gov.justice.laa.crime.enums.HardshipReviewStatus\", but got " + value.getClass().toString());
            }
            this.setReviewStatus((HardshipReviewStatus)value);
            return true;
        }
        if ("userSession".equals(name)) {
            if (!(value instanceof ApiUserSession)) {
                throw new IllegalArgumentException("property \"userSession\" is of type \"uk.gov.justice.laa.crime.common.model.common.ApiUserSession\", but got " + value.getClass().toString());
            }
            this.setUserSession((ApiUserSession)value);
            return true;
        }
        if ("reviewReason".equals(name)) {
            if (!(value instanceof NewWorkReason)) {
                throw new IllegalArgumentException("property \"reviewReason\" is of type \"uk.gov.justice.laa.crime.enums.NewWorkReason\", but got " + value.getClass().toString());
            }
            this.setReviewReason((NewWorkReason)value);
            return true;
        }
        if ("notes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"notes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setNotes((String)value);
            return true;
        }
        if ("decisionNotes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"decisionNotes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setDecisionNotes((String)value);
            return true;
        }
        if ("financialAssessmentId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"financialAssessmentId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setFinancialAssessmentId((Integer)value);
            return true;
        }
        if ("hardshipReviewId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"hardshipReviewId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setHardshipReviewId((Integer)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("repId".equals(name)) {
            return this.getRepId();
        }
        if ("cmuId".equals(name)) {
            return this.getCmuId();
        }
        if ("reviewStatus".equals(name)) {
            return this.getReviewStatus();
        }
        if ("userSession".equals(name)) {
            return this.getUserSession();
        }
        if ("reviewReason".equals(name)) {
            return this.getReviewReason();
        }
        if ("notes".equals(name)) {
            return this.getNotes();
        }
        if ("decisionNotes".equals(name)) {
            return this.getDecisionNotes();
        }
        if ("financialAssessmentId".equals(name)) {
            return this.getFinancialAssessmentId();
        }
        if ("hardshipReviewId".equals(name)) {
            return this.getHardshipReviewId();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public HardshipMetadata with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(HardshipMetadata.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("repId");
        sb.append('=');
        sb.append(this.repId == null ? "<null>" : this.repId);
        sb.append(',');
        sb.append("cmuId");
        sb.append('=');
        sb.append(this.cmuId == null ? "<null>" : this.cmuId);
        sb.append(',');
        sb.append("reviewStatus");
        sb.append('=');
        sb.append((Object)(this.reviewStatus == null ? "<null>" : this.reviewStatus));
        sb.append(',');
        sb.append("userSession");
        sb.append('=');
        sb.append(this.userSession == null ? "<null>" : this.userSession);
        sb.append(',');
        sb.append("reviewReason");
        sb.append('=');
        sb.append((Object)(this.reviewReason == null ? "<null>" : this.reviewReason));
        sb.append(',');
        sb.append("notes");
        sb.append('=');
        sb.append(this.notes == null ? "<null>" : this.notes);
        sb.append(',');
        sb.append("decisionNotes");
        sb.append('=');
        sb.append(this.decisionNotes == null ? "<null>" : this.decisionNotes);
        sb.append(',');
        sb.append("financialAssessmentId");
        sb.append('=');
        sb.append(this.financialAssessmentId == null ? "<null>" : this.financialAssessmentId);
        sb.append(',');
        sb.append("hardshipReviewId");
        sb.append('=');
        sb.append(this.hardshipReviewId == null ? "<null>" : this.hardshipReviewId);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.cmuId == null ? 0 : this.cmuId.hashCode());
        result = result * 31 + (this.notes == null ? 0 : this.notes.hashCode());
        result = result * 31 + (this.decisionNotes == null ? 0 : this.decisionNotes.hashCode());
        result = result * 31 + (this.reviewReason == null ? 0 : this.reviewReason.hashCode());
        result = result * 31 + (this.financialAssessmentId == null ? 0 : this.financialAssessmentId.hashCode());
        result = result * 31 + (this.userSession == null ? 0 : this.userSession.hashCode());
        result = result * 31 + (this.reviewStatus == null ? 0 : this.reviewStatus.hashCode());
        result = result * 31 + (this.hardshipReviewId == null ? 0 : this.hardshipReviewId.hashCode());
        result = result * 31 + (this.repId == null ? 0 : this.repId.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HardshipMetadata)) {
            return false;
        }
        HardshipMetadata rhs = (HardshipMetadata)other;
        return (this.cmuId == rhs.cmuId || this.cmuId != null && this.cmuId.equals(rhs.cmuId)) && (this.notes == rhs.notes || this.notes != null && this.notes.equals(rhs.notes)) && (this.decisionNotes == rhs.decisionNotes || this.decisionNotes != null && this.decisionNotes.equals(rhs.decisionNotes)) && (this.reviewReason == rhs.reviewReason || this.reviewReason != null && this.reviewReason.equals((Object)rhs.reviewReason)) && (this.financialAssessmentId == rhs.financialAssessmentId || this.financialAssessmentId != null && this.financialAssessmentId.equals(rhs.financialAssessmentId)) && (this.userSession == rhs.userSession || this.userSession != null && this.userSession.equals(rhs.userSession)) && (this.reviewStatus == rhs.reviewStatus || this.reviewStatus != null && this.reviewStatus.equals((Object)rhs.reviewStatus)) && (this.hardshipReviewId == rhs.hardshipReviewId || this.hardshipReviewId != null && this.hardshipReviewId.equals(rhs.hardshipReviewId)) && (this.repId == rhs.repId || this.repId != null && this.repId.equals(rhs.repId));
    }
}

