/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.hardship;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.hardship.DeniedIncome;
import uk.gov.justice.laa.crime.common.model.hardship.ExtraExpenditure;
import uk.gov.justice.laa.crime.common.model.hardship.SolicitorCosts;
import uk.gov.justice.laa.crime.enums.CourtType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"courtType", "totalAnnualDisposableIncome", "reviewDate", "extraExpenditure", "deniedIncome", "solicitorCosts"})
public class HardshipReview {
    @JsonProperty(value="courtType")
    @JsonPropertyDescription(value="The Court Type")
    @Valid
    @NotNull
    private CourtType courtType;
    @JsonProperty(value="totalAnnualDisposableIncome")
    @JsonPropertyDescription(value="The applicants total annual disposable income")
    @NotNull
    private BigDecimal totalAnnualDisposableIncome;
    @JsonProperty(value="reviewDate")
    @JsonPropertyDescription(value="The hardship review date")
    @NotNull
    private LocalDateTime reviewDate;
    @JsonProperty(value="extraExpenditure")
    @JsonPropertyDescription(value="Extra expenditure")
    @Valid
    private List<ExtraExpenditure> extraExpenditure = new ArrayList<ExtraExpenditure>();
    @JsonProperty(value="deniedIncome")
    @JsonPropertyDescription(value="Denied income")
    @Valid
    private List<DeniedIncome> deniedIncome = new ArrayList<DeniedIncome>();
    @JsonProperty(value="solicitorCosts")
    @JsonPropertyDescription(value="Details of solicitor cost")
    @Valid
    private SolicitorCosts solicitorCosts;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public HardshipReview() {
    }

    public HardshipReview(CourtType courtType, BigDecimal totalAnnualDisposableIncome, LocalDateTime reviewDate, List<ExtraExpenditure> extraExpenditure, List<DeniedIncome> deniedIncome, SolicitorCosts solicitorCosts) {
        this.courtType = courtType;
        this.totalAnnualDisposableIncome = totalAnnualDisposableIncome;
        this.reviewDate = reviewDate;
        this.extraExpenditure = extraExpenditure;
        this.deniedIncome = deniedIncome;
        this.solicitorCosts = solicitorCosts;
    }

    @JsonProperty(value="courtType")
    public CourtType getCourtType() {
        return this.courtType;
    }

    @JsonProperty(value="courtType")
    public void setCourtType(CourtType courtType) {
        this.courtType = courtType;
    }

    public HardshipReview withCourtType(CourtType courtType) {
        this.courtType = courtType;
        return this;
    }

    @JsonProperty(value="totalAnnualDisposableIncome")
    public BigDecimal getTotalAnnualDisposableIncome() {
        return this.totalAnnualDisposableIncome;
    }

    @JsonProperty(value="totalAnnualDisposableIncome")
    public void setTotalAnnualDisposableIncome(BigDecimal totalAnnualDisposableIncome) {
        this.totalAnnualDisposableIncome = totalAnnualDisposableIncome;
    }

    public HardshipReview withTotalAnnualDisposableIncome(BigDecimal totalAnnualDisposableIncome) {
        this.totalAnnualDisposableIncome = totalAnnualDisposableIncome;
        return this;
    }

    @JsonProperty(value="reviewDate")
    public LocalDateTime getReviewDate() {
        return this.reviewDate;
    }

    @JsonProperty(value="reviewDate")
    public void setReviewDate(LocalDateTime reviewDate) {
        this.reviewDate = reviewDate;
    }

    public HardshipReview withReviewDate(LocalDateTime reviewDate) {
        this.reviewDate = reviewDate;
        return this;
    }

    @JsonProperty(value="extraExpenditure")
    public List<ExtraExpenditure> getExtraExpenditure() {
        return this.extraExpenditure;
    }

    @JsonProperty(value="extraExpenditure")
    public void setExtraExpenditure(List<ExtraExpenditure> extraExpenditure) {
        this.extraExpenditure = extraExpenditure;
    }

    public HardshipReview withExtraExpenditure(List<ExtraExpenditure> extraExpenditure) {
        this.extraExpenditure = extraExpenditure;
        return this;
    }

    @JsonProperty(value="deniedIncome")
    public List<DeniedIncome> getDeniedIncome() {
        return this.deniedIncome;
    }

    @JsonProperty(value="deniedIncome")
    public void setDeniedIncome(List<DeniedIncome> deniedIncome) {
        this.deniedIncome = deniedIncome;
    }

    public HardshipReview withDeniedIncome(List<DeniedIncome> deniedIncome) {
        this.deniedIncome = deniedIncome;
        return this;
    }

    @JsonProperty(value="solicitorCosts")
    public SolicitorCosts getSolicitorCosts() {
        return this.solicitorCosts;
    }

    @JsonProperty(value="solicitorCosts")
    public void setSolicitorCosts(SolicitorCosts solicitorCosts) {
        this.solicitorCosts = solicitorCosts;
    }

    public HardshipReview withSolicitorCosts(SolicitorCosts solicitorCosts) {
        this.solicitorCosts = solicitorCosts;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("courtType".equals(name)) {
            if (!(value instanceof CourtType)) {
                throw new IllegalArgumentException("property \"courtType\" is of type \"uk.gov.justice.laa.crime.enums.CourtType\", but got " + value.getClass().toString());
            }
            this.setCourtType((CourtType)value);
            return true;
        }
        if ("totalAnnualDisposableIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"totalAnnualDisposableIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setTotalAnnualDisposableIncome((BigDecimal)value);
            return true;
        }
        if ("reviewDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"reviewDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setReviewDate((LocalDateTime)value);
            return true;
        }
        if ("extraExpenditure".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"extraExpenditure\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.hardship.ExtraExpenditure>\", but got " + value.getClass().toString());
            }
            this.setExtraExpenditure((List)value);
            return true;
        }
        if ("deniedIncome".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"deniedIncome\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.hardship.DeniedIncome>\", but got " + value.getClass().toString());
            }
            this.setDeniedIncome((List)value);
            return true;
        }
        if ("solicitorCosts".equals(name)) {
            if (!(value instanceof SolicitorCosts)) {
                throw new IllegalArgumentException("property \"solicitorCosts\" is of type \"uk.gov.justice.laa.crime.common.model.hardship.SolicitorCosts\", but got " + value.getClass().toString());
            }
            this.setSolicitorCosts((SolicitorCosts)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("courtType".equals(name)) {
            return this.getCourtType();
        }
        if ("totalAnnualDisposableIncome".equals(name)) {
            return this.getTotalAnnualDisposableIncome();
        }
        if ("reviewDate".equals(name)) {
            return this.getReviewDate();
        }
        if ("extraExpenditure".equals(name)) {
            return this.getExtraExpenditure();
        }
        if ("deniedIncome".equals(name)) {
            return this.getDeniedIncome();
        }
        if ("solicitorCosts".equals(name)) {
            return this.getSolicitorCosts();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public HardshipReview with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(HardshipReview.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("courtType");
        sb.append('=');
        sb.append((Object)(this.courtType == null ? "<null>" : this.courtType));
        sb.append(',');
        sb.append("totalAnnualDisposableIncome");
        sb.append('=');
        sb.append(this.totalAnnualDisposableIncome == null ? "<null>" : this.totalAnnualDisposableIncome);
        sb.append(',');
        sb.append("reviewDate");
        sb.append('=');
        sb.append(this.reviewDate == null ? "<null>" : this.reviewDate);
        sb.append(',');
        sb.append("extraExpenditure");
        sb.append('=');
        sb.append(this.extraExpenditure == null ? "<null>" : this.extraExpenditure);
        sb.append(',');
        sb.append("deniedIncome");
        sb.append('=');
        sb.append(this.deniedIncome == null ? "<null>" : this.deniedIncome);
        sb.append(',');
        sb.append("solicitorCosts");
        sb.append('=');
        sb.append(this.solicitorCosts == null ? "<null>" : this.solicitorCosts);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.courtType == null ? 0 : this.courtType.hashCode());
        result = result * 31 + (this.reviewDate == null ? 0 : this.reviewDate.hashCode());
        result = result * 31 + (this.deniedIncome == null ? 0 : this.deniedIncome.hashCode());
        result = result * 31 + (this.extraExpenditure == null ? 0 : this.extraExpenditure.hashCode());
        result = result * 31 + (this.totalAnnualDisposableIncome == null ? 0 : this.totalAnnualDisposableIncome.hashCode());
        result = result * 31 + (this.solicitorCosts == null ? 0 : this.solicitorCosts.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HardshipReview)) {
            return false;
        }
        HardshipReview rhs = (HardshipReview)other;
        return (this.courtType == rhs.courtType || this.courtType != null && this.courtType.equals((Object)rhs.courtType)) && (this.reviewDate == rhs.reviewDate || this.reviewDate != null && this.reviewDate.equals(rhs.reviewDate)) && (this.deniedIncome == rhs.deniedIncome || this.deniedIncome != null && this.deniedIncome.equals(rhs.deniedIncome)) && (this.extraExpenditure == rhs.extraExpenditure || this.extraExpenditure != null && this.extraExpenditure.equals(rhs.extraExpenditure)) && (this.totalAnnualDisposableIncome == rhs.totalAnnualDisposableIncome || this.totalAnnualDisposableIncome != null && this.totalAnnualDisposableIncome.equals(rhs.totalAnnualDisposableIncome)) && (this.solicitorCosts == rhs.solicitorCosts || this.solicitorCosts != null && this.solicitorCosts.equals(rhs.solicitorCosts));
    }
}

