/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.hardship;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"rate", "hours", "vat", "disbursements", "estimatedTotal"})
public class SolicitorCosts {
    @JsonProperty(value="rate")
    @JsonPropertyDescription(value="The solicitors hourly rate")
    @NotNull
    private BigDecimal rate;
    @JsonProperty(value="hours")
    @JsonPropertyDescription(value="The number of billable hours")
    @NotNull
    private BigDecimal hours;
    @JsonProperty(value="vat")
    @JsonPropertyDescription(value="Solicitors VAT costs")
    @NotNull
    private BigDecimal vat;
    @JsonProperty(value="disbursements")
    @JsonPropertyDescription(value="Solicitors disbursement costs")
    private BigDecimal disbursements;
    @JsonProperty(value="estimatedTotal")
    @JsonPropertyDescription(value="The total estimated cost")
    private BigDecimal estimatedTotal;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public SolicitorCosts() {
    }

    public SolicitorCosts(BigDecimal rate, BigDecimal hours, BigDecimal vat, BigDecimal disbursements, BigDecimal estimatedTotal) {
        this.rate = rate;
        this.hours = hours;
        this.vat = vat;
        this.disbursements = disbursements;
        this.estimatedTotal = estimatedTotal;
    }

    @JsonProperty(value="rate")
    public BigDecimal getRate() {
        return this.rate;
    }

    @JsonProperty(value="rate")
    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public SolicitorCosts withRate(BigDecimal rate) {
        this.rate = rate;
        return this;
    }

    @JsonProperty(value="hours")
    public BigDecimal getHours() {
        return this.hours;
    }

    @JsonProperty(value="hours")
    public void setHours(BigDecimal hours) {
        this.hours = hours;
    }

    public SolicitorCosts withHours(BigDecimal hours) {
        this.hours = hours;
        return this;
    }

    @JsonProperty(value="vat")
    public BigDecimal getVat() {
        return this.vat;
    }

    @JsonProperty(value="vat")
    public void setVat(BigDecimal vat) {
        this.vat = vat;
    }

    public SolicitorCosts withVat(BigDecimal vat) {
        this.vat = vat;
        return this;
    }

    @JsonProperty(value="disbursements")
    public BigDecimal getDisbursements() {
        return this.disbursements;
    }

    @JsonProperty(value="disbursements")
    public void setDisbursements(BigDecimal disbursements) {
        this.disbursements = disbursements;
    }

    public SolicitorCosts withDisbursements(BigDecimal disbursements) {
        this.disbursements = disbursements;
        return this;
    }

    @JsonProperty(value="estimatedTotal")
    public BigDecimal getEstimatedTotal() {
        return this.estimatedTotal;
    }

    @JsonProperty(value="estimatedTotal")
    public void setEstimatedTotal(BigDecimal estimatedTotal) {
        this.estimatedTotal = estimatedTotal;
    }

    public SolicitorCosts withEstimatedTotal(BigDecimal estimatedTotal) {
        this.estimatedTotal = estimatedTotal;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SolicitorCosts withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("rate".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"rate\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setRate((BigDecimal)value);
            return true;
        }
        if ("hours".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"hours\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setHours((BigDecimal)value);
            return true;
        }
        if ("vat".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"vat\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setVat((BigDecimal)value);
            return true;
        }
        if ("disbursements".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"disbursements\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setDisbursements((BigDecimal)value);
            return true;
        }
        if ("estimatedTotal".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"estimatedTotal\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setEstimatedTotal((BigDecimal)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("rate".equals(name)) {
            return this.getRate();
        }
        if ("hours".equals(name)) {
            return this.getHours();
        }
        if ("vat".equals(name)) {
            return this.getVat();
        }
        if ("disbursements".equals(name)) {
            return this.getDisbursements();
        }
        if ("estimatedTotal".equals(name)) {
            return this.getEstimatedTotal();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public SolicitorCosts with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SolicitorCosts.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("rate");
        sb.append('=');
        sb.append(this.rate == null ? "<null>" : this.rate);
        sb.append(',');
        sb.append("hours");
        sb.append('=');
        sb.append(this.hours == null ? "<null>" : this.hours);
        sb.append(',');
        sb.append("vat");
        sb.append('=');
        sb.append(this.vat == null ? "<null>" : this.vat);
        sb.append(',');
        sb.append("disbursements");
        sb.append('=');
        sb.append(this.disbursements == null ? "<null>" : this.disbursements);
        sb.append(',');
        sb.append("estimatedTotal");
        sb.append('=');
        sb.append(this.estimatedTotal == null ? "<null>" : this.estimatedTotal);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.hours == null ? 0 : this.hours.hashCode());
        result = result * 31 + (this.rate == null ? 0 : this.rate.hashCode());
        result = result * 31 + (this.disbursements == null ? 0 : this.disbursements.hashCode());
        result = result * 31 + (this.vat == null ? 0 : this.vat.hashCode());
        result = result * 31 + (this.estimatedTotal == null ? 0 : this.estimatedTotal.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SolicitorCosts)) {
            return false;
        }
        SolicitorCosts rhs = (SolicitorCosts)other;
        return (this.hours == rhs.hours || this.hours != null && this.hours.equals(rhs.hours)) && (this.rate == rhs.rate || this.rate != null && this.rate.equals(rhs.rate)) && (this.disbursements == rhs.disbursements || this.disbursements != null && this.disbursements.equals(rhs.disbursements)) && (this.vat == rhs.vat || this.vat != null && this.vat.equals(rhs.vat)) && (this.estimatedTotal == rhs.estimatedTotal || this.estimatedTotal != null && this.estimatedTotal.equals(rhs.estimatedTotal)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }
}

