/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.hardship.maat_api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.hardship.ApiHardshipDetail;
import uk.gov.justice.laa.crime.common.model.hardship.maat_api.ApiPersistHardshipRequest;
import uk.gov.justice.laa.crime.dto.maatapi.SolicitorCosts;
import uk.gov.justice.laa.crime.enums.CourtType;
import uk.gov.justice.laa.crime.enums.HardshipReviewResult;
import uk.gov.justice.laa.crime.enums.HardshipReviewStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"repId", "userCreated", "courtType", "financialAssessmentId"})
public class ApiCreateHardshipRequest
extends ApiPersistHardshipRequest {
    @JsonProperty(value="repId")
    @JsonPropertyDescription(value="MAAT / Rep Id")
    @NotNull
    private Integer repId;
    @JsonProperty(value="userCreated")
    @JsonPropertyDescription(value="ID of the user creating the assessment")
    @NotNull
    private String userCreated;
    @JsonProperty(value="courtType")
    @JsonPropertyDescription(value="The Court Type")
    @Valid
    @NotNull
    private CourtType courtType;
    @JsonProperty(value="financialAssessmentId")
    @JsonPropertyDescription(value="The ID of the financial assessment completed prior to the Hardship Review")
    @NotNull
    private Integer financialAssessmentId;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiCreateHardshipRequest() {
    }

    public ApiCreateHardshipRequest(Integer repId, String userCreated, CourtType courtType, Integer financialAssessmentId, String nworCode, Integer cmuId, HardshipReviewResult reviewResult, LocalDateTime resultDate, LocalDateTime reviewDate, String notes, String decisionNotes, SolicitorCosts solicitorCosts, BigDecimal disposableIncome, BigDecimal disposableIncomeAfterHardship, HardshipReviewStatus status, List<ApiHardshipDetail> reviewDetails) {
        super(nworCode, cmuId, reviewResult, resultDate, reviewDate, notes, decisionNotes, solicitorCosts, disposableIncome, disposableIncomeAfterHardship, status, reviewDetails);
        this.repId = repId;
        this.userCreated = userCreated;
        this.courtType = courtType;
        this.financialAssessmentId = financialAssessmentId;
    }

    @JsonProperty(value="repId")
    public Integer getRepId() {
        return this.repId;
    }

    @JsonProperty(value="repId")
    public void setRepId(Integer repId) {
        this.repId = repId;
    }

    public ApiCreateHardshipRequest withRepId(Integer repId) {
        this.repId = repId;
        return this;
    }

    @JsonProperty(value="userCreated")
    public String getUserCreated() {
        return this.userCreated;
    }

    @JsonProperty(value="userCreated")
    public void setUserCreated(String userCreated) {
        this.userCreated = userCreated;
    }

    public ApiCreateHardshipRequest withUserCreated(String userCreated) {
        this.userCreated = userCreated;
        return this;
    }

    @JsonProperty(value="courtType")
    public CourtType getCourtType() {
        return this.courtType;
    }

    @JsonProperty(value="courtType")
    public void setCourtType(CourtType courtType) {
        this.courtType = courtType;
    }

    public ApiCreateHardshipRequest withCourtType(CourtType courtType) {
        this.courtType = courtType;
        return this;
    }

    @JsonProperty(value="financialAssessmentId")
    public Integer getFinancialAssessmentId() {
        return this.financialAssessmentId;
    }

    @JsonProperty(value="financialAssessmentId")
    public void setFinancialAssessmentId(Integer financialAssessmentId) {
        this.financialAssessmentId = financialAssessmentId;
    }

    public ApiCreateHardshipRequest withFinancialAssessmentId(Integer financialAssessmentId) {
        this.financialAssessmentId = financialAssessmentId;
        return this;
    }

    @Override
    public ApiCreateHardshipRequest withNworCode(String nworCode) {
        super.withNworCode(nworCode);
        return this;
    }

    @Override
    public ApiCreateHardshipRequest withCmuId(Integer cmuId) {
        super.withCmuId(cmuId);
        return this;
    }

    @Override
    public ApiCreateHardshipRequest withReviewResult(HardshipReviewResult reviewResult) {
        super.withReviewResult(reviewResult);
        return this;
    }

    @Override
    public ApiCreateHardshipRequest withResultDate(LocalDateTime resultDate) {
        super.withResultDate(resultDate);
        return this;
    }

    @Override
    public ApiCreateHardshipRequest withReviewDate(LocalDateTime reviewDate) {
        super.withReviewDate(reviewDate);
        return this;
    }

    @Override
    public ApiCreateHardshipRequest withNotes(String notes) {
        super.withNotes(notes);
        return this;
    }

    @Override
    public ApiCreateHardshipRequest withDecisionNotes(String decisionNotes) {
        super.withDecisionNotes(decisionNotes);
        return this;
    }

    @Override
    public ApiCreateHardshipRequest withSolicitorCosts(SolicitorCosts solicitorCosts) {
        super.withSolicitorCosts(solicitorCosts);
        return this;
    }

    @Override
    public ApiCreateHardshipRequest withDisposableIncome(BigDecimal disposableIncome) {
        super.withDisposableIncome(disposableIncome);
        return this;
    }

    @Override
    public ApiCreateHardshipRequest withDisposableIncomeAfterHardship(BigDecimal disposableIncomeAfterHardship) {
        super.withDisposableIncomeAfterHardship(disposableIncomeAfterHardship);
        return this;
    }

    @Override
    public ApiCreateHardshipRequest withStatus(HardshipReviewStatus status) {
        super.withStatus(status);
        return this;
    }

    @Override
    public ApiCreateHardshipRequest withReviewDetails(List<ApiHardshipDetail> reviewDetails) {
        super.withReviewDetails(reviewDetails);
        return this;
    }

    @Override
    protected boolean declaredProperty(String name, Object value) {
        if ("repId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"repId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setRepId((Integer)value);
            return true;
        }
        if ("userCreated".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"userCreated\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUserCreated((String)value);
            return true;
        }
        if ("courtType".equals(name)) {
            if (!(value instanceof CourtType)) {
                throw new IllegalArgumentException("property \"courtType\" is of type \"uk.gov.justice.laa.crime.enums.CourtType\", but got " + value.getClass().toString());
            }
            this.setCourtType((CourtType)value);
            return true;
        }
        if ("financialAssessmentId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"financialAssessmentId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setFinancialAssessmentId((Integer)value);
            return true;
        }
        return super.declaredProperty(name, value);
    }

    @Override
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("repId".equals(name)) {
            return this.getRepId();
        }
        if ("userCreated".equals(name)) {
            return this.getUserCreated();
        }
        if ("courtType".equals(name)) {
            return this.getCourtType();
        }
        if ("financialAssessmentId".equals(name)) {
            return this.getFinancialAssessmentId();
        }
        return super.declaredPropertyOrNotFound(name, notFoundValue);
    }

    @Override
    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    @Override
    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    @Override
    public ApiCreateHardshipRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiCreateHardshipRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("repId");
        sb.append('=');
        sb.append(this.repId == null ? "<null>" : this.repId);
        sb.append(',');
        sb.append("userCreated");
        sb.append('=');
        sb.append(this.userCreated == null ? "<null>" : this.userCreated);
        sb.append(',');
        sb.append("courtType");
        sb.append('=');
        sb.append((Object)(this.courtType == null ? "<null>" : this.courtType));
        sb.append(',');
        sb.append("financialAssessmentId");
        sb.append('=');
        sb.append(this.financialAssessmentId == null ? "<null>" : this.financialAssessmentId);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.courtType == null ? 0 : this.courtType.hashCode());
        result = result * 31 + (this.userCreated == null ? 0 : this.userCreated.hashCode());
        result = result * 31 + (this.repId == null ? 0 : this.repId.hashCode());
        result = result * 31 + (this.financialAssessmentId == null ? 0 : this.financialAssessmentId.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiCreateHardshipRequest)) {
            return false;
        }
        ApiCreateHardshipRequest rhs = (ApiCreateHardshipRequest)other;
        return super.equals(rhs) && (this.courtType == rhs.courtType || this.courtType != null && this.courtType.equals((Object)rhs.courtType)) && (this.userCreated == rhs.userCreated || this.userCreated != null && this.userCreated.equals(rhs.userCreated)) && (this.repId == rhs.repId || this.repId != null && this.repId.equals(rhs.repId)) && (this.financialAssessmentId == rhs.financialAssessmentId || this.financialAssessmentId != null && this.financialAssessmentId.equals(rhs.financialAssessmentId));
    }
}

