/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.hardship.maat_api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.hardship.ApiHardshipDetail;
import uk.gov.justice.laa.crime.common.model.hardship.maat_api.ApiPersistHardshipRequest;
import uk.gov.justice.laa.crime.dto.maatapi.SolicitorCosts;
import uk.gov.justice.laa.crime.enums.HardshipReviewResult;
import uk.gov.justice.laa.crime.enums.HardshipReviewStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "userModified"})
public class ApiUpdateHardshipRequest
extends ApiPersistHardshipRequest {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="The ID of the Hardship Review to update")
    @NotNull
    private Integer id;
    @JsonProperty(value="userModified")
    @JsonPropertyDescription(value="ID of the user updating the Hardship Review")
    @NotNull
    private String userModified;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiUpdateHardshipRequest() {
    }

    public ApiUpdateHardshipRequest(Integer id, String userModified, String nworCode, Integer cmuId, HardshipReviewResult reviewResult, LocalDateTime resultDate, LocalDateTime reviewDate, String notes, String decisionNotes, SolicitorCosts solicitorCosts, BigDecimal disposableIncome, BigDecimal disposableIncomeAfterHardship, HardshipReviewStatus status, List<ApiHardshipDetail> reviewDetails) {
        super(nworCode, cmuId, reviewResult, resultDate, reviewDate, notes, decisionNotes, solicitorCosts, disposableIncome, disposableIncomeAfterHardship, status, reviewDetails);
        this.id = id;
        this.userModified = userModified;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public ApiUpdateHardshipRequest withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="userModified")
    public String getUserModified() {
        return this.userModified;
    }

    @JsonProperty(value="userModified")
    public void setUserModified(String userModified) {
        this.userModified = userModified;
    }

    public ApiUpdateHardshipRequest withUserModified(String userModified) {
        this.userModified = userModified;
        return this;
    }

    @Override
    public ApiUpdateHardshipRequest withNworCode(String nworCode) {
        super.withNworCode(nworCode);
        return this;
    }

    @Override
    public ApiUpdateHardshipRequest withCmuId(Integer cmuId) {
        super.withCmuId(cmuId);
        return this;
    }

    @Override
    public ApiUpdateHardshipRequest withReviewResult(HardshipReviewResult reviewResult) {
        super.withReviewResult(reviewResult);
        return this;
    }

    @Override
    public ApiUpdateHardshipRequest withResultDate(LocalDateTime resultDate) {
        super.withResultDate(resultDate);
        return this;
    }

    @Override
    public ApiUpdateHardshipRequest withReviewDate(LocalDateTime reviewDate) {
        super.withReviewDate(reviewDate);
        return this;
    }

    @Override
    public ApiUpdateHardshipRequest withNotes(String notes) {
        super.withNotes(notes);
        return this;
    }

    @Override
    public ApiUpdateHardshipRequest withDecisionNotes(String decisionNotes) {
        super.withDecisionNotes(decisionNotes);
        return this;
    }

    @Override
    public ApiUpdateHardshipRequest withSolicitorCosts(SolicitorCosts solicitorCosts) {
        super.withSolicitorCosts(solicitorCosts);
        return this;
    }

    @Override
    public ApiUpdateHardshipRequest withDisposableIncome(BigDecimal disposableIncome) {
        super.withDisposableIncome(disposableIncome);
        return this;
    }

    @Override
    public ApiUpdateHardshipRequest withDisposableIncomeAfterHardship(BigDecimal disposableIncomeAfterHardship) {
        super.withDisposableIncomeAfterHardship(disposableIncomeAfterHardship);
        return this;
    }

    @Override
    public ApiUpdateHardshipRequest withStatus(HardshipReviewStatus status) {
        super.withStatus(status);
        return this;
    }

    @Override
    public ApiUpdateHardshipRequest withReviewDetails(List<ApiHardshipDetail> reviewDetails) {
        super.withReviewDetails(reviewDetails);
        return this;
    }

    @Override
    protected boolean declaredProperty(String name, Object value) {
        if ("id".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"id\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setId((Integer)value);
            return true;
        }
        if ("userModified".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"userModified\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUserModified((String)value);
            return true;
        }
        return super.declaredProperty(name, value);
    }

    @Override
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("userModified".equals(name)) {
            return this.getUserModified();
        }
        return super.declaredPropertyOrNotFound(name, notFoundValue);
    }

    @Override
    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    @Override
    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    @Override
    public ApiUpdateHardshipRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiUpdateHardshipRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("userModified");
        sb.append('=');
        sb.append(this.userModified == null ? "<null>" : this.userModified);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.userModified == null ? 0 : this.userModified.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiUpdateHardshipRequest)) {
            return false;
        }
        ApiUpdateHardshipRequest rhs = (ApiUpdateHardshipRequest)other;
        return super.equals(rhs) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.userModified == rhs.userModified || this.userModified != null && this.userModified.equals(rhs.userModified));
    }
}

