/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.maatapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.maatapi.ApiAssessmentDetail;
import uk.gov.justice.laa.crime.common.model.maatapi.ApiAssessmentStatus;
import uk.gov.justice.laa.crime.common.model.maatapi.ApiNewWorkReason;
import uk.gov.justice.laa.crime.common.model.maatapi.ApiReviewType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"laaTransactionId", "repId", "cmuId", "userId", "criteriaId", "employmentStatus", "transactionDateTime", "assessmentDate", "otherBenefitNote", "otherIncomeNote", "notes", "assessmentStatus", "newWorkReason", "incomeEvidenceDueDate", "incomeUpliftRemovalDueDate", "incomeUpliftApplyDueDate", "incomeEvidenceNotes", "totalAggregatedIncome", "adjustedIncomeValue", "result", "resultReason", "reviewType", "assessmentDetail"})
public class ApiCreateInitialMeansAssessment {
    @JsonProperty(value="laaTransactionId")
    @JsonPropertyDescription(value="The correlation / transaction UUID")
    @NotNull
    private String laaTransactionId;
    @JsonProperty(value="repId")
    @JsonPropertyDescription(value="MAAT / Rep Id")
    @NotNull
    private Integer repId;
    @JsonProperty(value="cmuId")
    @JsonPropertyDescription(value="Case Management Unit Id")
    @NotNull
    private Integer cmuId;
    @JsonProperty(value="userId")
    @JsonPropertyDescription(value="User  ID")
    @NotNull
    private String userId;
    @JsonProperty(value="criteriaId")
    @JsonPropertyDescription(value="Criteria ID")
    private Integer criteriaId;
    @JsonProperty(value="employmentStatus")
    @JsonPropertyDescription(value="Code for the employment status")
    private Integer employmentStatus;
    @JsonProperty(value="transactionDateTime")
    @JsonPropertyDescription(value="Time Stamp of the transaction")
    @NotNull
    private LocalDateTime transactionDateTime;
    @JsonProperty(value="assessmentDate")
    @JsonPropertyDescription(value="Effective Date of the assessment")
    @NotNull
    private String assessmentDate;
    @JsonProperty(value="otherBenefitNote")
    @JsonPropertyDescription(value="Benefit Note")
    private String otherBenefitNote;
    @JsonProperty(value="otherIncomeNote")
    @JsonPropertyDescription(value="Income Note.")
    private String otherIncomeNote;
    @JsonProperty(value="notes")
    @JsonPropertyDescription(value="Notes field.")
    private String notes;
    @JsonProperty(value="assessmentStatus")
    @JsonPropertyDescription(value="Assessment Status Details")
    @Valid
    private ApiAssessmentStatus assessmentStatus;
    @JsonProperty(value="newWorkReason")
    @JsonPropertyDescription(value="An explanation about the purpose of this instance.")
    @Valid
    @NotNull
    private ApiNewWorkReason newWorkReason;
    @JsonProperty(value="incomeEvidenceDueDate")
    @JsonPropertyDescription(value="Income Evidence Due Date")
    private LocalDateTime incomeEvidenceDueDate;
    @JsonProperty(value="incomeUpliftRemovalDueDate")
    @JsonPropertyDescription(value="Income Uplift Removal Due Date")
    private LocalDateTime incomeUpliftRemovalDueDate;
    @JsonProperty(value="incomeUpliftApplyDueDate")
    @JsonPropertyDescription(value="Income Uplift Apply Due Date")
    private LocalDateTime incomeUpliftApplyDueDate;
    @JsonProperty(value="incomeEvidenceNotes")
    @JsonPropertyDescription(value="Income Evidence Notes")
    private LocalDateTime incomeEvidenceNotes;
    @JsonProperty(value="totalAggregatedIncome")
    @JsonPropertyDescription(value="Total Aggregated income of the application.")
    private BigDecimal totalAggregatedIncome;
    @JsonProperty(value="adjustedIncomeValue")
    @JsonPropertyDescription(value="Adjusted Income of the Application")
    private BigDecimal adjustedIncomeValue;
    @JsonProperty(value="result")
    @JsonPropertyDescription(value="Outcome of an Assessment")
    private String result;
    @JsonProperty(value="resultReason")
    @JsonPropertyDescription(value="The reason for the outcome ")
    private String resultReason;
    @JsonProperty(value="reviewType")
    @JsonPropertyDescription(value="An explanation about the purpose of this instance.")
    @Valid
    private ApiReviewType reviewType;
    @JsonProperty(value="assessmentDetail")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<ApiAssessmentDetail> assessmentDetail = new ArrayList<ApiAssessmentDetail>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiCreateInitialMeansAssessment() {
    }

    public ApiCreateInitialMeansAssessment(String laaTransactionId, Integer repId, Integer cmuId, String userId, Integer criteriaId, Integer employmentStatus, LocalDateTime transactionDateTime, String assessmentDate, String otherBenefitNote, String otherIncomeNote, String notes, ApiAssessmentStatus assessmentStatus, ApiNewWorkReason newWorkReason, LocalDateTime incomeEvidenceDueDate, LocalDateTime incomeUpliftRemovalDueDate, LocalDateTime incomeUpliftApplyDueDate, LocalDateTime incomeEvidenceNotes, BigDecimal totalAggregatedIncome, BigDecimal adjustedIncomeValue, String result, String resultReason, ApiReviewType reviewType, List<ApiAssessmentDetail> assessmentDetail) {
        this.laaTransactionId = laaTransactionId;
        this.repId = repId;
        this.cmuId = cmuId;
        this.userId = userId;
        this.criteriaId = criteriaId;
        this.employmentStatus = employmentStatus;
        this.transactionDateTime = transactionDateTime;
        this.assessmentDate = assessmentDate;
        this.otherBenefitNote = otherBenefitNote;
        this.otherIncomeNote = otherIncomeNote;
        this.notes = notes;
        this.assessmentStatus = assessmentStatus;
        this.newWorkReason = newWorkReason;
        this.incomeEvidenceDueDate = incomeEvidenceDueDate;
        this.incomeUpliftRemovalDueDate = incomeUpliftRemovalDueDate;
        this.incomeUpliftApplyDueDate = incomeUpliftApplyDueDate;
        this.incomeEvidenceNotes = incomeEvidenceNotes;
        this.totalAggregatedIncome = totalAggregatedIncome;
        this.adjustedIncomeValue = adjustedIncomeValue;
        this.result = result;
        this.resultReason = resultReason;
        this.reviewType = reviewType;
        this.assessmentDetail = assessmentDetail;
    }

    @JsonProperty(value="laaTransactionId")
    public String getLaaTransactionId() {
        return this.laaTransactionId;
    }

    @JsonProperty(value="laaTransactionId")
    public void setLaaTransactionId(String laaTransactionId) {
        this.laaTransactionId = laaTransactionId;
    }

    public ApiCreateInitialMeansAssessment withLaaTransactionId(String laaTransactionId) {
        this.laaTransactionId = laaTransactionId;
        return this;
    }

    @JsonProperty(value="repId")
    public Integer getRepId() {
        return this.repId;
    }

    @JsonProperty(value="repId")
    public void setRepId(Integer repId) {
        this.repId = repId;
    }

    public ApiCreateInitialMeansAssessment withRepId(Integer repId) {
        this.repId = repId;
        return this;
    }

    @JsonProperty(value="cmuId")
    public Integer getCmuId() {
        return this.cmuId;
    }

    @JsonProperty(value="cmuId")
    public void setCmuId(Integer cmuId) {
        this.cmuId = cmuId;
    }

    public ApiCreateInitialMeansAssessment withCmuId(Integer cmuId) {
        this.cmuId = cmuId;
        return this;
    }

    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ApiCreateInitialMeansAssessment withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    @JsonProperty(value="criteriaId")
    public Integer getCriteriaId() {
        return this.criteriaId;
    }

    @JsonProperty(value="criteriaId")
    public void setCriteriaId(Integer criteriaId) {
        this.criteriaId = criteriaId;
    }

    public ApiCreateInitialMeansAssessment withCriteriaId(Integer criteriaId) {
        this.criteriaId = criteriaId;
        return this;
    }

    @JsonProperty(value="employmentStatus")
    public Integer getEmploymentStatus() {
        return this.employmentStatus;
    }

    @JsonProperty(value="employmentStatus")
    public void setEmploymentStatus(Integer employmentStatus) {
        this.employmentStatus = employmentStatus;
    }

    public ApiCreateInitialMeansAssessment withEmploymentStatus(Integer employmentStatus) {
        this.employmentStatus = employmentStatus;
        return this;
    }

    @JsonProperty(value="transactionDateTime")
    public LocalDateTime getTransactionDateTime() {
        return this.transactionDateTime;
    }

    @JsonProperty(value="transactionDateTime")
    public void setTransactionDateTime(LocalDateTime transactionDateTime) {
        this.transactionDateTime = transactionDateTime;
    }

    public ApiCreateInitialMeansAssessment withTransactionDateTime(LocalDateTime transactionDateTime) {
        this.transactionDateTime = transactionDateTime;
        return this;
    }

    @JsonProperty(value="assessmentDate")
    public String getAssessmentDate() {
        return this.assessmentDate;
    }

    @JsonProperty(value="assessmentDate")
    public void setAssessmentDate(String assessmentDate) {
        this.assessmentDate = assessmentDate;
    }

    public ApiCreateInitialMeansAssessment withAssessmentDate(String assessmentDate) {
        this.assessmentDate = assessmentDate;
        return this;
    }

    @JsonProperty(value="otherBenefitNote")
    public String getOtherBenefitNote() {
        return this.otherBenefitNote;
    }

    @JsonProperty(value="otherBenefitNote")
    public void setOtherBenefitNote(String otherBenefitNote) {
        this.otherBenefitNote = otherBenefitNote;
    }

    public ApiCreateInitialMeansAssessment withOtherBenefitNote(String otherBenefitNote) {
        this.otherBenefitNote = otherBenefitNote;
        return this;
    }

    @JsonProperty(value="otherIncomeNote")
    public String getOtherIncomeNote() {
        return this.otherIncomeNote;
    }

    @JsonProperty(value="otherIncomeNote")
    public void setOtherIncomeNote(String otherIncomeNote) {
        this.otherIncomeNote = otherIncomeNote;
    }

    public ApiCreateInitialMeansAssessment withOtherIncomeNote(String otherIncomeNote) {
        this.otherIncomeNote = otherIncomeNote;
        return this;
    }

    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    public void setNotes(String notes) {
        this.notes = notes;
    }

    public ApiCreateInitialMeansAssessment withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    @JsonProperty(value="assessmentStatus")
    public ApiAssessmentStatus getAssessmentStatus() {
        return this.assessmentStatus;
    }

    @JsonProperty(value="assessmentStatus")
    public void setAssessmentStatus(ApiAssessmentStatus assessmentStatus) {
        this.assessmentStatus = assessmentStatus;
    }

    public ApiCreateInitialMeansAssessment withAssessmentStatus(ApiAssessmentStatus assessmentStatus) {
        this.assessmentStatus = assessmentStatus;
        return this;
    }

    @JsonProperty(value="newWorkReason")
    public ApiNewWorkReason getNewWorkReason() {
        return this.newWorkReason;
    }

    @JsonProperty(value="newWorkReason")
    public void setNewWorkReason(ApiNewWorkReason newWorkReason) {
        this.newWorkReason = newWorkReason;
    }

    public ApiCreateInitialMeansAssessment withNewWorkReason(ApiNewWorkReason newWorkReason) {
        this.newWorkReason = newWorkReason;
        return this;
    }

    @JsonProperty(value="incomeEvidenceDueDate")
    public LocalDateTime getIncomeEvidenceDueDate() {
        return this.incomeEvidenceDueDate;
    }

    @JsonProperty(value="incomeEvidenceDueDate")
    public void setIncomeEvidenceDueDate(LocalDateTime incomeEvidenceDueDate) {
        this.incomeEvidenceDueDate = incomeEvidenceDueDate;
    }

    public ApiCreateInitialMeansAssessment withIncomeEvidenceDueDate(LocalDateTime incomeEvidenceDueDate) {
        this.incomeEvidenceDueDate = incomeEvidenceDueDate;
        return this;
    }

    @JsonProperty(value="incomeUpliftRemovalDueDate")
    public LocalDateTime getIncomeUpliftRemovalDueDate() {
        return this.incomeUpliftRemovalDueDate;
    }

    @JsonProperty(value="incomeUpliftRemovalDueDate")
    public void setIncomeUpliftRemovalDueDate(LocalDateTime incomeUpliftRemovalDueDate) {
        this.incomeUpliftRemovalDueDate = incomeUpliftRemovalDueDate;
    }

    public ApiCreateInitialMeansAssessment withIncomeUpliftRemovalDueDate(LocalDateTime incomeUpliftRemovalDueDate) {
        this.incomeUpliftRemovalDueDate = incomeUpliftRemovalDueDate;
        return this;
    }

    @JsonProperty(value="incomeUpliftApplyDueDate")
    public LocalDateTime getIncomeUpliftApplyDueDate() {
        return this.incomeUpliftApplyDueDate;
    }

    @JsonProperty(value="incomeUpliftApplyDueDate")
    public void setIncomeUpliftApplyDueDate(LocalDateTime incomeUpliftApplyDueDate) {
        this.incomeUpliftApplyDueDate = incomeUpliftApplyDueDate;
    }

    public ApiCreateInitialMeansAssessment withIncomeUpliftApplyDueDate(LocalDateTime incomeUpliftApplyDueDate) {
        this.incomeUpliftApplyDueDate = incomeUpliftApplyDueDate;
        return this;
    }

    @JsonProperty(value="incomeEvidenceNotes")
    public LocalDateTime getIncomeEvidenceNotes() {
        return this.incomeEvidenceNotes;
    }

    @JsonProperty(value="incomeEvidenceNotes")
    public void setIncomeEvidenceNotes(LocalDateTime incomeEvidenceNotes) {
        this.incomeEvidenceNotes = incomeEvidenceNotes;
    }

    public ApiCreateInitialMeansAssessment withIncomeEvidenceNotes(LocalDateTime incomeEvidenceNotes) {
        this.incomeEvidenceNotes = incomeEvidenceNotes;
        return this;
    }

    @JsonProperty(value="totalAggregatedIncome")
    public BigDecimal getTotalAggregatedIncome() {
        return this.totalAggregatedIncome;
    }

    @JsonProperty(value="totalAggregatedIncome")
    public void setTotalAggregatedIncome(BigDecimal totalAggregatedIncome) {
        this.totalAggregatedIncome = totalAggregatedIncome;
    }

    public ApiCreateInitialMeansAssessment withTotalAggregatedIncome(BigDecimal totalAggregatedIncome) {
        this.totalAggregatedIncome = totalAggregatedIncome;
        return this;
    }

    @JsonProperty(value="adjustedIncomeValue")
    public BigDecimal getAdjustedIncomeValue() {
        return this.adjustedIncomeValue;
    }

    @JsonProperty(value="adjustedIncomeValue")
    public void setAdjustedIncomeValue(BigDecimal adjustedIncomeValue) {
        this.adjustedIncomeValue = adjustedIncomeValue;
    }

    public ApiCreateInitialMeansAssessment withAdjustedIncomeValue(BigDecimal adjustedIncomeValue) {
        this.adjustedIncomeValue = adjustedIncomeValue;
        return this;
    }

    @JsonProperty(value="result")
    public String getResult() {
        return this.result;
    }

    @JsonProperty(value="result")
    public void setResult(String result) {
        this.result = result;
    }

    public ApiCreateInitialMeansAssessment withResult(String result) {
        this.result = result;
        return this;
    }

    @JsonProperty(value="resultReason")
    public String getResultReason() {
        return this.resultReason;
    }

    @JsonProperty(value="resultReason")
    public void setResultReason(String resultReason) {
        this.resultReason = resultReason;
    }

    public ApiCreateInitialMeansAssessment withResultReason(String resultReason) {
        this.resultReason = resultReason;
        return this;
    }

    @JsonProperty(value="reviewType")
    public ApiReviewType getReviewType() {
        return this.reviewType;
    }

    @JsonProperty(value="reviewType")
    public void setReviewType(ApiReviewType reviewType) {
        this.reviewType = reviewType;
    }

    public ApiCreateInitialMeansAssessment withReviewType(ApiReviewType reviewType) {
        this.reviewType = reviewType;
        return this;
    }

    @JsonProperty(value="assessmentDetail")
    public List<ApiAssessmentDetail> getAssessmentDetail() {
        return this.assessmentDetail;
    }

    @JsonProperty(value="assessmentDetail")
    public void setAssessmentDetail(List<ApiAssessmentDetail> assessmentDetail) {
        this.assessmentDetail = assessmentDetail;
    }

    public ApiCreateInitialMeansAssessment withAssessmentDetail(List<ApiAssessmentDetail> assessmentDetail) {
        this.assessmentDetail = assessmentDetail;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("laaTransactionId".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"laaTransactionId\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setLaaTransactionId((String)value);
            return true;
        }
        if ("repId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"repId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setRepId((Integer)value);
            return true;
        }
        if ("cmuId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"cmuId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setCmuId((Integer)value);
            return true;
        }
        if ("userId".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"userId\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUserId((String)value);
            return true;
        }
        if ("criteriaId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"criteriaId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setCriteriaId((Integer)value);
            return true;
        }
        if ("employmentStatus".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"employmentStatus\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setEmploymentStatus((Integer)value);
            return true;
        }
        if ("transactionDateTime".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"transactionDateTime\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setTransactionDateTime((LocalDateTime)value);
            return true;
        }
        if ("assessmentDate".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"assessmentDate\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setAssessmentDate((String)value);
            return true;
        }
        if ("otherBenefitNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"otherBenefitNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOtherBenefitNote((String)value);
            return true;
        }
        if ("otherIncomeNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"otherIncomeNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOtherIncomeNote((String)value);
            return true;
        }
        if ("notes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"notes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setNotes((String)value);
            return true;
        }
        if ("assessmentStatus".equals(name)) {
            if (!(value instanceof ApiAssessmentStatus)) {
                throw new IllegalArgumentException("property \"assessmentStatus\" is of type \"uk.gov.justice.laa.crime.common.model.maatapi.ApiAssessmentStatus\", but got " + value.getClass().toString());
            }
            this.setAssessmentStatus((ApiAssessmentStatus)value);
            return true;
        }
        if ("newWorkReason".equals(name)) {
            if (!(value instanceof ApiNewWorkReason)) {
                throw new IllegalArgumentException("property \"newWorkReason\" is of type \"uk.gov.justice.laa.crime.common.model.maatapi.ApiNewWorkReason\", but got " + value.getClass().toString());
            }
            this.setNewWorkReason((ApiNewWorkReason)value);
            return true;
        }
        if ("incomeEvidenceDueDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"incomeEvidenceDueDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidenceDueDate((LocalDateTime)value);
            return true;
        }
        if ("incomeUpliftRemovalDueDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"incomeUpliftRemovalDueDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setIncomeUpliftRemovalDueDate((LocalDateTime)value);
            return true;
        }
        if ("incomeUpliftApplyDueDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"incomeUpliftApplyDueDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setIncomeUpliftApplyDueDate((LocalDateTime)value);
            return true;
        }
        if ("incomeEvidenceNotes".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"incomeEvidenceNotes\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidenceNotes((LocalDateTime)value);
            return true;
        }
        if ("totalAggregatedIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"totalAggregatedIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setTotalAggregatedIncome((BigDecimal)value);
            return true;
        }
        if ("adjustedIncomeValue".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"adjustedIncomeValue\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setAdjustedIncomeValue((BigDecimal)value);
            return true;
        }
        if ("result".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"result\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setResult((String)value);
            return true;
        }
        if ("resultReason".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"resultReason\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setResultReason((String)value);
            return true;
        }
        if ("reviewType".equals(name)) {
            if (!(value instanceof ApiReviewType)) {
                throw new IllegalArgumentException("property \"reviewType\" is of type \"uk.gov.justice.laa.crime.common.model.maatapi.ApiReviewType\", but got " + value.getClass().toString());
            }
            this.setReviewType((ApiReviewType)value);
            return true;
        }
        if ("assessmentDetail".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"assessmentDetail\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.maatapi.ApiAssessmentDetail>\", but got " + value.getClass().toString());
            }
            this.setAssessmentDetail((List)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("laaTransactionId".equals(name)) {
            return this.getLaaTransactionId();
        }
        if ("repId".equals(name)) {
            return this.getRepId();
        }
        if ("cmuId".equals(name)) {
            return this.getCmuId();
        }
        if ("userId".equals(name)) {
            return this.getUserId();
        }
        if ("criteriaId".equals(name)) {
            return this.getCriteriaId();
        }
        if ("employmentStatus".equals(name)) {
            return this.getEmploymentStatus();
        }
        if ("transactionDateTime".equals(name)) {
            return this.getTransactionDateTime();
        }
        if ("assessmentDate".equals(name)) {
            return this.getAssessmentDate();
        }
        if ("otherBenefitNote".equals(name)) {
            return this.getOtherBenefitNote();
        }
        if ("otherIncomeNote".equals(name)) {
            return this.getOtherIncomeNote();
        }
        if ("notes".equals(name)) {
            return this.getNotes();
        }
        if ("assessmentStatus".equals(name)) {
            return this.getAssessmentStatus();
        }
        if ("newWorkReason".equals(name)) {
            return this.getNewWorkReason();
        }
        if ("incomeEvidenceDueDate".equals(name)) {
            return this.getIncomeEvidenceDueDate();
        }
        if ("incomeUpliftRemovalDueDate".equals(name)) {
            return this.getIncomeUpliftRemovalDueDate();
        }
        if ("incomeUpliftApplyDueDate".equals(name)) {
            return this.getIncomeUpliftApplyDueDate();
        }
        if ("incomeEvidenceNotes".equals(name)) {
            return this.getIncomeEvidenceNotes();
        }
        if ("totalAggregatedIncome".equals(name)) {
            return this.getTotalAggregatedIncome();
        }
        if ("adjustedIncomeValue".equals(name)) {
            return this.getAdjustedIncomeValue();
        }
        if ("result".equals(name)) {
            return this.getResult();
        }
        if ("resultReason".equals(name)) {
            return this.getResultReason();
        }
        if ("reviewType".equals(name)) {
            return this.getReviewType();
        }
        if ("assessmentDetail".equals(name)) {
            return this.getAssessmentDetail();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiCreateInitialMeansAssessment with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiCreateInitialMeansAssessment.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("laaTransactionId");
        sb.append('=');
        sb.append(this.laaTransactionId == null ? "<null>" : this.laaTransactionId);
        sb.append(',');
        sb.append("repId");
        sb.append('=');
        sb.append(this.repId == null ? "<null>" : this.repId);
        sb.append(',');
        sb.append("cmuId");
        sb.append('=');
        sb.append(this.cmuId == null ? "<null>" : this.cmuId);
        sb.append(',');
        sb.append("userId");
        sb.append('=');
        sb.append(this.userId == null ? "<null>" : this.userId);
        sb.append(',');
        sb.append("criteriaId");
        sb.append('=');
        sb.append(this.criteriaId == null ? "<null>" : this.criteriaId);
        sb.append(',');
        sb.append("employmentStatus");
        sb.append('=');
        sb.append(this.employmentStatus == null ? "<null>" : this.employmentStatus);
        sb.append(',');
        sb.append("transactionDateTime");
        sb.append('=');
        sb.append(this.transactionDateTime == null ? "<null>" : this.transactionDateTime);
        sb.append(',');
        sb.append("assessmentDate");
        sb.append('=');
        sb.append(this.assessmentDate == null ? "<null>" : this.assessmentDate);
        sb.append(',');
        sb.append("otherBenefitNote");
        sb.append('=');
        sb.append(this.otherBenefitNote == null ? "<null>" : this.otherBenefitNote);
        sb.append(',');
        sb.append("otherIncomeNote");
        sb.append('=');
        sb.append(this.otherIncomeNote == null ? "<null>" : this.otherIncomeNote);
        sb.append(',');
        sb.append("notes");
        sb.append('=');
        sb.append(this.notes == null ? "<null>" : this.notes);
        sb.append(',');
        sb.append("assessmentStatus");
        sb.append('=');
        sb.append(this.assessmentStatus == null ? "<null>" : this.assessmentStatus);
        sb.append(',');
        sb.append("newWorkReason");
        sb.append('=');
        sb.append(this.newWorkReason == null ? "<null>" : this.newWorkReason);
        sb.append(',');
        sb.append("incomeEvidenceDueDate");
        sb.append('=');
        sb.append(this.incomeEvidenceDueDate == null ? "<null>" : this.incomeEvidenceDueDate);
        sb.append(',');
        sb.append("incomeUpliftRemovalDueDate");
        sb.append('=');
        sb.append(this.incomeUpliftRemovalDueDate == null ? "<null>" : this.incomeUpliftRemovalDueDate);
        sb.append(',');
        sb.append("incomeUpliftApplyDueDate");
        sb.append('=');
        sb.append(this.incomeUpliftApplyDueDate == null ? "<null>" : this.incomeUpliftApplyDueDate);
        sb.append(',');
        sb.append("incomeEvidenceNotes");
        sb.append('=');
        sb.append(this.incomeEvidenceNotes == null ? "<null>" : this.incomeEvidenceNotes);
        sb.append(',');
        sb.append("totalAggregatedIncome");
        sb.append('=');
        sb.append(this.totalAggregatedIncome == null ? "<null>" : this.totalAggregatedIncome);
        sb.append(',');
        sb.append("adjustedIncomeValue");
        sb.append('=');
        sb.append(this.adjustedIncomeValue == null ? "<null>" : this.adjustedIncomeValue);
        sb.append(',');
        sb.append("result");
        sb.append('=');
        sb.append(this.result == null ? "<null>" : this.result);
        sb.append(',');
        sb.append("resultReason");
        sb.append('=');
        sb.append(this.resultReason == null ? "<null>" : this.resultReason);
        sb.append(',');
        sb.append("reviewType");
        sb.append('=');
        sb.append(this.reviewType == null ? "<null>" : this.reviewType);
        sb.append(',');
        sb.append("assessmentDetail");
        sb.append('=');
        sb.append(this.assessmentDetail == null ? "<null>" : this.assessmentDetail);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.incomeEvidenceNotes == null ? 0 : this.incomeEvidenceNotes.hashCode());
        result = result * 31 + (this.notes == null ? 0 : this.notes.hashCode());
        result = result * 31 + (this.criteriaId == null ? 0 : this.criteriaId.hashCode());
        result = result * 31 + (this.assessmentDate == null ? 0 : this.assessmentDate.hashCode());
        result = result * 31 + (this.otherBenefitNote == null ? 0 : this.otherBenefitNote.hashCode());
        result = result * 31 + (this.reviewType == null ? 0 : this.reviewType.hashCode());
        result = result * 31 + (this.newWorkReason == null ? 0 : this.newWorkReason.hashCode());
        result = result * 31 + (this.employmentStatus == null ? 0 : this.employmentStatus.hashCode());
        result = result * 31 + (this.result == null ? 0 : this.result.hashCode());
        result = result * 31 + (this.resultReason == null ? 0 : this.resultReason.hashCode());
        result = result * 31 + (this.laaTransactionId == null ? 0 : this.laaTransactionId.hashCode());
        result = result * 31 + (this.cmuId == null ? 0 : this.cmuId.hashCode());
        result = result * 31 + (this.adjustedIncomeValue == null ? 0 : this.adjustedIncomeValue.hashCode());
        result = result * 31 + (this.incomeEvidenceDueDate == null ? 0 : this.incomeEvidenceDueDate.hashCode());
        result = result * 31 + (this.transactionDateTime == null ? 0 : this.transactionDateTime.hashCode());
        result = result * 31 + (this.incomeUpliftRemovalDueDate == null ? 0 : this.incomeUpliftRemovalDueDate.hashCode());
        result = result * 31 + (this.assessmentDetail == null ? 0 : this.assessmentDetail.hashCode());
        result = result * 31 + (this.assessmentStatus == null ? 0 : this.assessmentStatus.hashCode());
        result = result * 31 + (this.otherIncomeNote == null ? 0 : this.otherIncomeNote.hashCode());
        result = result * 31 + (this.userId == null ? 0 : this.userId.hashCode());
        result = result * 31 + (this.repId == null ? 0 : this.repId.hashCode());
        result = result * 31 + (this.totalAggregatedIncome == null ? 0 : this.totalAggregatedIncome.hashCode());
        result = result * 31 + (this.incomeUpliftApplyDueDate == null ? 0 : this.incomeUpliftApplyDueDate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiCreateInitialMeansAssessment)) {
            return false;
        }
        ApiCreateInitialMeansAssessment rhs = (ApiCreateInitialMeansAssessment)other;
        return (this.incomeEvidenceNotes == rhs.incomeEvidenceNotes || this.incomeEvidenceNotes != null && this.incomeEvidenceNotes.equals(rhs.incomeEvidenceNotes)) && (this.notes == rhs.notes || this.notes != null && this.notes.equals(rhs.notes)) && (this.criteriaId == rhs.criteriaId || this.criteriaId != null && this.criteriaId.equals(rhs.criteriaId)) && (this.assessmentDate == rhs.assessmentDate || this.assessmentDate != null && this.assessmentDate.equals(rhs.assessmentDate)) && (this.otherBenefitNote == rhs.otherBenefitNote || this.otherBenefitNote != null && this.otherBenefitNote.equals(rhs.otherBenefitNote)) && (this.reviewType == rhs.reviewType || this.reviewType != null && this.reviewType.equals(rhs.reviewType)) && (this.newWorkReason == rhs.newWorkReason || this.newWorkReason != null && this.newWorkReason.equals(rhs.newWorkReason)) && (this.employmentStatus == rhs.employmentStatus || this.employmentStatus != null && this.employmentStatus.equals(rhs.employmentStatus)) && (this.result == rhs.result || this.result != null && this.result.equals(rhs.result)) && (this.resultReason == rhs.resultReason || this.resultReason != null && this.resultReason.equals(rhs.resultReason)) && (this.laaTransactionId == rhs.laaTransactionId || this.laaTransactionId != null && this.laaTransactionId.equals(rhs.laaTransactionId)) && (this.cmuId == rhs.cmuId || this.cmuId != null && this.cmuId.equals(rhs.cmuId)) && (this.adjustedIncomeValue == rhs.adjustedIncomeValue || this.adjustedIncomeValue != null && this.adjustedIncomeValue.equals(rhs.adjustedIncomeValue)) && (this.incomeEvidenceDueDate == rhs.incomeEvidenceDueDate || this.incomeEvidenceDueDate != null && this.incomeEvidenceDueDate.equals(rhs.incomeEvidenceDueDate)) && (this.transactionDateTime == rhs.transactionDateTime || this.transactionDateTime != null && this.transactionDateTime.equals(rhs.transactionDateTime)) && (this.incomeUpliftRemovalDueDate == rhs.incomeUpliftRemovalDueDate || this.incomeUpliftRemovalDueDate != null && this.incomeUpliftRemovalDueDate.equals(rhs.incomeUpliftRemovalDueDate)) && (this.assessmentDetail == rhs.assessmentDetail || this.assessmentDetail != null && this.assessmentDetail.equals(rhs.assessmentDetail)) && (this.assessmentStatus == rhs.assessmentStatus || this.assessmentStatus != null && this.assessmentStatus.equals(rhs.assessmentStatus)) && (this.otherIncomeNote == rhs.otherIncomeNote || this.otherIncomeNote != null && this.otherIncomeNote.equals(rhs.otherIncomeNote)) && (this.userId == rhs.userId || this.userId != null && this.userId.equals(rhs.userId)) && (this.repId == rhs.repId || this.repId != null && this.repId.equals(rhs.repId)) && (this.totalAggregatedIncome == rhs.totalAggregatedIncome || this.totalAggregatedIncome != null && this.totalAggregatedIncome.equals(rhs.totalAggregatedIncome)) && (this.incomeUpliftApplyDueDate == rhs.incomeUpliftApplyDueDate || this.incomeUpliftApplyDueDate != null && this.incomeUpliftApplyDueDate.equals(rhs.incomeUpliftApplyDueDate));
    }
}

