/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentDetail;
import uk.gov.justice.laa.crime.enums.AssessmentType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"section", "applicantAnnualTotal", "partnerAnnualTotal", "annualTotal", "assessmentType", "assessmentDetails"})
public class ApiAssessmentSectionSummary {
    @JsonProperty(value="section")
    @JsonPropertyDescription(value="The section identifier")
    @NotNull
    private String section;
    @JsonProperty(value="applicantAnnualTotal")
    @JsonPropertyDescription(value="Applicant Annual Total")
    private BigDecimal applicantAnnualTotal;
    @JsonProperty(value="partnerAnnualTotal")
    @JsonPropertyDescription(value="Partner Annual Total")
    private BigDecimal partnerAnnualTotal;
    @JsonProperty(value="annualTotal")
    @JsonPropertyDescription(value="Annual Total")
    private BigDecimal annualTotal;
    @JsonProperty(value="assessmentType")
    @JsonPropertyDescription(value="The Frequency of Applicant")
    @Valid
    private AssessmentType assessmentType;
    @JsonProperty(value="assessmentDetails")
    @Size(min=1)
    @Valid
    @NotNull
    private @Size(min=1) @Valid @NotNull List<ApiAssessmentDetail> assessmentDetails = new ArrayList<ApiAssessmentDetail>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiAssessmentSectionSummary() {
    }

    public ApiAssessmentSectionSummary(String section, BigDecimal applicantAnnualTotal, BigDecimal partnerAnnualTotal, BigDecimal annualTotal, AssessmentType assessmentType, List<ApiAssessmentDetail> assessmentDetails) {
        this.section = section;
        this.applicantAnnualTotal = applicantAnnualTotal;
        this.partnerAnnualTotal = partnerAnnualTotal;
        this.annualTotal = annualTotal;
        this.assessmentType = assessmentType;
        this.assessmentDetails = assessmentDetails;
    }

    @JsonProperty(value="section")
    public String getSection() {
        return this.section;
    }

    @JsonProperty(value="section")
    public void setSection(String section) {
        this.section = section;
    }

    public ApiAssessmentSectionSummary withSection(String section) {
        this.section = section;
        return this;
    }

    @JsonProperty(value="applicantAnnualTotal")
    public BigDecimal getApplicantAnnualTotal() {
        return this.applicantAnnualTotal;
    }

    @JsonProperty(value="applicantAnnualTotal")
    public void setApplicantAnnualTotal(BigDecimal applicantAnnualTotal) {
        this.applicantAnnualTotal = applicantAnnualTotal;
    }

    public ApiAssessmentSectionSummary withApplicantAnnualTotal(BigDecimal applicantAnnualTotal) {
        this.applicantAnnualTotal = applicantAnnualTotal;
        return this;
    }

    @JsonProperty(value="partnerAnnualTotal")
    public BigDecimal getPartnerAnnualTotal() {
        return this.partnerAnnualTotal;
    }

    @JsonProperty(value="partnerAnnualTotal")
    public void setPartnerAnnualTotal(BigDecimal partnerAnnualTotal) {
        this.partnerAnnualTotal = partnerAnnualTotal;
    }

    public ApiAssessmentSectionSummary withPartnerAnnualTotal(BigDecimal partnerAnnualTotal) {
        this.partnerAnnualTotal = partnerAnnualTotal;
        return this;
    }

    @JsonProperty(value="annualTotal")
    public BigDecimal getAnnualTotal() {
        return this.annualTotal;
    }

    @JsonProperty(value="annualTotal")
    public void setAnnualTotal(BigDecimal annualTotal) {
        this.annualTotal = annualTotal;
    }

    public ApiAssessmentSectionSummary withAnnualTotal(BigDecimal annualTotal) {
        this.annualTotal = annualTotal;
        return this;
    }

    @JsonProperty(value="assessmentType")
    public AssessmentType getAssessmentType() {
        return this.assessmentType;
    }

    @JsonProperty(value="assessmentType")
    public void setAssessmentType(AssessmentType assessmentType) {
        this.assessmentType = assessmentType;
    }

    public ApiAssessmentSectionSummary withAssessmentType(AssessmentType assessmentType) {
        this.assessmentType = assessmentType;
        return this;
    }

    @JsonProperty(value="assessmentDetails")
    public List<ApiAssessmentDetail> getAssessmentDetails() {
        return this.assessmentDetails;
    }

    @JsonProperty(value="assessmentDetails")
    public void setAssessmentDetails(List<ApiAssessmentDetail> assessmentDetails) {
        this.assessmentDetails = assessmentDetails;
    }

    public ApiAssessmentSectionSummary withAssessmentDetails(List<ApiAssessmentDetail> assessmentDetails) {
        this.assessmentDetails = assessmentDetails;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("section".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"section\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setSection((String)value);
            return true;
        }
        if ("applicantAnnualTotal".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"applicantAnnualTotal\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setApplicantAnnualTotal((BigDecimal)value);
            return true;
        }
        if ("partnerAnnualTotal".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"partnerAnnualTotal\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setPartnerAnnualTotal((BigDecimal)value);
            return true;
        }
        if ("annualTotal".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"annualTotal\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setAnnualTotal((BigDecimal)value);
            return true;
        }
        if ("assessmentType".equals(name)) {
            if (!(value instanceof AssessmentType)) {
                throw new IllegalArgumentException("property \"assessmentType\" is of type \"uk.gov.justice.laa.crime.enums.AssessmentType\", but got " + value.getClass().toString());
            }
            this.setAssessmentType((AssessmentType)value);
            return true;
        }
        if ("assessmentDetails".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"assessmentDetails\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentDetail>\", but got " + value.getClass().toString());
            }
            this.setAssessmentDetails((List)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("section".equals(name)) {
            return this.getSection();
        }
        if ("applicantAnnualTotal".equals(name)) {
            return this.getApplicantAnnualTotal();
        }
        if ("partnerAnnualTotal".equals(name)) {
            return this.getPartnerAnnualTotal();
        }
        if ("annualTotal".equals(name)) {
            return this.getAnnualTotal();
        }
        if ("assessmentType".equals(name)) {
            return this.getAssessmentType();
        }
        if ("assessmentDetails".equals(name)) {
            return this.getAssessmentDetails();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiAssessmentSectionSummary with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiAssessmentSectionSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("section");
        sb.append('=');
        sb.append(this.section == null ? "<null>" : this.section);
        sb.append(',');
        sb.append("applicantAnnualTotal");
        sb.append('=');
        sb.append(this.applicantAnnualTotal == null ? "<null>" : this.applicantAnnualTotal);
        sb.append(',');
        sb.append("partnerAnnualTotal");
        sb.append('=');
        sb.append(this.partnerAnnualTotal == null ? "<null>" : this.partnerAnnualTotal);
        sb.append(',');
        sb.append("annualTotal");
        sb.append('=');
        sb.append(this.annualTotal == null ? "<null>" : this.annualTotal);
        sb.append(',');
        sb.append("assessmentType");
        sb.append('=');
        sb.append((Object)(this.assessmentType == null ? "<null>" : this.assessmentType));
        sb.append(',');
        sb.append("assessmentDetails");
        sb.append('=');
        sb.append(this.assessmentDetails == null ? "<null>" : this.assessmentDetails);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.assessmentType == null ? 0 : this.assessmentType.hashCode());
        result = result * 31 + (this.annualTotal == null ? 0 : this.annualTotal.hashCode());
        result = result * 31 + (this.assessmentDetails == null ? 0 : this.assessmentDetails.hashCode());
        result = result * 31 + (this.section == null ? 0 : this.section.hashCode());
        result = result * 31 + (this.applicantAnnualTotal == null ? 0 : this.applicantAnnualTotal.hashCode());
        result = result * 31 + (this.partnerAnnualTotal == null ? 0 : this.partnerAnnualTotal.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiAssessmentSectionSummary)) {
            return false;
        }
        ApiAssessmentSectionSummary rhs = (ApiAssessmentSectionSummary)other;
        return (this.assessmentType == rhs.assessmentType || this.assessmentType != null && this.assessmentType.equals((Object)rhs.assessmentType)) && (this.annualTotal == rhs.annualTotal || this.annualTotal != null && this.annualTotal.equals(rhs.annualTotal)) && (this.assessmentDetails == rhs.assessmentDetails || this.assessmentDetails != null && this.assessmentDetails.equals(rhs.assessmentDetails)) && (this.section == rhs.section || this.section != null && this.section.equals(rhs.section)) && (this.applicantAnnualTotal == rhs.applicantAnnualTotal || this.applicantAnnualTotal != null && this.applicantAnnualTotal.equals(rhs.applicantAnnualTotal)) && (this.partnerAnnualTotal == rhs.partnerAnnualTotal || this.partnerAnnualTotal != null && this.partnerAnnualTotal.equals(rhs.partnerAnnualTotal));
    }
}

