/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import uk.gov.justice.laa.crime.enums.WorkType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "assessmentDate", "type", "reviewType", "status", "result"})
public class ApiAssessmentSummary {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Assessment ID")
    @NotNull
    private Integer id;
    @JsonProperty(value="assessmentDate")
    @JsonPropertyDescription(value="Assessment date")
    @NotNull
    private LocalDateTime assessmentDate;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Assessment type (work_type)")
    @NotNull
    private WorkType type;
    @JsonProperty(value="reviewType")
    @JsonPropertyDescription(value="Review type code")
    private String reviewType;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="Assessment status")
    @NotNull
    private String status;
    @JsonProperty(value="result")
    @JsonPropertyDescription(value="Outcome of an Assessment")
    @NotNull
    private String result;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiAssessmentSummary() {
    }

    public ApiAssessmentSummary(Integer id, LocalDateTime assessmentDate, WorkType type, String reviewType, String status, String result) {
        this.id = id;
        this.assessmentDate = assessmentDate;
        this.type = type;
        this.reviewType = reviewType;
        this.status = status;
        this.result = result;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public ApiAssessmentSummary withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="assessmentDate")
    public LocalDateTime getAssessmentDate() {
        return this.assessmentDate;
    }

    @JsonProperty(value="assessmentDate")
    public void setAssessmentDate(LocalDateTime assessmentDate) {
        this.assessmentDate = assessmentDate;
    }

    public ApiAssessmentSummary withAssessmentDate(LocalDateTime assessmentDate) {
        this.assessmentDate = assessmentDate;
        return this;
    }

    @JsonProperty(value="type")
    public WorkType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(WorkType type) {
        this.type = type;
    }

    public ApiAssessmentSummary withType(WorkType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="reviewType")
    public String getReviewType() {
        return this.reviewType;
    }

    @JsonProperty(value="reviewType")
    public void setReviewType(String reviewType) {
        this.reviewType = reviewType;
    }

    public ApiAssessmentSummary withReviewType(String reviewType) {
        this.reviewType = reviewType;
        return this;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    public ApiAssessmentSummary withStatus(String status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="result")
    public String getResult() {
        return this.result;
    }

    @JsonProperty(value="result")
    public void setResult(String result) {
        this.result = result;
    }

    public ApiAssessmentSummary withResult(String result) {
        this.result = result;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("id".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"id\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setId((Integer)value);
            return true;
        }
        if ("assessmentDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"assessmentDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setAssessmentDate((LocalDateTime)value);
            return true;
        }
        if ("type".equals(name)) {
            if (!(value instanceof WorkType)) {
                throw new IllegalArgumentException("property \"type\" is of type \"uk.gov.justice.laa.crime.enums.WorkType\", but got " + value.getClass().toString());
            }
            this.setType((WorkType)value);
            return true;
        }
        if ("reviewType".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"reviewType\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setReviewType((String)value);
            return true;
        }
        if ("status".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"status\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setStatus((String)value);
            return true;
        }
        if ("result".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"result\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setResult((String)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("assessmentDate".equals(name)) {
            return this.getAssessmentDate();
        }
        if ("type".equals(name)) {
            return this.getType();
        }
        if ("reviewType".equals(name)) {
            return this.getReviewType();
        }
        if ("status".equals(name)) {
            return this.getStatus();
        }
        if ("result".equals(name)) {
            return this.getResult();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiAssessmentSummary with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiAssessmentSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("assessmentDate");
        sb.append('=');
        sb.append(this.assessmentDate == null ? "<null>" : this.assessmentDate);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append((Object)(this.type == null ? "<null>" : this.type));
        sb.append(',');
        sb.append("reviewType");
        sb.append('=');
        sb.append(this.reviewType == null ? "<null>" : this.reviewType);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("result");
        sb.append('=');
        sb.append(this.result == null ? "<null>" : this.result);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.result == null ? 0 : this.result.hashCode());
        result = result * 31 + (this.assessmentDate == null ? 0 : this.assessmentDate.hashCode());
        result = result * 31 + (this.reviewType == null ? 0 : this.reviewType.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiAssessmentSummary)) {
            return false;
        }
        ApiAssessmentSummary rhs = (ApiAssessmentSummary)other;
        return (this.result == rhs.result || this.result != null && this.result.equals(rhs.result)) && (this.assessmentDate == rhs.assessmentDate || this.assessmentDate != null && this.assessmentDate.equals(rhs.assessmentDate)) && (this.reviewType == rhs.reviewType || this.reviewType != null && this.reviewType.equals(rhs.reviewType)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.status == rhs.status || this.status != null && this.status.equals(rhs.status));
    }
}

