/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentSectionSummary;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"criteriaId", "assessmentDate", "assessmentNotes", "adjustedLivingAllowance", "otherHousingNote", "totalAggregatedExpense", "totalAnnualDisposableIncome", "threshold", "result", "resultReason", "assessmentStatus", "assessmentSectionSummary"})
public class ApiFullMeansAssessment {
    @JsonProperty(value="criteriaId")
    @JsonPropertyDescription(value="Assessment criteria Id")
    private Integer criteriaId;
    @JsonProperty(value="assessmentDate")
    @JsonPropertyDescription(value="Assessment Date")
    private LocalDateTime assessmentDate;
    @JsonProperty(value="assessmentNotes")
    @JsonPropertyDescription(value="Assessment Notes")
    private String assessmentNotes;
    @JsonProperty(value="adjustedLivingAllowance")
    @JsonPropertyDescription(value="Adjusted living allowance")
    private BigDecimal adjustedLivingAllowance;
    @JsonProperty(value="otherHousingNote")
    @JsonPropertyDescription(value="Other housing notes")
    private String otherHousingNote;
    @JsonProperty(value="totalAggregatedExpense")
    @JsonPropertyDescription(value="Total Aggregated Expense")
    private BigDecimal totalAggregatedExpense;
    @JsonProperty(value="totalAnnualDisposableIncome")
    @JsonPropertyDescription(value="Total Annual Disposable Income")
    private BigDecimal totalAnnualDisposableIncome;
    @JsonProperty(value="threshold")
    @JsonPropertyDescription(value="Assessment Threshold")
    private BigDecimal threshold;
    @JsonProperty(value="result")
    @JsonPropertyDescription(value="Assessment Result")
    private String result;
    @JsonProperty(value="resultReason")
    @JsonPropertyDescription(value="Assessment result reason")
    private String resultReason;
    @JsonProperty(value="assessmentStatus")
    @JsonPropertyDescription(value="Assessment Status Details")
    @Valid
    private ApiAssessmentStatus assessmentStatus;
    @JsonProperty(value="assessmentSectionSummary")
    @JsonPropertyDescription(value="Assessment Section Summary")
    @Valid
    private List<ApiAssessmentSectionSummary> assessmentSectionSummary = new ArrayList<ApiAssessmentSectionSummary>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiFullMeansAssessment() {
    }

    public ApiFullMeansAssessment(Integer criteriaId, LocalDateTime assessmentDate, String assessmentNotes, BigDecimal adjustedLivingAllowance, String otherHousingNote, BigDecimal totalAggregatedExpense, BigDecimal totalAnnualDisposableIncome, BigDecimal threshold, String result, String resultReason, ApiAssessmentStatus assessmentStatus, List<ApiAssessmentSectionSummary> assessmentSectionSummary) {
        this.criteriaId = criteriaId;
        this.assessmentDate = assessmentDate;
        this.assessmentNotes = assessmentNotes;
        this.adjustedLivingAllowance = adjustedLivingAllowance;
        this.otherHousingNote = otherHousingNote;
        this.totalAggregatedExpense = totalAggregatedExpense;
        this.totalAnnualDisposableIncome = totalAnnualDisposableIncome;
        this.threshold = threshold;
        this.result = result;
        this.resultReason = resultReason;
        this.assessmentStatus = assessmentStatus;
        this.assessmentSectionSummary = assessmentSectionSummary;
    }

    @JsonProperty(value="criteriaId")
    public Integer getCriteriaId() {
        return this.criteriaId;
    }

    @JsonProperty(value="criteriaId")
    public void setCriteriaId(Integer criteriaId) {
        this.criteriaId = criteriaId;
    }

    public ApiFullMeansAssessment withCriteriaId(Integer criteriaId) {
        this.criteriaId = criteriaId;
        return this;
    }

    @JsonProperty(value="assessmentDate")
    public LocalDateTime getAssessmentDate() {
        return this.assessmentDate;
    }

    @JsonProperty(value="assessmentDate")
    public void setAssessmentDate(LocalDateTime assessmentDate) {
        this.assessmentDate = assessmentDate;
    }

    public ApiFullMeansAssessment withAssessmentDate(LocalDateTime assessmentDate) {
        this.assessmentDate = assessmentDate;
        return this;
    }

    @JsonProperty(value="assessmentNotes")
    public String getAssessmentNotes() {
        return this.assessmentNotes;
    }

    @JsonProperty(value="assessmentNotes")
    public void setAssessmentNotes(String assessmentNotes) {
        this.assessmentNotes = assessmentNotes;
    }

    public ApiFullMeansAssessment withAssessmentNotes(String assessmentNotes) {
        this.assessmentNotes = assessmentNotes;
        return this;
    }

    @JsonProperty(value="adjustedLivingAllowance")
    public BigDecimal getAdjustedLivingAllowance() {
        return this.adjustedLivingAllowance;
    }

    @JsonProperty(value="adjustedLivingAllowance")
    public void setAdjustedLivingAllowance(BigDecimal adjustedLivingAllowance) {
        this.adjustedLivingAllowance = adjustedLivingAllowance;
    }

    public ApiFullMeansAssessment withAdjustedLivingAllowance(BigDecimal adjustedLivingAllowance) {
        this.adjustedLivingAllowance = adjustedLivingAllowance;
        return this;
    }

    @JsonProperty(value="otherHousingNote")
    public String getOtherHousingNote() {
        return this.otherHousingNote;
    }

    @JsonProperty(value="otherHousingNote")
    public void setOtherHousingNote(String otherHousingNote) {
        this.otherHousingNote = otherHousingNote;
    }

    public ApiFullMeansAssessment withOtherHousingNote(String otherHousingNote) {
        this.otherHousingNote = otherHousingNote;
        return this;
    }

    @JsonProperty(value="totalAggregatedExpense")
    public BigDecimal getTotalAggregatedExpense() {
        return this.totalAggregatedExpense;
    }

    @JsonProperty(value="totalAggregatedExpense")
    public void setTotalAggregatedExpense(BigDecimal totalAggregatedExpense) {
        this.totalAggregatedExpense = totalAggregatedExpense;
    }

    public ApiFullMeansAssessment withTotalAggregatedExpense(BigDecimal totalAggregatedExpense) {
        this.totalAggregatedExpense = totalAggregatedExpense;
        return this;
    }

    @JsonProperty(value="totalAnnualDisposableIncome")
    public BigDecimal getTotalAnnualDisposableIncome() {
        return this.totalAnnualDisposableIncome;
    }

    @JsonProperty(value="totalAnnualDisposableIncome")
    public void setTotalAnnualDisposableIncome(BigDecimal totalAnnualDisposableIncome) {
        this.totalAnnualDisposableIncome = totalAnnualDisposableIncome;
    }

    public ApiFullMeansAssessment withTotalAnnualDisposableIncome(BigDecimal totalAnnualDisposableIncome) {
        this.totalAnnualDisposableIncome = totalAnnualDisposableIncome;
        return this;
    }

    @JsonProperty(value="threshold")
    public BigDecimal getThreshold() {
        return this.threshold;
    }

    @JsonProperty(value="threshold")
    public void setThreshold(BigDecimal threshold) {
        this.threshold = threshold;
    }

    public ApiFullMeansAssessment withThreshold(BigDecimal threshold) {
        this.threshold = threshold;
        return this;
    }

    @JsonProperty(value="result")
    public String getResult() {
        return this.result;
    }

    @JsonProperty(value="result")
    public void setResult(String result) {
        this.result = result;
    }

    public ApiFullMeansAssessment withResult(String result) {
        this.result = result;
        return this;
    }

    @JsonProperty(value="resultReason")
    public String getResultReason() {
        return this.resultReason;
    }

    @JsonProperty(value="resultReason")
    public void setResultReason(String resultReason) {
        this.resultReason = resultReason;
    }

    public ApiFullMeansAssessment withResultReason(String resultReason) {
        this.resultReason = resultReason;
        return this;
    }

    @JsonProperty(value="assessmentStatus")
    public ApiAssessmentStatus getAssessmentStatus() {
        return this.assessmentStatus;
    }

    @JsonProperty(value="assessmentStatus")
    public void setAssessmentStatus(ApiAssessmentStatus assessmentStatus) {
        this.assessmentStatus = assessmentStatus;
    }

    public ApiFullMeansAssessment withAssessmentStatus(ApiAssessmentStatus assessmentStatus) {
        this.assessmentStatus = assessmentStatus;
        return this;
    }

    @JsonProperty(value="assessmentSectionSummary")
    public List<ApiAssessmentSectionSummary> getAssessmentSectionSummary() {
        return this.assessmentSectionSummary;
    }

    @JsonProperty(value="assessmentSectionSummary")
    public void setAssessmentSectionSummary(List<ApiAssessmentSectionSummary> assessmentSectionSummary) {
        this.assessmentSectionSummary = assessmentSectionSummary;
    }

    public ApiFullMeansAssessment withAssessmentSectionSummary(List<ApiAssessmentSectionSummary> assessmentSectionSummary) {
        this.assessmentSectionSummary = assessmentSectionSummary;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("criteriaId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"criteriaId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setCriteriaId((Integer)value);
            return true;
        }
        if ("assessmentDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"assessmentDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setAssessmentDate((LocalDateTime)value);
            return true;
        }
        if ("assessmentNotes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"assessmentNotes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setAssessmentNotes((String)value);
            return true;
        }
        if ("adjustedLivingAllowance".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"adjustedLivingAllowance\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setAdjustedLivingAllowance((BigDecimal)value);
            return true;
        }
        if ("otherHousingNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"otherHousingNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOtherHousingNote((String)value);
            return true;
        }
        if ("totalAggregatedExpense".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"totalAggregatedExpense\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setTotalAggregatedExpense((BigDecimal)value);
            return true;
        }
        if ("totalAnnualDisposableIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"totalAnnualDisposableIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setTotalAnnualDisposableIncome((BigDecimal)value);
            return true;
        }
        if ("threshold".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"threshold\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setThreshold((BigDecimal)value);
            return true;
        }
        if ("result".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"result\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setResult((String)value);
            return true;
        }
        if ("resultReason".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"resultReason\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setResultReason((String)value);
            return true;
        }
        if ("assessmentStatus".equals(name)) {
            if (!(value instanceof ApiAssessmentStatus)) {
                throw new IllegalArgumentException("property \"assessmentStatus\" is of type \"uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentStatus\", but got " + value.getClass().toString());
            }
            this.setAssessmentStatus((ApiAssessmentStatus)value);
            return true;
        }
        if ("assessmentSectionSummary".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"assessmentSectionSummary\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentSectionSummary>\", but got " + value.getClass().toString());
            }
            this.setAssessmentSectionSummary((List)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("criteriaId".equals(name)) {
            return this.getCriteriaId();
        }
        if ("assessmentDate".equals(name)) {
            return this.getAssessmentDate();
        }
        if ("assessmentNotes".equals(name)) {
            return this.getAssessmentNotes();
        }
        if ("adjustedLivingAllowance".equals(name)) {
            return this.getAdjustedLivingAllowance();
        }
        if ("otherHousingNote".equals(name)) {
            return this.getOtherHousingNote();
        }
        if ("totalAggregatedExpense".equals(name)) {
            return this.getTotalAggregatedExpense();
        }
        if ("totalAnnualDisposableIncome".equals(name)) {
            return this.getTotalAnnualDisposableIncome();
        }
        if ("threshold".equals(name)) {
            return this.getThreshold();
        }
        if ("result".equals(name)) {
            return this.getResult();
        }
        if ("resultReason".equals(name)) {
            return this.getResultReason();
        }
        if ("assessmentStatus".equals(name)) {
            return this.getAssessmentStatus();
        }
        if ("assessmentSectionSummary".equals(name)) {
            return this.getAssessmentSectionSummary();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiFullMeansAssessment with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiFullMeansAssessment.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("criteriaId");
        sb.append('=');
        sb.append(this.criteriaId == null ? "<null>" : this.criteriaId);
        sb.append(',');
        sb.append("assessmentDate");
        sb.append('=');
        sb.append(this.assessmentDate == null ? "<null>" : this.assessmentDate);
        sb.append(',');
        sb.append("assessmentNotes");
        sb.append('=');
        sb.append(this.assessmentNotes == null ? "<null>" : this.assessmentNotes);
        sb.append(',');
        sb.append("adjustedLivingAllowance");
        sb.append('=');
        sb.append(this.adjustedLivingAllowance == null ? "<null>" : this.adjustedLivingAllowance);
        sb.append(',');
        sb.append("otherHousingNote");
        sb.append('=');
        sb.append(this.otherHousingNote == null ? "<null>" : this.otherHousingNote);
        sb.append(',');
        sb.append("totalAggregatedExpense");
        sb.append('=');
        sb.append(this.totalAggregatedExpense == null ? "<null>" : this.totalAggregatedExpense);
        sb.append(',');
        sb.append("totalAnnualDisposableIncome");
        sb.append('=');
        sb.append(this.totalAnnualDisposableIncome == null ? "<null>" : this.totalAnnualDisposableIncome);
        sb.append(',');
        sb.append("threshold");
        sb.append('=');
        sb.append(this.threshold == null ? "<null>" : this.threshold);
        sb.append(',');
        sb.append("result");
        sb.append('=');
        sb.append(this.result == null ? "<null>" : this.result);
        sb.append(',');
        sb.append("resultReason");
        sb.append('=');
        sb.append(this.resultReason == null ? "<null>" : this.resultReason);
        sb.append(',');
        sb.append("assessmentStatus");
        sb.append('=');
        sb.append(this.assessmentStatus == null ? "<null>" : this.assessmentStatus);
        sb.append(',');
        sb.append("assessmentSectionSummary");
        sb.append('=');
        sb.append(this.assessmentSectionSummary == null ? "<null>" : this.assessmentSectionSummary);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.otherHousingNote == null ? 0 : this.otherHousingNote.hashCode());
        result = result * 31 + (this.criteriaId == null ? 0 : this.criteriaId.hashCode());
        result = result * 31 + (this.assessmentDate == null ? 0 : this.assessmentDate.hashCode());
        result = result * 31 + (this.adjustedLivingAllowance == null ? 0 : this.adjustedLivingAllowance.hashCode());
        result = result * 31 + (this.threshold == null ? 0 : this.threshold.hashCode());
        result = result * 31 + (this.assessmentStatus == null ? 0 : this.assessmentStatus.hashCode());
        result = result * 31 + (this.totalAnnualDisposableIncome == null ? 0 : this.totalAnnualDisposableIncome.hashCode());
        result = result * 31 + (this.result == null ? 0 : this.result.hashCode());
        result = result * 31 + (this.assessmentNotes == null ? 0 : this.assessmentNotes.hashCode());
        result = result * 31 + (this.resultReason == null ? 0 : this.resultReason.hashCode());
        result = result * 31 + (this.totalAggregatedExpense == null ? 0 : this.totalAggregatedExpense.hashCode());
        result = result * 31 + (this.assessmentSectionSummary == null ? 0 : this.assessmentSectionSummary.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiFullMeansAssessment)) {
            return false;
        }
        ApiFullMeansAssessment rhs = (ApiFullMeansAssessment)other;
        return (this.otherHousingNote == rhs.otherHousingNote || this.otherHousingNote != null && this.otherHousingNote.equals(rhs.otherHousingNote)) && (this.criteriaId == rhs.criteriaId || this.criteriaId != null && this.criteriaId.equals(rhs.criteriaId)) && (this.assessmentDate == rhs.assessmentDate || this.assessmentDate != null && this.assessmentDate.equals(rhs.assessmentDate)) && (this.adjustedLivingAllowance == rhs.adjustedLivingAllowance || this.adjustedLivingAllowance != null && this.adjustedLivingAllowance.equals(rhs.adjustedLivingAllowance)) && (this.threshold == rhs.threshold || this.threshold != null && this.threshold.equals(rhs.threshold)) && (this.assessmentStatus == rhs.assessmentStatus || this.assessmentStatus != null && this.assessmentStatus.equals(rhs.assessmentStatus)) && (this.totalAnnualDisposableIncome == rhs.totalAnnualDisposableIncome || this.totalAnnualDisposableIncome != null && this.totalAnnualDisposableIncome.equals(rhs.totalAnnualDisposableIncome)) && (this.result == rhs.result || this.result != null && this.result.equals(rhs.result)) && (this.assessmentNotes == rhs.assessmentNotes || this.assessmentNotes != null && this.assessmentNotes.equals(rhs.assessmentNotes)) && (this.resultReason == rhs.resultReason || this.resultReason != null && this.resultReason.equals(rhs.resultReason)) && (this.totalAggregatedExpense == rhs.totalAggregatedExpense || this.totalAggregatedExpense != null && this.totalAggregatedExpense.equals(rhs.totalAggregatedExpense)) && (this.assessmentSectionSummary == rhs.assessmentSectionSummary || this.assessmentSectionSummary != null && this.assessmentSectionSummary.equals(rhs.assessmentSectionSummary));
    }
}

