/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiEvidenceType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "dateReceived", "dateModified", "active", "apiEvidenceType", "mandatory", "applicantId", "otherText", "adhoc"})
public class ApiIncomeEvidence {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="The ID of the income evidence item associated with the financial assessment")
    private Integer id;
    @JsonProperty(value="dateReceived")
    @JsonPropertyDescription(value="The date the evidence was received")
    private LocalDateTime dateReceived;
    @JsonProperty(value="dateModified")
    @JsonPropertyDescription(value="Evidence modified Date")
    private LocalDateTime dateModified;
    @JsonProperty(value="active")
    @JsonPropertyDescription(value="Is the evidence active")
    private String active;
    @JsonProperty(value="apiEvidenceType")
    @JsonPropertyDescription(value="Evidence type.")
    @Valid
    private ApiEvidenceType apiEvidenceType;
    @JsonProperty(value="mandatory")
    @JsonPropertyDescription(value="Indicates whether the evidence is mandatory")
    private String mandatory;
    @JsonProperty(value="applicantId")
    @JsonPropertyDescription(value="The ID of the person associated with the income evidence (applicant or partner)")
    private Integer applicantId;
    @JsonProperty(value="otherText")
    @JsonPropertyDescription(value="The evidence description (required for certain evidence types)")
    private String otherText;
    @JsonProperty(value="adhoc")
    @JsonPropertyDescription(value="Indicates who the other adhoc evidence is associated with (applicant or partner)")
    private String adhoc;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiIncomeEvidence() {
    }

    public ApiIncomeEvidence(Integer id, LocalDateTime dateReceived, LocalDateTime dateModified, String active, ApiEvidenceType apiEvidenceType, String mandatory, Integer applicantId, String otherText, String adhoc) {
        this.id = id;
        this.dateReceived = dateReceived;
        this.dateModified = dateModified;
        this.active = active;
        this.apiEvidenceType = apiEvidenceType;
        this.mandatory = mandatory;
        this.applicantId = applicantId;
        this.otherText = otherText;
        this.adhoc = adhoc;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public ApiIncomeEvidence withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="dateReceived")
    public LocalDateTime getDateReceived() {
        return this.dateReceived;
    }

    @JsonProperty(value="dateReceived")
    public void setDateReceived(LocalDateTime dateReceived) {
        this.dateReceived = dateReceived;
    }

    public ApiIncomeEvidence withDateReceived(LocalDateTime dateReceived) {
        this.dateReceived = dateReceived;
        return this;
    }

    @JsonProperty(value="dateModified")
    public LocalDateTime getDateModified() {
        return this.dateModified;
    }

    @JsonProperty(value="dateModified")
    public void setDateModified(LocalDateTime dateModified) {
        this.dateModified = dateModified;
    }

    public ApiIncomeEvidence withDateModified(LocalDateTime dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @JsonProperty(value="active")
    public String getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    public void setActive(String active) {
        this.active = active;
    }

    public ApiIncomeEvidence withActive(String active) {
        this.active = active;
        return this;
    }

    @JsonProperty(value="apiEvidenceType")
    public ApiEvidenceType getApiEvidenceType() {
        return this.apiEvidenceType;
    }

    @JsonProperty(value="apiEvidenceType")
    public void setApiEvidenceType(ApiEvidenceType apiEvidenceType) {
        this.apiEvidenceType = apiEvidenceType;
    }

    public ApiIncomeEvidence withApiEvidenceType(ApiEvidenceType apiEvidenceType) {
        this.apiEvidenceType = apiEvidenceType;
        return this;
    }

    @JsonProperty(value="mandatory")
    public String getMandatory() {
        return this.mandatory;
    }

    @JsonProperty(value="mandatory")
    public void setMandatory(String mandatory) {
        this.mandatory = mandatory;
    }

    public ApiIncomeEvidence withMandatory(String mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    @JsonProperty(value="applicantId")
    public Integer getApplicantId() {
        return this.applicantId;
    }

    @JsonProperty(value="applicantId")
    public void setApplicantId(Integer applicantId) {
        this.applicantId = applicantId;
    }

    public ApiIncomeEvidence withApplicantId(Integer applicantId) {
        this.applicantId = applicantId;
        return this;
    }

    @JsonProperty(value="otherText")
    public String getOtherText() {
        return this.otherText;
    }

    @JsonProperty(value="otherText")
    public void setOtherText(String otherText) {
        this.otherText = otherText;
    }

    public ApiIncomeEvidence withOtherText(String otherText) {
        this.otherText = otherText;
        return this;
    }

    @JsonProperty(value="adhoc")
    public String getAdhoc() {
        return this.adhoc;
    }

    @JsonProperty(value="adhoc")
    public void setAdhoc(String adhoc) {
        this.adhoc = adhoc;
    }

    public ApiIncomeEvidence withAdhoc(String adhoc) {
        this.adhoc = adhoc;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("id".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"id\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setId((Integer)value);
            return true;
        }
        if ("dateReceived".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"dateReceived\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setDateReceived((LocalDateTime)value);
            return true;
        }
        if ("dateModified".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"dateModified\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setDateModified((LocalDateTime)value);
            return true;
        }
        if ("active".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"active\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setActive((String)value);
            return true;
        }
        if ("apiEvidenceType".equals(name)) {
            if (!(value instanceof ApiEvidenceType)) {
                throw new IllegalArgumentException("property \"apiEvidenceType\" is of type \"uk.gov.justice.laa.crime.common.model.meansassessment.ApiEvidenceType\", but got " + value.getClass().toString());
            }
            this.setApiEvidenceType((ApiEvidenceType)value);
            return true;
        }
        if ("mandatory".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"mandatory\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setMandatory((String)value);
            return true;
        }
        if ("applicantId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"applicantId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setApplicantId((Integer)value);
            return true;
        }
        if ("otherText".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"otherText\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOtherText((String)value);
            return true;
        }
        if ("adhoc".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"adhoc\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setAdhoc((String)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("dateReceived".equals(name)) {
            return this.getDateReceived();
        }
        if ("dateModified".equals(name)) {
            return this.getDateModified();
        }
        if ("active".equals(name)) {
            return this.getActive();
        }
        if ("apiEvidenceType".equals(name)) {
            return this.getApiEvidenceType();
        }
        if ("mandatory".equals(name)) {
            return this.getMandatory();
        }
        if ("applicantId".equals(name)) {
            return this.getApplicantId();
        }
        if ("otherText".equals(name)) {
            return this.getOtherText();
        }
        if ("adhoc".equals(name)) {
            return this.getAdhoc();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiIncomeEvidence with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiIncomeEvidence.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("dateReceived");
        sb.append('=');
        sb.append(this.dateReceived == null ? "<null>" : this.dateReceived);
        sb.append(',');
        sb.append("dateModified");
        sb.append('=');
        sb.append(this.dateModified == null ? "<null>" : this.dateModified);
        sb.append(',');
        sb.append("active");
        sb.append('=');
        sb.append(this.active == null ? "<null>" : this.active);
        sb.append(',');
        sb.append("apiEvidenceType");
        sb.append('=');
        sb.append(this.apiEvidenceType == null ? "<null>" : this.apiEvidenceType);
        sb.append(',');
        sb.append("mandatory");
        sb.append('=');
        sb.append(this.mandatory == null ? "<null>" : this.mandatory);
        sb.append(',');
        sb.append("applicantId");
        sb.append('=');
        sb.append(this.applicantId == null ? "<null>" : this.applicantId);
        sb.append(',');
        sb.append("otherText");
        sb.append('=');
        sb.append(this.otherText == null ? "<null>" : this.otherText);
        sb.append(',');
        sb.append("adhoc");
        sb.append('=');
        sb.append(this.adhoc == null ? "<null>" : this.adhoc);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.apiEvidenceType == null ? 0 : this.apiEvidenceType.hashCode());
        result = result * 31 + (this.dateReceived == null ? 0 : this.dateReceived.hashCode());
        result = result * 31 + (this.active == null ? 0 : this.active.hashCode());
        result = result * 31 + (this.otherText == null ? 0 : this.otherText.hashCode());
        result = result * 31 + (this.dateModified == null ? 0 : this.dateModified.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.applicantId == null ? 0 : this.applicantId.hashCode());
        result = result * 31 + (this.adhoc == null ? 0 : this.adhoc.hashCode());
        result = result * 31 + (this.mandatory == null ? 0 : this.mandatory.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiIncomeEvidence)) {
            return false;
        }
        ApiIncomeEvidence rhs = (ApiIncomeEvidence)other;
        return (this.apiEvidenceType == rhs.apiEvidenceType || this.apiEvidenceType != null && this.apiEvidenceType.equals(rhs.apiEvidenceType)) && (this.dateReceived == rhs.dateReceived || this.dateReceived != null && this.dateReceived.equals(rhs.dateReceived)) && (this.active == rhs.active || this.active != null && this.active.equals(rhs.active)) && (this.otherText == rhs.otherText || this.otherText != null && this.otherText.equals(rhs.otherText)) && (this.dateModified == rhs.dateModified || this.dateModified != null && this.dateModified.equals(rhs.dateModified)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.applicantId == rhs.applicantId || this.applicantId != null && this.applicantId.equals(rhs.applicantId)) && (this.adhoc == rhs.adhoc || this.adhoc != null && this.adhoc.equals(rhs.adhoc)) && (this.mandatory == rhs.mandatory || this.mandatory != null && this.mandatory.equals(rhs.mandatory));
    }
}

