/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiIncomeEvidence;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"evidenceDueDate", "evidenceReceivedDate", "upliftAppliedDate", "upliftRemovedDate", "firstReminderDate", "secondReminderDate", "incomeEvidenceNotes", "incomeEvidence"})
public class ApiIncomeEvidenceSummary {
    @JsonProperty(value="evidenceDueDate")
    @JsonPropertyDescription(value="Evidence Due Date")
    private LocalDateTime evidenceDueDate;
    @JsonProperty(value="evidenceReceivedDate")
    @JsonPropertyDescription(value="Evidence received Date")
    private LocalDateTime evidenceReceivedDate;
    @JsonProperty(value="upliftAppliedDate")
    @JsonPropertyDescription(value="Uplift Applied Date")
    private LocalDateTime upliftAppliedDate;
    @JsonProperty(value="upliftRemovedDate")
    @JsonPropertyDescription(value="Uplift Removed Date")
    private LocalDateTime upliftRemovedDate;
    @JsonProperty(value="firstReminderDate")
    @JsonPropertyDescription(value="first reminder Date")
    private LocalDateTime firstReminderDate;
    @JsonProperty(value="secondReminderDate")
    @JsonPropertyDescription(value="second reminder Date")
    private LocalDateTime secondReminderDate;
    @JsonProperty(value="incomeEvidenceNotes")
    @JsonPropertyDescription(value="Income Evidence Notes")
    private String incomeEvidenceNotes;
    @JsonProperty(value="incomeEvidence")
    @Size(min=0)
    @Valid
    private @Size(min=0) @Valid List<ApiIncomeEvidence> incomeEvidence = new ArrayList<ApiIncomeEvidence>();
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiIncomeEvidenceSummary() {
    }

    public ApiIncomeEvidenceSummary(LocalDateTime evidenceDueDate, LocalDateTime evidenceReceivedDate, LocalDateTime upliftAppliedDate, LocalDateTime upliftRemovedDate, LocalDateTime firstReminderDate, LocalDateTime secondReminderDate, String incomeEvidenceNotes, List<ApiIncomeEvidence> incomeEvidence) {
        this.evidenceDueDate = evidenceDueDate;
        this.evidenceReceivedDate = evidenceReceivedDate;
        this.upliftAppliedDate = upliftAppliedDate;
        this.upliftRemovedDate = upliftRemovedDate;
        this.firstReminderDate = firstReminderDate;
        this.secondReminderDate = secondReminderDate;
        this.incomeEvidenceNotes = incomeEvidenceNotes;
        this.incomeEvidence = incomeEvidence;
    }

    @JsonProperty(value="evidenceDueDate")
    public LocalDateTime getEvidenceDueDate() {
        return this.evidenceDueDate;
    }

    @JsonProperty(value="evidenceDueDate")
    public void setEvidenceDueDate(LocalDateTime evidenceDueDate) {
        this.evidenceDueDate = evidenceDueDate;
    }

    public ApiIncomeEvidenceSummary withEvidenceDueDate(LocalDateTime evidenceDueDate) {
        this.evidenceDueDate = evidenceDueDate;
        return this;
    }

    @JsonProperty(value="evidenceReceivedDate")
    public LocalDateTime getEvidenceReceivedDate() {
        return this.evidenceReceivedDate;
    }

    @JsonProperty(value="evidenceReceivedDate")
    public void setEvidenceReceivedDate(LocalDateTime evidenceReceivedDate) {
        this.evidenceReceivedDate = evidenceReceivedDate;
    }

    public ApiIncomeEvidenceSummary withEvidenceReceivedDate(LocalDateTime evidenceReceivedDate) {
        this.evidenceReceivedDate = evidenceReceivedDate;
        return this;
    }

    @JsonProperty(value="upliftAppliedDate")
    public LocalDateTime getUpliftAppliedDate() {
        return this.upliftAppliedDate;
    }

    @JsonProperty(value="upliftAppliedDate")
    public void setUpliftAppliedDate(LocalDateTime upliftAppliedDate) {
        this.upliftAppliedDate = upliftAppliedDate;
    }

    public ApiIncomeEvidenceSummary withUpliftAppliedDate(LocalDateTime upliftAppliedDate) {
        this.upliftAppliedDate = upliftAppliedDate;
        return this;
    }

    @JsonProperty(value="upliftRemovedDate")
    public LocalDateTime getUpliftRemovedDate() {
        return this.upliftRemovedDate;
    }

    @JsonProperty(value="upliftRemovedDate")
    public void setUpliftRemovedDate(LocalDateTime upliftRemovedDate) {
        this.upliftRemovedDate = upliftRemovedDate;
    }

    public ApiIncomeEvidenceSummary withUpliftRemovedDate(LocalDateTime upliftRemovedDate) {
        this.upliftRemovedDate = upliftRemovedDate;
        return this;
    }

    @JsonProperty(value="firstReminderDate")
    public LocalDateTime getFirstReminderDate() {
        return this.firstReminderDate;
    }

    @JsonProperty(value="firstReminderDate")
    public void setFirstReminderDate(LocalDateTime firstReminderDate) {
        this.firstReminderDate = firstReminderDate;
    }

    public ApiIncomeEvidenceSummary withFirstReminderDate(LocalDateTime firstReminderDate) {
        this.firstReminderDate = firstReminderDate;
        return this;
    }

    @JsonProperty(value="secondReminderDate")
    public LocalDateTime getSecondReminderDate() {
        return this.secondReminderDate;
    }

    @JsonProperty(value="secondReminderDate")
    public void setSecondReminderDate(LocalDateTime secondReminderDate) {
        this.secondReminderDate = secondReminderDate;
    }

    public ApiIncomeEvidenceSummary withSecondReminderDate(LocalDateTime secondReminderDate) {
        this.secondReminderDate = secondReminderDate;
        return this;
    }

    @JsonProperty(value="incomeEvidenceNotes")
    public String getIncomeEvidenceNotes() {
        return this.incomeEvidenceNotes;
    }

    @JsonProperty(value="incomeEvidenceNotes")
    public void setIncomeEvidenceNotes(String incomeEvidenceNotes) {
        this.incomeEvidenceNotes = incomeEvidenceNotes;
    }

    public ApiIncomeEvidenceSummary withIncomeEvidenceNotes(String incomeEvidenceNotes) {
        this.incomeEvidenceNotes = incomeEvidenceNotes;
        return this;
    }

    @JsonProperty(value="incomeEvidence")
    public List<ApiIncomeEvidence> getIncomeEvidence() {
        return this.incomeEvidence;
    }

    @JsonProperty(value="incomeEvidence")
    public void setIncomeEvidence(List<ApiIncomeEvidence> incomeEvidence) {
        this.incomeEvidence = incomeEvidence;
    }

    public ApiIncomeEvidenceSummary withIncomeEvidence(List<ApiIncomeEvidence> incomeEvidence) {
        this.incomeEvidence = incomeEvidence;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ApiIncomeEvidenceSummary withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("evidenceDueDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"evidenceDueDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setEvidenceDueDate((LocalDateTime)value);
            return true;
        }
        if ("evidenceReceivedDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"evidenceReceivedDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setEvidenceReceivedDate((LocalDateTime)value);
            return true;
        }
        if ("upliftAppliedDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"upliftAppliedDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setUpliftAppliedDate((LocalDateTime)value);
            return true;
        }
        if ("upliftRemovedDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"upliftRemovedDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setUpliftRemovedDate((LocalDateTime)value);
            return true;
        }
        if ("firstReminderDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"firstReminderDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setFirstReminderDate((LocalDateTime)value);
            return true;
        }
        if ("secondReminderDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"secondReminderDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setSecondReminderDate((LocalDateTime)value);
            return true;
        }
        if ("incomeEvidenceNotes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"incomeEvidenceNotes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidenceNotes((String)value);
            return true;
        }
        if ("incomeEvidence".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"incomeEvidence\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiIncomeEvidence>\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidence((List)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("evidenceDueDate".equals(name)) {
            return this.getEvidenceDueDate();
        }
        if ("evidenceReceivedDate".equals(name)) {
            return this.getEvidenceReceivedDate();
        }
        if ("upliftAppliedDate".equals(name)) {
            return this.getUpliftAppliedDate();
        }
        if ("upliftRemovedDate".equals(name)) {
            return this.getUpliftRemovedDate();
        }
        if ("firstReminderDate".equals(name)) {
            return this.getFirstReminderDate();
        }
        if ("secondReminderDate".equals(name)) {
            return this.getSecondReminderDate();
        }
        if ("incomeEvidenceNotes".equals(name)) {
            return this.getIncomeEvidenceNotes();
        }
        if ("incomeEvidence".equals(name)) {
            return this.getIncomeEvidence();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public ApiIncomeEvidenceSummary with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiIncomeEvidenceSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("evidenceDueDate");
        sb.append('=');
        sb.append(this.evidenceDueDate == null ? "<null>" : this.evidenceDueDate);
        sb.append(',');
        sb.append("evidenceReceivedDate");
        sb.append('=');
        sb.append(this.evidenceReceivedDate == null ? "<null>" : this.evidenceReceivedDate);
        sb.append(',');
        sb.append("upliftAppliedDate");
        sb.append('=');
        sb.append(this.upliftAppliedDate == null ? "<null>" : this.upliftAppliedDate);
        sb.append(',');
        sb.append("upliftRemovedDate");
        sb.append('=');
        sb.append(this.upliftRemovedDate == null ? "<null>" : this.upliftRemovedDate);
        sb.append(',');
        sb.append("firstReminderDate");
        sb.append('=');
        sb.append(this.firstReminderDate == null ? "<null>" : this.firstReminderDate);
        sb.append(',');
        sb.append("secondReminderDate");
        sb.append('=');
        sb.append(this.secondReminderDate == null ? "<null>" : this.secondReminderDate);
        sb.append(',');
        sb.append("incomeEvidenceNotes");
        sb.append('=');
        sb.append(this.incomeEvidenceNotes == null ? "<null>" : this.incomeEvidenceNotes);
        sb.append(',');
        sb.append("incomeEvidence");
        sb.append('=');
        sb.append(this.incomeEvidence == null ? "<null>" : this.incomeEvidence);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.incomeEvidenceNotes == null ? 0 : this.incomeEvidenceNotes.hashCode());
        result = result * 31 + (this.firstReminderDate == null ? 0 : this.firstReminderDate.hashCode());
        result = result * 31 + (this.upliftRemovedDate == null ? 0 : this.upliftRemovedDate.hashCode());
        result = result * 31 + (this.incomeEvidence == null ? 0 : this.incomeEvidence.hashCode());
        result = result * 31 + (this.evidenceDueDate == null ? 0 : this.evidenceDueDate.hashCode());
        result = result * 31 + (this.secondReminderDate == null ? 0 : this.secondReminderDate.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.evidenceReceivedDate == null ? 0 : this.evidenceReceivedDate.hashCode());
        result = result * 31 + (this.upliftAppliedDate == null ? 0 : this.upliftAppliedDate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiIncomeEvidenceSummary)) {
            return false;
        }
        ApiIncomeEvidenceSummary rhs = (ApiIncomeEvidenceSummary)other;
        return (this.incomeEvidenceNotes == rhs.incomeEvidenceNotes || this.incomeEvidenceNotes != null && this.incomeEvidenceNotes.equals(rhs.incomeEvidenceNotes)) && (this.firstReminderDate == rhs.firstReminderDate || this.firstReminderDate != null && this.firstReminderDate.equals(rhs.firstReminderDate)) && (this.upliftRemovedDate == rhs.upliftRemovedDate || this.upliftRemovedDate != null && this.upliftRemovedDate.equals(rhs.upliftRemovedDate)) && (this.incomeEvidence == rhs.incomeEvidence || this.incomeEvidence != null && this.incomeEvidence.equals(rhs.incomeEvidence)) && (this.evidenceDueDate == rhs.evidenceDueDate || this.evidenceDueDate != null && this.evidenceDueDate.equals(rhs.evidenceDueDate)) && (this.secondReminderDate == rhs.secondReminderDate || this.secondReminderDate != null && this.secondReminderDate.equals(rhs.secondReminderDate)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.evidenceReceivedDate == rhs.evidenceReceivedDate || this.evidenceReceivedDate != null && this.evidenceReceivedDate.equals(rhs.evidenceReceivedDate)) && (this.upliftAppliedDate == rhs.upliftAppliedDate || this.upliftAppliedDate != null && this.upliftAppliedDate.equals(rhs.upliftAppliedDate));
    }
}

