/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentChildWeighting;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentSectionSummary;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentStatus;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiNewWorkReason;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiReviewType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "assessmentDate", "otherBenefitNote", "otherIncomeNote", "totalAggregatedIncome", "adjustedIncomeValue", "notes", "lowerThreshold", "upperThreshold", "result", "resultReason", "assessmentStatus", "newWorkReason", "reviewType", "assessmentSectionSummary", "childWeighting"})
public class ApiInitialMeansAssessment {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Initial Assessment Id")
    private Integer id;
    @JsonProperty(value="assessmentDate")
    @JsonPropertyDescription(value="Assessment Date")
    private LocalDateTime assessmentDate;
    @JsonProperty(value="otherBenefitNote")
    @JsonPropertyDescription(value="Other Benefit Note")
    private String otherBenefitNote;
    @JsonProperty(value="otherIncomeNote")
    @JsonPropertyDescription(value="Other income note")
    private String otherIncomeNote;
    @JsonProperty(value="totalAggregatedIncome")
    @JsonPropertyDescription(value="total aggregated income")
    private BigDecimal totalAggregatedIncome;
    @JsonProperty(value="adjustedIncomeValue")
    @JsonPropertyDescription(value="Adjusted income value")
    private BigDecimal adjustedIncomeValue;
    @JsonProperty(value="notes")
    @JsonPropertyDescription(value="Notes")
    private String notes;
    @JsonProperty(value="lowerThreshold")
    @JsonPropertyDescription(value="Lower Threshold")
    private BigDecimal lowerThreshold;
    @JsonProperty(value="upperThreshold")
    @JsonPropertyDescription(value="Upper Threshold")
    private BigDecimal upperThreshold;
    @JsonProperty(value="result")
    @JsonPropertyDescription(value="Result")
    private String result;
    @JsonProperty(value="resultReason")
    @JsonPropertyDescription(value="Result reason")
    private String resultReason;
    @JsonProperty(value="assessmentStatus")
    @JsonPropertyDescription(value="Assessment Status Details")
    @Valid
    private ApiAssessmentStatus assessmentStatus;
    @JsonProperty(value="newWorkReason")
    @JsonPropertyDescription(value="An explanation about the purpose of this instance.")
    @Valid
    private ApiNewWorkReason newWorkReason;
    @JsonProperty(value="reviewType")
    @JsonPropertyDescription(value="An explanation about the purpose of this instance.")
    @Valid
    private ApiReviewType reviewType;
    @JsonProperty(value="assessmentSectionSummary")
    @JsonPropertyDescription(value="Assessment Section Summary")
    @Valid
    private List<ApiAssessmentSectionSummary> assessmentSectionSummary = new ArrayList<ApiAssessmentSectionSummary>();
    @JsonProperty(value="childWeighting")
    @JsonPropertyDescription(value="Child weighting")
    @Valid
    private List<ApiAssessmentChildWeighting> childWeighting = new ArrayList<ApiAssessmentChildWeighting>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiInitialMeansAssessment() {
    }

    public ApiInitialMeansAssessment(Integer id, LocalDateTime assessmentDate, String otherBenefitNote, String otherIncomeNote, BigDecimal totalAggregatedIncome, BigDecimal adjustedIncomeValue, String notes, BigDecimal lowerThreshold, BigDecimal upperThreshold, String result, String resultReason, ApiAssessmentStatus assessmentStatus, ApiNewWorkReason newWorkReason, ApiReviewType reviewType, List<ApiAssessmentSectionSummary> assessmentSectionSummary, List<ApiAssessmentChildWeighting> childWeighting) {
        this.id = id;
        this.assessmentDate = assessmentDate;
        this.otherBenefitNote = otherBenefitNote;
        this.otherIncomeNote = otherIncomeNote;
        this.totalAggregatedIncome = totalAggregatedIncome;
        this.adjustedIncomeValue = adjustedIncomeValue;
        this.notes = notes;
        this.lowerThreshold = lowerThreshold;
        this.upperThreshold = upperThreshold;
        this.result = result;
        this.resultReason = resultReason;
        this.assessmentStatus = assessmentStatus;
        this.newWorkReason = newWorkReason;
        this.reviewType = reviewType;
        this.assessmentSectionSummary = assessmentSectionSummary;
        this.childWeighting = childWeighting;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public ApiInitialMeansAssessment withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="assessmentDate")
    public LocalDateTime getAssessmentDate() {
        return this.assessmentDate;
    }

    @JsonProperty(value="assessmentDate")
    public void setAssessmentDate(LocalDateTime assessmentDate) {
        this.assessmentDate = assessmentDate;
    }

    public ApiInitialMeansAssessment withAssessmentDate(LocalDateTime assessmentDate) {
        this.assessmentDate = assessmentDate;
        return this;
    }

    @JsonProperty(value="otherBenefitNote")
    public String getOtherBenefitNote() {
        return this.otherBenefitNote;
    }

    @JsonProperty(value="otherBenefitNote")
    public void setOtherBenefitNote(String otherBenefitNote) {
        this.otherBenefitNote = otherBenefitNote;
    }

    public ApiInitialMeansAssessment withOtherBenefitNote(String otherBenefitNote) {
        this.otherBenefitNote = otherBenefitNote;
        return this;
    }

    @JsonProperty(value="otherIncomeNote")
    public String getOtherIncomeNote() {
        return this.otherIncomeNote;
    }

    @JsonProperty(value="otherIncomeNote")
    public void setOtherIncomeNote(String otherIncomeNote) {
        this.otherIncomeNote = otherIncomeNote;
    }

    public ApiInitialMeansAssessment withOtherIncomeNote(String otherIncomeNote) {
        this.otherIncomeNote = otherIncomeNote;
        return this;
    }

    @JsonProperty(value="totalAggregatedIncome")
    public BigDecimal getTotalAggregatedIncome() {
        return this.totalAggregatedIncome;
    }

    @JsonProperty(value="totalAggregatedIncome")
    public void setTotalAggregatedIncome(BigDecimal totalAggregatedIncome) {
        this.totalAggregatedIncome = totalAggregatedIncome;
    }

    public ApiInitialMeansAssessment withTotalAggregatedIncome(BigDecimal totalAggregatedIncome) {
        this.totalAggregatedIncome = totalAggregatedIncome;
        return this;
    }

    @JsonProperty(value="adjustedIncomeValue")
    public BigDecimal getAdjustedIncomeValue() {
        return this.adjustedIncomeValue;
    }

    @JsonProperty(value="adjustedIncomeValue")
    public void setAdjustedIncomeValue(BigDecimal adjustedIncomeValue) {
        this.adjustedIncomeValue = adjustedIncomeValue;
    }

    public ApiInitialMeansAssessment withAdjustedIncomeValue(BigDecimal adjustedIncomeValue) {
        this.adjustedIncomeValue = adjustedIncomeValue;
        return this;
    }

    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    public void setNotes(String notes) {
        this.notes = notes;
    }

    public ApiInitialMeansAssessment withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    @JsonProperty(value="lowerThreshold")
    public BigDecimal getLowerThreshold() {
        return this.lowerThreshold;
    }

    @JsonProperty(value="lowerThreshold")
    public void setLowerThreshold(BigDecimal lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
    }

    public ApiInitialMeansAssessment withLowerThreshold(BigDecimal lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
        return this;
    }

    @JsonProperty(value="upperThreshold")
    public BigDecimal getUpperThreshold() {
        return this.upperThreshold;
    }

    @JsonProperty(value="upperThreshold")
    public void setUpperThreshold(BigDecimal upperThreshold) {
        this.upperThreshold = upperThreshold;
    }

    public ApiInitialMeansAssessment withUpperThreshold(BigDecimal upperThreshold) {
        this.upperThreshold = upperThreshold;
        return this;
    }

    @JsonProperty(value="result")
    public String getResult() {
        return this.result;
    }

    @JsonProperty(value="result")
    public void setResult(String result) {
        this.result = result;
    }

    public ApiInitialMeansAssessment withResult(String result) {
        this.result = result;
        return this;
    }

    @JsonProperty(value="resultReason")
    public String getResultReason() {
        return this.resultReason;
    }

    @JsonProperty(value="resultReason")
    public void setResultReason(String resultReason) {
        this.resultReason = resultReason;
    }

    public ApiInitialMeansAssessment withResultReason(String resultReason) {
        this.resultReason = resultReason;
        return this;
    }

    @JsonProperty(value="assessmentStatus")
    public ApiAssessmentStatus getAssessmentStatus() {
        return this.assessmentStatus;
    }

    @JsonProperty(value="assessmentStatus")
    public void setAssessmentStatus(ApiAssessmentStatus assessmentStatus) {
        this.assessmentStatus = assessmentStatus;
    }

    public ApiInitialMeansAssessment withAssessmentStatus(ApiAssessmentStatus assessmentStatus) {
        this.assessmentStatus = assessmentStatus;
        return this;
    }

    @JsonProperty(value="newWorkReason")
    public ApiNewWorkReason getNewWorkReason() {
        return this.newWorkReason;
    }

    @JsonProperty(value="newWorkReason")
    public void setNewWorkReason(ApiNewWorkReason newWorkReason) {
        this.newWorkReason = newWorkReason;
    }

    public ApiInitialMeansAssessment withNewWorkReason(ApiNewWorkReason newWorkReason) {
        this.newWorkReason = newWorkReason;
        return this;
    }

    @JsonProperty(value="reviewType")
    public ApiReviewType getReviewType() {
        return this.reviewType;
    }

    @JsonProperty(value="reviewType")
    public void setReviewType(ApiReviewType reviewType) {
        this.reviewType = reviewType;
    }

    public ApiInitialMeansAssessment withReviewType(ApiReviewType reviewType) {
        this.reviewType = reviewType;
        return this;
    }

    @JsonProperty(value="assessmentSectionSummary")
    public List<ApiAssessmentSectionSummary> getAssessmentSectionSummary() {
        return this.assessmentSectionSummary;
    }

    @JsonProperty(value="assessmentSectionSummary")
    public void setAssessmentSectionSummary(List<ApiAssessmentSectionSummary> assessmentSectionSummary) {
        this.assessmentSectionSummary = assessmentSectionSummary;
    }

    public ApiInitialMeansAssessment withAssessmentSectionSummary(List<ApiAssessmentSectionSummary> assessmentSectionSummary) {
        this.assessmentSectionSummary = assessmentSectionSummary;
        return this;
    }

    @JsonProperty(value="childWeighting")
    public List<ApiAssessmentChildWeighting> getChildWeighting() {
        return this.childWeighting;
    }

    @JsonProperty(value="childWeighting")
    public void setChildWeighting(List<ApiAssessmentChildWeighting> childWeighting) {
        this.childWeighting = childWeighting;
    }

    public ApiInitialMeansAssessment withChildWeighting(List<ApiAssessmentChildWeighting> childWeighting) {
        this.childWeighting = childWeighting;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("id".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"id\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setId((Integer)value);
            return true;
        }
        if ("assessmentDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"assessmentDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setAssessmentDate((LocalDateTime)value);
            return true;
        }
        if ("otherBenefitNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"otherBenefitNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOtherBenefitNote((String)value);
            return true;
        }
        if ("otherIncomeNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"otherIncomeNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOtherIncomeNote((String)value);
            return true;
        }
        if ("totalAggregatedIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"totalAggregatedIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setTotalAggregatedIncome((BigDecimal)value);
            return true;
        }
        if ("adjustedIncomeValue".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"adjustedIncomeValue\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setAdjustedIncomeValue((BigDecimal)value);
            return true;
        }
        if ("notes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"notes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setNotes((String)value);
            return true;
        }
        if ("lowerThreshold".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"lowerThreshold\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setLowerThreshold((BigDecimal)value);
            return true;
        }
        if ("upperThreshold".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"upperThreshold\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setUpperThreshold((BigDecimal)value);
            return true;
        }
        if ("result".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"result\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setResult((String)value);
            return true;
        }
        if ("resultReason".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"resultReason\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setResultReason((String)value);
            return true;
        }
        if ("assessmentStatus".equals(name)) {
            if (!(value instanceof ApiAssessmentStatus)) {
                throw new IllegalArgumentException("property \"assessmentStatus\" is of type \"uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentStatus\", but got " + value.getClass().toString());
            }
            this.setAssessmentStatus((ApiAssessmentStatus)value);
            return true;
        }
        if ("newWorkReason".equals(name)) {
            if (!(value instanceof ApiNewWorkReason)) {
                throw new IllegalArgumentException("property \"newWorkReason\" is of type \"uk.gov.justice.laa.crime.common.model.meansassessment.ApiNewWorkReason\", but got " + value.getClass().toString());
            }
            this.setNewWorkReason((ApiNewWorkReason)value);
            return true;
        }
        if ("reviewType".equals(name)) {
            if (!(value instanceof ApiReviewType)) {
                throw new IllegalArgumentException("property \"reviewType\" is of type \"uk.gov.justice.laa.crime.common.model.meansassessment.ApiReviewType\", but got " + value.getClass().toString());
            }
            this.setReviewType((ApiReviewType)value);
            return true;
        }
        if ("assessmentSectionSummary".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"assessmentSectionSummary\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentSectionSummary>\", but got " + value.getClass().toString());
            }
            this.setAssessmentSectionSummary((List)value);
            return true;
        }
        if ("childWeighting".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"childWeighting\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentChildWeighting>\", but got " + value.getClass().toString());
            }
            this.setChildWeighting((List)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("assessmentDate".equals(name)) {
            return this.getAssessmentDate();
        }
        if ("otherBenefitNote".equals(name)) {
            return this.getOtherBenefitNote();
        }
        if ("otherIncomeNote".equals(name)) {
            return this.getOtherIncomeNote();
        }
        if ("totalAggregatedIncome".equals(name)) {
            return this.getTotalAggregatedIncome();
        }
        if ("adjustedIncomeValue".equals(name)) {
            return this.getAdjustedIncomeValue();
        }
        if ("notes".equals(name)) {
            return this.getNotes();
        }
        if ("lowerThreshold".equals(name)) {
            return this.getLowerThreshold();
        }
        if ("upperThreshold".equals(name)) {
            return this.getUpperThreshold();
        }
        if ("result".equals(name)) {
            return this.getResult();
        }
        if ("resultReason".equals(name)) {
            return this.getResultReason();
        }
        if ("assessmentStatus".equals(name)) {
            return this.getAssessmentStatus();
        }
        if ("newWorkReason".equals(name)) {
            return this.getNewWorkReason();
        }
        if ("reviewType".equals(name)) {
            return this.getReviewType();
        }
        if ("assessmentSectionSummary".equals(name)) {
            return this.getAssessmentSectionSummary();
        }
        if ("childWeighting".equals(name)) {
            return this.getChildWeighting();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiInitialMeansAssessment with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiInitialMeansAssessment.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("assessmentDate");
        sb.append('=');
        sb.append(this.assessmentDate == null ? "<null>" : this.assessmentDate);
        sb.append(',');
        sb.append("otherBenefitNote");
        sb.append('=');
        sb.append(this.otherBenefitNote == null ? "<null>" : this.otherBenefitNote);
        sb.append(',');
        sb.append("otherIncomeNote");
        sb.append('=');
        sb.append(this.otherIncomeNote == null ? "<null>" : this.otherIncomeNote);
        sb.append(',');
        sb.append("totalAggregatedIncome");
        sb.append('=');
        sb.append(this.totalAggregatedIncome == null ? "<null>" : this.totalAggregatedIncome);
        sb.append(',');
        sb.append("adjustedIncomeValue");
        sb.append('=');
        sb.append(this.adjustedIncomeValue == null ? "<null>" : this.adjustedIncomeValue);
        sb.append(',');
        sb.append("notes");
        sb.append('=');
        sb.append(this.notes == null ? "<null>" : this.notes);
        sb.append(',');
        sb.append("lowerThreshold");
        sb.append('=');
        sb.append(this.lowerThreshold == null ? "<null>" : this.lowerThreshold);
        sb.append(',');
        sb.append("upperThreshold");
        sb.append('=');
        sb.append(this.upperThreshold == null ? "<null>" : this.upperThreshold);
        sb.append(',');
        sb.append("result");
        sb.append('=');
        sb.append(this.result == null ? "<null>" : this.result);
        sb.append(',');
        sb.append("resultReason");
        sb.append('=');
        sb.append(this.resultReason == null ? "<null>" : this.resultReason);
        sb.append(',');
        sb.append("assessmentStatus");
        sb.append('=');
        sb.append(this.assessmentStatus == null ? "<null>" : this.assessmentStatus);
        sb.append(',');
        sb.append("newWorkReason");
        sb.append('=');
        sb.append(this.newWorkReason == null ? "<null>" : this.newWorkReason);
        sb.append(',');
        sb.append("reviewType");
        sb.append('=');
        sb.append(this.reviewType == null ? "<null>" : this.reviewType);
        sb.append(',');
        sb.append("assessmentSectionSummary");
        sb.append('=');
        sb.append(this.assessmentSectionSummary == null ? "<null>" : this.assessmentSectionSummary);
        sb.append(',');
        sb.append("childWeighting");
        sb.append('=');
        sb.append(this.childWeighting == null ? "<null>" : this.childWeighting);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.adjustedIncomeValue == null ? 0 : this.adjustedIncomeValue.hashCode());
        result = result * 31 + (this.upperThreshold == null ? 0 : this.upperThreshold.hashCode());
        result = result * 31 + (this.notes == null ? 0 : this.notes.hashCode());
        result = result * 31 + (this.assessmentDate == null ? 0 : this.assessmentDate.hashCode());
        result = result * 31 + (this.otherBenefitNote == null ? 0 : this.otherBenefitNote.hashCode());
        result = result * 31 + (this.reviewType == null ? 0 : this.reviewType.hashCode());
        result = result * 31 + (this.assessmentStatus == null ? 0 : this.assessmentStatus.hashCode());
        result = result * 31 + (this.otherIncomeNote == null ? 0 : this.otherIncomeNote.hashCode());
        result = result * 31 + (this.newWorkReason == null ? 0 : this.newWorkReason.hashCode());
        result = result * 31 + (this.childWeighting == null ? 0 : this.childWeighting.hashCode());
        result = result * 31 + (this.result == null ? 0 : this.result.hashCode());
        result = result * 31 + (this.resultReason == null ? 0 : this.resultReason.hashCode());
        result = result * 31 + (this.totalAggregatedIncome == null ? 0 : this.totalAggregatedIncome.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.lowerThreshold == null ? 0 : this.lowerThreshold.hashCode());
        result = result * 31 + (this.assessmentSectionSummary == null ? 0 : this.assessmentSectionSummary.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiInitialMeansAssessment)) {
            return false;
        }
        ApiInitialMeansAssessment rhs = (ApiInitialMeansAssessment)other;
        return (this.adjustedIncomeValue == rhs.adjustedIncomeValue || this.adjustedIncomeValue != null && this.adjustedIncomeValue.equals(rhs.adjustedIncomeValue)) && (this.upperThreshold == rhs.upperThreshold || this.upperThreshold != null && this.upperThreshold.equals(rhs.upperThreshold)) && (this.notes == rhs.notes || this.notes != null && this.notes.equals(rhs.notes)) && (this.assessmentDate == rhs.assessmentDate || this.assessmentDate != null && this.assessmentDate.equals(rhs.assessmentDate)) && (this.otherBenefitNote == rhs.otherBenefitNote || this.otherBenefitNote != null && this.otherBenefitNote.equals(rhs.otherBenefitNote)) && (this.reviewType == rhs.reviewType || this.reviewType != null && this.reviewType.equals(rhs.reviewType)) && (this.assessmentStatus == rhs.assessmentStatus || this.assessmentStatus != null && this.assessmentStatus.equals(rhs.assessmentStatus)) && (this.otherIncomeNote == rhs.otherIncomeNote || this.otherIncomeNote != null && this.otherIncomeNote.equals(rhs.otherIncomeNote)) && (this.newWorkReason == rhs.newWorkReason || this.newWorkReason != null && this.newWorkReason.equals(rhs.newWorkReason)) && (this.childWeighting == rhs.childWeighting || this.childWeighting != null && this.childWeighting.equals(rhs.childWeighting)) && (this.result == rhs.result || this.result != null && this.result.equals(rhs.result)) && (this.resultReason == rhs.resultReason || this.resultReason != null && this.resultReason.equals(rhs.resultReason)) && (this.totalAggregatedIncome == rhs.totalAggregatedIncome || this.totalAggregatedIncome != null && this.totalAggregatedIncome.equals(rhs.totalAggregatedIncome)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.lowerThreshold == rhs.lowerThreshold || this.lowerThreshold != null && this.lowerThreshold.equals(rhs.lowerThreshold)) && (this.assessmentSectionSummary == rhs.assessmentSectionSummary || this.assessmentSectionSummary != null && this.assessmentSectionSummary.equals(rhs.assessmentSectionSummary));
    }
}

