/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.common.ApiUserSession;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentChildWeighting;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentSectionSummary;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiCrownCourtOverview;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiIncomeEvidenceSummary;
import uk.gov.justice.laa.crime.enums.AssessmentType;
import uk.gov.justice.laa.crime.enums.CaseType;
import uk.gov.justice.laa.crime.enums.CurrentStatus;
import uk.gov.justice.laa.crime.enums.MagCourtOutcome;
import uk.gov.justice.laa.crime.enums.NewWorkReason;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"laaTransactionId", "repId", "cmuId", "initialAssessmentDate", "otherBenefitNote", "otherIncomeNote", "employmentStatus", "initAssessmentNotes", "assessmentStatus", "sectionSummaries", "childWeightings", "hasPartner", "partnerContraryInterest", "assessmentType", "caseType", "userSession", "incomeEvidenceSummary", "crownCourtOverview", "magCourtOutcome", "newWorkReason"})
public class ApiMeansAssessmentRequest {
    @JsonProperty(value="laaTransactionId")
    @JsonPropertyDescription(value="The txn / correlation UUID")
    @NotNull
    private String laaTransactionId;
    @JsonProperty(value="repId")
    @JsonPropertyDescription(value="MAAT / Rep Id")
    @NotNull
    private Integer repId;
    @JsonProperty(value="cmuId")
    @JsonPropertyDescription(value="Case Management Unit Id")
    @NotNull
    private Integer cmuId;
    @JsonProperty(value="initialAssessmentDate")
    @JsonPropertyDescription(value="Effective Date of initial assessment")
    @NotNull
    private LocalDateTime initialAssessmentDate;
    @JsonProperty(value="otherBenefitNote")
    @JsonPropertyDescription(value="Benefit Note")
    private String otherBenefitNote;
    @JsonProperty(value="otherIncomeNote")
    @JsonPropertyDescription(value="Income Note.")
    private String otherIncomeNote;
    @JsonProperty(value="employmentStatus")
    @JsonPropertyDescription(value="Employment status code")
    @NotNull
    private String employmentStatus;
    @JsonProperty(value="initAssessmentNotes")
    @JsonPropertyDescription(value="Initial assessment notes field.")
    private String initAssessmentNotes;
    @JsonProperty(value="assessmentStatus")
    @JsonPropertyDescription(value="Assessment Status")
    @Valid
    @NotNull
    private CurrentStatus assessmentStatus;
    @JsonProperty(value="sectionSummaries")
    @Size(min=1)
    @Valid
    @NotNull
    private @Size(min=1) @Valid @NotNull List<ApiAssessmentSectionSummary> sectionSummaries = new ArrayList<ApiAssessmentSectionSummary>();
    @JsonProperty(value="childWeightings")
    @Size(min=1)
    @Valid
    @NotNull
    private @Size(min=1) @Valid @NotNull List<ApiAssessmentChildWeighting> childWeightings = new ArrayList<ApiAssessmentChildWeighting>();
    @JsonProperty(value="hasPartner")
    @JsonPropertyDescription(value="Indicates whether the applicant has a partner (used to check if partner weighting factor is applicable)")
    @NotNull
    private Boolean hasPartner;
    @JsonProperty(value="partnerContraryInterest")
    @JsonPropertyDescription(value="Indicates whether the applicant's partner has a contrary interest' (used to check if partner weighting factor is applicable)")
    @NotNull
    private Boolean partnerContraryInterest;
    @JsonProperty(value="assessmentType")
    @JsonPropertyDescription(value="Type of as Assessment - Initial, full etc.")
    @Valid
    @NotNull
    private AssessmentType assessmentType;
    @JsonProperty(value="caseType")
    @JsonPropertyDescription(value="The case type")
    @Valid
    @NotNull
    private CaseType caseType;
    @JsonProperty(value="userSession")
    @JsonPropertyDescription(value="Details of a user session")
    @Valid
    @NotNull
    private ApiUserSession userSession;
    @JsonProperty(value="incomeEvidenceSummary")
    @JsonPropertyDescription(value="Details of income evidence")
    @Valid
    private ApiIncomeEvidenceSummary incomeEvidenceSummary;
    @JsonProperty(value="crownCourtOverview")
    @JsonPropertyDescription(value="Crown Court Overview")
    @Valid
    @NotNull
    private ApiCrownCourtOverview crownCourtOverview;
    @JsonProperty(value="magCourtOutcome")
    @JsonPropertyDescription(value="Magistrate Court Outcome")
    @Valid
    private MagCourtOutcome magCourtOutcome;
    @JsonProperty(value="newWorkReason")
    @JsonPropertyDescription(value="Work Reason Details")
    private NewWorkReason newWorkReason;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiMeansAssessmentRequest() {
    }

    public ApiMeansAssessmentRequest(String laaTransactionId, Integer repId, Integer cmuId, LocalDateTime initialAssessmentDate, String otherBenefitNote, String otherIncomeNote, String employmentStatus, String initAssessmentNotes, CurrentStatus assessmentStatus, List<ApiAssessmentSectionSummary> sectionSummaries, List<ApiAssessmentChildWeighting> childWeightings, Boolean hasPartner, Boolean partnerContraryInterest, AssessmentType assessmentType, CaseType caseType, ApiUserSession userSession, ApiIncomeEvidenceSummary incomeEvidenceSummary, ApiCrownCourtOverview crownCourtOverview, MagCourtOutcome magCourtOutcome, NewWorkReason newWorkReason) {
        this.laaTransactionId = laaTransactionId;
        this.repId = repId;
        this.cmuId = cmuId;
        this.initialAssessmentDate = initialAssessmentDate;
        this.otherBenefitNote = otherBenefitNote;
        this.otherIncomeNote = otherIncomeNote;
        this.employmentStatus = employmentStatus;
        this.initAssessmentNotes = initAssessmentNotes;
        this.assessmentStatus = assessmentStatus;
        this.sectionSummaries = sectionSummaries;
        this.childWeightings = childWeightings;
        this.hasPartner = hasPartner;
        this.partnerContraryInterest = partnerContraryInterest;
        this.assessmentType = assessmentType;
        this.caseType = caseType;
        this.userSession = userSession;
        this.incomeEvidenceSummary = incomeEvidenceSummary;
        this.crownCourtOverview = crownCourtOverview;
        this.magCourtOutcome = magCourtOutcome;
        this.newWorkReason = newWorkReason;
    }

    @JsonProperty(value="laaTransactionId")
    public String getLaaTransactionId() {
        return this.laaTransactionId;
    }

    @JsonProperty(value="laaTransactionId")
    public void setLaaTransactionId(String laaTransactionId) {
        this.laaTransactionId = laaTransactionId;
    }

    public ApiMeansAssessmentRequest withLaaTransactionId(String laaTransactionId) {
        this.laaTransactionId = laaTransactionId;
        return this;
    }

    @JsonProperty(value="repId")
    public Integer getRepId() {
        return this.repId;
    }

    @JsonProperty(value="repId")
    public void setRepId(Integer repId) {
        this.repId = repId;
    }

    public ApiMeansAssessmentRequest withRepId(Integer repId) {
        this.repId = repId;
        return this;
    }

    @JsonProperty(value="cmuId")
    public Integer getCmuId() {
        return this.cmuId;
    }

    @JsonProperty(value="cmuId")
    public void setCmuId(Integer cmuId) {
        this.cmuId = cmuId;
    }

    public ApiMeansAssessmentRequest withCmuId(Integer cmuId) {
        this.cmuId = cmuId;
        return this;
    }

    @JsonProperty(value="initialAssessmentDate")
    public LocalDateTime getInitialAssessmentDate() {
        return this.initialAssessmentDate;
    }

    @JsonProperty(value="initialAssessmentDate")
    public void setInitialAssessmentDate(LocalDateTime initialAssessmentDate) {
        this.initialAssessmentDate = initialAssessmentDate;
    }

    public ApiMeansAssessmentRequest withInitialAssessmentDate(LocalDateTime initialAssessmentDate) {
        this.initialAssessmentDate = initialAssessmentDate;
        return this;
    }

    @JsonProperty(value="otherBenefitNote")
    public String getOtherBenefitNote() {
        return this.otherBenefitNote;
    }

    @JsonProperty(value="otherBenefitNote")
    public void setOtherBenefitNote(String otherBenefitNote) {
        this.otherBenefitNote = otherBenefitNote;
    }

    public ApiMeansAssessmentRequest withOtherBenefitNote(String otherBenefitNote) {
        this.otherBenefitNote = otherBenefitNote;
        return this;
    }

    @JsonProperty(value="otherIncomeNote")
    public String getOtherIncomeNote() {
        return this.otherIncomeNote;
    }

    @JsonProperty(value="otherIncomeNote")
    public void setOtherIncomeNote(String otherIncomeNote) {
        this.otherIncomeNote = otherIncomeNote;
    }

    public ApiMeansAssessmentRequest withOtherIncomeNote(String otherIncomeNote) {
        this.otherIncomeNote = otherIncomeNote;
        return this;
    }

    @JsonProperty(value="employmentStatus")
    public String getEmploymentStatus() {
        return this.employmentStatus;
    }

    @JsonProperty(value="employmentStatus")
    public void setEmploymentStatus(String employmentStatus) {
        this.employmentStatus = employmentStatus;
    }

    public ApiMeansAssessmentRequest withEmploymentStatus(String employmentStatus) {
        this.employmentStatus = employmentStatus;
        return this;
    }

    @JsonProperty(value="initAssessmentNotes")
    public String getInitAssessmentNotes() {
        return this.initAssessmentNotes;
    }

    @JsonProperty(value="initAssessmentNotes")
    public void setInitAssessmentNotes(String initAssessmentNotes) {
        this.initAssessmentNotes = initAssessmentNotes;
    }

    public ApiMeansAssessmentRequest withInitAssessmentNotes(String initAssessmentNotes) {
        this.initAssessmentNotes = initAssessmentNotes;
        return this;
    }

    @JsonProperty(value="assessmentStatus")
    public CurrentStatus getAssessmentStatus() {
        return this.assessmentStatus;
    }

    @JsonProperty(value="assessmentStatus")
    public void setAssessmentStatus(CurrentStatus assessmentStatus) {
        this.assessmentStatus = assessmentStatus;
    }

    public ApiMeansAssessmentRequest withAssessmentStatus(CurrentStatus assessmentStatus) {
        this.assessmentStatus = assessmentStatus;
        return this;
    }

    @JsonProperty(value="sectionSummaries")
    public List<ApiAssessmentSectionSummary> getSectionSummaries() {
        return this.sectionSummaries;
    }

    @JsonProperty(value="sectionSummaries")
    public void setSectionSummaries(List<ApiAssessmentSectionSummary> sectionSummaries) {
        this.sectionSummaries = sectionSummaries;
    }

    public ApiMeansAssessmentRequest withSectionSummaries(List<ApiAssessmentSectionSummary> sectionSummaries) {
        this.sectionSummaries = sectionSummaries;
        return this;
    }

    @JsonProperty(value="childWeightings")
    public List<ApiAssessmentChildWeighting> getChildWeightings() {
        return this.childWeightings;
    }

    @JsonProperty(value="childWeightings")
    public void setChildWeightings(List<ApiAssessmentChildWeighting> childWeightings) {
        this.childWeightings = childWeightings;
    }

    public ApiMeansAssessmentRequest withChildWeightings(List<ApiAssessmentChildWeighting> childWeightings) {
        this.childWeightings = childWeightings;
        return this;
    }

    @JsonProperty(value="hasPartner")
    public Boolean getHasPartner() {
        return this.hasPartner;
    }

    @JsonProperty(value="hasPartner")
    public void setHasPartner(Boolean hasPartner) {
        this.hasPartner = hasPartner;
    }

    public ApiMeansAssessmentRequest withHasPartner(Boolean hasPartner) {
        this.hasPartner = hasPartner;
        return this;
    }

    @JsonProperty(value="partnerContraryInterest")
    public Boolean getPartnerContraryInterest() {
        return this.partnerContraryInterest;
    }

    @JsonProperty(value="partnerContraryInterest")
    public void setPartnerContraryInterest(Boolean partnerContraryInterest) {
        this.partnerContraryInterest = partnerContraryInterest;
    }

    public ApiMeansAssessmentRequest withPartnerContraryInterest(Boolean partnerContraryInterest) {
        this.partnerContraryInterest = partnerContraryInterest;
        return this;
    }

    @JsonProperty(value="assessmentType")
    public AssessmentType getAssessmentType() {
        return this.assessmentType;
    }

    @JsonProperty(value="assessmentType")
    public void setAssessmentType(AssessmentType assessmentType) {
        this.assessmentType = assessmentType;
    }

    public ApiMeansAssessmentRequest withAssessmentType(AssessmentType assessmentType) {
        this.assessmentType = assessmentType;
        return this;
    }

    @JsonProperty(value="caseType")
    public CaseType getCaseType() {
        return this.caseType;
    }

    @JsonProperty(value="caseType")
    public void setCaseType(CaseType caseType) {
        this.caseType = caseType;
    }

    public ApiMeansAssessmentRequest withCaseType(CaseType caseType) {
        this.caseType = caseType;
        return this;
    }

    @JsonProperty(value="userSession")
    public ApiUserSession getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    public void setUserSession(ApiUserSession userSession) {
        this.userSession = userSession;
    }

    public ApiMeansAssessmentRequest withUserSession(ApiUserSession userSession) {
        this.userSession = userSession;
        return this;
    }

    @JsonProperty(value="incomeEvidenceSummary")
    public ApiIncomeEvidenceSummary getIncomeEvidenceSummary() {
        return this.incomeEvidenceSummary;
    }

    @JsonProperty(value="incomeEvidenceSummary")
    public void setIncomeEvidenceSummary(ApiIncomeEvidenceSummary incomeEvidenceSummary) {
        this.incomeEvidenceSummary = incomeEvidenceSummary;
    }

    public ApiMeansAssessmentRequest withIncomeEvidenceSummary(ApiIncomeEvidenceSummary incomeEvidenceSummary) {
        this.incomeEvidenceSummary = incomeEvidenceSummary;
        return this;
    }

    @JsonProperty(value="crownCourtOverview")
    public ApiCrownCourtOverview getCrownCourtOverview() {
        return this.crownCourtOverview;
    }

    @JsonProperty(value="crownCourtOverview")
    public void setCrownCourtOverview(ApiCrownCourtOverview crownCourtOverview) {
        this.crownCourtOverview = crownCourtOverview;
    }

    public ApiMeansAssessmentRequest withCrownCourtOverview(ApiCrownCourtOverview crownCourtOverview) {
        this.crownCourtOverview = crownCourtOverview;
        return this;
    }

    @JsonProperty(value="magCourtOutcome")
    public MagCourtOutcome getMagCourtOutcome() {
        return this.magCourtOutcome;
    }

    @JsonProperty(value="magCourtOutcome")
    public void setMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
    }

    public ApiMeansAssessmentRequest withMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
        return this;
    }

    @JsonProperty(value="newWorkReason")
    public NewWorkReason getNewWorkReason() {
        return this.newWorkReason;
    }

    @JsonProperty(value="newWorkReason")
    public void setNewWorkReason(NewWorkReason newWorkReason) {
        this.newWorkReason = newWorkReason;
    }

    public ApiMeansAssessmentRequest withNewWorkReason(NewWorkReason newWorkReason) {
        this.newWorkReason = newWorkReason;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("laaTransactionId".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"laaTransactionId\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setLaaTransactionId((String)value);
            return true;
        }
        if ("repId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"repId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setRepId((Integer)value);
            return true;
        }
        if ("cmuId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"cmuId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setCmuId((Integer)value);
            return true;
        }
        if ("initialAssessmentDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"initialAssessmentDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setInitialAssessmentDate((LocalDateTime)value);
            return true;
        }
        if ("otherBenefitNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"otherBenefitNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOtherBenefitNote((String)value);
            return true;
        }
        if ("otherIncomeNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"otherIncomeNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOtherIncomeNote((String)value);
            return true;
        }
        if ("employmentStatus".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"employmentStatus\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setEmploymentStatus((String)value);
            return true;
        }
        if ("initAssessmentNotes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initAssessmentNotes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitAssessmentNotes((String)value);
            return true;
        }
        if ("assessmentStatus".equals(name)) {
            if (!(value instanceof CurrentStatus)) {
                throw new IllegalArgumentException("property \"assessmentStatus\" is of type \"uk.gov.justice.laa.crime.enums.CurrentStatus\", but got " + value.getClass().toString());
            }
            this.setAssessmentStatus((CurrentStatus)value);
            return true;
        }
        if ("sectionSummaries".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"sectionSummaries\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentSectionSummary>\", but got " + value.getClass().toString());
            }
            this.setSectionSummaries((List)value);
            return true;
        }
        if ("childWeightings".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"childWeightings\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentChildWeighting>\", but got " + value.getClass().toString());
            }
            this.setChildWeightings((List)value);
            return true;
        }
        if ("hasPartner".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"hasPartner\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setHasPartner((Boolean)value);
            return true;
        }
        if ("partnerContraryInterest".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"partnerContraryInterest\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setPartnerContraryInterest((Boolean)value);
            return true;
        }
        if ("assessmentType".equals(name)) {
            if (!(value instanceof AssessmentType)) {
                throw new IllegalArgumentException("property \"assessmentType\" is of type \"uk.gov.justice.laa.crime.enums.AssessmentType\", but got " + value.getClass().toString());
            }
            this.setAssessmentType((AssessmentType)value);
            return true;
        }
        if ("caseType".equals(name)) {
            if (!(value instanceof CaseType)) {
                throw new IllegalArgumentException("property \"caseType\" is of type \"uk.gov.justice.laa.crime.enums.CaseType\", but got " + value.getClass().toString());
            }
            this.setCaseType((CaseType)value);
            return true;
        }
        if ("userSession".equals(name)) {
            if (!(value instanceof ApiUserSession)) {
                throw new IllegalArgumentException("property \"userSession\" is of type \"uk.gov.justice.laa.crime.common.model.common.ApiUserSession\", but got " + value.getClass().toString());
            }
            this.setUserSession((ApiUserSession)value);
            return true;
        }
        if ("incomeEvidenceSummary".equals(name)) {
            if (!(value instanceof ApiIncomeEvidenceSummary)) {
                throw new IllegalArgumentException("property \"incomeEvidenceSummary\" is of type \"uk.gov.justice.laa.crime.common.model.meansassessment.ApiIncomeEvidenceSummary\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidenceSummary((ApiIncomeEvidenceSummary)value);
            return true;
        }
        if ("crownCourtOverview".equals(name)) {
            if (!(value instanceof ApiCrownCourtOverview)) {
                throw new IllegalArgumentException("property \"crownCourtOverview\" is of type \"uk.gov.justice.laa.crime.common.model.meansassessment.ApiCrownCourtOverview\", but got " + value.getClass().toString());
            }
            this.setCrownCourtOverview((ApiCrownCourtOverview)value);
            return true;
        }
        if ("magCourtOutcome".equals(name)) {
            if (!(value instanceof MagCourtOutcome)) {
                throw new IllegalArgumentException("property \"magCourtOutcome\" is of type \"uk.gov.justice.laa.crime.enums.MagCourtOutcome\", but got " + value.getClass().toString());
            }
            this.setMagCourtOutcome((MagCourtOutcome)value);
            return true;
        }
        if ("newWorkReason".equals(name)) {
            if (!(value instanceof NewWorkReason)) {
                throw new IllegalArgumentException("property \"newWorkReason\" is of type \"uk.gov.justice.laa.crime.enums.NewWorkReason\", but got " + value.getClass().toString());
            }
            this.setNewWorkReason((NewWorkReason)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("laaTransactionId".equals(name)) {
            return this.getLaaTransactionId();
        }
        if ("repId".equals(name)) {
            return this.getRepId();
        }
        if ("cmuId".equals(name)) {
            return this.getCmuId();
        }
        if ("initialAssessmentDate".equals(name)) {
            return this.getInitialAssessmentDate();
        }
        if ("otherBenefitNote".equals(name)) {
            return this.getOtherBenefitNote();
        }
        if ("otherIncomeNote".equals(name)) {
            return this.getOtherIncomeNote();
        }
        if ("employmentStatus".equals(name)) {
            return this.getEmploymentStatus();
        }
        if ("initAssessmentNotes".equals(name)) {
            return this.getInitAssessmentNotes();
        }
        if ("assessmentStatus".equals(name)) {
            return this.getAssessmentStatus();
        }
        if ("sectionSummaries".equals(name)) {
            return this.getSectionSummaries();
        }
        if ("childWeightings".equals(name)) {
            return this.getChildWeightings();
        }
        if ("hasPartner".equals(name)) {
            return this.getHasPartner();
        }
        if ("partnerContraryInterest".equals(name)) {
            return this.getPartnerContraryInterest();
        }
        if ("assessmentType".equals(name)) {
            return this.getAssessmentType();
        }
        if ("caseType".equals(name)) {
            return this.getCaseType();
        }
        if ("userSession".equals(name)) {
            return this.getUserSession();
        }
        if ("incomeEvidenceSummary".equals(name)) {
            return this.getIncomeEvidenceSummary();
        }
        if ("crownCourtOverview".equals(name)) {
            return this.getCrownCourtOverview();
        }
        if ("magCourtOutcome".equals(name)) {
            return this.getMagCourtOutcome();
        }
        if ("newWorkReason".equals(name)) {
            return this.getNewWorkReason();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiMeansAssessmentRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiMeansAssessmentRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("laaTransactionId");
        sb.append('=');
        sb.append(this.laaTransactionId == null ? "<null>" : this.laaTransactionId);
        sb.append(',');
        sb.append("repId");
        sb.append('=');
        sb.append(this.repId == null ? "<null>" : this.repId);
        sb.append(',');
        sb.append("cmuId");
        sb.append('=');
        sb.append(this.cmuId == null ? "<null>" : this.cmuId);
        sb.append(',');
        sb.append("initialAssessmentDate");
        sb.append('=');
        sb.append(this.initialAssessmentDate == null ? "<null>" : this.initialAssessmentDate);
        sb.append(',');
        sb.append("otherBenefitNote");
        sb.append('=');
        sb.append(this.otherBenefitNote == null ? "<null>" : this.otherBenefitNote);
        sb.append(',');
        sb.append("otherIncomeNote");
        sb.append('=');
        sb.append(this.otherIncomeNote == null ? "<null>" : this.otherIncomeNote);
        sb.append(',');
        sb.append("employmentStatus");
        sb.append('=');
        sb.append(this.employmentStatus == null ? "<null>" : this.employmentStatus);
        sb.append(',');
        sb.append("initAssessmentNotes");
        sb.append('=');
        sb.append(this.initAssessmentNotes == null ? "<null>" : this.initAssessmentNotes);
        sb.append(',');
        sb.append("assessmentStatus");
        sb.append('=');
        sb.append((Object)(this.assessmentStatus == null ? "<null>" : this.assessmentStatus));
        sb.append(',');
        sb.append("sectionSummaries");
        sb.append('=');
        sb.append(this.sectionSummaries == null ? "<null>" : this.sectionSummaries);
        sb.append(',');
        sb.append("childWeightings");
        sb.append('=');
        sb.append(this.childWeightings == null ? "<null>" : this.childWeightings);
        sb.append(',');
        sb.append("hasPartner");
        sb.append('=');
        sb.append(this.hasPartner == null ? "<null>" : this.hasPartner);
        sb.append(',');
        sb.append("partnerContraryInterest");
        sb.append('=');
        sb.append(this.partnerContraryInterest == null ? "<null>" : this.partnerContraryInterest);
        sb.append(',');
        sb.append("assessmentType");
        sb.append('=');
        sb.append((Object)(this.assessmentType == null ? "<null>" : this.assessmentType));
        sb.append(',');
        sb.append("caseType");
        sb.append('=');
        sb.append((Object)(this.caseType == null ? "<null>" : this.caseType));
        sb.append(',');
        sb.append("userSession");
        sb.append('=');
        sb.append(this.userSession == null ? "<null>" : this.userSession);
        sb.append(',');
        sb.append("incomeEvidenceSummary");
        sb.append('=');
        sb.append(this.incomeEvidenceSummary == null ? "<null>" : this.incomeEvidenceSummary);
        sb.append(',');
        sb.append("crownCourtOverview");
        sb.append('=');
        sb.append(this.crownCourtOverview == null ? "<null>" : this.crownCourtOverview);
        sb.append(',');
        sb.append("magCourtOutcome");
        sb.append('=');
        sb.append((Object)(this.magCourtOutcome == null ? "<null>" : this.magCourtOutcome));
        sb.append(',');
        sb.append("newWorkReason");
        sb.append('=');
        sb.append((Object)(this.newWorkReason == null ? "<null>" : this.newWorkReason));
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.laaTransactionId == null ? 0 : this.laaTransactionId.hashCode());
        result = result * 31 + (this.cmuId == null ? 0 : this.cmuId.hashCode());
        result = result * 31 + (this.sectionSummaries == null ? 0 : this.sectionSummaries.hashCode());
        result = result * 31 + (this.assessmentType == null ? 0 : this.assessmentType.hashCode());
        result = result * 31 + (this.incomeEvidenceSummary == null ? 0 : this.incomeEvidenceSummary.hashCode());
        result = result * 31 + (this.otherBenefitNote == null ? 0 : this.otherBenefitNote.hashCode());
        result = result * 31 + (this.assessmentStatus == null ? 0 : this.assessmentStatus.hashCode());
        result = result * 31 + (this.otherIncomeNote == null ? 0 : this.otherIncomeNote.hashCode());
        result = result * 31 + (this.newWorkReason == null ? 0 : this.newWorkReason.hashCode());
        result = result * 31 + (this.employmentStatus == null ? 0 : this.employmentStatus.hashCode());
        result = result * 31 + (this.repId == null ? 0 : this.repId.hashCode());
        result = result * 31 + (this.hasPartner == null ? 0 : this.hasPartner.hashCode());
        result = result * 31 + (this.caseType == null ? 0 : this.caseType.hashCode());
        result = result * 31 + (this.childWeightings == null ? 0 : this.childWeightings.hashCode());
        result = result * 31 + (this.initialAssessmentDate == null ? 0 : this.initialAssessmentDate.hashCode());
        result = result * 31 + (this.magCourtOutcome == null ? 0 : this.magCourtOutcome.hashCode());
        result = result * 31 + (this.crownCourtOverview == null ? 0 : this.crownCourtOverview.hashCode());
        result = result * 31 + (this.userSession == null ? 0 : this.userSession.hashCode());
        result = result * 31 + (this.partnerContraryInterest == null ? 0 : this.partnerContraryInterest.hashCode());
        result = result * 31 + (this.initAssessmentNotes == null ? 0 : this.initAssessmentNotes.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiMeansAssessmentRequest)) {
            return false;
        }
        ApiMeansAssessmentRequest rhs = (ApiMeansAssessmentRequest)other;
        return (this.laaTransactionId == rhs.laaTransactionId || this.laaTransactionId != null && this.laaTransactionId.equals(rhs.laaTransactionId)) && (this.cmuId == rhs.cmuId || this.cmuId != null && this.cmuId.equals(rhs.cmuId)) && (this.sectionSummaries == rhs.sectionSummaries || this.sectionSummaries != null && this.sectionSummaries.equals(rhs.sectionSummaries)) && (this.assessmentType == rhs.assessmentType || this.assessmentType != null && this.assessmentType.equals((Object)rhs.assessmentType)) && (this.incomeEvidenceSummary == rhs.incomeEvidenceSummary || this.incomeEvidenceSummary != null && this.incomeEvidenceSummary.equals(rhs.incomeEvidenceSummary)) && (this.otherBenefitNote == rhs.otherBenefitNote || this.otherBenefitNote != null && this.otherBenefitNote.equals(rhs.otherBenefitNote)) && (this.assessmentStatus == rhs.assessmentStatus || this.assessmentStatus != null && this.assessmentStatus.equals((Object)rhs.assessmentStatus)) && (this.otherIncomeNote == rhs.otherIncomeNote || this.otherIncomeNote != null && this.otherIncomeNote.equals(rhs.otherIncomeNote)) && (this.newWorkReason == rhs.newWorkReason || this.newWorkReason != null && this.newWorkReason.equals((Object)rhs.newWorkReason)) && (this.employmentStatus == rhs.employmentStatus || this.employmentStatus != null && this.employmentStatus.equals(rhs.employmentStatus)) && (this.repId == rhs.repId || this.repId != null && this.repId.equals(rhs.repId)) && (this.hasPartner == rhs.hasPartner || this.hasPartner != null && this.hasPartner.equals(rhs.hasPartner)) && (this.caseType == rhs.caseType || this.caseType != null && this.caseType.equals((Object)rhs.caseType)) && (this.childWeightings == rhs.childWeightings || this.childWeightings != null && this.childWeightings.equals(rhs.childWeightings)) && (this.initialAssessmentDate == rhs.initialAssessmentDate || this.initialAssessmentDate != null && this.initialAssessmentDate.equals(rhs.initialAssessmentDate)) && (this.magCourtOutcome == rhs.magCourtOutcome || this.magCourtOutcome != null && this.magCourtOutcome.equals((Object)rhs.magCourtOutcome)) && (this.crownCourtOverview == rhs.crownCourtOverview || this.crownCourtOverview != null && this.crownCourtOverview.equals(rhs.crownCourtOverview)) && (this.userSession == rhs.userSession || this.userSession != null && this.userSession.equals(rhs.userSession)) && (this.partnerContraryInterest == rhs.partnerContraryInterest || this.partnerContraryInterest != null && this.partnerContraryInterest.equals(rhs.partnerContraryInterest)) && (this.initAssessmentNotes == rhs.initAssessmentNotes || this.initAssessmentNotes != null && this.initAssessmentNotes.equals(rhs.initAssessmentNotes));
    }
}

