/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentChildWeighting;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentSectionSummary;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentSummary;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiIncomeEvidence;
import uk.gov.justice.laa.crime.enums.AssessmentType;
import uk.gov.justice.laa.crime.enums.CurrentStatus;
import uk.gov.justice.laa.crime.enums.ReviewType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"assessmentId", "repId", "criteriaId", "transactionDateTime", "totalAggregatedIncome", "adjustedIncomeValue", "adjustedLivingAllowance", "totalAggregatedExpense", "totalAnnualDisposableIncome", "lowerThreshold", "upperThreshold", "fullThreshold", "assessmentType", "initResult", "initResultReason", "initialAssessmentDate", "fassInitStatus", "fullResult", "fullResultReason", "fullAssessmentDate", "fassFullStatus", "assessmentSectionSummary", "assessmentSummary", "childWeightings", "incomeEvidence", "fullAssessmentAvailable", "reviewType", "updated", "applicationTimestamp", "dateCompleted"})
public class ApiMeansAssessmentResponse {
    @JsonProperty(value="assessmentId")
    @JsonPropertyDescription(value="Unique Identifier of an Assessment.")
    @NotNull
    private Integer assessmentId;
    @JsonProperty(value="repId")
    @JsonPropertyDescription(value="MAAT / Rep Id")
    private Integer repId;
    @JsonProperty(value="criteriaId")
    @JsonPropertyDescription(value="Unique Identifier of the Criteria.")
    @NotNull
    private Integer criteriaId;
    @JsonProperty(value="transactionDateTime")
    @JsonPropertyDescription(value="Time Stamp of the transaction")
    private LocalDateTime transactionDateTime;
    @JsonProperty(value="totalAggregatedIncome")
    @JsonPropertyDescription(value="Total Aggregated income of the application.")
    @NotNull
    private BigDecimal totalAggregatedIncome;
    @JsonProperty(value="adjustedIncomeValue")
    @JsonPropertyDescription(value="Adjusted Income of the Application")
    @NotNull
    private BigDecimal adjustedIncomeValue;
    @JsonProperty(value="adjustedLivingAllowance")
    @JsonPropertyDescription(value="Adjusted Living Allowance of the Application")
    @NotNull
    private BigDecimal adjustedLivingAllowance;
    @JsonProperty(value="totalAggregatedExpense")
    @JsonPropertyDescription(value="Total Aggregated Expense of the Application")
    @NotNull
    private BigDecimal totalAggregatedExpense;
    @JsonProperty(value="totalAnnualDisposableIncome")
    @JsonPropertyDescription(value="Total Annual Disposable Income of the Application")
    @NotNull
    private BigDecimal totalAnnualDisposableIncome;
    @JsonProperty(value="lowerThreshold")
    @JsonPropertyDescription(value="Lower Threshold Value from Ref Data")
    @NotNull
    private BigDecimal lowerThreshold;
    @JsonProperty(value="upperThreshold")
    @JsonPropertyDescription(value="Upper Threshold Value from Ref Data")
    @NotNull
    private BigDecimal upperThreshold;
    @JsonProperty(value="fullThreshold")
    @JsonPropertyDescription(value="Full Threshold Value from Ref Data")
    @NotNull
    private BigDecimal fullThreshold;
    @JsonProperty(value="assessmentType")
    @JsonPropertyDescription(value="Type of as Assessment - Initial, full etc.")
    @Valid
    private AssessmentType assessmentType;
    @JsonProperty(value="initResult")
    @JsonPropertyDescription(value="Outcome of initial assessment")
    private String initResult;
    @JsonProperty(value="initResultReason")
    @JsonPropertyDescription(value="The reason for the outcome ")
    private String initResultReason;
    @JsonProperty(value="initialAssessmentDate")
    @JsonPropertyDescription(value="Effective Date of initial assessment")
    private LocalDateTime initialAssessmentDate;
    @JsonProperty(value="fassInitStatus")
    @JsonPropertyDescription(value="Assessment Status")
    private CurrentStatus fassInitStatus;
    @JsonProperty(value="fullResult")
    @JsonPropertyDescription(value="Outcome of full assessment")
    private String fullResult;
    @JsonProperty(value="fullResultReason")
    @JsonPropertyDescription(value="The reason for the outcome ")
    private String fullResultReason;
    @JsonProperty(value="fullAssessmentDate")
    @JsonPropertyDescription(value="Effective Date of full assessment")
    private LocalDateTime fullAssessmentDate;
    @JsonProperty(value="fassFullStatus")
    @JsonPropertyDescription(value="Assessment Status")
    private CurrentStatus fassFullStatus;
    @JsonProperty(value="assessmentSectionSummary")
    @JsonPropertyDescription(value="Assessment section summary")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<ApiAssessmentSectionSummary> assessmentSectionSummary = new ArrayList<ApiAssessmentSectionSummary>();
    @JsonProperty(value="assessmentSummary")
    @JsonPropertyDescription(value="Assessment summary")
    @Size(min=1)
    @Valid
    @NotNull
    private @Size(min=1) @Valid @NotNull List<ApiAssessmentSummary> assessmentSummary = new ArrayList<ApiAssessmentSummary>();
    @JsonProperty(value="childWeightings")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<ApiAssessmentChildWeighting> childWeightings = new ArrayList<ApiAssessmentChildWeighting>();
    @JsonProperty(value="incomeEvidence")
    @Valid
    private List<ApiIncomeEvidence> incomeEvidence = new ArrayList<ApiIncomeEvidence>();
    @JsonProperty(value="fullAssessmentAvailable")
    @JsonPropertyDescription(value="Indicates the availability of Full Means Assessment.")
    @NotNull
    private Boolean fullAssessmentAvailable;
    @JsonProperty(value="reviewType")
    @JsonPropertyDescription(value="Review Type Info")
    private ReviewType reviewType;
    @JsonProperty(value="updated")
    @JsonPropertyDescription(value="The date the assessment was last updated")
    private LocalDateTime updated;
    @JsonProperty(value="applicationTimestamp")
    @JsonPropertyDescription(value="The application modification timestamp")
    private LocalDateTime applicationTimestamp;
    @JsonProperty(value="dateCompleted")
    @JsonPropertyDescription(value="The date the assessment was completed")
    private LocalDateTime dateCompleted;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiMeansAssessmentResponse() {
    }

    public ApiMeansAssessmentResponse(Integer assessmentId, Integer repId, Integer criteriaId, LocalDateTime transactionDateTime, BigDecimal totalAggregatedIncome, BigDecimal adjustedIncomeValue, BigDecimal adjustedLivingAllowance, BigDecimal totalAggregatedExpense, BigDecimal totalAnnualDisposableIncome, BigDecimal lowerThreshold, BigDecimal upperThreshold, BigDecimal fullThreshold, AssessmentType assessmentType, String initResult, String initResultReason, LocalDateTime initialAssessmentDate, CurrentStatus fassInitStatus, String fullResult, String fullResultReason, LocalDateTime fullAssessmentDate, CurrentStatus fassFullStatus, List<ApiAssessmentSectionSummary> assessmentSectionSummary, List<ApiAssessmentSummary> assessmentSummary, List<ApiAssessmentChildWeighting> childWeightings, List<ApiIncomeEvidence> incomeEvidence, Boolean fullAssessmentAvailable, ReviewType reviewType, LocalDateTime updated, LocalDateTime applicationTimestamp, LocalDateTime dateCompleted) {
        this.assessmentId = assessmentId;
        this.repId = repId;
        this.criteriaId = criteriaId;
        this.transactionDateTime = transactionDateTime;
        this.totalAggregatedIncome = totalAggregatedIncome;
        this.adjustedIncomeValue = adjustedIncomeValue;
        this.adjustedLivingAllowance = adjustedLivingAllowance;
        this.totalAggregatedExpense = totalAggregatedExpense;
        this.totalAnnualDisposableIncome = totalAnnualDisposableIncome;
        this.lowerThreshold = lowerThreshold;
        this.upperThreshold = upperThreshold;
        this.fullThreshold = fullThreshold;
        this.assessmentType = assessmentType;
        this.initResult = initResult;
        this.initResultReason = initResultReason;
        this.initialAssessmentDate = initialAssessmentDate;
        this.fassInitStatus = fassInitStatus;
        this.fullResult = fullResult;
        this.fullResultReason = fullResultReason;
        this.fullAssessmentDate = fullAssessmentDate;
        this.fassFullStatus = fassFullStatus;
        this.assessmentSectionSummary = assessmentSectionSummary;
        this.assessmentSummary = assessmentSummary;
        this.childWeightings = childWeightings;
        this.incomeEvidence = incomeEvidence;
        this.fullAssessmentAvailable = fullAssessmentAvailable;
        this.reviewType = reviewType;
        this.updated = updated;
        this.applicationTimestamp = applicationTimestamp;
        this.dateCompleted = dateCompleted;
    }

    @JsonProperty(value="assessmentId")
    public Integer getAssessmentId() {
        return this.assessmentId;
    }

    @JsonProperty(value="assessmentId")
    public void setAssessmentId(Integer assessmentId) {
        this.assessmentId = assessmentId;
    }

    public ApiMeansAssessmentResponse withAssessmentId(Integer assessmentId) {
        this.assessmentId = assessmentId;
        return this;
    }

    @JsonProperty(value="repId")
    public Integer getRepId() {
        return this.repId;
    }

    @JsonProperty(value="repId")
    public void setRepId(Integer repId) {
        this.repId = repId;
    }

    public ApiMeansAssessmentResponse withRepId(Integer repId) {
        this.repId = repId;
        return this;
    }

    @JsonProperty(value="criteriaId")
    public Integer getCriteriaId() {
        return this.criteriaId;
    }

    @JsonProperty(value="criteriaId")
    public void setCriteriaId(Integer criteriaId) {
        this.criteriaId = criteriaId;
    }

    public ApiMeansAssessmentResponse withCriteriaId(Integer criteriaId) {
        this.criteriaId = criteriaId;
        return this;
    }

    @JsonProperty(value="transactionDateTime")
    public LocalDateTime getTransactionDateTime() {
        return this.transactionDateTime;
    }

    @JsonProperty(value="transactionDateTime")
    public void setTransactionDateTime(LocalDateTime transactionDateTime) {
        this.transactionDateTime = transactionDateTime;
    }

    public ApiMeansAssessmentResponse withTransactionDateTime(LocalDateTime transactionDateTime) {
        this.transactionDateTime = transactionDateTime;
        return this;
    }

    @JsonProperty(value="totalAggregatedIncome")
    public BigDecimal getTotalAggregatedIncome() {
        return this.totalAggregatedIncome;
    }

    @JsonProperty(value="totalAggregatedIncome")
    public void setTotalAggregatedIncome(BigDecimal totalAggregatedIncome) {
        this.totalAggregatedIncome = totalAggregatedIncome;
    }

    public ApiMeansAssessmentResponse withTotalAggregatedIncome(BigDecimal totalAggregatedIncome) {
        this.totalAggregatedIncome = totalAggregatedIncome;
        return this;
    }

    @JsonProperty(value="adjustedIncomeValue")
    public BigDecimal getAdjustedIncomeValue() {
        return this.adjustedIncomeValue;
    }

    @JsonProperty(value="adjustedIncomeValue")
    public void setAdjustedIncomeValue(BigDecimal adjustedIncomeValue) {
        this.adjustedIncomeValue = adjustedIncomeValue;
    }

    public ApiMeansAssessmentResponse withAdjustedIncomeValue(BigDecimal adjustedIncomeValue) {
        this.adjustedIncomeValue = adjustedIncomeValue;
        return this;
    }

    @JsonProperty(value="adjustedLivingAllowance")
    public BigDecimal getAdjustedLivingAllowance() {
        return this.adjustedLivingAllowance;
    }

    @JsonProperty(value="adjustedLivingAllowance")
    public void setAdjustedLivingAllowance(BigDecimal adjustedLivingAllowance) {
        this.adjustedLivingAllowance = adjustedLivingAllowance;
    }

    public ApiMeansAssessmentResponse withAdjustedLivingAllowance(BigDecimal adjustedLivingAllowance) {
        this.adjustedLivingAllowance = adjustedLivingAllowance;
        return this;
    }

    @JsonProperty(value="totalAggregatedExpense")
    public BigDecimal getTotalAggregatedExpense() {
        return this.totalAggregatedExpense;
    }

    @JsonProperty(value="totalAggregatedExpense")
    public void setTotalAggregatedExpense(BigDecimal totalAggregatedExpense) {
        this.totalAggregatedExpense = totalAggregatedExpense;
    }

    public ApiMeansAssessmentResponse withTotalAggregatedExpense(BigDecimal totalAggregatedExpense) {
        this.totalAggregatedExpense = totalAggregatedExpense;
        return this;
    }

    @JsonProperty(value="totalAnnualDisposableIncome")
    public BigDecimal getTotalAnnualDisposableIncome() {
        return this.totalAnnualDisposableIncome;
    }

    @JsonProperty(value="totalAnnualDisposableIncome")
    public void setTotalAnnualDisposableIncome(BigDecimal totalAnnualDisposableIncome) {
        this.totalAnnualDisposableIncome = totalAnnualDisposableIncome;
    }

    public ApiMeansAssessmentResponse withTotalAnnualDisposableIncome(BigDecimal totalAnnualDisposableIncome) {
        this.totalAnnualDisposableIncome = totalAnnualDisposableIncome;
        return this;
    }

    @JsonProperty(value="lowerThreshold")
    public BigDecimal getLowerThreshold() {
        return this.lowerThreshold;
    }

    @JsonProperty(value="lowerThreshold")
    public void setLowerThreshold(BigDecimal lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
    }

    public ApiMeansAssessmentResponse withLowerThreshold(BigDecimal lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
        return this;
    }

    @JsonProperty(value="upperThreshold")
    public BigDecimal getUpperThreshold() {
        return this.upperThreshold;
    }

    @JsonProperty(value="upperThreshold")
    public void setUpperThreshold(BigDecimal upperThreshold) {
        this.upperThreshold = upperThreshold;
    }

    public ApiMeansAssessmentResponse withUpperThreshold(BigDecimal upperThreshold) {
        this.upperThreshold = upperThreshold;
        return this;
    }

    @JsonProperty(value="fullThreshold")
    public BigDecimal getFullThreshold() {
        return this.fullThreshold;
    }

    @JsonProperty(value="fullThreshold")
    public void setFullThreshold(BigDecimal fullThreshold) {
        this.fullThreshold = fullThreshold;
    }

    public ApiMeansAssessmentResponse withFullThreshold(BigDecimal fullThreshold) {
        this.fullThreshold = fullThreshold;
        return this;
    }

    @JsonProperty(value="assessmentType")
    public AssessmentType getAssessmentType() {
        return this.assessmentType;
    }

    @JsonProperty(value="assessmentType")
    public void setAssessmentType(AssessmentType assessmentType) {
        this.assessmentType = assessmentType;
    }

    public ApiMeansAssessmentResponse withAssessmentType(AssessmentType assessmentType) {
        this.assessmentType = assessmentType;
        return this;
    }

    @JsonProperty(value="initResult")
    public String getInitResult() {
        return this.initResult;
    }

    @JsonProperty(value="initResult")
    public void setInitResult(String initResult) {
        this.initResult = initResult;
    }

    public ApiMeansAssessmentResponse withInitResult(String initResult) {
        this.initResult = initResult;
        return this;
    }

    @JsonProperty(value="initResultReason")
    public String getInitResultReason() {
        return this.initResultReason;
    }

    @JsonProperty(value="initResultReason")
    public void setInitResultReason(String initResultReason) {
        this.initResultReason = initResultReason;
    }

    public ApiMeansAssessmentResponse withInitResultReason(String initResultReason) {
        this.initResultReason = initResultReason;
        return this;
    }

    @JsonProperty(value="initialAssessmentDate")
    public LocalDateTime getInitialAssessmentDate() {
        return this.initialAssessmentDate;
    }

    @JsonProperty(value="initialAssessmentDate")
    public void setInitialAssessmentDate(LocalDateTime initialAssessmentDate) {
        this.initialAssessmentDate = initialAssessmentDate;
    }

    public ApiMeansAssessmentResponse withInitialAssessmentDate(LocalDateTime initialAssessmentDate) {
        this.initialAssessmentDate = initialAssessmentDate;
        return this;
    }

    @JsonProperty(value="fassInitStatus")
    public CurrentStatus getFassInitStatus() {
        return this.fassInitStatus;
    }

    @JsonProperty(value="fassInitStatus")
    public void setFassInitStatus(CurrentStatus fassInitStatus) {
        this.fassInitStatus = fassInitStatus;
    }

    public ApiMeansAssessmentResponse withFassInitStatus(CurrentStatus fassInitStatus) {
        this.fassInitStatus = fassInitStatus;
        return this;
    }

    @JsonProperty(value="fullResult")
    public String getFullResult() {
        return this.fullResult;
    }

    @JsonProperty(value="fullResult")
    public void setFullResult(String fullResult) {
        this.fullResult = fullResult;
    }

    public ApiMeansAssessmentResponse withFullResult(String fullResult) {
        this.fullResult = fullResult;
        return this;
    }

    @JsonProperty(value="fullResultReason")
    public String getFullResultReason() {
        return this.fullResultReason;
    }

    @JsonProperty(value="fullResultReason")
    public void setFullResultReason(String fullResultReason) {
        this.fullResultReason = fullResultReason;
    }

    public ApiMeansAssessmentResponse withFullResultReason(String fullResultReason) {
        this.fullResultReason = fullResultReason;
        return this;
    }

    @JsonProperty(value="fullAssessmentDate")
    public LocalDateTime getFullAssessmentDate() {
        return this.fullAssessmentDate;
    }

    @JsonProperty(value="fullAssessmentDate")
    public void setFullAssessmentDate(LocalDateTime fullAssessmentDate) {
        this.fullAssessmentDate = fullAssessmentDate;
    }

    public ApiMeansAssessmentResponse withFullAssessmentDate(LocalDateTime fullAssessmentDate) {
        this.fullAssessmentDate = fullAssessmentDate;
        return this;
    }

    @JsonProperty(value="fassFullStatus")
    public CurrentStatus getFassFullStatus() {
        return this.fassFullStatus;
    }

    @JsonProperty(value="fassFullStatus")
    public void setFassFullStatus(CurrentStatus fassFullStatus) {
        this.fassFullStatus = fassFullStatus;
    }

    public ApiMeansAssessmentResponse withFassFullStatus(CurrentStatus fassFullStatus) {
        this.fassFullStatus = fassFullStatus;
        return this;
    }

    @JsonProperty(value="assessmentSectionSummary")
    public List<ApiAssessmentSectionSummary> getAssessmentSectionSummary() {
        return this.assessmentSectionSummary;
    }

    @JsonProperty(value="assessmentSectionSummary")
    public void setAssessmentSectionSummary(List<ApiAssessmentSectionSummary> assessmentSectionSummary) {
        this.assessmentSectionSummary = assessmentSectionSummary;
    }

    public ApiMeansAssessmentResponse withAssessmentSectionSummary(List<ApiAssessmentSectionSummary> assessmentSectionSummary) {
        this.assessmentSectionSummary = assessmentSectionSummary;
        return this;
    }

    @JsonProperty(value="assessmentSummary")
    public List<ApiAssessmentSummary> getAssessmentSummary() {
        return this.assessmentSummary;
    }

    @JsonProperty(value="assessmentSummary")
    public void setAssessmentSummary(List<ApiAssessmentSummary> assessmentSummary) {
        this.assessmentSummary = assessmentSummary;
    }

    public ApiMeansAssessmentResponse withAssessmentSummary(List<ApiAssessmentSummary> assessmentSummary) {
        this.assessmentSummary = assessmentSummary;
        return this;
    }

    @JsonProperty(value="childWeightings")
    public List<ApiAssessmentChildWeighting> getChildWeightings() {
        return this.childWeightings;
    }

    @JsonProperty(value="childWeightings")
    public void setChildWeightings(List<ApiAssessmentChildWeighting> childWeightings) {
        this.childWeightings = childWeightings;
    }

    public ApiMeansAssessmentResponse withChildWeightings(List<ApiAssessmentChildWeighting> childWeightings) {
        this.childWeightings = childWeightings;
        return this;
    }

    @JsonProperty(value="incomeEvidence")
    public List<ApiIncomeEvidence> getIncomeEvidence() {
        return this.incomeEvidence;
    }

    @JsonProperty(value="incomeEvidence")
    public void setIncomeEvidence(List<ApiIncomeEvidence> incomeEvidence) {
        this.incomeEvidence = incomeEvidence;
    }

    public ApiMeansAssessmentResponse withIncomeEvidence(List<ApiIncomeEvidence> incomeEvidence) {
        this.incomeEvidence = incomeEvidence;
        return this;
    }

    @JsonProperty(value="fullAssessmentAvailable")
    public Boolean getFullAssessmentAvailable() {
        return this.fullAssessmentAvailable;
    }

    @JsonProperty(value="fullAssessmentAvailable")
    public void setFullAssessmentAvailable(Boolean fullAssessmentAvailable) {
        this.fullAssessmentAvailable = fullAssessmentAvailable;
    }

    public ApiMeansAssessmentResponse withFullAssessmentAvailable(Boolean fullAssessmentAvailable) {
        this.fullAssessmentAvailable = fullAssessmentAvailable;
        return this;
    }

    @JsonProperty(value="reviewType")
    public ReviewType getReviewType() {
        return this.reviewType;
    }

    @JsonProperty(value="reviewType")
    public void setReviewType(ReviewType reviewType) {
        this.reviewType = reviewType;
    }

    public ApiMeansAssessmentResponse withReviewType(ReviewType reviewType) {
        this.reviewType = reviewType;
        return this;
    }

    @JsonProperty(value="updated")
    public LocalDateTime getUpdated() {
        return this.updated;
    }

    @JsonProperty(value="updated")
    public void setUpdated(LocalDateTime updated) {
        this.updated = updated;
    }

    public ApiMeansAssessmentResponse withUpdated(LocalDateTime updated) {
        this.updated = updated;
        return this;
    }

    @JsonProperty(value="applicationTimestamp")
    public LocalDateTime getApplicationTimestamp() {
        return this.applicationTimestamp;
    }

    @JsonProperty(value="applicationTimestamp")
    public void setApplicationTimestamp(LocalDateTime applicationTimestamp) {
        this.applicationTimestamp = applicationTimestamp;
    }

    public ApiMeansAssessmentResponse withApplicationTimestamp(LocalDateTime applicationTimestamp) {
        this.applicationTimestamp = applicationTimestamp;
        return this;
    }

    @JsonProperty(value="dateCompleted")
    public LocalDateTime getDateCompleted() {
        return this.dateCompleted;
    }

    @JsonProperty(value="dateCompleted")
    public void setDateCompleted(LocalDateTime dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    public ApiMeansAssessmentResponse withDateCompleted(LocalDateTime dateCompleted) {
        this.dateCompleted = dateCompleted;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("assessmentId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"assessmentId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setAssessmentId((Integer)value);
            return true;
        }
        if ("repId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"repId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setRepId((Integer)value);
            return true;
        }
        if ("criteriaId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"criteriaId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setCriteriaId((Integer)value);
            return true;
        }
        if ("transactionDateTime".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"transactionDateTime\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setTransactionDateTime((LocalDateTime)value);
            return true;
        }
        if ("totalAggregatedIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"totalAggregatedIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setTotalAggregatedIncome((BigDecimal)value);
            return true;
        }
        if ("adjustedIncomeValue".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"adjustedIncomeValue\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setAdjustedIncomeValue((BigDecimal)value);
            return true;
        }
        if ("adjustedLivingAllowance".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"adjustedLivingAllowance\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setAdjustedLivingAllowance((BigDecimal)value);
            return true;
        }
        if ("totalAggregatedExpense".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"totalAggregatedExpense\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setTotalAggregatedExpense((BigDecimal)value);
            return true;
        }
        if ("totalAnnualDisposableIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"totalAnnualDisposableIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setTotalAnnualDisposableIncome((BigDecimal)value);
            return true;
        }
        if ("lowerThreshold".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"lowerThreshold\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setLowerThreshold((BigDecimal)value);
            return true;
        }
        if ("upperThreshold".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"upperThreshold\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setUpperThreshold((BigDecimal)value);
            return true;
        }
        if ("fullThreshold".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"fullThreshold\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setFullThreshold((BigDecimal)value);
            return true;
        }
        if ("assessmentType".equals(name)) {
            if (!(value instanceof AssessmentType)) {
                throw new IllegalArgumentException("property \"assessmentType\" is of type \"uk.gov.justice.laa.crime.enums.AssessmentType\", but got " + value.getClass().toString());
            }
            this.setAssessmentType((AssessmentType)value);
            return true;
        }
        if ("initResult".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initResult\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitResult((String)value);
            return true;
        }
        if ("initResultReason".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initResultReason\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitResultReason((String)value);
            return true;
        }
        if ("initialAssessmentDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"initialAssessmentDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setInitialAssessmentDate((LocalDateTime)value);
            return true;
        }
        if ("fassInitStatus".equals(name)) {
            if (!(value instanceof CurrentStatus)) {
                throw new IllegalArgumentException("property \"fassInitStatus\" is of type \"uk.gov.justice.laa.crime.enums.CurrentStatus\", but got " + value.getClass().toString());
            }
            this.setFassInitStatus((CurrentStatus)value);
            return true;
        }
        if ("fullResult".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fullResult\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFullResult((String)value);
            return true;
        }
        if ("fullResultReason".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fullResultReason\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFullResultReason((String)value);
            return true;
        }
        if ("fullAssessmentDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"fullAssessmentDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setFullAssessmentDate((LocalDateTime)value);
            return true;
        }
        if ("fassFullStatus".equals(name)) {
            if (!(value instanceof CurrentStatus)) {
                throw new IllegalArgumentException("property \"fassFullStatus\" is of type \"uk.gov.justice.laa.crime.enums.CurrentStatus\", but got " + value.getClass().toString());
            }
            this.setFassFullStatus((CurrentStatus)value);
            return true;
        }
        if ("assessmentSectionSummary".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"assessmentSectionSummary\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentSectionSummary>\", but got " + value.getClass().toString());
            }
            this.setAssessmentSectionSummary((List)value);
            return true;
        }
        if ("assessmentSummary".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"assessmentSummary\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentSummary>\", but got " + value.getClass().toString());
            }
            this.setAssessmentSummary((List)value);
            return true;
        }
        if ("childWeightings".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"childWeightings\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentChildWeighting>\", but got " + value.getClass().toString());
            }
            this.setChildWeightings((List)value);
            return true;
        }
        if ("incomeEvidence".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"incomeEvidence\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiIncomeEvidence>\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidence((List)value);
            return true;
        }
        if ("fullAssessmentAvailable".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"fullAssessmentAvailable\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setFullAssessmentAvailable((Boolean)value);
            return true;
        }
        if ("reviewType".equals(name)) {
            if (!(value instanceof ReviewType)) {
                throw new IllegalArgumentException("property \"reviewType\" is of type \"uk.gov.justice.laa.crime.enums.ReviewType\", but got " + value.getClass().toString());
            }
            this.setReviewType((ReviewType)value);
            return true;
        }
        if ("updated".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"updated\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setUpdated((LocalDateTime)value);
            return true;
        }
        if ("applicationTimestamp".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"applicationTimestamp\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setApplicationTimestamp((LocalDateTime)value);
            return true;
        }
        if ("dateCompleted".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"dateCompleted\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setDateCompleted((LocalDateTime)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("assessmentId".equals(name)) {
            return this.getAssessmentId();
        }
        if ("repId".equals(name)) {
            return this.getRepId();
        }
        if ("criteriaId".equals(name)) {
            return this.getCriteriaId();
        }
        if ("transactionDateTime".equals(name)) {
            return this.getTransactionDateTime();
        }
        if ("totalAggregatedIncome".equals(name)) {
            return this.getTotalAggregatedIncome();
        }
        if ("adjustedIncomeValue".equals(name)) {
            return this.getAdjustedIncomeValue();
        }
        if ("adjustedLivingAllowance".equals(name)) {
            return this.getAdjustedLivingAllowance();
        }
        if ("totalAggregatedExpense".equals(name)) {
            return this.getTotalAggregatedExpense();
        }
        if ("totalAnnualDisposableIncome".equals(name)) {
            return this.getTotalAnnualDisposableIncome();
        }
        if ("lowerThreshold".equals(name)) {
            return this.getLowerThreshold();
        }
        if ("upperThreshold".equals(name)) {
            return this.getUpperThreshold();
        }
        if ("fullThreshold".equals(name)) {
            return this.getFullThreshold();
        }
        if ("assessmentType".equals(name)) {
            return this.getAssessmentType();
        }
        if ("initResult".equals(name)) {
            return this.getInitResult();
        }
        if ("initResultReason".equals(name)) {
            return this.getInitResultReason();
        }
        if ("initialAssessmentDate".equals(name)) {
            return this.getInitialAssessmentDate();
        }
        if ("fassInitStatus".equals(name)) {
            return this.getFassInitStatus();
        }
        if ("fullResult".equals(name)) {
            return this.getFullResult();
        }
        if ("fullResultReason".equals(name)) {
            return this.getFullResultReason();
        }
        if ("fullAssessmentDate".equals(name)) {
            return this.getFullAssessmentDate();
        }
        if ("fassFullStatus".equals(name)) {
            return this.getFassFullStatus();
        }
        if ("assessmentSectionSummary".equals(name)) {
            return this.getAssessmentSectionSummary();
        }
        if ("assessmentSummary".equals(name)) {
            return this.getAssessmentSummary();
        }
        if ("childWeightings".equals(name)) {
            return this.getChildWeightings();
        }
        if ("incomeEvidence".equals(name)) {
            return this.getIncomeEvidence();
        }
        if ("fullAssessmentAvailable".equals(name)) {
            return this.getFullAssessmentAvailable();
        }
        if ("reviewType".equals(name)) {
            return this.getReviewType();
        }
        if ("updated".equals(name)) {
            return this.getUpdated();
        }
        if ("applicationTimestamp".equals(name)) {
            return this.getApplicationTimestamp();
        }
        if ("dateCompleted".equals(name)) {
            return this.getDateCompleted();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiMeansAssessmentResponse with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiMeansAssessmentResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("assessmentId");
        sb.append('=');
        sb.append(this.assessmentId == null ? "<null>" : this.assessmentId);
        sb.append(',');
        sb.append("repId");
        sb.append('=');
        sb.append(this.repId == null ? "<null>" : this.repId);
        sb.append(',');
        sb.append("criteriaId");
        sb.append('=');
        sb.append(this.criteriaId == null ? "<null>" : this.criteriaId);
        sb.append(',');
        sb.append("transactionDateTime");
        sb.append('=');
        sb.append(this.transactionDateTime == null ? "<null>" : this.transactionDateTime);
        sb.append(',');
        sb.append("totalAggregatedIncome");
        sb.append('=');
        sb.append(this.totalAggregatedIncome == null ? "<null>" : this.totalAggregatedIncome);
        sb.append(',');
        sb.append("adjustedIncomeValue");
        sb.append('=');
        sb.append(this.adjustedIncomeValue == null ? "<null>" : this.adjustedIncomeValue);
        sb.append(',');
        sb.append("adjustedLivingAllowance");
        sb.append('=');
        sb.append(this.adjustedLivingAllowance == null ? "<null>" : this.adjustedLivingAllowance);
        sb.append(',');
        sb.append("totalAggregatedExpense");
        sb.append('=');
        sb.append(this.totalAggregatedExpense == null ? "<null>" : this.totalAggregatedExpense);
        sb.append(',');
        sb.append("totalAnnualDisposableIncome");
        sb.append('=');
        sb.append(this.totalAnnualDisposableIncome == null ? "<null>" : this.totalAnnualDisposableIncome);
        sb.append(',');
        sb.append("lowerThreshold");
        sb.append('=');
        sb.append(this.lowerThreshold == null ? "<null>" : this.lowerThreshold);
        sb.append(',');
        sb.append("upperThreshold");
        sb.append('=');
        sb.append(this.upperThreshold == null ? "<null>" : this.upperThreshold);
        sb.append(',');
        sb.append("fullThreshold");
        sb.append('=');
        sb.append(this.fullThreshold == null ? "<null>" : this.fullThreshold);
        sb.append(',');
        sb.append("assessmentType");
        sb.append('=');
        sb.append((Object)(this.assessmentType == null ? "<null>" : this.assessmentType));
        sb.append(',');
        sb.append("initResult");
        sb.append('=');
        sb.append(this.initResult == null ? "<null>" : this.initResult);
        sb.append(',');
        sb.append("initResultReason");
        sb.append('=');
        sb.append(this.initResultReason == null ? "<null>" : this.initResultReason);
        sb.append(',');
        sb.append("initialAssessmentDate");
        sb.append('=');
        sb.append(this.initialAssessmentDate == null ? "<null>" : this.initialAssessmentDate);
        sb.append(',');
        sb.append("fassInitStatus");
        sb.append('=');
        sb.append((Object)(this.fassInitStatus == null ? "<null>" : this.fassInitStatus));
        sb.append(',');
        sb.append("fullResult");
        sb.append('=');
        sb.append(this.fullResult == null ? "<null>" : this.fullResult);
        sb.append(',');
        sb.append("fullResultReason");
        sb.append('=');
        sb.append(this.fullResultReason == null ? "<null>" : this.fullResultReason);
        sb.append(',');
        sb.append("fullAssessmentDate");
        sb.append('=');
        sb.append(this.fullAssessmentDate == null ? "<null>" : this.fullAssessmentDate);
        sb.append(',');
        sb.append("fassFullStatus");
        sb.append('=');
        sb.append((Object)(this.fassFullStatus == null ? "<null>" : this.fassFullStatus));
        sb.append(',');
        sb.append("assessmentSectionSummary");
        sb.append('=');
        sb.append(this.assessmentSectionSummary == null ? "<null>" : this.assessmentSectionSummary);
        sb.append(',');
        sb.append("assessmentSummary");
        sb.append('=');
        sb.append(this.assessmentSummary == null ? "<null>" : this.assessmentSummary);
        sb.append(',');
        sb.append("childWeightings");
        sb.append('=');
        sb.append(this.childWeightings == null ? "<null>" : this.childWeightings);
        sb.append(',');
        sb.append("incomeEvidence");
        sb.append('=');
        sb.append(this.incomeEvidence == null ? "<null>" : this.incomeEvidence);
        sb.append(',');
        sb.append("fullAssessmentAvailable");
        sb.append('=');
        sb.append(this.fullAssessmentAvailable == null ? "<null>" : this.fullAssessmentAvailable);
        sb.append(',');
        sb.append("reviewType");
        sb.append('=');
        sb.append((Object)(this.reviewType == null ? "<null>" : this.reviewType));
        sb.append(',');
        sb.append("updated");
        sb.append('=');
        sb.append(this.updated == null ? "<null>" : this.updated);
        sb.append(',');
        sb.append("applicationTimestamp");
        sb.append('=');
        sb.append(this.applicationTimestamp == null ? "<null>" : this.applicationTimestamp);
        sb.append(',');
        sb.append("dateCompleted");
        sb.append('=');
        sb.append(this.dateCompleted == null ? "<null>" : this.dateCompleted);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.upperThreshold == null ? 0 : this.upperThreshold.hashCode());
        result = result * 31 + (this.assessmentType == null ? 0 : this.assessmentType.hashCode());
        result = result * 31 + (this.criteriaId == null ? 0 : this.criteriaId.hashCode());
        result = result * 31 + (this.fullAssessmentDate == null ? 0 : this.fullAssessmentDate.hashCode());
        result = result * 31 + (this.reviewType == null ? 0 : this.reviewType.hashCode());
        result = result * 31 + (this.totalAnnualDisposableIncome == null ? 0 : this.totalAnnualDisposableIncome.hashCode());
        result = result * 31 + (this.fullResult == null ? 0 : this.fullResult.hashCode());
        result = result * 31 + (this.fullResultReason == null ? 0 : this.fullResultReason.hashCode());
        result = result * 31 + (this.initialAssessmentDate == null ? 0 : this.initialAssessmentDate.hashCode());
        result = result * 31 + (this.dateCompleted == null ? 0 : this.dateCompleted.hashCode());
        result = result * 31 + (this.fassInitStatus == null ? 0 : this.fassInitStatus.hashCode());
        result = result * 31 + (this.totalAggregatedExpense == null ? 0 : this.totalAggregatedExpense.hashCode());
        result = result * 31 + (this.assessmentId == null ? 0 : this.assessmentId.hashCode());
        result = result * 31 + (this.lowerThreshold == null ? 0 : this.lowerThreshold.hashCode());
        result = result * 31 + (this.assessmentSectionSummary == null ? 0 : this.assessmentSectionSummary.hashCode());
        result = result * 31 + (this.adjustedIncomeValue == null ? 0 : this.adjustedIncomeValue.hashCode());
        result = result * 31 + (this.assessmentSummary == null ? 0 : this.assessmentSummary.hashCode());
        result = result * 31 + (this.transactionDateTime == null ? 0 : this.transactionDateTime.hashCode());
        result = result * 31 + (this.initResult == null ? 0 : this.initResult.hashCode());
        result = result * 31 + (this.initResultReason == null ? 0 : this.initResultReason.hashCode());
        result = result * 31 + (this.applicationTimestamp == null ? 0 : this.applicationTimestamp.hashCode());
        result = result * 31 + (this.fassFullStatus == null ? 0 : this.fassFullStatus.hashCode());
        result = result * 31 + (this.adjustedLivingAllowance == null ? 0 : this.adjustedLivingAllowance.hashCode());
        result = result * 31 + (this.fullThreshold == null ? 0 : this.fullThreshold.hashCode());
        result = result * 31 + (this.repId == null ? 0 : this.repId.hashCode());
        result = result * 31 + (this.fullAssessmentAvailable == null ? 0 : this.fullAssessmentAvailable.hashCode());
        result = result * 31 + (this.childWeightings == null ? 0 : this.childWeightings.hashCode());
        result = result * 31 + (this.incomeEvidence == null ? 0 : this.incomeEvidence.hashCode());
        result = result * 31 + (this.totalAggregatedIncome == null ? 0 : this.totalAggregatedIncome.hashCode());
        result = result * 31 + (this.updated == null ? 0 : this.updated.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiMeansAssessmentResponse)) {
            return false;
        }
        ApiMeansAssessmentResponse rhs = (ApiMeansAssessmentResponse)other;
        return (this.upperThreshold == rhs.upperThreshold || this.upperThreshold != null && this.upperThreshold.equals(rhs.upperThreshold)) && (this.assessmentType == rhs.assessmentType || this.assessmentType != null && this.assessmentType.equals((Object)rhs.assessmentType)) && (this.criteriaId == rhs.criteriaId || this.criteriaId != null && this.criteriaId.equals(rhs.criteriaId)) && (this.fullAssessmentDate == rhs.fullAssessmentDate || this.fullAssessmentDate != null && this.fullAssessmentDate.equals(rhs.fullAssessmentDate)) && (this.reviewType == rhs.reviewType || this.reviewType != null && this.reviewType.equals((Object)rhs.reviewType)) && (this.totalAnnualDisposableIncome == rhs.totalAnnualDisposableIncome || this.totalAnnualDisposableIncome != null && this.totalAnnualDisposableIncome.equals(rhs.totalAnnualDisposableIncome)) && (this.fullResult == rhs.fullResult || this.fullResult != null && this.fullResult.equals(rhs.fullResult)) && (this.fullResultReason == rhs.fullResultReason || this.fullResultReason != null && this.fullResultReason.equals(rhs.fullResultReason)) && (this.initialAssessmentDate == rhs.initialAssessmentDate || this.initialAssessmentDate != null && this.initialAssessmentDate.equals(rhs.initialAssessmentDate)) && (this.dateCompleted == rhs.dateCompleted || this.dateCompleted != null && this.dateCompleted.equals(rhs.dateCompleted)) && (this.fassInitStatus == rhs.fassInitStatus || this.fassInitStatus != null && this.fassInitStatus.equals((Object)rhs.fassInitStatus)) && (this.totalAggregatedExpense == rhs.totalAggregatedExpense || this.totalAggregatedExpense != null && this.totalAggregatedExpense.equals(rhs.totalAggregatedExpense)) && (this.assessmentId == rhs.assessmentId || this.assessmentId != null && this.assessmentId.equals(rhs.assessmentId)) && (this.lowerThreshold == rhs.lowerThreshold || this.lowerThreshold != null && this.lowerThreshold.equals(rhs.lowerThreshold)) && (this.assessmentSectionSummary == rhs.assessmentSectionSummary || this.assessmentSectionSummary != null && this.assessmentSectionSummary.equals(rhs.assessmentSectionSummary)) && (this.adjustedIncomeValue == rhs.adjustedIncomeValue || this.adjustedIncomeValue != null && this.adjustedIncomeValue.equals(rhs.adjustedIncomeValue)) && (this.assessmentSummary == rhs.assessmentSummary || this.assessmentSummary != null && this.assessmentSummary.equals(rhs.assessmentSummary)) && (this.transactionDateTime == rhs.transactionDateTime || this.transactionDateTime != null && this.transactionDateTime.equals(rhs.transactionDateTime)) && (this.initResult == rhs.initResult || this.initResult != null && this.initResult.equals(rhs.initResult)) && (this.initResultReason == rhs.initResultReason || this.initResultReason != null && this.initResultReason.equals(rhs.initResultReason)) && (this.applicationTimestamp == rhs.applicationTimestamp || this.applicationTimestamp != null && this.applicationTimestamp.equals(rhs.applicationTimestamp)) && (this.fassFullStatus == rhs.fassFullStatus || this.fassFullStatus != null && this.fassFullStatus.equals((Object)rhs.fassFullStatus)) && (this.adjustedLivingAllowance == rhs.adjustedLivingAllowance || this.adjustedLivingAllowance != null && this.adjustedLivingAllowance.equals(rhs.adjustedLivingAllowance)) && (this.fullThreshold == rhs.fullThreshold || this.fullThreshold != null && this.fullThreshold.equals(rhs.fullThreshold)) && (this.repId == rhs.repId || this.repId != null && this.repId.equals(rhs.repId)) && (this.fullAssessmentAvailable == rhs.fullAssessmentAvailable || this.fullAssessmentAvailable != null && this.fullAssessmentAvailable.equals(rhs.fullAssessmentAvailable)) && (this.childWeightings == rhs.childWeightings || this.childWeightings != null && this.childWeightings.equals(rhs.childWeightings)) && (this.incomeEvidence == rhs.incomeEvidence || this.incomeEvidence != null && this.incomeEvidence.equals(rhs.incomeEvidence)) && (this.totalAggregatedIncome == rhs.totalAggregatedIncome || this.totalAggregatedIncome != null && this.totalAggregatedIncome.equals(rhs.totalAggregatedIncome)) && (this.updated == rhs.updated || this.updated != null && this.updated.equals(rhs.updated));
    }
}

