/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.common.ApiUserSession;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentChildWeighting;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentSectionSummary;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiCrownCourtOverview;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiIncomeEvidence;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiIncomeEvidenceSummary;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiMeansAssessmentRequest;
import uk.gov.justice.laa.crime.enums.AssessmentType;
import uk.gov.justice.laa.crime.enums.CaseType;
import uk.gov.justice.laa.crime.enums.CurrentStatus;
import uk.gov.justice.laa.crime.enums.MagCourtOutcome;
import uk.gov.justice.laa.crime.enums.NewWorkReason;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"financialAssessmentId", "fullAssessmentDate", "otherHousingNote", "initTotalAggregatedIncome", "fullAssessmentNotes", "incomeEvidence"})
public class ApiUpdateMeansAssessmentRequest
extends ApiMeansAssessmentRequest {
    @JsonProperty(value="financialAssessmentId")
    @JsonPropertyDescription(value="The ID of the financial assessment being updated")
    private Integer financialAssessmentId;
    @JsonProperty(value="fullAssessmentDate")
    @JsonPropertyDescription(value="Effective Date of full assessment")
    private LocalDateTime fullAssessmentDate;
    @JsonProperty(value="otherHousingNote")
    @JsonPropertyDescription(value="Other housing note field.")
    private String otherHousingNote;
    @JsonProperty(value="initTotalAggregatedIncome")
    @JsonPropertyDescription(value="The total aggregated income calculated during the initial assessment")
    @NotNull
    private BigDecimal initTotalAggregatedIncome;
    @JsonProperty(value="fullAssessmentNotes")
    @JsonPropertyDescription(value="Full assessment notes field.")
    private String fullAssessmentNotes;
    @JsonProperty(value="incomeEvidence")
    @JsonPropertyDescription(value="Income evidence.")
    @Valid
    private List<ApiIncomeEvidence> incomeEvidence = new ArrayList<ApiIncomeEvidence>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiUpdateMeansAssessmentRequest() {
    }

    public ApiUpdateMeansAssessmentRequest(Integer financialAssessmentId, LocalDateTime fullAssessmentDate, String otherHousingNote, BigDecimal initTotalAggregatedIncome, String fullAssessmentNotes, List<ApiIncomeEvidence> incomeEvidence, String laaTransactionId, Integer repId, Integer cmuId, LocalDateTime initialAssessmentDate, String otherBenefitNote, String otherIncomeNote, String employmentStatus, String initAssessmentNotes, CurrentStatus assessmentStatus, List<ApiAssessmentSectionSummary> sectionSummaries, List<ApiAssessmentChildWeighting> childWeightings, Boolean hasPartner, Boolean partnerContraryInterest, AssessmentType assessmentType, CaseType caseType, ApiUserSession userSession, ApiIncomeEvidenceSummary incomeEvidenceSummary, ApiCrownCourtOverview crownCourtOverview, MagCourtOutcome magCourtOutcome, NewWorkReason newWorkReason) {
        super(laaTransactionId, repId, cmuId, initialAssessmentDate, otherBenefitNote, otherIncomeNote, employmentStatus, initAssessmentNotes, assessmentStatus, sectionSummaries, childWeightings, hasPartner, partnerContraryInterest, assessmentType, caseType, userSession, incomeEvidenceSummary, crownCourtOverview, magCourtOutcome, newWorkReason);
        this.financialAssessmentId = financialAssessmentId;
        this.fullAssessmentDate = fullAssessmentDate;
        this.otherHousingNote = otherHousingNote;
        this.initTotalAggregatedIncome = initTotalAggregatedIncome;
        this.fullAssessmentNotes = fullAssessmentNotes;
        this.incomeEvidence = incomeEvidence;
    }

    @JsonProperty(value="financialAssessmentId")
    public Integer getFinancialAssessmentId() {
        return this.financialAssessmentId;
    }

    @JsonProperty(value="financialAssessmentId")
    public void setFinancialAssessmentId(Integer financialAssessmentId) {
        this.financialAssessmentId = financialAssessmentId;
    }

    public ApiUpdateMeansAssessmentRequest withFinancialAssessmentId(Integer financialAssessmentId) {
        this.financialAssessmentId = financialAssessmentId;
        return this;
    }

    @JsonProperty(value="fullAssessmentDate")
    public LocalDateTime getFullAssessmentDate() {
        return this.fullAssessmentDate;
    }

    @JsonProperty(value="fullAssessmentDate")
    public void setFullAssessmentDate(LocalDateTime fullAssessmentDate) {
        this.fullAssessmentDate = fullAssessmentDate;
    }

    public ApiUpdateMeansAssessmentRequest withFullAssessmentDate(LocalDateTime fullAssessmentDate) {
        this.fullAssessmentDate = fullAssessmentDate;
        return this;
    }

    @JsonProperty(value="otherHousingNote")
    public String getOtherHousingNote() {
        return this.otherHousingNote;
    }

    @JsonProperty(value="otherHousingNote")
    public void setOtherHousingNote(String otherHousingNote) {
        this.otherHousingNote = otherHousingNote;
    }

    public ApiUpdateMeansAssessmentRequest withOtherHousingNote(String otherHousingNote) {
        this.otherHousingNote = otherHousingNote;
        return this;
    }

    @JsonProperty(value="initTotalAggregatedIncome")
    public BigDecimal getInitTotalAggregatedIncome() {
        return this.initTotalAggregatedIncome;
    }

    @JsonProperty(value="initTotalAggregatedIncome")
    public void setInitTotalAggregatedIncome(BigDecimal initTotalAggregatedIncome) {
        this.initTotalAggregatedIncome = initTotalAggregatedIncome;
    }

    public ApiUpdateMeansAssessmentRequest withInitTotalAggregatedIncome(BigDecimal initTotalAggregatedIncome) {
        this.initTotalAggregatedIncome = initTotalAggregatedIncome;
        return this;
    }

    @JsonProperty(value="fullAssessmentNotes")
    public String getFullAssessmentNotes() {
        return this.fullAssessmentNotes;
    }

    @JsonProperty(value="fullAssessmentNotes")
    public void setFullAssessmentNotes(String fullAssessmentNotes) {
        this.fullAssessmentNotes = fullAssessmentNotes;
    }

    public ApiUpdateMeansAssessmentRequest withFullAssessmentNotes(String fullAssessmentNotes) {
        this.fullAssessmentNotes = fullAssessmentNotes;
        return this;
    }

    @JsonProperty(value="incomeEvidence")
    public List<ApiIncomeEvidence> getIncomeEvidence() {
        return this.incomeEvidence;
    }

    @JsonProperty(value="incomeEvidence")
    public void setIncomeEvidence(List<ApiIncomeEvidence> incomeEvidence) {
        this.incomeEvidence = incomeEvidence;
    }

    public ApiUpdateMeansAssessmentRequest withIncomeEvidence(List<ApiIncomeEvidence> incomeEvidence) {
        this.incomeEvidence = incomeEvidence;
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withLaaTransactionId(String laaTransactionId) {
        super.withLaaTransactionId(laaTransactionId);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withRepId(Integer repId) {
        super.withRepId(repId);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withCmuId(Integer cmuId) {
        super.withCmuId(cmuId);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withInitialAssessmentDate(LocalDateTime initialAssessmentDate) {
        super.withInitialAssessmentDate(initialAssessmentDate);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withOtherBenefitNote(String otherBenefitNote) {
        super.withOtherBenefitNote(otherBenefitNote);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withOtherIncomeNote(String otherIncomeNote) {
        super.withOtherIncomeNote(otherIncomeNote);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withEmploymentStatus(String employmentStatus) {
        super.withEmploymentStatus(employmentStatus);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withInitAssessmentNotes(String initAssessmentNotes) {
        super.withInitAssessmentNotes(initAssessmentNotes);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withAssessmentStatus(CurrentStatus assessmentStatus) {
        super.withAssessmentStatus(assessmentStatus);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withSectionSummaries(List<ApiAssessmentSectionSummary> sectionSummaries) {
        super.withSectionSummaries(sectionSummaries);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withChildWeightings(List<ApiAssessmentChildWeighting> childWeightings) {
        super.withChildWeightings(childWeightings);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withHasPartner(Boolean hasPartner) {
        super.withHasPartner(hasPartner);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withPartnerContraryInterest(Boolean partnerContraryInterest) {
        super.withPartnerContraryInterest(partnerContraryInterest);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withAssessmentType(AssessmentType assessmentType) {
        super.withAssessmentType(assessmentType);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withCaseType(CaseType caseType) {
        super.withCaseType(caseType);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withUserSession(ApiUserSession userSession) {
        super.withUserSession(userSession);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withIncomeEvidenceSummary(ApiIncomeEvidenceSummary incomeEvidenceSummary) {
        super.withIncomeEvidenceSummary(incomeEvidenceSummary);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withCrownCourtOverview(ApiCrownCourtOverview crownCourtOverview) {
        super.withCrownCourtOverview(crownCourtOverview);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        super.withMagCourtOutcome(magCourtOutcome);
        return this;
    }

    @Override
    public ApiUpdateMeansAssessmentRequest withNewWorkReason(NewWorkReason newWorkReason) {
        super.withNewWorkReason(newWorkReason);
        return this;
    }

    @Override
    protected boolean declaredProperty(String name, Object value) {
        if ("financialAssessmentId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"financialAssessmentId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setFinancialAssessmentId((Integer)value);
            return true;
        }
        if ("fullAssessmentDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"fullAssessmentDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setFullAssessmentDate((LocalDateTime)value);
            return true;
        }
        if ("otherHousingNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"otherHousingNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOtherHousingNote((String)value);
            return true;
        }
        if ("initTotalAggregatedIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"initTotalAggregatedIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setInitTotalAggregatedIncome((BigDecimal)value);
            return true;
        }
        if ("fullAssessmentNotes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fullAssessmentNotes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFullAssessmentNotes((String)value);
            return true;
        }
        if ("incomeEvidence".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"incomeEvidence\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiIncomeEvidence>\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidence((List)value);
            return true;
        }
        return super.declaredProperty(name, value);
    }

    @Override
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("financialAssessmentId".equals(name)) {
            return this.getFinancialAssessmentId();
        }
        if ("fullAssessmentDate".equals(name)) {
            return this.getFullAssessmentDate();
        }
        if ("otherHousingNote".equals(name)) {
            return this.getOtherHousingNote();
        }
        if ("initTotalAggregatedIncome".equals(name)) {
            return this.getInitTotalAggregatedIncome();
        }
        if ("fullAssessmentNotes".equals(name)) {
            return this.getFullAssessmentNotes();
        }
        if ("incomeEvidence".equals(name)) {
            return this.getIncomeEvidence();
        }
        return super.declaredPropertyOrNotFound(name, notFoundValue);
    }

    @Override
    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    @Override
    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    @Override
    public ApiUpdateMeansAssessmentRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiUpdateMeansAssessmentRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("financialAssessmentId");
        sb.append('=');
        sb.append(this.financialAssessmentId == null ? "<null>" : this.financialAssessmentId);
        sb.append(',');
        sb.append("fullAssessmentDate");
        sb.append('=');
        sb.append(this.fullAssessmentDate == null ? "<null>" : this.fullAssessmentDate);
        sb.append(',');
        sb.append("otherHousingNote");
        sb.append('=');
        sb.append(this.otherHousingNote == null ? "<null>" : this.otherHousingNote);
        sb.append(',');
        sb.append("initTotalAggregatedIncome");
        sb.append('=');
        sb.append(this.initTotalAggregatedIncome == null ? "<null>" : this.initTotalAggregatedIncome);
        sb.append(',');
        sb.append("fullAssessmentNotes");
        sb.append('=');
        sb.append(this.fullAssessmentNotes == null ? "<null>" : this.fullAssessmentNotes);
        sb.append(',');
        sb.append("incomeEvidence");
        sb.append('=');
        sb.append(this.incomeEvidence == null ? "<null>" : this.incomeEvidence);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.otherHousingNote == null ? 0 : this.otherHousingNote.hashCode());
        result = result * 31 + (this.incomeEvidence == null ? 0 : this.incomeEvidence.hashCode());
        result = result * 31 + (this.fullAssessmentDate == null ? 0 : this.fullAssessmentDate.hashCode());
        result = result * 31 + (this.initTotalAggregatedIncome == null ? 0 : this.initTotalAggregatedIncome.hashCode());
        result = result * 31 + (this.financialAssessmentId == null ? 0 : this.financialAssessmentId.hashCode());
        result = result * 31 + (this.fullAssessmentNotes == null ? 0 : this.fullAssessmentNotes.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiUpdateMeansAssessmentRequest)) {
            return false;
        }
        ApiUpdateMeansAssessmentRequest rhs = (ApiUpdateMeansAssessmentRequest)other;
        return super.equals(rhs) && (this.otherHousingNote == rhs.otherHousingNote || this.otherHousingNote != null && this.otherHousingNote.equals(rhs.otherHousingNote)) && (this.incomeEvidence == rhs.incomeEvidence || this.incomeEvidence != null && this.incomeEvidence.equals(rhs.incomeEvidence)) && (this.fullAssessmentDate == rhs.fullAssessmentDate || this.fullAssessmentDate != null && this.fullAssessmentDate.equals(rhs.fullAssessmentDate)) && (this.initTotalAggregatedIncome == rhs.initTotalAggregatedIncome || this.initTotalAggregatedIncome != null && this.initTotalAggregatedIncome.equals(rhs.initTotalAggregatedIncome)) && (this.financialAssessmentId == rhs.financialAssessmentId || this.financialAssessmentId != null && this.financialAssessmentId.equals(rhs.financialAssessmentId)) && (this.fullAssessmentNotes == rhs.fullAssessmentNotes || this.fullAssessmentNotes != null && this.fullAssessmentNotes.equals(rhs.fullAssessmentNotes));
    }
}

