/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment.maatapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentChildWeighting;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentDetail;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"laaTransactionId", "repId", "initialAscrId", "assessmentType", "cmuId", "fassInitStatus", "initialAssessmentDate", "initOtherBenefitNote", "initOtherIncomeNote", "initTotAggregatedIncome", "initAdjustedIncomeValue", "initNotes", "initResult", "initResultReason", "incomeEvidenceDueDate", "incomeEvidenceNotes", "initApplicationEmploymentStatus", "assessmentDetails", "childWeightings", "dateCompleted"})
public class MaatApiAssessmentRequest {
    @JsonProperty(value="laaTransactionId")
    @JsonPropertyDescription(value="The correlation / transaction UUID")
    private String laaTransactionId;
    @JsonProperty(value="repId")
    @JsonPropertyDescription(value="MAAT / Rep Id")
    @NotNull
    private Integer repId;
    @JsonProperty(value="initialAscrId")
    @JsonPropertyDescription(value="Initial assessment criteria ID")
    @NotNull
    private Integer initialAscrId;
    @JsonProperty(value="assessmentType")
    @JsonPropertyDescription(value="The type of assessment")
    @NotNull
    private String assessmentType;
    @JsonProperty(value="cmuId")
    @JsonPropertyDescription(value="Case Management Unit Id")
    @NotNull
    private Integer cmuId;
    @JsonProperty(value="fassInitStatus")
    @JsonPropertyDescription(value="Initial assessment status")
    @NotNull
    private String fassInitStatus;
    @JsonProperty(value="initialAssessmentDate")
    @JsonPropertyDescription(value="Initial assessment date")
    @NotNull
    private LocalDateTime initialAssessmentDate;
    @JsonProperty(value="initOtherBenefitNote")
    @JsonPropertyDescription(value="Benefit Note")
    private String initOtherBenefitNote;
    @JsonProperty(value="initOtherIncomeNote")
    @JsonPropertyDescription(value="Income Note.")
    private String initOtherIncomeNote;
    @JsonProperty(value="initTotAggregatedIncome")
    @JsonPropertyDescription(value="Total Aggregated income of the application.")
    @NotNull
    private BigDecimal initTotAggregatedIncome;
    @JsonProperty(value="initAdjustedIncomeValue")
    @JsonPropertyDescription(value="Adjusted Income of the Application")
    @NotNull
    private BigDecimal initAdjustedIncomeValue;
    @JsonProperty(value="initNotes")
    @JsonPropertyDescription(value="Init assessment notes")
    private String initNotes;
    @JsonProperty(value="initResult")
    @JsonPropertyDescription(value="Initial assessment result")
    @NotNull
    private String initResult;
    @JsonProperty(value="initResultReason")
    @JsonPropertyDescription(value="Initial assessment result reason")
    @NotNull
    private String initResultReason;
    @JsonProperty(value="incomeEvidenceDueDate")
    @JsonPropertyDescription(value="Income Evidence Due Date")
    private LocalDateTime incomeEvidenceDueDate;
    @JsonProperty(value="incomeEvidenceNotes")
    @JsonPropertyDescription(value="Income Evidence Notes")
    private String incomeEvidenceNotes;
    @JsonProperty(value="initApplicationEmploymentStatus")
    @JsonPropertyDescription(value="Code for the employment status")
    @NotNull
    private String initApplicationEmploymentStatus;
    @JsonProperty(value="assessmentDetails")
    @Size(min=1)
    @Valid
    @NotNull
    private @Size(min=1) @Valid @NotNull List<ApiAssessmentDetail> assessmentDetails = new ArrayList<ApiAssessmentDetail>();
    @JsonProperty(value="childWeightings")
    @Size(min=1)
    @Valid
    @NotNull
    private @Size(min=1) @Valid @NotNull List<ApiAssessmentChildWeighting> childWeightings = new ArrayList<ApiAssessmentChildWeighting>();
    @JsonProperty(value="dateCompleted")
    @JsonPropertyDescription(value="Assessment completion date")
    private LocalDateTime dateCompleted;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public MaatApiAssessmentRequest() {
    }

    public MaatApiAssessmentRequest(String laaTransactionId, Integer repId, Integer initialAscrId, String assessmentType, Integer cmuId, String fassInitStatus, LocalDateTime initialAssessmentDate, String initOtherBenefitNote, String initOtherIncomeNote, BigDecimal initTotAggregatedIncome, BigDecimal initAdjustedIncomeValue, String initNotes, String initResult, String initResultReason, LocalDateTime incomeEvidenceDueDate, String incomeEvidenceNotes, String initApplicationEmploymentStatus, List<ApiAssessmentDetail> assessmentDetails, List<ApiAssessmentChildWeighting> childWeightings, LocalDateTime dateCompleted) {
        this.laaTransactionId = laaTransactionId;
        this.repId = repId;
        this.initialAscrId = initialAscrId;
        this.assessmentType = assessmentType;
        this.cmuId = cmuId;
        this.fassInitStatus = fassInitStatus;
        this.initialAssessmentDate = initialAssessmentDate;
        this.initOtherBenefitNote = initOtherBenefitNote;
        this.initOtherIncomeNote = initOtherIncomeNote;
        this.initTotAggregatedIncome = initTotAggregatedIncome;
        this.initAdjustedIncomeValue = initAdjustedIncomeValue;
        this.initNotes = initNotes;
        this.initResult = initResult;
        this.initResultReason = initResultReason;
        this.incomeEvidenceDueDate = incomeEvidenceDueDate;
        this.incomeEvidenceNotes = incomeEvidenceNotes;
        this.initApplicationEmploymentStatus = initApplicationEmploymentStatus;
        this.assessmentDetails = assessmentDetails;
        this.childWeightings = childWeightings;
        this.dateCompleted = dateCompleted;
    }

    @JsonProperty(value="laaTransactionId")
    public String getLaaTransactionId() {
        return this.laaTransactionId;
    }

    @JsonProperty(value="laaTransactionId")
    public void setLaaTransactionId(String laaTransactionId) {
        this.laaTransactionId = laaTransactionId;
    }

    public MaatApiAssessmentRequest withLaaTransactionId(String laaTransactionId) {
        this.laaTransactionId = laaTransactionId;
        return this;
    }

    @JsonProperty(value="repId")
    public Integer getRepId() {
        return this.repId;
    }

    @JsonProperty(value="repId")
    public void setRepId(Integer repId) {
        this.repId = repId;
    }

    public MaatApiAssessmentRequest withRepId(Integer repId) {
        this.repId = repId;
        return this;
    }

    @JsonProperty(value="initialAscrId")
    public Integer getInitialAscrId() {
        return this.initialAscrId;
    }

    @JsonProperty(value="initialAscrId")
    public void setInitialAscrId(Integer initialAscrId) {
        this.initialAscrId = initialAscrId;
    }

    public MaatApiAssessmentRequest withInitialAscrId(Integer initialAscrId) {
        this.initialAscrId = initialAscrId;
        return this;
    }

    @JsonProperty(value="assessmentType")
    public String getAssessmentType() {
        return this.assessmentType;
    }

    @JsonProperty(value="assessmentType")
    public void setAssessmentType(String assessmentType) {
        this.assessmentType = assessmentType;
    }

    public MaatApiAssessmentRequest withAssessmentType(String assessmentType) {
        this.assessmentType = assessmentType;
        return this;
    }

    @JsonProperty(value="cmuId")
    public Integer getCmuId() {
        return this.cmuId;
    }

    @JsonProperty(value="cmuId")
    public void setCmuId(Integer cmuId) {
        this.cmuId = cmuId;
    }

    public MaatApiAssessmentRequest withCmuId(Integer cmuId) {
        this.cmuId = cmuId;
        return this;
    }

    @JsonProperty(value="fassInitStatus")
    public String getFassInitStatus() {
        return this.fassInitStatus;
    }

    @JsonProperty(value="fassInitStatus")
    public void setFassInitStatus(String fassInitStatus) {
        this.fassInitStatus = fassInitStatus;
    }

    public MaatApiAssessmentRequest withFassInitStatus(String fassInitStatus) {
        this.fassInitStatus = fassInitStatus;
        return this;
    }

    @JsonProperty(value="initialAssessmentDate")
    public LocalDateTime getInitialAssessmentDate() {
        return this.initialAssessmentDate;
    }

    @JsonProperty(value="initialAssessmentDate")
    public void setInitialAssessmentDate(LocalDateTime initialAssessmentDate) {
        this.initialAssessmentDate = initialAssessmentDate;
    }

    public MaatApiAssessmentRequest withInitialAssessmentDate(LocalDateTime initialAssessmentDate) {
        this.initialAssessmentDate = initialAssessmentDate;
        return this;
    }

    @JsonProperty(value="initOtherBenefitNote")
    public String getInitOtherBenefitNote() {
        return this.initOtherBenefitNote;
    }

    @JsonProperty(value="initOtherBenefitNote")
    public void setInitOtherBenefitNote(String initOtherBenefitNote) {
        this.initOtherBenefitNote = initOtherBenefitNote;
    }

    public MaatApiAssessmentRequest withInitOtherBenefitNote(String initOtherBenefitNote) {
        this.initOtherBenefitNote = initOtherBenefitNote;
        return this;
    }

    @JsonProperty(value="initOtherIncomeNote")
    public String getInitOtherIncomeNote() {
        return this.initOtherIncomeNote;
    }

    @JsonProperty(value="initOtherIncomeNote")
    public void setInitOtherIncomeNote(String initOtherIncomeNote) {
        this.initOtherIncomeNote = initOtherIncomeNote;
    }

    public MaatApiAssessmentRequest withInitOtherIncomeNote(String initOtherIncomeNote) {
        this.initOtherIncomeNote = initOtherIncomeNote;
        return this;
    }

    @JsonProperty(value="initTotAggregatedIncome")
    public BigDecimal getInitTotAggregatedIncome() {
        return this.initTotAggregatedIncome;
    }

    @JsonProperty(value="initTotAggregatedIncome")
    public void setInitTotAggregatedIncome(BigDecimal initTotAggregatedIncome) {
        this.initTotAggregatedIncome = initTotAggregatedIncome;
    }

    public MaatApiAssessmentRequest withInitTotAggregatedIncome(BigDecimal initTotAggregatedIncome) {
        this.initTotAggregatedIncome = initTotAggregatedIncome;
        return this;
    }

    @JsonProperty(value="initAdjustedIncomeValue")
    public BigDecimal getInitAdjustedIncomeValue() {
        return this.initAdjustedIncomeValue;
    }

    @JsonProperty(value="initAdjustedIncomeValue")
    public void setInitAdjustedIncomeValue(BigDecimal initAdjustedIncomeValue) {
        this.initAdjustedIncomeValue = initAdjustedIncomeValue;
    }

    public MaatApiAssessmentRequest withInitAdjustedIncomeValue(BigDecimal initAdjustedIncomeValue) {
        this.initAdjustedIncomeValue = initAdjustedIncomeValue;
        return this;
    }

    @JsonProperty(value="initNotes")
    public String getInitNotes() {
        return this.initNotes;
    }

    @JsonProperty(value="initNotes")
    public void setInitNotes(String initNotes) {
        this.initNotes = initNotes;
    }

    public MaatApiAssessmentRequest withInitNotes(String initNotes) {
        this.initNotes = initNotes;
        return this;
    }

    @JsonProperty(value="initResult")
    public String getInitResult() {
        return this.initResult;
    }

    @JsonProperty(value="initResult")
    public void setInitResult(String initResult) {
        this.initResult = initResult;
    }

    public MaatApiAssessmentRequest withInitResult(String initResult) {
        this.initResult = initResult;
        return this;
    }

    @JsonProperty(value="initResultReason")
    public String getInitResultReason() {
        return this.initResultReason;
    }

    @JsonProperty(value="initResultReason")
    public void setInitResultReason(String initResultReason) {
        this.initResultReason = initResultReason;
    }

    public MaatApiAssessmentRequest withInitResultReason(String initResultReason) {
        this.initResultReason = initResultReason;
        return this;
    }

    @JsonProperty(value="incomeEvidenceDueDate")
    public LocalDateTime getIncomeEvidenceDueDate() {
        return this.incomeEvidenceDueDate;
    }

    @JsonProperty(value="incomeEvidenceDueDate")
    public void setIncomeEvidenceDueDate(LocalDateTime incomeEvidenceDueDate) {
        this.incomeEvidenceDueDate = incomeEvidenceDueDate;
    }

    public MaatApiAssessmentRequest withIncomeEvidenceDueDate(LocalDateTime incomeEvidenceDueDate) {
        this.incomeEvidenceDueDate = incomeEvidenceDueDate;
        return this;
    }

    @JsonProperty(value="incomeEvidenceNotes")
    public String getIncomeEvidenceNotes() {
        return this.incomeEvidenceNotes;
    }

    @JsonProperty(value="incomeEvidenceNotes")
    public void setIncomeEvidenceNotes(String incomeEvidenceNotes) {
        this.incomeEvidenceNotes = incomeEvidenceNotes;
    }

    public MaatApiAssessmentRequest withIncomeEvidenceNotes(String incomeEvidenceNotes) {
        this.incomeEvidenceNotes = incomeEvidenceNotes;
        return this;
    }

    @JsonProperty(value="initApplicationEmploymentStatus")
    public String getInitApplicationEmploymentStatus() {
        return this.initApplicationEmploymentStatus;
    }

    @JsonProperty(value="initApplicationEmploymentStatus")
    public void setInitApplicationEmploymentStatus(String initApplicationEmploymentStatus) {
        this.initApplicationEmploymentStatus = initApplicationEmploymentStatus;
    }

    public MaatApiAssessmentRequest withInitApplicationEmploymentStatus(String initApplicationEmploymentStatus) {
        this.initApplicationEmploymentStatus = initApplicationEmploymentStatus;
        return this;
    }

    @JsonProperty(value="assessmentDetails")
    public List<ApiAssessmentDetail> getAssessmentDetails() {
        return this.assessmentDetails;
    }

    @JsonProperty(value="assessmentDetails")
    public void setAssessmentDetails(List<ApiAssessmentDetail> assessmentDetails) {
        this.assessmentDetails = assessmentDetails;
    }

    public MaatApiAssessmentRequest withAssessmentDetails(List<ApiAssessmentDetail> assessmentDetails) {
        this.assessmentDetails = assessmentDetails;
        return this;
    }

    @JsonProperty(value="childWeightings")
    public List<ApiAssessmentChildWeighting> getChildWeightings() {
        return this.childWeightings;
    }

    @JsonProperty(value="childWeightings")
    public void setChildWeightings(List<ApiAssessmentChildWeighting> childWeightings) {
        this.childWeightings = childWeightings;
    }

    public MaatApiAssessmentRequest withChildWeightings(List<ApiAssessmentChildWeighting> childWeightings) {
        this.childWeightings = childWeightings;
        return this;
    }

    @JsonProperty(value="dateCompleted")
    public LocalDateTime getDateCompleted() {
        return this.dateCompleted;
    }

    @JsonProperty(value="dateCompleted")
    public void setDateCompleted(LocalDateTime dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    public MaatApiAssessmentRequest withDateCompleted(LocalDateTime dateCompleted) {
        this.dateCompleted = dateCompleted;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("laaTransactionId".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"laaTransactionId\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setLaaTransactionId((String)value);
            return true;
        }
        if ("repId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"repId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setRepId((Integer)value);
            return true;
        }
        if ("initialAscrId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"initialAscrId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setInitialAscrId((Integer)value);
            return true;
        }
        if ("assessmentType".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"assessmentType\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setAssessmentType((String)value);
            return true;
        }
        if ("cmuId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"cmuId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setCmuId((Integer)value);
            return true;
        }
        if ("fassInitStatus".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fassInitStatus\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFassInitStatus((String)value);
            return true;
        }
        if ("initialAssessmentDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"initialAssessmentDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setInitialAssessmentDate((LocalDateTime)value);
            return true;
        }
        if ("initOtherBenefitNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initOtherBenefitNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitOtherBenefitNote((String)value);
            return true;
        }
        if ("initOtherIncomeNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initOtherIncomeNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitOtherIncomeNote((String)value);
            return true;
        }
        if ("initTotAggregatedIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"initTotAggregatedIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setInitTotAggregatedIncome((BigDecimal)value);
            return true;
        }
        if ("initAdjustedIncomeValue".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"initAdjustedIncomeValue\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setInitAdjustedIncomeValue((BigDecimal)value);
            return true;
        }
        if ("initNotes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initNotes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitNotes((String)value);
            return true;
        }
        if ("initResult".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initResult\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitResult((String)value);
            return true;
        }
        if ("initResultReason".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initResultReason\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitResultReason((String)value);
            return true;
        }
        if ("incomeEvidenceDueDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"incomeEvidenceDueDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidenceDueDate((LocalDateTime)value);
            return true;
        }
        if ("incomeEvidenceNotes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"incomeEvidenceNotes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidenceNotes((String)value);
            return true;
        }
        if ("initApplicationEmploymentStatus".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initApplicationEmploymentStatus\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitApplicationEmploymentStatus((String)value);
            return true;
        }
        if ("assessmentDetails".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"assessmentDetails\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentDetail>\", but got " + value.getClass().toString());
            }
            this.setAssessmentDetails((List)value);
            return true;
        }
        if ("childWeightings".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"childWeightings\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentChildWeighting>\", but got " + value.getClass().toString());
            }
            this.setChildWeightings((List)value);
            return true;
        }
        if ("dateCompleted".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"dateCompleted\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setDateCompleted((LocalDateTime)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("laaTransactionId".equals(name)) {
            return this.getLaaTransactionId();
        }
        if ("repId".equals(name)) {
            return this.getRepId();
        }
        if ("initialAscrId".equals(name)) {
            return this.getInitialAscrId();
        }
        if ("assessmentType".equals(name)) {
            return this.getAssessmentType();
        }
        if ("cmuId".equals(name)) {
            return this.getCmuId();
        }
        if ("fassInitStatus".equals(name)) {
            return this.getFassInitStatus();
        }
        if ("initialAssessmentDate".equals(name)) {
            return this.getInitialAssessmentDate();
        }
        if ("initOtherBenefitNote".equals(name)) {
            return this.getInitOtherBenefitNote();
        }
        if ("initOtherIncomeNote".equals(name)) {
            return this.getInitOtherIncomeNote();
        }
        if ("initTotAggregatedIncome".equals(name)) {
            return this.getInitTotAggregatedIncome();
        }
        if ("initAdjustedIncomeValue".equals(name)) {
            return this.getInitAdjustedIncomeValue();
        }
        if ("initNotes".equals(name)) {
            return this.getInitNotes();
        }
        if ("initResult".equals(name)) {
            return this.getInitResult();
        }
        if ("initResultReason".equals(name)) {
            return this.getInitResultReason();
        }
        if ("incomeEvidenceDueDate".equals(name)) {
            return this.getIncomeEvidenceDueDate();
        }
        if ("incomeEvidenceNotes".equals(name)) {
            return this.getIncomeEvidenceNotes();
        }
        if ("initApplicationEmploymentStatus".equals(name)) {
            return this.getInitApplicationEmploymentStatus();
        }
        if ("assessmentDetails".equals(name)) {
            return this.getAssessmentDetails();
        }
        if ("childWeightings".equals(name)) {
            return this.getChildWeightings();
        }
        if ("dateCompleted".equals(name)) {
            return this.getDateCompleted();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public MaatApiAssessmentRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MaatApiAssessmentRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("laaTransactionId");
        sb.append('=');
        sb.append(this.laaTransactionId == null ? "<null>" : this.laaTransactionId);
        sb.append(',');
        sb.append("repId");
        sb.append('=');
        sb.append(this.repId == null ? "<null>" : this.repId);
        sb.append(',');
        sb.append("initialAscrId");
        sb.append('=');
        sb.append(this.initialAscrId == null ? "<null>" : this.initialAscrId);
        sb.append(',');
        sb.append("assessmentType");
        sb.append('=');
        sb.append(this.assessmentType == null ? "<null>" : this.assessmentType);
        sb.append(',');
        sb.append("cmuId");
        sb.append('=');
        sb.append(this.cmuId == null ? "<null>" : this.cmuId);
        sb.append(',');
        sb.append("fassInitStatus");
        sb.append('=');
        sb.append(this.fassInitStatus == null ? "<null>" : this.fassInitStatus);
        sb.append(',');
        sb.append("initialAssessmentDate");
        sb.append('=');
        sb.append(this.initialAssessmentDate == null ? "<null>" : this.initialAssessmentDate);
        sb.append(',');
        sb.append("initOtherBenefitNote");
        sb.append('=');
        sb.append(this.initOtherBenefitNote == null ? "<null>" : this.initOtherBenefitNote);
        sb.append(',');
        sb.append("initOtherIncomeNote");
        sb.append('=');
        sb.append(this.initOtherIncomeNote == null ? "<null>" : this.initOtherIncomeNote);
        sb.append(',');
        sb.append("initTotAggregatedIncome");
        sb.append('=');
        sb.append(this.initTotAggregatedIncome == null ? "<null>" : this.initTotAggregatedIncome);
        sb.append(',');
        sb.append("initAdjustedIncomeValue");
        sb.append('=');
        sb.append(this.initAdjustedIncomeValue == null ? "<null>" : this.initAdjustedIncomeValue);
        sb.append(',');
        sb.append("initNotes");
        sb.append('=');
        sb.append(this.initNotes == null ? "<null>" : this.initNotes);
        sb.append(',');
        sb.append("initResult");
        sb.append('=');
        sb.append(this.initResult == null ? "<null>" : this.initResult);
        sb.append(',');
        sb.append("initResultReason");
        sb.append('=');
        sb.append(this.initResultReason == null ? "<null>" : this.initResultReason);
        sb.append(',');
        sb.append("incomeEvidenceDueDate");
        sb.append('=');
        sb.append(this.incomeEvidenceDueDate == null ? "<null>" : this.incomeEvidenceDueDate);
        sb.append(',');
        sb.append("incomeEvidenceNotes");
        sb.append('=');
        sb.append(this.incomeEvidenceNotes == null ? "<null>" : this.incomeEvidenceNotes);
        sb.append(',');
        sb.append("initApplicationEmploymentStatus");
        sb.append('=');
        sb.append(this.initApplicationEmploymentStatus == null ? "<null>" : this.initApplicationEmploymentStatus);
        sb.append(',');
        sb.append("assessmentDetails");
        sb.append('=');
        sb.append(this.assessmentDetails == null ? "<null>" : this.assessmentDetails);
        sb.append(',');
        sb.append("childWeightings");
        sb.append('=');
        sb.append(this.childWeightings == null ? "<null>" : this.childWeightings);
        sb.append(',');
        sb.append("dateCompleted");
        sb.append('=');
        sb.append(this.dateCompleted == null ? "<null>" : this.dateCompleted);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.laaTransactionId == null ? 0 : this.laaTransactionId.hashCode());
        result = result * 31 + (this.cmuId == null ? 0 : this.cmuId.hashCode());
        result = result * 31 + (this.incomeEvidenceNotes == null ? 0 : this.incomeEvidenceNotes.hashCode());
        result = result * 31 + (this.assessmentType == null ? 0 : this.assessmentType.hashCode());
        result = result * 31 + (this.initNotes == null ? 0 : this.initNotes.hashCode());
        result = result * 31 + (this.incomeEvidenceDueDate == null ? 0 : this.incomeEvidenceDueDate.hashCode());
        result = result * 31 + (this.initAdjustedIncomeValue == null ? 0 : this.initAdjustedIncomeValue.hashCode());
        result = result * 31 + (this.initResult == null ? 0 : this.initResult.hashCode());
        result = result * 31 + (this.initResultReason == null ? 0 : this.initResultReason.hashCode());
        result = result * 31 + (this.repId == null ? 0 : this.repId.hashCode());
        result = result * 31 + (this.initOtherIncomeNote == null ? 0 : this.initOtherIncomeNote.hashCode());
        result = result * 31 + (this.initApplicationEmploymentStatus == null ? 0 : this.initApplicationEmploymentStatus.hashCode());
        result = result * 31 + (this.childWeightings == null ? 0 : this.childWeightings.hashCode());
        result = result * 31 + (this.initOtherBenefitNote == null ? 0 : this.initOtherBenefitNote.hashCode());
        result = result * 31 + (this.initialAssessmentDate == null ? 0 : this.initialAssessmentDate.hashCode());
        result = result * 31 + (this.dateCompleted == null ? 0 : this.dateCompleted.hashCode());
        result = result * 31 + (this.assessmentDetails == null ? 0 : this.assessmentDetails.hashCode());
        result = result * 31 + (this.initialAscrId == null ? 0 : this.initialAscrId.hashCode());
        result = result * 31 + (this.fassInitStatus == null ? 0 : this.fassInitStatus.hashCode());
        result = result * 31 + (this.initTotAggregatedIncome == null ? 0 : this.initTotAggregatedIncome.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MaatApiAssessmentRequest)) {
            return false;
        }
        MaatApiAssessmentRequest rhs = (MaatApiAssessmentRequest)other;
        return (this.laaTransactionId == rhs.laaTransactionId || this.laaTransactionId != null && this.laaTransactionId.equals(rhs.laaTransactionId)) && (this.cmuId == rhs.cmuId || this.cmuId != null && this.cmuId.equals(rhs.cmuId)) && (this.incomeEvidenceNotes == rhs.incomeEvidenceNotes || this.incomeEvidenceNotes != null && this.incomeEvidenceNotes.equals(rhs.incomeEvidenceNotes)) && (this.assessmentType == rhs.assessmentType || this.assessmentType != null && this.assessmentType.equals(rhs.assessmentType)) && (this.initNotes == rhs.initNotes || this.initNotes != null && this.initNotes.equals(rhs.initNotes)) && (this.incomeEvidenceDueDate == rhs.incomeEvidenceDueDate || this.incomeEvidenceDueDate != null && this.incomeEvidenceDueDate.equals(rhs.incomeEvidenceDueDate)) && (this.initAdjustedIncomeValue == rhs.initAdjustedIncomeValue || this.initAdjustedIncomeValue != null && this.initAdjustedIncomeValue.equals(rhs.initAdjustedIncomeValue)) && (this.initResult == rhs.initResult || this.initResult != null && this.initResult.equals(rhs.initResult)) && (this.initResultReason == rhs.initResultReason || this.initResultReason != null && this.initResultReason.equals(rhs.initResultReason)) && (this.repId == rhs.repId || this.repId != null && this.repId.equals(rhs.repId)) && (this.initOtherIncomeNote == rhs.initOtherIncomeNote || this.initOtherIncomeNote != null && this.initOtherIncomeNote.equals(rhs.initOtherIncomeNote)) && (this.initApplicationEmploymentStatus == rhs.initApplicationEmploymentStatus || this.initApplicationEmploymentStatus != null && this.initApplicationEmploymentStatus.equals(rhs.initApplicationEmploymentStatus)) && (this.childWeightings == rhs.childWeightings || this.childWeightings != null && this.childWeightings.equals(rhs.childWeightings)) && (this.initOtherBenefitNote == rhs.initOtherBenefitNote || this.initOtherBenefitNote != null && this.initOtherBenefitNote.equals(rhs.initOtherBenefitNote)) && (this.initialAssessmentDate == rhs.initialAssessmentDate || this.initialAssessmentDate != null && this.initialAssessmentDate.equals(rhs.initialAssessmentDate)) && (this.dateCompleted == rhs.dateCompleted || this.dateCompleted != null && this.dateCompleted.equals(rhs.dateCompleted)) && (this.assessmentDetails == rhs.assessmentDetails || this.assessmentDetails != null && this.assessmentDetails.equals(rhs.assessmentDetails)) && (this.initialAscrId == rhs.initialAscrId || this.initialAscrId != null && this.initialAscrId.equals(rhs.initialAscrId)) && (this.fassInitStatus == rhs.fassInitStatus || this.fassInitStatus != null && this.fassInitStatus.equals(rhs.fassInitStatus)) && (this.initTotAggregatedIncome == rhs.initTotAggregatedIncome || this.initTotAggregatedIncome != null && this.initTotAggregatedIncome.equals(rhs.initTotAggregatedIncome));
    }
}

