/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment.maatapi;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentChildWeighting;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentDetail;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiIncomeEvidence;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "repId", "initialAscrId", "assessmentType", "nworCode", "dateCreated", "userCreated", "cmuId", "fassInitStatus", "initialAssessmentDate", "initOtherBenefitNote", "initOtherIncomeNote", "initTotAggregatedIncome", "initAdjustedIncomeValue", "initNotes", "initResult", "initResultReason", "incomeEvidenceDueDate", "evidenceReceivedDate", "incomeUpliftRemoveDate", "incomeUpliftApplyDate", "incomeEvidenceNotes", "initApplicationEmploymentStatus", "fassFullStatus", "fullAssessmentDate", "fullResult", "fullResultReason", "fullAssessmentNotes", "fullAdjustedLivingAllowance", "fullTotalAnnualDisposableIncome", "fullOtherHousingNote", "fullTotalAggregatedExpenses", "fullAscrId", "dateCompleted", "updated", "userModified", "usn", "rtCode", "assessmentDetails", "childWeightings", "incomeEvidence"})
public class MaatApiAssessmentResponse {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Financial assessment ID")
    private Integer id;
    @JsonProperty(value="repId")
    @JsonPropertyDescription(value="Financial assessment ID")
    private Integer repId;
    @JsonProperty(value="initialAscrId")
    @JsonPropertyDescription(value="Initial assessment criteria ID")
    private Integer initialAscrId;
    @JsonProperty(value="assessmentType")
    @JsonPropertyDescription(value="The type of assessment")
    private String assessmentType;
    @JsonProperty(value="nworCode")
    @JsonPropertyDescription(value="New work reason details")
    private String nworCode;
    @JsonProperty(value="dateCreated")
    @JsonPropertyDescription(value="The date the assessment was created")
    private LocalDateTime dateCreated;
    @JsonProperty(value="userCreated")
    @JsonPropertyDescription(value="ID of the user that created the assessment")
    private String userCreated;
    @JsonProperty(value="cmuId")
    @JsonPropertyDescription(value="Case Management Unit Id")
    private Integer cmuId;
    @JsonProperty(value="fassInitStatus")
    @JsonPropertyDescription(value="Initial assessment status")
    private String fassInitStatus;
    @JsonProperty(value="initialAssessmentDate")
    @JsonPropertyDescription(value="Initial assessment date")
    private LocalDateTime initialAssessmentDate;
    @JsonProperty(value="initOtherBenefitNote")
    @JsonPropertyDescription(value="Benefit Note")
    private String initOtherBenefitNote;
    @JsonProperty(value="initOtherIncomeNote")
    @JsonPropertyDescription(value="Income Note.")
    private String initOtherIncomeNote;
    @JsonProperty(value="initTotAggregatedIncome")
    @JsonPropertyDescription(value="Total Aggregated income of the application.")
    private BigDecimal initTotAggregatedIncome;
    @JsonProperty(value="initAdjustedIncomeValue")
    @JsonPropertyDescription(value="Adjusted Income of the Application")
    private BigDecimal initAdjustedIncomeValue;
    @JsonProperty(value="initNotes")
    @JsonPropertyDescription(value="Init assessment notes")
    private String initNotes;
    @JsonProperty(value="initResult")
    @JsonPropertyDescription(value="Initial assessment result")
    private String initResult;
    @JsonProperty(value="initResultReason")
    @JsonPropertyDescription(value="Initial assessment result reason")
    private String initResultReason;
    @JsonProperty(value="incomeEvidenceDueDate")
    @JsonPropertyDescription(value="Income Evidence Due Date")
    private LocalDateTime incomeEvidenceDueDate;
    @JsonProperty(value="evidenceReceivedDate")
    @JsonPropertyDescription(value="The date that all of the income evidence was received")
    private LocalDateTime evidenceReceivedDate;
    @JsonProperty(value="incomeUpliftRemoveDate")
    @JsonPropertyDescription(value="Income Uplift Removal Due Date")
    private LocalDateTime incomeUpliftRemoveDate;
    @JsonProperty(value="incomeUpliftApplyDate")
    @JsonPropertyDescription(value="Income Uplift Apply Due Date")
    private LocalDateTime incomeUpliftApplyDate;
    @JsonProperty(value="incomeEvidenceNotes")
    @JsonPropertyDescription(value="Income Evidence Notes")
    private String incomeEvidenceNotes;
    @JsonProperty(value="initApplicationEmploymentStatus")
    @JsonPropertyDescription(value="Code for the employment status")
    private String initApplicationEmploymentStatus;
    @JsonProperty(value="fassFullStatus")
    @JsonPropertyDescription(value="Full assessment status")
    private String fassFullStatus;
    @JsonProperty(value="fullAssessmentDate")
    @JsonPropertyDescription(value="Full assessment date")
    private LocalDateTime fullAssessmentDate;
    @JsonProperty(value="fullResult")
    @JsonPropertyDescription(value="Full assessment result")
    private String fullResult;
    @JsonProperty(value="fullResultReason")
    @JsonPropertyDescription(value="Full assessment result reason")
    private String fullResultReason;
    @JsonProperty(value="fullAssessmentNotes")
    @JsonPropertyDescription(value="Full assessment notes")
    private String fullAssessmentNotes;
    @JsonProperty(value="fullAdjustedLivingAllowance")
    @JsonPropertyDescription(value="Full adjusted living allowance")
    private BigDecimal fullAdjustedLivingAllowance;
    @JsonProperty(value="fullTotalAnnualDisposableIncome")
    @JsonPropertyDescription(value="Full total annual disposable income")
    private BigDecimal fullTotalAnnualDisposableIncome;
    @JsonProperty(value="fullOtherHousingNote")
    @JsonPropertyDescription(value="Full other housing note")
    private String fullOtherHousingNote;
    @JsonProperty(value="fullTotalAggregatedExpenses")
    @JsonPropertyDescription(value="Full total aggregated expenses")
    private BigDecimal fullTotalAggregatedExpenses;
    @JsonProperty(value="fullAscrId")
    @JsonPropertyDescription(value="Full assessment criteria ID")
    private Integer fullAscrId;
    @JsonProperty(value="dateCompleted")
    @JsonPropertyDescription(value="The date the assessment was completed")
    private LocalDateTime dateCompleted;
    @JsonProperty(value="updated")
    @JsonPropertyDescription(value="The date the assessment was last updated")
    private LocalDateTime updated;
    @JsonProperty(value="userModified")
    @JsonPropertyDescription(value="ID of the user that last modified the assessment")
    private String userModified;
    @JsonProperty(value="usn")
    @JsonPropertyDescription(value="Unique Submission Number - EForm Reference")
    private Integer usn;
    @JsonProperty(value="rtCode")
    @JsonPropertyDescription(value="Review Type code")
    private String rtCode;
    @JsonProperty(value="assessmentDetails")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<ApiAssessmentDetail> assessmentDetails = new ArrayList<ApiAssessmentDetail>();
    @JsonProperty(value="childWeightings")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<ApiAssessmentChildWeighting> childWeightings = new ArrayList<ApiAssessmentChildWeighting>();
    @JsonProperty(value="incomeEvidence")
    @Valid
    private List<ApiIncomeEvidence> incomeEvidence = new ArrayList<ApiIncomeEvidence>();
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public MaatApiAssessmentResponse() {
    }

    public MaatApiAssessmentResponse(Integer id, Integer repId, Integer initialAscrId, String assessmentType, String nworCode, LocalDateTime dateCreated, String userCreated, Integer cmuId, String fassInitStatus, LocalDateTime initialAssessmentDate, String initOtherBenefitNote, String initOtherIncomeNote, BigDecimal initTotAggregatedIncome, BigDecimal initAdjustedIncomeValue, String initNotes, String initResult, String initResultReason, LocalDateTime incomeEvidenceDueDate, LocalDateTime evidenceReceivedDate, LocalDateTime incomeUpliftRemoveDate, LocalDateTime incomeUpliftApplyDate, String incomeEvidenceNotes, String initApplicationEmploymentStatus, String fassFullStatus, LocalDateTime fullAssessmentDate, String fullResult, String fullResultReason, String fullAssessmentNotes, BigDecimal fullAdjustedLivingAllowance, BigDecimal fullTotalAnnualDisposableIncome, String fullOtherHousingNote, BigDecimal fullTotalAggregatedExpenses, Integer fullAscrId, LocalDateTime dateCompleted, LocalDateTime updated, String userModified, Integer usn, String rtCode, List<ApiAssessmentDetail> assessmentDetails, List<ApiAssessmentChildWeighting> childWeightings, List<ApiIncomeEvidence> incomeEvidence) {
        this.id = id;
        this.repId = repId;
        this.initialAscrId = initialAscrId;
        this.assessmentType = assessmentType;
        this.nworCode = nworCode;
        this.dateCreated = dateCreated;
        this.userCreated = userCreated;
        this.cmuId = cmuId;
        this.fassInitStatus = fassInitStatus;
        this.initialAssessmentDate = initialAssessmentDate;
        this.initOtherBenefitNote = initOtherBenefitNote;
        this.initOtherIncomeNote = initOtherIncomeNote;
        this.initTotAggregatedIncome = initTotAggregatedIncome;
        this.initAdjustedIncomeValue = initAdjustedIncomeValue;
        this.initNotes = initNotes;
        this.initResult = initResult;
        this.initResultReason = initResultReason;
        this.incomeEvidenceDueDate = incomeEvidenceDueDate;
        this.evidenceReceivedDate = evidenceReceivedDate;
        this.incomeUpliftRemoveDate = incomeUpliftRemoveDate;
        this.incomeUpliftApplyDate = incomeUpliftApplyDate;
        this.incomeEvidenceNotes = incomeEvidenceNotes;
        this.initApplicationEmploymentStatus = initApplicationEmploymentStatus;
        this.fassFullStatus = fassFullStatus;
        this.fullAssessmentDate = fullAssessmentDate;
        this.fullResult = fullResult;
        this.fullResultReason = fullResultReason;
        this.fullAssessmentNotes = fullAssessmentNotes;
        this.fullAdjustedLivingAllowance = fullAdjustedLivingAllowance;
        this.fullTotalAnnualDisposableIncome = fullTotalAnnualDisposableIncome;
        this.fullOtherHousingNote = fullOtherHousingNote;
        this.fullTotalAggregatedExpenses = fullTotalAggregatedExpenses;
        this.fullAscrId = fullAscrId;
        this.dateCompleted = dateCompleted;
        this.updated = updated;
        this.userModified = userModified;
        this.usn = usn;
        this.rtCode = rtCode;
        this.assessmentDetails = assessmentDetails;
        this.childWeightings = childWeightings;
        this.incomeEvidence = incomeEvidence;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public MaatApiAssessmentResponse withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="repId")
    public Integer getRepId() {
        return this.repId;
    }

    @JsonProperty(value="repId")
    public void setRepId(Integer repId) {
        this.repId = repId;
    }

    public MaatApiAssessmentResponse withRepId(Integer repId) {
        this.repId = repId;
        return this;
    }

    @JsonProperty(value="initialAscrId")
    public Integer getInitialAscrId() {
        return this.initialAscrId;
    }

    @JsonProperty(value="initialAscrId")
    public void setInitialAscrId(Integer initialAscrId) {
        this.initialAscrId = initialAscrId;
    }

    public MaatApiAssessmentResponse withInitialAscrId(Integer initialAscrId) {
        this.initialAscrId = initialAscrId;
        return this;
    }

    @JsonProperty(value="assessmentType")
    public String getAssessmentType() {
        return this.assessmentType;
    }

    @JsonProperty(value="assessmentType")
    public void setAssessmentType(String assessmentType) {
        this.assessmentType = assessmentType;
    }

    public MaatApiAssessmentResponse withAssessmentType(String assessmentType) {
        this.assessmentType = assessmentType;
        return this;
    }

    @JsonProperty(value="nworCode")
    public String getNworCode() {
        return this.nworCode;
    }

    @JsonProperty(value="nworCode")
    public void setNworCode(String nworCode) {
        this.nworCode = nworCode;
    }

    public MaatApiAssessmentResponse withNworCode(String nworCode) {
        this.nworCode = nworCode;
        return this;
    }

    @JsonProperty(value="dateCreated")
    public LocalDateTime getDateCreated() {
        return this.dateCreated;
    }

    @JsonProperty(value="dateCreated")
    public void setDateCreated(LocalDateTime dateCreated) {
        this.dateCreated = dateCreated;
    }

    public MaatApiAssessmentResponse withDateCreated(LocalDateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @JsonProperty(value="userCreated")
    public String getUserCreated() {
        return this.userCreated;
    }

    @JsonProperty(value="userCreated")
    public void setUserCreated(String userCreated) {
        this.userCreated = userCreated;
    }

    public MaatApiAssessmentResponse withUserCreated(String userCreated) {
        this.userCreated = userCreated;
        return this;
    }

    @JsonProperty(value="cmuId")
    public Integer getCmuId() {
        return this.cmuId;
    }

    @JsonProperty(value="cmuId")
    public void setCmuId(Integer cmuId) {
        this.cmuId = cmuId;
    }

    public MaatApiAssessmentResponse withCmuId(Integer cmuId) {
        this.cmuId = cmuId;
        return this;
    }

    @JsonProperty(value="fassInitStatus")
    public String getFassInitStatus() {
        return this.fassInitStatus;
    }

    @JsonProperty(value="fassInitStatus")
    public void setFassInitStatus(String fassInitStatus) {
        this.fassInitStatus = fassInitStatus;
    }

    public MaatApiAssessmentResponse withFassInitStatus(String fassInitStatus) {
        this.fassInitStatus = fassInitStatus;
        return this;
    }

    @JsonProperty(value="initialAssessmentDate")
    public LocalDateTime getInitialAssessmentDate() {
        return this.initialAssessmentDate;
    }

    @JsonProperty(value="initialAssessmentDate")
    public void setInitialAssessmentDate(LocalDateTime initialAssessmentDate) {
        this.initialAssessmentDate = initialAssessmentDate;
    }

    public MaatApiAssessmentResponse withInitialAssessmentDate(LocalDateTime initialAssessmentDate) {
        this.initialAssessmentDate = initialAssessmentDate;
        return this;
    }

    @JsonProperty(value="initOtherBenefitNote")
    public String getInitOtherBenefitNote() {
        return this.initOtherBenefitNote;
    }

    @JsonProperty(value="initOtherBenefitNote")
    public void setInitOtherBenefitNote(String initOtherBenefitNote) {
        this.initOtherBenefitNote = initOtherBenefitNote;
    }

    public MaatApiAssessmentResponse withInitOtherBenefitNote(String initOtherBenefitNote) {
        this.initOtherBenefitNote = initOtherBenefitNote;
        return this;
    }

    @JsonProperty(value="initOtherIncomeNote")
    public String getInitOtherIncomeNote() {
        return this.initOtherIncomeNote;
    }

    @JsonProperty(value="initOtherIncomeNote")
    public void setInitOtherIncomeNote(String initOtherIncomeNote) {
        this.initOtherIncomeNote = initOtherIncomeNote;
    }

    public MaatApiAssessmentResponse withInitOtherIncomeNote(String initOtherIncomeNote) {
        this.initOtherIncomeNote = initOtherIncomeNote;
        return this;
    }

    @JsonProperty(value="initTotAggregatedIncome")
    public BigDecimal getInitTotAggregatedIncome() {
        return this.initTotAggregatedIncome;
    }

    @JsonProperty(value="initTotAggregatedIncome")
    public void setInitTotAggregatedIncome(BigDecimal initTotAggregatedIncome) {
        this.initTotAggregatedIncome = initTotAggregatedIncome;
    }

    public MaatApiAssessmentResponse withInitTotAggregatedIncome(BigDecimal initTotAggregatedIncome) {
        this.initTotAggregatedIncome = initTotAggregatedIncome;
        return this;
    }

    @JsonProperty(value="initAdjustedIncomeValue")
    public BigDecimal getInitAdjustedIncomeValue() {
        return this.initAdjustedIncomeValue;
    }

    @JsonProperty(value="initAdjustedIncomeValue")
    public void setInitAdjustedIncomeValue(BigDecimal initAdjustedIncomeValue) {
        this.initAdjustedIncomeValue = initAdjustedIncomeValue;
    }

    public MaatApiAssessmentResponse withInitAdjustedIncomeValue(BigDecimal initAdjustedIncomeValue) {
        this.initAdjustedIncomeValue = initAdjustedIncomeValue;
        return this;
    }

    @JsonProperty(value="initNotes")
    public String getInitNotes() {
        return this.initNotes;
    }

    @JsonProperty(value="initNotes")
    public void setInitNotes(String initNotes) {
        this.initNotes = initNotes;
    }

    public MaatApiAssessmentResponse withInitNotes(String initNotes) {
        this.initNotes = initNotes;
        return this;
    }

    @JsonProperty(value="initResult")
    public String getInitResult() {
        return this.initResult;
    }

    @JsonProperty(value="initResult")
    public void setInitResult(String initResult) {
        this.initResult = initResult;
    }

    public MaatApiAssessmentResponse withInitResult(String initResult) {
        this.initResult = initResult;
        return this;
    }

    @JsonProperty(value="initResultReason")
    public String getInitResultReason() {
        return this.initResultReason;
    }

    @JsonProperty(value="initResultReason")
    public void setInitResultReason(String initResultReason) {
        this.initResultReason = initResultReason;
    }

    public MaatApiAssessmentResponse withInitResultReason(String initResultReason) {
        this.initResultReason = initResultReason;
        return this;
    }

    @JsonProperty(value="incomeEvidenceDueDate")
    public LocalDateTime getIncomeEvidenceDueDate() {
        return this.incomeEvidenceDueDate;
    }

    @JsonProperty(value="incomeEvidenceDueDate")
    public void setIncomeEvidenceDueDate(LocalDateTime incomeEvidenceDueDate) {
        this.incomeEvidenceDueDate = incomeEvidenceDueDate;
    }

    public MaatApiAssessmentResponse withIncomeEvidenceDueDate(LocalDateTime incomeEvidenceDueDate) {
        this.incomeEvidenceDueDate = incomeEvidenceDueDate;
        return this;
    }

    @JsonProperty(value="evidenceReceivedDate")
    public LocalDateTime getEvidenceReceivedDate() {
        return this.evidenceReceivedDate;
    }

    @JsonProperty(value="evidenceReceivedDate")
    public void setEvidenceReceivedDate(LocalDateTime evidenceReceivedDate) {
        this.evidenceReceivedDate = evidenceReceivedDate;
    }

    public MaatApiAssessmentResponse withEvidenceReceivedDate(LocalDateTime evidenceReceivedDate) {
        this.evidenceReceivedDate = evidenceReceivedDate;
        return this;
    }

    @JsonProperty(value="incomeUpliftRemoveDate")
    public LocalDateTime getIncomeUpliftRemoveDate() {
        return this.incomeUpliftRemoveDate;
    }

    @JsonProperty(value="incomeUpliftRemoveDate")
    public void setIncomeUpliftRemoveDate(LocalDateTime incomeUpliftRemoveDate) {
        this.incomeUpliftRemoveDate = incomeUpliftRemoveDate;
    }

    public MaatApiAssessmentResponse withIncomeUpliftRemoveDate(LocalDateTime incomeUpliftRemoveDate) {
        this.incomeUpliftRemoveDate = incomeUpliftRemoveDate;
        return this;
    }

    @JsonProperty(value="incomeUpliftApplyDate")
    public LocalDateTime getIncomeUpliftApplyDate() {
        return this.incomeUpliftApplyDate;
    }

    @JsonProperty(value="incomeUpliftApplyDate")
    public void setIncomeUpliftApplyDate(LocalDateTime incomeUpliftApplyDate) {
        this.incomeUpliftApplyDate = incomeUpliftApplyDate;
    }

    public MaatApiAssessmentResponse withIncomeUpliftApplyDate(LocalDateTime incomeUpliftApplyDate) {
        this.incomeUpliftApplyDate = incomeUpliftApplyDate;
        return this;
    }

    @JsonProperty(value="incomeEvidenceNotes")
    public String getIncomeEvidenceNotes() {
        return this.incomeEvidenceNotes;
    }

    @JsonProperty(value="incomeEvidenceNotes")
    public void setIncomeEvidenceNotes(String incomeEvidenceNotes) {
        this.incomeEvidenceNotes = incomeEvidenceNotes;
    }

    public MaatApiAssessmentResponse withIncomeEvidenceNotes(String incomeEvidenceNotes) {
        this.incomeEvidenceNotes = incomeEvidenceNotes;
        return this;
    }

    @JsonProperty(value="initApplicationEmploymentStatus")
    public String getInitApplicationEmploymentStatus() {
        return this.initApplicationEmploymentStatus;
    }

    @JsonProperty(value="initApplicationEmploymentStatus")
    public void setInitApplicationEmploymentStatus(String initApplicationEmploymentStatus) {
        this.initApplicationEmploymentStatus = initApplicationEmploymentStatus;
    }

    public MaatApiAssessmentResponse withInitApplicationEmploymentStatus(String initApplicationEmploymentStatus) {
        this.initApplicationEmploymentStatus = initApplicationEmploymentStatus;
        return this;
    }

    @JsonProperty(value="fassFullStatus")
    public String getFassFullStatus() {
        return this.fassFullStatus;
    }

    @JsonProperty(value="fassFullStatus")
    public void setFassFullStatus(String fassFullStatus) {
        this.fassFullStatus = fassFullStatus;
    }

    public MaatApiAssessmentResponse withFassFullStatus(String fassFullStatus) {
        this.fassFullStatus = fassFullStatus;
        return this;
    }

    @JsonProperty(value="fullAssessmentDate")
    public LocalDateTime getFullAssessmentDate() {
        return this.fullAssessmentDate;
    }

    @JsonProperty(value="fullAssessmentDate")
    public void setFullAssessmentDate(LocalDateTime fullAssessmentDate) {
        this.fullAssessmentDate = fullAssessmentDate;
    }

    public MaatApiAssessmentResponse withFullAssessmentDate(LocalDateTime fullAssessmentDate) {
        this.fullAssessmentDate = fullAssessmentDate;
        return this;
    }

    @JsonProperty(value="fullResult")
    public String getFullResult() {
        return this.fullResult;
    }

    @JsonProperty(value="fullResult")
    public void setFullResult(String fullResult) {
        this.fullResult = fullResult;
    }

    public MaatApiAssessmentResponse withFullResult(String fullResult) {
        this.fullResult = fullResult;
        return this;
    }

    @JsonProperty(value="fullResultReason")
    public String getFullResultReason() {
        return this.fullResultReason;
    }

    @JsonProperty(value="fullResultReason")
    public void setFullResultReason(String fullResultReason) {
        this.fullResultReason = fullResultReason;
    }

    public MaatApiAssessmentResponse withFullResultReason(String fullResultReason) {
        this.fullResultReason = fullResultReason;
        return this;
    }

    @JsonProperty(value="fullAssessmentNotes")
    public String getFullAssessmentNotes() {
        return this.fullAssessmentNotes;
    }

    @JsonProperty(value="fullAssessmentNotes")
    public void setFullAssessmentNotes(String fullAssessmentNotes) {
        this.fullAssessmentNotes = fullAssessmentNotes;
    }

    public MaatApiAssessmentResponse withFullAssessmentNotes(String fullAssessmentNotes) {
        this.fullAssessmentNotes = fullAssessmentNotes;
        return this;
    }

    @JsonProperty(value="fullAdjustedLivingAllowance")
    public BigDecimal getFullAdjustedLivingAllowance() {
        return this.fullAdjustedLivingAllowance;
    }

    @JsonProperty(value="fullAdjustedLivingAllowance")
    public void setFullAdjustedLivingAllowance(BigDecimal fullAdjustedLivingAllowance) {
        this.fullAdjustedLivingAllowance = fullAdjustedLivingAllowance;
    }

    public MaatApiAssessmentResponse withFullAdjustedLivingAllowance(BigDecimal fullAdjustedLivingAllowance) {
        this.fullAdjustedLivingAllowance = fullAdjustedLivingAllowance;
        return this;
    }

    @JsonProperty(value="fullTotalAnnualDisposableIncome")
    public BigDecimal getFullTotalAnnualDisposableIncome() {
        return this.fullTotalAnnualDisposableIncome;
    }

    @JsonProperty(value="fullTotalAnnualDisposableIncome")
    public void setFullTotalAnnualDisposableIncome(BigDecimal fullTotalAnnualDisposableIncome) {
        this.fullTotalAnnualDisposableIncome = fullTotalAnnualDisposableIncome;
    }

    public MaatApiAssessmentResponse withFullTotalAnnualDisposableIncome(BigDecimal fullTotalAnnualDisposableIncome) {
        this.fullTotalAnnualDisposableIncome = fullTotalAnnualDisposableIncome;
        return this;
    }

    @JsonProperty(value="fullOtherHousingNote")
    public String getFullOtherHousingNote() {
        return this.fullOtherHousingNote;
    }

    @JsonProperty(value="fullOtherHousingNote")
    public void setFullOtherHousingNote(String fullOtherHousingNote) {
        this.fullOtherHousingNote = fullOtherHousingNote;
    }

    public MaatApiAssessmentResponse withFullOtherHousingNote(String fullOtherHousingNote) {
        this.fullOtherHousingNote = fullOtherHousingNote;
        return this;
    }

    @JsonProperty(value="fullTotalAggregatedExpenses")
    public BigDecimal getFullTotalAggregatedExpenses() {
        return this.fullTotalAggregatedExpenses;
    }

    @JsonProperty(value="fullTotalAggregatedExpenses")
    public void setFullTotalAggregatedExpenses(BigDecimal fullTotalAggregatedExpenses) {
        this.fullTotalAggregatedExpenses = fullTotalAggregatedExpenses;
    }

    public MaatApiAssessmentResponse withFullTotalAggregatedExpenses(BigDecimal fullTotalAggregatedExpenses) {
        this.fullTotalAggregatedExpenses = fullTotalAggregatedExpenses;
        return this;
    }

    @JsonProperty(value="fullAscrId")
    public Integer getFullAscrId() {
        return this.fullAscrId;
    }

    @JsonProperty(value="fullAscrId")
    public void setFullAscrId(Integer fullAscrId) {
        this.fullAscrId = fullAscrId;
    }

    public MaatApiAssessmentResponse withFullAscrId(Integer fullAscrId) {
        this.fullAscrId = fullAscrId;
        return this;
    }

    @JsonProperty(value="dateCompleted")
    public LocalDateTime getDateCompleted() {
        return this.dateCompleted;
    }

    @JsonProperty(value="dateCompleted")
    public void setDateCompleted(LocalDateTime dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    public MaatApiAssessmentResponse withDateCompleted(LocalDateTime dateCompleted) {
        this.dateCompleted = dateCompleted;
        return this;
    }

    @JsonProperty(value="updated")
    public LocalDateTime getUpdated() {
        return this.updated;
    }

    @JsonProperty(value="updated")
    public void setUpdated(LocalDateTime updated) {
        this.updated = updated;
    }

    public MaatApiAssessmentResponse withUpdated(LocalDateTime updated) {
        this.updated = updated;
        return this;
    }

    @JsonProperty(value="userModified")
    public String getUserModified() {
        return this.userModified;
    }

    @JsonProperty(value="userModified")
    public void setUserModified(String userModified) {
        this.userModified = userModified;
    }

    public MaatApiAssessmentResponse withUserModified(String userModified) {
        this.userModified = userModified;
        return this;
    }

    @JsonProperty(value="usn")
    public Integer getUsn() {
        return this.usn;
    }

    @JsonProperty(value="usn")
    public void setUsn(Integer usn) {
        this.usn = usn;
    }

    public MaatApiAssessmentResponse withUsn(Integer usn) {
        this.usn = usn;
        return this;
    }

    @JsonProperty(value="rtCode")
    public String getRtCode() {
        return this.rtCode;
    }

    @JsonProperty(value="rtCode")
    public void setRtCode(String rtCode) {
        this.rtCode = rtCode;
    }

    public MaatApiAssessmentResponse withRtCode(String rtCode) {
        this.rtCode = rtCode;
        return this;
    }

    @JsonProperty(value="assessmentDetails")
    public List<ApiAssessmentDetail> getAssessmentDetails() {
        return this.assessmentDetails;
    }

    @JsonProperty(value="assessmentDetails")
    public void setAssessmentDetails(List<ApiAssessmentDetail> assessmentDetails) {
        this.assessmentDetails = assessmentDetails;
    }

    public MaatApiAssessmentResponse withAssessmentDetails(List<ApiAssessmentDetail> assessmentDetails) {
        this.assessmentDetails = assessmentDetails;
        return this;
    }

    @JsonProperty(value="childWeightings")
    public List<ApiAssessmentChildWeighting> getChildWeightings() {
        return this.childWeightings;
    }

    @JsonProperty(value="childWeightings")
    public void setChildWeightings(List<ApiAssessmentChildWeighting> childWeightings) {
        this.childWeightings = childWeightings;
    }

    public MaatApiAssessmentResponse withChildWeightings(List<ApiAssessmentChildWeighting> childWeightings) {
        this.childWeightings = childWeightings;
        return this;
    }

    @JsonProperty(value="incomeEvidence")
    public List<ApiIncomeEvidence> getIncomeEvidence() {
        return this.incomeEvidence;
    }

    @JsonProperty(value="incomeEvidence")
    public void setIncomeEvidence(List<ApiIncomeEvidence> incomeEvidence) {
        this.incomeEvidence = incomeEvidence;
    }

    public MaatApiAssessmentResponse withIncomeEvidence(List<ApiIncomeEvidence> incomeEvidence) {
        this.incomeEvidence = incomeEvidence;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MaatApiAssessmentResponse withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("id".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"id\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setId((Integer)value);
            return true;
        }
        if ("repId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"repId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setRepId((Integer)value);
            return true;
        }
        if ("initialAscrId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"initialAscrId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setInitialAscrId((Integer)value);
            return true;
        }
        if ("assessmentType".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"assessmentType\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setAssessmentType((String)value);
            return true;
        }
        if ("nworCode".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"nworCode\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setNworCode((String)value);
            return true;
        }
        if ("dateCreated".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"dateCreated\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setDateCreated((LocalDateTime)value);
            return true;
        }
        if ("userCreated".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"userCreated\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUserCreated((String)value);
            return true;
        }
        if ("cmuId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"cmuId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setCmuId((Integer)value);
            return true;
        }
        if ("fassInitStatus".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fassInitStatus\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFassInitStatus((String)value);
            return true;
        }
        if ("initialAssessmentDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"initialAssessmentDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setInitialAssessmentDate((LocalDateTime)value);
            return true;
        }
        if ("initOtherBenefitNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initOtherBenefitNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitOtherBenefitNote((String)value);
            return true;
        }
        if ("initOtherIncomeNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initOtherIncomeNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitOtherIncomeNote((String)value);
            return true;
        }
        if ("initTotAggregatedIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"initTotAggregatedIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setInitTotAggregatedIncome((BigDecimal)value);
            return true;
        }
        if ("initAdjustedIncomeValue".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"initAdjustedIncomeValue\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setInitAdjustedIncomeValue((BigDecimal)value);
            return true;
        }
        if ("initNotes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initNotes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitNotes((String)value);
            return true;
        }
        if ("initResult".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initResult\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitResult((String)value);
            return true;
        }
        if ("initResultReason".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initResultReason\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitResultReason((String)value);
            return true;
        }
        if ("incomeEvidenceDueDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"incomeEvidenceDueDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidenceDueDate((LocalDateTime)value);
            return true;
        }
        if ("evidenceReceivedDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"evidenceReceivedDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setEvidenceReceivedDate((LocalDateTime)value);
            return true;
        }
        if ("incomeUpliftRemoveDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"incomeUpliftRemoveDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setIncomeUpliftRemoveDate((LocalDateTime)value);
            return true;
        }
        if ("incomeUpliftApplyDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"incomeUpliftApplyDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setIncomeUpliftApplyDate((LocalDateTime)value);
            return true;
        }
        if ("incomeEvidenceNotes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"incomeEvidenceNotes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidenceNotes((String)value);
            return true;
        }
        if ("initApplicationEmploymentStatus".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"initApplicationEmploymentStatus\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setInitApplicationEmploymentStatus((String)value);
            return true;
        }
        if ("fassFullStatus".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fassFullStatus\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFassFullStatus((String)value);
            return true;
        }
        if ("fullAssessmentDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"fullAssessmentDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setFullAssessmentDate((LocalDateTime)value);
            return true;
        }
        if ("fullResult".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fullResult\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFullResult((String)value);
            return true;
        }
        if ("fullResultReason".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fullResultReason\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFullResultReason((String)value);
            return true;
        }
        if ("fullAssessmentNotes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fullAssessmentNotes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFullAssessmentNotes((String)value);
            return true;
        }
        if ("fullAdjustedLivingAllowance".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"fullAdjustedLivingAllowance\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setFullAdjustedLivingAllowance((BigDecimal)value);
            return true;
        }
        if ("fullTotalAnnualDisposableIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"fullTotalAnnualDisposableIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setFullTotalAnnualDisposableIncome((BigDecimal)value);
            return true;
        }
        if ("fullOtherHousingNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fullOtherHousingNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFullOtherHousingNote((String)value);
            return true;
        }
        if ("fullTotalAggregatedExpenses".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"fullTotalAggregatedExpenses\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setFullTotalAggregatedExpenses((BigDecimal)value);
            return true;
        }
        if ("fullAscrId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"fullAscrId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setFullAscrId((Integer)value);
            return true;
        }
        if ("dateCompleted".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"dateCompleted\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setDateCompleted((LocalDateTime)value);
            return true;
        }
        if ("updated".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"updated\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setUpdated((LocalDateTime)value);
            return true;
        }
        if ("userModified".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"userModified\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUserModified((String)value);
            return true;
        }
        if ("usn".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"usn\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setUsn((Integer)value);
            return true;
        }
        if ("rtCode".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"rtCode\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setRtCode((String)value);
            return true;
        }
        if ("assessmentDetails".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"assessmentDetails\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentDetail>\", but got " + value.getClass().toString());
            }
            this.setAssessmentDetails((List)value);
            return true;
        }
        if ("childWeightings".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"childWeightings\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentChildWeighting>\", but got " + value.getClass().toString());
            }
            this.setChildWeightings((List)value);
            return true;
        }
        if ("incomeEvidence".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"incomeEvidence\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.ApiIncomeEvidence>\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidence((List)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("repId".equals(name)) {
            return this.getRepId();
        }
        if ("initialAscrId".equals(name)) {
            return this.getInitialAscrId();
        }
        if ("assessmentType".equals(name)) {
            return this.getAssessmentType();
        }
        if ("nworCode".equals(name)) {
            return this.getNworCode();
        }
        if ("dateCreated".equals(name)) {
            return this.getDateCreated();
        }
        if ("userCreated".equals(name)) {
            return this.getUserCreated();
        }
        if ("cmuId".equals(name)) {
            return this.getCmuId();
        }
        if ("fassInitStatus".equals(name)) {
            return this.getFassInitStatus();
        }
        if ("initialAssessmentDate".equals(name)) {
            return this.getInitialAssessmentDate();
        }
        if ("initOtherBenefitNote".equals(name)) {
            return this.getInitOtherBenefitNote();
        }
        if ("initOtherIncomeNote".equals(name)) {
            return this.getInitOtherIncomeNote();
        }
        if ("initTotAggregatedIncome".equals(name)) {
            return this.getInitTotAggregatedIncome();
        }
        if ("initAdjustedIncomeValue".equals(name)) {
            return this.getInitAdjustedIncomeValue();
        }
        if ("initNotes".equals(name)) {
            return this.getInitNotes();
        }
        if ("initResult".equals(name)) {
            return this.getInitResult();
        }
        if ("initResultReason".equals(name)) {
            return this.getInitResultReason();
        }
        if ("incomeEvidenceDueDate".equals(name)) {
            return this.getIncomeEvidenceDueDate();
        }
        if ("evidenceReceivedDate".equals(name)) {
            return this.getEvidenceReceivedDate();
        }
        if ("incomeUpliftRemoveDate".equals(name)) {
            return this.getIncomeUpliftRemoveDate();
        }
        if ("incomeUpliftApplyDate".equals(name)) {
            return this.getIncomeUpliftApplyDate();
        }
        if ("incomeEvidenceNotes".equals(name)) {
            return this.getIncomeEvidenceNotes();
        }
        if ("initApplicationEmploymentStatus".equals(name)) {
            return this.getInitApplicationEmploymentStatus();
        }
        if ("fassFullStatus".equals(name)) {
            return this.getFassFullStatus();
        }
        if ("fullAssessmentDate".equals(name)) {
            return this.getFullAssessmentDate();
        }
        if ("fullResult".equals(name)) {
            return this.getFullResult();
        }
        if ("fullResultReason".equals(name)) {
            return this.getFullResultReason();
        }
        if ("fullAssessmentNotes".equals(name)) {
            return this.getFullAssessmentNotes();
        }
        if ("fullAdjustedLivingAllowance".equals(name)) {
            return this.getFullAdjustedLivingAllowance();
        }
        if ("fullTotalAnnualDisposableIncome".equals(name)) {
            return this.getFullTotalAnnualDisposableIncome();
        }
        if ("fullOtherHousingNote".equals(name)) {
            return this.getFullOtherHousingNote();
        }
        if ("fullTotalAggregatedExpenses".equals(name)) {
            return this.getFullTotalAggregatedExpenses();
        }
        if ("fullAscrId".equals(name)) {
            return this.getFullAscrId();
        }
        if ("dateCompleted".equals(name)) {
            return this.getDateCompleted();
        }
        if ("updated".equals(name)) {
            return this.getUpdated();
        }
        if ("userModified".equals(name)) {
            return this.getUserModified();
        }
        if ("usn".equals(name)) {
            return this.getUsn();
        }
        if ("rtCode".equals(name)) {
            return this.getRtCode();
        }
        if ("assessmentDetails".equals(name)) {
            return this.getAssessmentDetails();
        }
        if ("childWeightings".equals(name)) {
            return this.getChildWeightings();
        }
        if ("incomeEvidence".equals(name)) {
            return this.getIncomeEvidence();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public MaatApiAssessmentResponse with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MaatApiAssessmentResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("repId");
        sb.append('=');
        sb.append(this.repId == null ? "<null>" : this.repId);
        sb.append(',');
        sb.append("initialAscrId");
        sb.append('=');
        sb.append(this.initialAscrId == null ? "<null>" : this.initialAscrId);
        sb.append(',');
        sb.append("assessmentType");
        sb.append('=');
        sb.append(this.assessmentType == null ? "<null>" : this.assessmentType);
        sb.append(',');
        sb.append("nworCode");
        sb.append('=');
        sb.append(this.nworCode == null ? "<null>" : this.nworCode);
        sb.append(',');
        sb.append("dateCreated");
        sb.append('=');
        sb.append(this.dateCreated == null ? "<null>" : this.dateCreated);
        sb.append(',');
        sb.append("userCreated");
        sb.append('=');
        sb.append(this.userCreated == null ? "<null>" : this.userCreated);
        sb.append(',');
        sb.append("cmuId");
        sb.append('=');
        sb.append(this.cmuId == null ? "<null>" : this.cmuId);
        sb.append(',');
        sb.append("fassInitStatus");
        sb.append('=');
        sb.append(this.fassInitStatus == null ? "<null>" : this.fassInitStatus);
        sb.append(',');
        sb.append("initialAssessmentDate");
        sb.append('=');
        sb.append(this.initialAssessmentDate == null ? "<null>" : this.initialAssessmentDate);
        sb.append(',');
        sb.append("initOtherBenefitNote");
        sb.append('=');
        sb.append(this.initOtherBenefitNote == null ? "<null>" : this.initOtherBenefitNote);
        sb.append(',');
        sb.append("initOtherIncomeNote");
        sb.append('=');
        sb.append(this.initOtherIncomeNote == null ? "<null>" : this.initOtherIncomeNote);
        sb.append(',');
        sb.append("initTotAggregatedIncome");
        sb.append('=');
        sb.append(this.initTotAggregatedIncome == null ? "<null>" : this.initTotAggregatedIncome);
        sb.append(',');
        sb.append("initAdjustedIncomeValue");
        sb.append('=');
        sb.append(this.initAdjustedIncomeValue == null ? "<null>" : this.initAdjustedIncomeValue);
        sb.append(',');
        sb.append("initNotes");
        sb.append('=');
        sb.append(this.initNotes == null ? "<null>" : this.initNotes);
        sb.append(',');
        sb.append("initResult");
        sb.append('=');
        sb.append(this.initResult == null ? "<null>" : this.initResult);
        sb.append(',');
        sb.append("initResultReason");
        sb.append('=');
        sb.append(this.initResultReason == null ? "<null>" : this.initResultReason);
        sb.append(',');
        sb.append("incomeEvidenceDueDate");
        sb.append('=');
        sb.append(this.incomeEvidenceDueDate == null ? "<null>" : this.incomeEvidenceDueDate);
        sb.append(',');
        sb.append("evidenceReceivedDate");
        sb.append('=');
        sb.append(this.evidenceReceivedDate == null ? "<null>" : this.evidenceReceivedDate);
        sb.append(',');
        sb.append("incomeUpliftRemoveDate");
        sb.append('=');
        sb.append(this.incomeUpliftRemoveDate == null ? "<null>" : this.incomeUpliftRemoveDate);
        sb.append(',');
        sb.append("incomeUpliftApplyDate");
        sb.append('=');
        sb.append(this.incomeUpliftApplyDate == null ? "<null>" : this.incomeUpliftApplyDate);
        sb.append(',');
        sb.append("incomeEvidenceNotes");
        sb.append('=');
        sb.append(this.incomeEvidenceNotes == null ? "<null>" : this.incomeEvidenceNotes);
        sb.append(',');
        sb.append("initApplicationEmploymentStatus");
        sb.append('=');
        sb.append(this.initApplicationEmploymentStatus == null ? "<null>" : this.initApplicationEmploymentStatus);
        sb.append(',');
        sb.append("fassFullStatus");
        sb.append('=');
        sb.append(this.fassFullStatus == null ? "<null>" : this.fassFullStatus);
        sb.append(',');
        sb.append("fullAssessmentDate");
        sb.append('=');
        sb.append(this.fullAssessmentDate == null ? "<null>" : this.fullAssessmentDate);
        sb.append(',');
        sb.append("fullResult");
        sb.append('=');
        sb.append(this.fullResult == null ? "<null>" : this.fullResult);
        sb.append(',');
        sb.append("fullResultReason");
        sb.append('=');
        sb.append(this.fullResultReason == null ? "<null>" : this.fullResultReason);
        sb.append(',');
        sb.append("fullAssessmentNotes");
        sb.append('=');
        sb.append(this.fullAssessmentNotes == null ? "<null>" : this.fullAssessmentNotes);
        sb.append(',');
        sb.append("fullAdjustedLivingAllowance");
        sb.append('=');
        sb.append(this.fullAdjustedLivingAllowance == null ? "<null>" : this.fullAdjustedLivingAllowance);
        sb.append(',');
        sb.append("fullTotalAnnualDisposableIncome");
        sb.append('=');
        sb.append(this.fullTotalAnnualDisposableIncome == null ? "<null>" : this.fullTotalAnnualDisposableIncome);
        sb.append(',');
        sb.append("fullOtherHousingNote");
        sb.append('=');
        sb.append(this.fullOtherHousingNote == null ? "<null>" : this.fullOtherHousingNote);
        sb.append(',');
        sb.append("fullTotalAggregatedExpenses");
        sb.append('=');
        sb.append(this.fullTotalAggregatedExpenses == null ? "<null>" : this.fullTotalAggregatedExpenses);
        sb.append(',');
        sb.append("fullAscrId");
        sb.append('=');
        sb.append(this.fullAscrId == null ? "<null>" : this.fullAscrId);
        sb.append(',');
        sb.append("dateCompleted");
        sb.append('=');
        sb.append(this.dateCompleted == null ? "<null>" : this.dateCompleted);
        sb.append(',');
        sb.append("updated");
        sb.append('=');
        sb.append(this.updated == null ? "<null>" : this.updated);
        sb.append(',');
        sb.append("userModified");
        sb.append('=');
        sb.append(this.userModified == null ? "<null>" : this.userModified);
        sb.append(',');
        sb.append("usn");
        sb.append('=');
        sb.append(this.usn == null ? "<null>" : this.usn);
        sb.append(',');
        sb.append("rtCode");
        sb.append('=');
        sb.append(this.rtCode == null ? "<null>" : this.rtCode);
        sb.append(',');
        sb.append("assessmentDetails");
        sb.append('=');
        sb.append(this.assessmentDetails == null ? "<null>" : this.assessmentDetails);
        sb.append(',');
        sb.append("childWeightings");
        sb.append('=');
        sb.append(this.childWeightings == null ? "<null>" : this.childWeightings);
        sb.append(',');
        sb.append("incomeEvidence");
        sb.append('=');
        sb.append(this.incomeEvidence == null ? "<null>" : this.incomeEvidence);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.incomeEvidenceNotes == null ? 0 : this.incomeEvidenceNotes.hashCode());
        result = result * 31 + (this.assessmentType == null ? 0 : this.assessmentType.hashCode());
        result = result * 31 + (this.rtCode == null ? 0 : this.rtCode.hashCode());
        result = result * 31 + (this.fullAssessmentDate == null ? 0 : this.fullAssessmentDate.hashCode());
        result = result * 31 + (this.fullTotalAggregatedExpenses == null ? 0 : this.fullTotalAggregatedExpenses.hashCode());
        result = result * 31 + (this.userCreated == null ? 0 : this.userCreated.hashCode());
        result = result * 31 + (this.fullAssessmentNotes == null ? 0 : this.fullAssessmentNotes.hashCode());
        result = result * 31 + (this.fullResult == null ? 0 : this.fullResult.hashCode());
        result = result * 31 + (this.fullResultReason == null ? 0 : this.fullResultReason.hashCode());
        result = result * 31 + (this.usn == null ? 0 : this.usn.hashCode());
        result = result * 31 + (this.initOtherIncomeNote == null ? 0 : this.initOtherIncomeNote.hashCode());
        result = result * 31 + (this.fullAdjustedLivingAllowance == null ? 0 : this.fullAdjustedLivingAllowance.hashCode());
        result = result * 31 + (this.dateCreated == null ? 0 : this.dateCreated.hashCode());
        result = result * 31 + (this.fullTotalAnnualDisposableIncome == null ? 0 : this.fullTotalAnnualDisposableIncome.hashCode());
        result = result * 31 + (this.fullAscrId == null ? 0 : this.fullAscrId.hashCode());
        result = result * 31 + (this.initialAssessmentDate == null ? 0 : this.initialAssessmentDate.hashCode());
        result = result * 31 + (this.dateCompleted == null ? 0 : this.dateCompleted.hashCode());
        result = result * 31 + (this.assessmentDetails == null ? 0 : this.assessmentDetails.hashCode());
        result = result * 31 + (this.initialAscrId == null ? 0 : this.initialAscrId.hashCode());
        result = result * 31 + (this.fassInitStatus == null ? 0 : this.fassInitStatus.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.fullOtherHousingNote == null ? 0 : this.fullOtherHousingNote.hashCode());
        result = result * 31 + (this.cmuId == null ? 0 : this.cmuId.hashCode());
        result = result * 31 + (this.initNotes == null ? 0 : this.initNotes.hashCode());
        result = result * 31 + (this.incomeEvidenceDueDate == null ? 0 : this.incomeEvidenceDueDate.hashCode());
        result = result * 31 + (this.initAdjustedIncomeValue == null ? 0 : this.initAdjustedIncomeValue.hashCode());
        result = result * 31 + (this.initResult == null ? 0 : this.initResult.hashCode());
        result = result * 31 + (this.initResultReason == null ? 0 : this.initResultReason.hashCode());
        result = result * 31 + (this.incomeUpliftApplyDate == null ? 0 : this.incomeUpliftApplyDate.hashCode());
        result = result * 31 + (this.fassFullStatus == null ? 0 : this.fassFullStatus.hashCode());
        result = result * 31 + (this.repId == null ? 0 : this.repId.hashCode());
        result = result * 31 + (this.nworCode == null ? 0 : this.nworCode.hashCode());
        result = result * 31 + (this.initApplicationEmploymentStatus == null ? 0 : this.initApplicationEmploymentStatus.hashCode());
        result = result * 31 + (this.childWeightings == null ? 0 : this.childWeightings.hashCode());
        result = result * 31 + (this.initOtherBenefitNote == null ? 0 : this.initOtherBenefitNote.hashCode());
        result = result * 31 + (this.incomeEvidence == null ? 0 : this.incomeEvidence.hashCode());
        result = result * 31 + (this.incomeUpliftRemoveDate == null ? 0 : this.incomeUpliftRemoveDate.hashCode());
        result = result * 31 + (this.initTotAggregatedIncome == null ? 0 : this.initTotAggregatedIncome.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.evidenceReceivedDate == null ? 0 : this.evidenceReceivedDate.hashCode());
        result = result * 31 + (this.updated == null ? 0 : this.updated.hashCode());
        result = result * 31 + (this.userModified == null ? 0 : this.userModified.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MaatApiAssessmentResponse)) {
            return false;
        }
        MaatApiAssessmentResponse rhs = (MaatApiAssessmentResponse)other;
        return (this.incomeEvidenceNotes == rhs.incomeEvidenceNotes || this.incomeEvidenceNotes != null && this.incomeEvidenceNotes.equals(rhs.incomeEvidenceNotes)) && (this.assessmentType == rhs.assessmentType || this.assessmentType != null && this.assessmentType.equals(rhs.assessmentType)) && (this.rtCode == rhs.rtCode || this.rtCode != null && this.rtCode.equals(rhs.rtCode)) && (this.fullAssessmentDate == rhs.fullAssessmentDate || this.fullAssessmentDate != null && this.fullAssessmentDate.equals(rhs.fullAssessmentDate)) && (this.fullTotalAggregatedExpenses == rhs.fullTotalAggregatedExpenses || this.fullTotalAggregatedExpenses != null && this.fullTotalAggregatedExpenses.equals(rhs.fullTotalAggregatedExpenses)) && (this.userCreated == rhs.userCreated || this.userCreated != null && this.userCreated.equals(rhs.userCreated)) && (this.fullAssessmentNotes == rhs.fullAssessmentNotes || this.fullAssessmentNotes != null && this.fullAssessmentNotes.equals(rhs.fullAssessmentNotes)) && (this.fullResult == rhs.fullResult || this.fullResult != null && this.fullResult.equals(rhs.fullResult)) && (this.fullResultReason == rhs.fullResultReason || this.fullResultReason != null && this.fullResultReason.equals(rhs.fullResultReason)) && (this.usn == rhs.usn || this.usn != null && this.usn.equals(rhs.usn)) && (this.initOtherIncomeNote == rhs.initOtherIncomeNote || this.initOtherIncomeNote != null && this.initOtherIncomeNote.equals(rhs.initOtherIncomeNote)) && (this.fullAdjustedLivingAllowance == rhs.fullAdjustedLivingAllowance || this.fullAdjustedLivingAllowance != null && this.fullAdjustedLivingAllowance.equals(rhs.fullAdjustedLivingAllowance)) && (this.dateCreated == rhs.dateCreated || this.dateCreated != null && this.dateCreated.equals(rhs.dateCreated)) && (this.fullTotalAnnualDisposableIncome == rhs.fullTotalAnnualDisposableIncome || this.fullTotalAnnualDisposableIncome != null && this.fullTotalAnnualDisposableIncome.equals(rhs.fullTotalAnnualDisposableIncome)) && (this.fullAscrId == rhs.fullAscrId || this.fullAscrId != null && this.fullAscrId.equals(rhs.fullAscrId)) && (this.initialAssessmentDate == rhs.initialAssessmentDate || this.initialAssessmentDate != null && this.initialAssessmentDate.equals(rhs.initialAssessmentDate)) && (this.dateCompleted == rhs.dateCompleted || this.dateCompleted != null && this.dateCompleted.equals(rhs.dateCompleted)) && (this.assessmentDetails == rhs.assessmentDetails || this.assessmentDetails != null && this.assessmentDetails.equals(rhs.assessmentDetails)) && (this.initialAscrId == rhs.initialAscrId || this.initialAscrId != null && this.initialAscrId.equals(rhs.initialAscrId)) && (this.fassInitStatus == rhs.fassInitStatus || this.fassInitStatus != null && this.fassInitStatus.equals(rhs.fassInitStatus)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.fullOtherHousingNote == rhs.fullOtherHousingNote || this.fullOtherHousingNote != null && this.fullOtherHousingNote.equals(rhs.fullOtherHousingNote)) && (this.cmuId == rhs.cmuId || this.cmuId != null && this.cmuId.equals(rhs.cmuId)) && (this.initNotes == rhs.initNotes || this.initNotes != null && this.initNotes.equals(rhs.initNotes)) && (this.incomeEvidenceDueDate == rhs.incomeEvidenceDueDate || this.incomeEvidenceDueDate != null && this.incomeEvidenceDueDate.equals(rhs.incomeEvidenceDueDate)) && (this.initAdjustedIncomeValue == rhs.initAdjustedIncomeValue || this.initAdjustedIncomeValue != null && this.initAdjustedIncomeValue.equals(rhs.initAdjustedIncomeValue)) && (this.initResult == rhs.initResult || this.initResult != null && this.initResult.equals(rhs.initResult)) && (this.initResultReason == rhs.initResultReason || this.initResultReason != null && this.initResultReason.equals(rhs.initResultReason)) && (this.incomeUpliftApplyDate == rhs.incomeUpliftApplyDate || this.incomeUpliftApplyDate != null && this.incomeUpliftApplyDate.equals(rhs.incomeUpliftApplyDate)) && (this.fassFullStatus == rhs.fassFullStatus || this.fassFullStatus != null && this.fassFullStatus.equals(rhs.fassFullStatus)) && (this.repId == rhs.repId || this.repId != null && this.repId.equals(rhs.repId)) && (this.nworCode == rhs.nworCode || this.nworCode != null && this.nworCode.equals(rhs.nworCode)) && (this.initApplicationEmploymentStatus == rhs.initApplicationEmploymentStatus || this.initApplicationEmploymentStatus != null && this.initApplicationEmploymentStatus.equals(rhs.initApplicationEmploymentStatus)) && (this.childWeightings == rhs.childWeightings || this.childWeightings != null && this.childWeightings.equals(rhs.childWeightings)) && (this.initOtherBenefitNote == rhs.initOtherBenefitNote || this.initOtherBenefitNote != null && this.initOtherBenefitNote.equals(rhs.initOtherBenefitNote)) && (this.incomeEvidence == rhs.incomeEvidence || this.incomeEvidence != null && this.incomeEvidence.equals(rhs.incomeEvidence)) && (this.incomeUpliftRemoveDate == rhs.incomeUpliftRemoveDate || this.incomeUpliftRemoveDate != null && this.incomeUpliftRemoveDate.equals(rhs.incomeUpliftRemoveDate)) && (this.initTotAggregatedIncome == rhs.initTotAggregatedIncome || this.initTotAggregatedIncome != null && this.initTotAggregatedIncome.equals(rhs.initTotAggregatedIncome)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.evidenceReceivedDate == rhs.evidenceReceivedDate || this.evidenceReceivedDate != null && this.evidenceReceivedDate.equals(rhs.evidenceReceivedDate)) && (this.updated == rhs.updated || this.updated != null && this.updated.equals(rhs.updated)) && (this.userModified == rhs.userModified || this.userModified != null && this.userModified.equals(rhs.userModified));
    }
}

