/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment.maatapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentChildWeighting;
import uk.gov.justice.laa.crime.common.model.meansassessment.ApiAssessmentDetail;
import uk.gov.justice.laa.crime.common.model.meansassessment.maatapi.FinancialAssessmentIncomeEvidence;
import uk.gov.justice.laa.crime.common.model.meansassessment.maatapi.MaatApiAssessmentRequest;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "fassFullStatus", "fullAssessmentDate", "fullResult", "fullResultReason", "fullAssessmentNotes", "fullAdjustedLivingAllowance", "fullTotalAnnualDisposableIncome", "fullOtherHousingNote", "fullTotalAggregatedExpenses", "fullAscrId", "userModified", "finAssIncomeEvidences", "incomeUpliftApplyDate", "incomeUpliftRemoveDate", "evidenceReceivedDate"})
public class MaatApiUpdateAssessment
extends MaatApiAssessmentRequest {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Financial assessment ID")
    private Integer financialAssessmentId;
    @JsonProperty(value="fassFullStatus")
    @JsonPropertyDescription(value="Full assessment status")
    private String fassFullStatus;
    @JsonProperty(value="fullAssessmentDate")
    @JsonPropertyDescription(value="Full assessment date")
    private LocalDateTime fullAssessmentDate;
    @JsonProperty(value="fullResult")
    @JsonPropertyDescription(value="Full assessment result")
    private String fullResult;
    @JsonProperty(value="fullResultReason")
    @JsonPropertyDescription(value="Full assessment result reason")
    private String fullResultReason;
    @JsonProperty(value="fullAssessmentNotes")
    @JsonPropertyDescription(value="Full assessment notes")
    private String fullAssessmentNotes;
    @JsonProperty(value="fullAdjustedLivingAllowance")
    @JsonPropertyDescription(value="Full adjusted living allowance")
    private BigDecimal fullAdjustedLivingAllowance;
    @JsonProperty(value="fullTotalAnnualDisposableIncome")
    @JsonPropertyDescription(value="Full total annual disposable income")
    private BigDecimal fullTotalAnnualDisposableIncome;
    @JsonProperty(value="fullOtherHousingNote")
    @JsonPropertyDescription(value="Full other housing note")
    private String fullOtherHousingNote;
    @JsonProperty(value="fullTotalAggregatedExpenses")
    @JsonPropertyDescription(value="Full total aggregated expenses")
    private BigDecimal fullTotalAggregatedExpenses;
    @JsonProperty(value="fullAscrId")
    @JsonPropertyDescription(value="Full assessment criteria ID")
    private Integer fullAscrId;
    @JsonProperty(value="userModified")
    @JsonPropertyDescription(value="ID of the user that last modified the assessment")
    @NotNull
    private String userModified;
    @JsonProperty(value="finAssIncomeEvidences")
    @JsonPropertyDescription(value="Income evidence records")
    @Valid
    private List<FinancialAssessmentIncomeEvidence> finAssIncomeEvidences = new ArrayList<FinancialAssessmentIncomeEvidence>();
    @JsonProperty(value="incomeUpliftApplyDate")
    @JsonPropertyDescription(value="The current uplift applied date")
    private LocalDateTime incomeUpliftApplyDate;
    @JsonProperty(value="incomeUpliftRemoveDate")
    @JsonPropertyDescription(value="The current uplift removed date")
    private LocalDateTime incomeUpliftRemoveDate;
    @JsonProperty(value="evidenceReceivedDate")
    @JsonPropertyDescription(value="The date that all of the income evidence was received")
    private LocalDateTime evidenceReceivedDate;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public MaatApiUpdateAssessment() {
    }

    public MaatApiUpdateAssessment(Integer financialAssessmentId, String fassFullStatus, LocalDateTime fullAssessmentDate, String fullResult, String fullResultReason, String fullAssessmentNotes, BigDecimal fullAdjustedLivingAllowance, BigDecimal fullTotalAnnualDisposableIncome, String fullOtherHousingNote, BigDecimal fullTotalAggregatedExpenses, Integer fullAscrId, String userModified, List<FinancialAssessmentIncomeEvidence> finAssIncomeEvidences, LocalDateTime incomeUpliftApplyDate, LocalDateTime incomeUpliftRemoveDate, LocalDateTime evidenceReceivedDate, String laaTransactionId, Integer repId, Integer initialAscrId, String assessmentType, Integer cmuId, String fassInitStatus, LocalDateTime initialAssessmentDate, String initOtherBenefitNote, String initOtherIncomeNote, BigDecimal initTotAggregatedIncome, BigDecimal initAdjustedIncomeValue, String initNotes, String initResult, String initResultReason, LocalDateTime incomeEvidenceDueDate, String incomeEvidenceNotes, String initApplicationEmploymentStatus, List<ApiAssessmentDetail> assessmentDetails, List<ApiAssessmentChildWeighting> childWeightings, LocalDateTime dateCompleted) {
        super(laaTransactionId, repId, initialAscrId, assessmentType, cmuId, fassInitStatus, initialAssessmentDate, initOtherBenefitNote, initOtherIncomeNote, initTotAggregatedIncome, initAdjustedIncomeValue, initNotes, initResult, initResultReason, incomeEvidenceDueDate, incomeEvidenceNotes, initApplicationEmploymentStatus, assessmentDetails, childWeightings, dateCompleted);
        this.financialAssessmentId = financialAssessmentId;
        this.fassFullStatus = fassFullStatus;
        this.fullAssessmentDate = fullAssessmentDate;
        this.fullResult = fullResult;
        this.fullResultReason = fullResultReason;
        this.fullAssessmentNotes = fullAssessmentNotes;
        this.fullAdjustedLivingAllowance = fullAdjustedLivingAllowance;
        this.fullTotalAnnualDisposableIncome = fullTotalAnnualDisposableIncome;
        this.fullOtherHousingNote = fullOtherHousingNote;
        this.fullTotalAggregatedExpenses = fullTotalAggregatedExpenses;
        this.fullAscrId = fullAscrId;
        this.userModified = userModified;
        this.finAssIncomeEvidences = finAssIncomeEvidences;
        this.incomeUpliftApplyDate = incomeUpliftApplyDate;
        this.incomeUpliftRemoveDate = incomeUpliftRemoveDate;
        this.evidenceReceivedDate = evidenceReceivedDate;
    }

    @JsonProperty(value="id")
    public Integer getFinancialAssessmentId() {
        return this.financialAssessmentId;
    }

    @JsonProperty(value="id")
    public void setFinancialAssessmentId(Integer financialAssessmentId) {
        this.financialAssessmentId = financialAssessmentId;
    }

    public MaatApiUpdateAssessment withFinancialAssessmentId(Integer financialAssessmentId) {
        this.financialAssessmentId = financialAssessmentId;
        return this;
    }

    @JsonProperty(value="fassFullStatus")
    public String getFassFullStatus() {
        return this.fassFullStatus;
    }

    @JsonProperty(value="fassFullStatus")
    public void setFassFullStatus(String fassFullStatus) {
        this.fassFullStatus = fassFullStatus;
    }

    public MaatApiUpdateAssessment withFassFullStatus(String fassFullStatus) {
        this.fassFullStatus = fassFullStatus;
        return this;
    }

    @JsonProperty(value="fullAssessmentDate")
    public LocalDateTime getFullAssessmentDate() {
        return this.fullAssessmentDate;
    }

    @JsonProperty(value="fullAssessmentDate")
    public void setFullAssessmentDate(LocalDateTime fullAssessmentDate) {
        this.fullAssessmentDate = fullAssessmentDate;
    }

    public MaatApiUpdateAssessment withFullAssessmentDate(LocalDateTime fullAssessmentDate) {
        this.fullAssessmentDate = fullAssessmentDate;
        return this;
    }

    @JsonProperty(value="fullResult")
    public String getFullResult() {
        return this.fullResult;
    }

    @JsonProperty(value="fullResult")
    public void setFullResult(String fullResult) {
        this.fullResult = fullResult;
    }

    public MaatApiUpdateAssessment withFullResult(String fullResult) {
        this.fullResult = fullResult;
        return this;
    }

    @JsonProperty(value="fullResultReason")
    public String getFullResultReason() {
        return this.fullResultReason;
    }

    @JsonProperty(value="fullResultReason")
    public void setFullResultReason(String fullResultReason) {
        this.fullResultReason = fullResultReason;
    }

    public MaatApiUpdateAssessment withFullResultReason(String fullResultReason) {
        this.fullResultReason = fullResultReason;
        return this;
    }

    @JsonProperty(value="fullAssessmentNotes")
    public String getFullAssessmentNotes() {
        return this.fullAssessmentNotes;
    }

    @JsonProperty(value="fullAssessmentNotes")
    public void setFullAssessmentNotes(String fullAssessmentNotes) {
        this.fullAssessmentNotes = fullAssessmentNotes;
    }

    public MaatApiUpdateAssessment withFullAssessmentNotes(String fullAssessmentNotes) {
        this.fullAssessmentNotes = fullAssessmentNotes;
        return this;
    }

    @JsonProperty(value="fullAdjustedLivingAllowance")
    public BigDecimal getFullAdjustedLivingAllowance() {
        return this.fullAdjustedLivingAllowance;
    }

    @JsonProperty(value="fullAdjustedLivingAllowance")
    public void setFullAdjustedLivingAllowance(BigDecimal fullAdjustedLivingAllowance) {
        this.fullAdjustedLivingAllowance = fullAdjustedLivingAllowance;
    }

    public MaatApiUpdateAssessment withFullAdjustedLivingAllowance(BigDecimal fullAdjustedLivingAllowance) {
        this.fullAdjustedLivingAllowance = fullAdjustedLivingAllowance;
        return this;
    }

    @JsonProperty(value="fullTotalAnnualDisposableIncome")
    public BigDecimal getFullTotalAnnualDisposableIncome() {
        return this.fullTotalAnnualDisposableIncome;
    }

    @JsonProperty(value="fullTotalAnnualDisposableIncome")
    public void setFullTotalAnnualDisposableIncome(BigDecimal fullTotalAnnualDisposableIncome) {
        this.fullTotalAnnualDisposableIncome = fullTotalAnnualDisposableIncome;
    }

    public MaatApiUpdateAssessment withFullTotalAnnualDisposableIncome(BigDecimal fullTotalAnnualDisposableIncome) {
        this.fullTotalAnnualDisposableIncome = fullTotalAnnualDisposableIncome;
        return this;
    }

    @JsonProperty(value="fullOtherHousingNote")
    public String getFullOtherHousingNote() {
        return this.fullOtherHousingNote;
    }

    @JsonProperty(value="fullOtherHousingNote")
    public void setFullOtherHousingNote(String fullOtherHousingNote) {
        this.fullOtherHousingNote = fullOtherHousingNote;
    }

    public MaatApiUpdateAssessment withFullOtherHousingNote(String fullOtherHousingNote) {
        this.fullOtherHousingNote = fullOtherHousingNote;
        return this;
    }

    @JsonProperty(value="fullTotalAggregatedExpenses")
    public BigDecimal getFullTotalAggregatedExpenses() {
        return this.fullTotalAggregatedExpenses;
    }

    @JsonProperty(value="fullTotalAggregatedExpenses")
    public void setFullTotalAggregatedExpenses(BigDecimal fullTotalAggregatedExpenses) {
        this.fullTotalAggregatedExpenses = fullTotalAggregatedExpenses;
    }

    public MaatApiUpdateAssessment withFullTotalAggregatedExpenses(BigDecimal fullTotalAggregatedExpenses) {
        this.fullTotalAggregatedExpenses = fullTotalAggregatedExpenses;
        return this;
    }

    @JsonProperty(value="fullAscrId")
    public Integer getFullAscrId() {
        return this.fullAscrId;
    }

    @JsonProperty(value="fullAscrId")
    public void setFullAscrId(Integer fullAscrId) {
        this.fullAscrId = fullAscrId;
    }

    public MaatApiUpdateAssessment withFullAscrId(Integer fullAscrId) {
        this.fullAscrId = fullAscrId;
        return this;
    }

    @JsonProperty(value="userModified")
    public String getUserModified() {
        return this.userModified;
    }

    @JsonProperty(value="userModified")
    public void setUserModified(String userModified) {
        this.userModified = userModified;
    }

    public MaatApiUpdateAssessment withUserModified(String userModified) {
        this.userModified = userModified;
        return this;
    }

    @JsonProperty(value="finAssIncomeEvidences")
    public List<FinancialAssessmentIncomeEvidence> getFinAssIncomeEvidences() {
        return this.finAssIncomeEvidences;
    }

    @JsonProperty(value="finAssIncomeEvidences")
    public void setFinAssIncomeEvidences(List<FinancialAssessmentIncomeEvidence> finAssIncomeEvidences) {
        this.finAssIncomeEvidences = finAssIncomeEvidences;
    }

    public MaatApiUpdateAssessment withFinAssIncomeEvidences(List<FinancialAssessmentIncomeEvidence> finAssIncomeEvidences) {
        this.finAssIncomeEvidences = finAssIncomeEvidences;
        return this;
    }

    @JsonProperty(value="incomeUpliftApplyDate")
    public LocalDateTime getIncomeUpliftApplyDate() {
        return this.incomeUpliftApplyDate;
    }

    @JsonProperty(value="incomeUpliftApplyDate")
    public void setIncomeUpliftApplyDate(LocalDateTime incomeUpliftApplyDate) {
        this.incomeUpliftApplyDate = incomeUpliftApplyDate;
    }

    public MaatApiUpdateAssessment withIncomeUpliftApplyDate(LocalDateTime incomeUpliftApplyDate) {
        this.incomeUpliftApplyDate = incomeUpliftApplyDate;
        return this;
    }

    @JsonProperty(value="incomeUpliftRemoveDate")
    public LocalDateTime getIncomeUpliftRemoveDate() {
        return this.incomeUpliftRemoveDate;
    }

    @JsonProperty(value="incomeUpliftRemoveDate")
    public void setIncomeUpliftRemoveDate(LocalDateTime incomeUpliftRemoveDate) {
        this.incomeUpliftRemoveDate = incomeUpliftRemoveDate;
    }

    public MaatApiUpdateAssessment withIncomeUpliftRemoveDate(LocalDateTime incomeUpliftRemoveDate) {
        this.incomeUpliftRemoveDate = incomeUpliftRemoveDate;
        return this;
    }

    @JsonProperty(value="evidenceReceivedDate")
    public LocalDateTime getEvidenceReceivedDate() {
        return this.evidenceReceivedDate;
    }

    @JsonProperty(value="evidenceReceivedDate")
    public void setEvidenceReceivedDate(LocalDateTime evidenceReceivedDate) {
        this.evidenceReceivedDate = evidenceReceivedDate;
    }

    public MaatApiUpdateAssessment withEvidenceReceivedDate(LocalDateTime evidenceReceivedDate) {
        this.evidenceReceivedDate = evidenceReceivedDate;
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withLaaTransactionId(String laaTransactionId) {
        super.withLaaTransactionId(laaTransactionId);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withRepId(Integer repId) {
        super.withRepId(repId);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withInitialAscrId(Integer initialAscrId) {
        super.withInitialAscrId(initialAscrId);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withAssessmentType(String assessmentType) {
        super.withAssessmentType(assessmentType);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withCmuId(Integer cmuId) {
        super.withCmuId(cmuId);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withFassInitStatus(String fassInitStatus) {
        super.withFassInitStatus(fassInitStatus);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withInitialAssessmentDate(LocalDateTime initialAssessmentDate) {
        super.withInitialAssessmentDate(initialAssessmentDate);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withInitOtherBenefitNote(String initOtherBenefitNote) {
        super.withInitOtherBenefitNote(initOtherBenefitNote);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withInitOtherIncomeNote(String initOtherIncomeNote) {
        super.withInitOtherIncomeNote(initOtherIncomeNote);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withInitTotAggregatedIncome(BigDecimal initTotAggregatedIncome) {
        super.withInitTotAggregatedIncome(initTotAggregatedIncome);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withInitAdjustedIncomeValue(BigDecimal initAdjustedIncomeValue) {
        super.withInitAdjustedIncomeValue(initAdjustedIncomeValue);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withInitNotes(String initNotes) {
        super.withInitNotes(initNotes);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withInitResult(String initResult) {
        super.withInitResult(initResult);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withInitResultReason(String initResultReason) {
        super.withInitResultReason(initResultReason);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withIncomeEvidenceDueDate(LocalDateTime incomeEvidenceDueDate) {
        super.withIncomeEvidenceDueDate(incomeEvidenceDueDate);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withIncomeEvidenceNotes(String incomeEvidenceNotes) {
        super.withIncomeEvidenceNotes(incomeEvidenceNotes);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withInitApplicationEmploymentStatus(String initApplicationEmploymentStatus) {
        super.withInitApplicationEmploymentStatus(initApplicationEmploymentStatus);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withAssessmentDetails(List<ApiAssessmentDetail> assessmentDetails) {
        super.withAssessmentDetails(assessmentDetails);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withChildWeightings(List<ApiAssessmentChildWeighting> childWeightings) {
        super.withChildWeightings(childWeightings);
        return this;
    }

    @Override
    public MaatApiUpdateAssessment withDateCompleted(LocalDateTime dateCompleted) {
        super.withDateCompleted(dateCompleted);
        return this;
    }

    @Override
    protected boolean declaredProperty(String name, Object value) {
        if ("id".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"id\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setFinancialAssessmentId((Integer)value);
            return true;
        }
        if ("fassFullStatus".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fassFullStatus\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFassFullStatus((String)value);
            return true;
        }
        if ("fullAssessmentDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"fullAssessmentDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setFullAssessmentDate((LocalDateTime)value);
            return true;
        }
        if ("fullResult".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fullResult\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFullResult((String)value);
            return true;
        }
        if ("fullResultReason".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fullResultReason\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFullResultReason((String)value);
            return true;
        }
        if ("fullAssessmentNotes".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fullAssessmentNotes\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFullAssessmentNotes((String)value);
            return true;
        }
        if ("fullAdjustedLivingAllowance".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"fullAdjustedLivingAllowance\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setFullAdjustedLivingAllowance((BigDecimal)value);
            return true;
        }
        if ("fullTotalAnnualDisposableIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"fullTotalAnnualDisposableIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setFullTotalAnnualDisposableIncome((BigDecimal)value);
            return true;
        }
        if ("fullOtherHousingNote".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"fullOtherHousingNote\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setFullOtherHousingNote((String)value);
            return true;
        }
        if ("fullTotalAggregatedExpenses".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"fullTotalAggregatedExpenses\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setFullTotalAggregatedExpenses((BigDecimal)value);
            return true;
        }
        if ("fullAscrId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"fullAscrId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setFullAscrId((Integer)value);
            return true;
        }
        if ("userModified".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"userModified\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUserModified((String)value);
            return true;
        }
        if ("finAssIncomeEvidences".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"finAssIncomeEvidences\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.meansassessment.maatapi.FinancialAssessmentIncomeEvidence>\", but got " + value.getClass().toString());
            }
            this.setFinAssIncomeEvidences((List)value);
            return true;
        }
        if ("incomeUpliftApplyDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"incomeUpliftApplyDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setIncomeUpliftApplyDate((LocalDateTime)value);
            return true;
        }
        if ("incomeUpliftRemoveDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"incomeUpliftRemoveDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setIncomeUpliftRemoveDate((LocalDateTime)value);
            return true;
        }
        if ("evidenceReceivedDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"evidenceReceivedDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setEvidenceReceivedDate((LocalDateTime)value);
            return true;
        }
        return super.declaredProperty(name, value);
    }

    @Override
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("id".equals(name)) {
            return this.getFinancialAssessmentId();
        }
        if ("fassFullStatus".equals(name)) {
            return this.getFassFullStatus();
        }
        if ("fullAssessmentDate".equals(name)) {
            return this.getFullAssessmentDate();
        }
        if ("fullResult".equals(name)) {
            return this.getFullResult();
        }
        if ("fullResultReason".equals(name)) {
            return this.getFullResultReason();
        }
        if ("fullAssessmentNotes".equals(name)) {
            return this.getFullAssessmentNotes();
        }
        if ("fullAdjustedLivingAllowance".equals(name)) {
            return this.getFullAdjustedLivingAllowance();
        }
        if ("fullTotalAnnualDisposableIncome".equals(name)) {
            return this.getFullTotalAnnualDisposableIncome();
        }
        if ("fullOtherHousingNote".equals(name)) {
            return this.getFullOtherHousingNote();
        }
        if ("fullTotalAggregatedExpenses".equals(name)) {
            return this.getFullTotalAggregatedExpenses();
        }
        if ("fullAscrId".equals(name)) {
            return this.getFullAscrId();
        }
        if ("userModified".equals(name)) {
            return this.getUserModified();
        }
        if ("finAssIncomeEvidences".equals(name)) {
            return this.getFinAssIncomeEvidences();
        }
        if ("incomeUpliftApplyDate".equals(name)) {
            return this.getIncomeUpliftApplyDate();
        }
        if ("incomeUpliftRemoveDate".equals(name)) {
            return this.getIncomeUpliftRemoveDate();
        }
        if ("evidenceReceivedDate".equals(name)) {
            return this.getEvidenceReceivedDate();
        }
        return super.declaredPropertyOrNotFound(name, notFoundValue);
    }

    @Override
    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    @Override
    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    @Override
    public MaatApiUpdateAssessment with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MaatApiUpdateAssessment.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("financialAssessmentId");
        sb.append('=');
        sb.append(this.financialAssessmentId == null ? "<null>" : this.financialAssessmentId);
        sb.append(',');
        sb.append("fassFullStatus");
        sb.append('=');
        sb.append(this.fassFullStatus == null ? "<null>" : this.fassFullStatus);
        sb.append(',');
        sb.append("fullAssessmentDate");
        sb.append('=');
        sb.append(this.fullAssessmentDate == null ? "<null>" : this.fullAssessmentDate);
        sb.append(',');
        sb.append("fullResult");
        sb.append('=');
        sb.append(this.fullResult == null ? "<null>" : this.fullResult);
        sb.append(',');
        sb.append("fullResultReason");
        sb.append('=');
        sb.append(this.fullResultReason == null ? "<null>" : this.fullResultReason);
        sb.append(',');
        sb.append("fullAssessmentNotes");
        sb.append('=');
        sb.append(this.fullAssessmentNotes == null ? "<null>" : this.fullAssessmentNotes);
        sb.append(',');
        sb.append("fullAdjustedLivingAllowance");
        sb.append('=');
        sb.append(this.fullAdjustedLivingAllowance == null ? "<null>" : this.fullAdjustedLivingAllowance);
        sb.append(',');
        sb.append("fullTotalAnnualDisposableIncome");
        sb.append('=');
        sb.append(this.fullTotalAnnualDisposableIncome == null ? "<null>" : this.fullTotalAnnualDisposableIncome);
        sb.append(',');
        sb.append("fullOtherHousingNote");
        sb.append('=');
        sb.append(this.fullOtherHousingNote == null ? "<null>" : this.fullOtherHousingNote);
        sb.append(',');
        sb.append("fullTotalAggregatedExpenses");
        sb.append('=');
        sb.append(this.fullTotalAggregatedExpenses == null ? "<null>" : this.fullTotalAggregatedExpenses);
        sb.append(',');
        sb.append("fullAscrId");
        sb.append('=');
        sb.append(this.fullAscrId == null ? "<null>" : this.fullAscrId);
        sb.append(',');
        sb.append("userModified");
        sb.append('=');
        sb.append(this.userModified == null ? "<null>" : this.userModified);
        sb.append(',');
        sb.append("finAssIncomeEvidences");
        sb.append('=');
        sb.append(this.finAssIncomeEvidences == null ? "<null>" : this.finAssIncomeEvidences);
        sb.append(',');
        sb.append("incomeUpliftApplyDate");
        sb.append('=');
        sb.append(this.incomeUpliftApplyDate == null ? "<null>" : this.incomeUpliftApplyDate);
        sb.append(',');
        sb.append("incomeUpliftRemoveDate");
        sb.append('=');
        sb.append(this.incomeUpliftRemoveDate == null ? "<null>" : this.incomeUpliftRemoveDate);
        sb.append(',');
        sb.append("evidenceReceivedDate");
        sb.append('=');
        sb.append(this.evidenceReceivedDate == null ? "<null>" : this.evidenceReceivedDate);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.fullAssessmentDate == null ? 0 : this.fullAssessmentDate.hashCode());
        result = result * 31 + (this.fassFullStatus == null ? 0 : this.fassFullStatus.hashCode());
        result = result * 31 + (this.fullTotalAggregatedExpenses == null ? 0 : this.fullTotalAggregatedExpenses.hashCode());
        result = result * 31 + (this.incomeUpliftApplyDate == null ? 0 : this.incomeUpliftApplyDate.hashCode());
        result = result * 31 + (this.fullAssessmentNotes == null ? 0 : this.fullAssessmentNotes.hashCode());
        result = result * 31 + (this.fullResult == null ? 0 : this.fullResult.hashCode());
        result = result * 31 + (this.fullResultReason == null ? 0 : this.fullResultReason.hashCode());
        result = result * 31 + (this.fullAdjustedLivingAllowance == null ? 0 : this.fullAdjustedLivingAllowance.hashCode());
        result = result * 31 + (this.fullTotalAnnualDisposableIncome == null ? 0 : this.fullTotalAnnualDisposableIncome.hashCode());
        result = result * 31 + (this.fullAscrId == null ? 0 : this.fullAscrId.hashCode());
        result = result * 31 + (this.incomeUpliftRemoveDate == null ? 0 : this.incomeUpliftRemoveDate.hashCode());
        result = result * 31 + (this.financialAssessmentId == null ? 0 : this.financialAssessmentId.hashCode());
        result = result * 31 + (this.finAssIncomeEvidences == null ? 0 : this.finAssIncomeEvidences.hashCode());
        result = result * 31 + (this.fullOtherHousingNote == null ? 0 : this.fullOtherHousingNote.hashCode());
        result = result * 31 + (this.evidenceReceivedDate == null ? 0 : this.evidenceReceivedDate.hashCode());
        result = result * 31 + (this.userModified == null ? 0 : this.userModified.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MaatApiUpdateAssessment)) {
            return false;
        }
        MaatApiUpdateAssessment rhs = (MaatApiUpdateAssessment)other;
        return super.equals(rhs) && (this.fullAssessmentDate == rhs.fullAssessmentDate || this.fullAssessmentDate != null && this.fullAssessmentDate.equals(rhs.fullAssessmentDate)) && (this.fassFullStatus == rhs.fassFullStatus || this.fassFullStatus != null && this.fassFullStatus.equals(rhs.fassFullStatus)) && (this.fullTotalAggregatedExpenses == rhs.fullTotalAggregatedExpenses || this.fullTotalAggregatedExpenses != null && this.fullTotalAggregatedExpenses.equals(rhs.fullTotalAggregatedExpenses)) && (this.incomeUpliftApplyDate == rhs.incomeUpliftApplyDate || this.incomeUpliftApplyDate != null && this.incomeUpliftApplyDate.equals(rhs.incomeUpliftApplyDate)) && (this.fullAssessmentNotes == rhs.fullAssessmentNotes || this.fullAssessmentNotes != null && this.fullAssessmentNotes.equals(rhs.fullAssessmentNotes)) && (this.fullResult == rhs.fullResult || this.fullResult != null && this.fullResult.equals(rhs.fullResult)) && (this.fullResultReason == rhs.fullResultReason || this.fullResultReason != null && this.fullResultReason.equals(rhs.fullResultReason)) && (this.fullAdjustedLivingAllowance == rhs.fullAdjustedLivingAllowance || this.fullAdjustedLivingAllowance != null && this.fullAdjustedLivingAllowance.equals(rhs.fullAdjustedLivingAllowance)) && (this.fullTotalAnnualDisposableIncome == rhs.fullTotalAnnualDisposableIncome || this.fullTotalAnnualDisposableIncome != null && this.fullTotalAnnualDisposableIncome.equals(rhs.fullTotalAnnualDisposableIncome)) && (this.fullAscrId == rhs.fullAscrId || this.fullAscrId != null && this.fullAscrId.equals(rhs.fullAscrId)) && (this.incomeUpliftRemoveDate == rhs.incomeUpliftRemoveDate || this.incomeUpliftRemoveDate != null && this.incomeUpliftRemoveDate.equals(rhs.incomeUpliftRemoveDate)) && (this.financialAssessmentId == rhs.financialAssessmentId || this.financialAssessmentId != null && this.financialAssessmentId.equals(rhs.financialAssessmentId)) && (this.finAssIncomeEvidences == rhs.finAssIncomeEvidences || this.finAssIncomeEvidences != null && this.finAssIncomeEvidences.equals(rhs.finAssIncomeEvidences)) && (this.fullOtherHousingNote == rhs.fullOtherHousingNote || this.fullOtherHousingNote != null && this.fullOtherHousingNote.equals(rhs.fullOtherHousingNote)) && (this.evidenceReceivedDate == rhs.evidenceReceivedDate || this.evidenceReceivedDate != null && this.evidenceReceivedDate.equals(rhs.evidenceReceivedDate)) && (this.userModified == rhs.userModified || this.userModified != null && this.userModified.equals(rhs.userModified));
    }
}

