/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment.stateless;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.enums.CaseType;
import uk.gov.justice.laa.crime.enums.MagCourtOutcome;
import uk.gov.justice.laa.crime.enums.meansassessment.StatelessRequestType;
import uk.gov.justice.laa.crime.meansassessment.DependantChild;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"assessment_type", "assessment_date", "case_type", "magistrate_court_outcome", "has_partner", "eligibility_check_required", "dependant_children"})
public class Assessment {
    @JsonProperty(value="assessment_type")
    @Valid
    @NotNull
    private StatelessRequestType assessmentType;
    @JsonProperty(value="assessment_date")
    @NotNull
    private LocalDateTime assessmentDate;
    @JsonProperty(value="case_type")
    @JsonPropertyDescription(value="The case type")
    @Valid
    @NotNull
    private CaseType caseType;
    @JsonProperty(value="magistrate_court_outcome")
    @JsonPropertyDescription(value="The magistrates court outcome")
    @Valid
    private MagCourtOutcome magistrateCourtOutcome;
    @JsonProperty(value="has_partner")
    @JsonPropertyDescription(value="Set true if client has a partner without a contrary interest in the case (so their income with also be part of the assessment)")
    @NotNull
    private Boolean hasPartner;
    @JsonProperty(value="eligibility_check_required")
    @JsonPropertyDescription(value="could this check possibily result in an INEL result")
    @NotNull
    private Boolean eligibilityCheckRequired;
    @JsonProperty(value="dependant_children")
    @Valid
    @NotNull
    private List<DependantChild> dependantChildren = new ArrayList<DependantChild>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public Assessment() {
    }

    public Assessment(StatelessRequestType assessmentType, LocalDateTime assessmentDate, CaseType caseType, MagCourtOutcome magistrateCourtOutcome, Boolean hasPartner, Boolean eligibilityCheckRequired, List<DependantChild> dependantChildren) {
        this.assessmentType = assessmentType;
        this.assessmentDate = assessmentDate;
        this.caseType = caseType;
        this.magistrateCourtOutcome = magistrateCourtOutcome;
        this.hasPartner = hasPartner;
        this.eligibilityCheckRequired = eligibilityCheckRequired;
        this.dependantChildren = dependantChildren;
    }

    @JsonProperty(value="assessment_type")
    public StatelessRequestType getAssessmentType() {
        return this.assessmentType;
    }

    @JsonProperty(value="assessment_type")
    public void setAssessmentType(StatelessRequestType assessmentType) {
        this.assessmentType = assessmentType;
    }

    public Assessment withAssessmentType(StatelessRequestType assessmentType) {
        this.assessmentType = assessmentType;
        return this;
    }

    @JsonProperty(value="assessment_date")
    public LocalDateTime getAssessmentDate() {
        return this.assessmentDate;
    }

    @JsonProperty(value="assessment_date")
    public void setAssessmentDate(LocalDateTime assessmentDate) {
        this.assessmentDate = assessmentDate;
    }

    public Assessment withAssessmentDate(LocalDateTime assessmentDate) {
        this.assessmentDate = assessmentDate;
        return this;
    }

    @JsonProperty(value="case_type")
    public CaseType getCaseType() {
        return this.caseType;
    }

    @JsonProperty(value="case_type")
    public void setCaseType(CaseType caseType) {
        this.caseType = caseType;
    }

    public Assessment withCaseType(CaseType caseType) {
        this.caseType = caseType;
        return this;
    }

    @JsonProperty(value="magistrate_court_outcome")
    public MagCourtOutcome getMagistrateCourtOutcome() {
        return this.magistrateCourtOutcome;
    }

    @JsonProperty(value="magistrate_court_outcome")
    public void setMagistrateCourtOutcome(MagCourtOutcome magistrateCourtOutcome) {
        this.magistrateCourtOutcome = magistrateCourtOutcome;
    }

    public Assessment withMagistrateCourtOutcome(MagCourtOutcome magistrateCourtOutcome) {
        this.magistrateCourtOutcome = magistrateCourtOutcome;
        return this;
    }

    @JsonProperty(value="has_partner")
    public Boolean getHasPartner() {
        return this.hasPartner;
    }

    @JsonProperty(value="has_partner")
    public void setHasPartner(Boolean hasPartner) {
        this.hasPartner = hasPartner;
    }

    public Assessment withHasPartner(Boolean hasPartner) {
        this.hasPartner = hasPartner;
        return this;
    }

    @JsonProperty(value="eligibility_check_required")
    public Boolean getEligibilityCheckRequired() {
        return this.eligibilityCheckRequired;
    }

    @JsonProperty(value="eligibility_check_required")
    public void setEligibilityCheckRequired(Boolean eligibilityCheckRequired) {
        this.eligibilityCheckRequired = eligibilityCheckRequired;
    }

    public Assessment withEligibilityCheckRequired(Boolean eligibilityCheckRequired) {
        this.eligibilityCheckRequired = eligibilityCheckRequired;
        return this;
    }

    @JsonProperty(value="dependant_children")
    public List<DependantChild> getDependantChildren() {
        return this.dependantChildren;
    }

    @JsonProperty(value="dependant_children")
    public void setDependantChildren(List<DependantChild> dependantChildren) {
        this.dependantChildren = dependantChildren;
    }

    public Assessment withDependantChildren(List<DependantChild> dependantChildren) {
        this.dependantChildren = dependantChildren;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("assessment_type".equals(name)) {
            if (!(value instanceof StatelessRequestType)) {
                throw new IllegalArgumentException("property \"assessment_type\" is of type \"uk.gov.justice.laa.crime.enums.meansassessment.StatelessRequestType\", but got " + value.getClass().toString());
            }
            this.setAssessmentType((StatelessRequestType)value);
            return true;
        }
        if ("assessment_date".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"assessment_date\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setAssessmentDate((LocalDateTime)value);
            return true;
        }
        if ("case_type".equals(name)) {
            if (!(value instanceof CaseType)) {
                throw new IllegalArgumentException("property \"case_type\" is of type \"uk.gov.justice.laa.crime.enums.CaseType\", but got " + value.getClass().toString());
            }
            this.setCaseType((CaseType)value);
            return true;
        }
        if ("magistrate_court_outcome".equals(name)) {
            if (!(value instanceof MagCourtOutcome)) {
                throw new IllegalArgumentException("property \"magistrate_court_outcome\" is of type \"uk.gov.justice.laa.crime.enums.MagCourtOutcome\", but got " + value.getClass().toString());
            }
            this.setMagistrateCourtOutcome((MagCourtOutcome)value);
            return true;
        }
        if ("has_partner".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"has_partner\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setHasPartner((Boolean)value);
            return true;
        }
        if ("eligibility_check_required".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"eligibility_check_required\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setEligibilityCheckRequired((Boolean)value);
            return true;
        }
        if ("dependant_children".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"dependant_children\" is of type \"java.util.List<uk.gov.justice.laa.crime.meansassessment.DependantChild>\", but got " + value.getClass().toString());
            }
            this.setDependantChildren((List)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("assessment_type".equals(name)) {
            return this.getAssessmentType();
        }
        if ("assessment_date".equals(name)) {
            return this.getAssessmentDate();
        }
        if ("case_type".equals(name)) {
            return this.getCaseType();
        }
        if ("magistrate_court_outcome".equals(name)) {
            return this.getMagistrateCourtOutcome();
        }
        if ("has_partner".equals(name)) {
            return this.getHasPartner();
        }
        if ("eligibility_check_required".equals(name)) {
            return this.getEligibilityCheckRequired();
        }
        if ("dependant_children".equals(name)) {
            return this.getDependantChildren();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public Assessment with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Assessment.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("assessmentType");
        sb.append('=');
        sb.append((Object)(this.assessmentType == null ? "<null>" : this.assessmentType));
        sb.append(',');
        sb.append("assessmentDate");
        sb.append('=');
        sb.append(this.assessmentDate == null ? "<null>" : this.assessmentDate);
        sb.append(',');
        sb.append("caseType");
        sb.append('=');
        sb.append((Object)(this.caseType == null ? "<null>" : this.caseType));
        sb.append(',');
        sb.append("magistrateCourtOutcome");
        sb.append('=');
        sb.append((Object)(this.magistrateCourtOutcome == null ? "<null>" : this.magistrateCourtOutcome));
        sb.append(',');
        sb.append("hasPartner");
        sb.append('=');
        sb.append(this.hasPartner == null ? "<null>" : this.hasPartner);
        sb.append(',');
        sb.append("eligibilityCheckRequired");
        sb.append('=');
        sb.append(this.eligibilityCheckRequired == null ? "<null>" : this.eligibilityCheckRequired);
        sb.append(',');
        sb.append("dependantChildren");
        sb.append('=');
        sb.append(this.dependantChildren == null ? "<null>" : this.dependantChildren);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.assessmentType == null ? 0 : this.assessmentType.hashCode());
        result = result * 31 + (this.magistrateCourtOutcome == null ? 0 : this.magistrateCourtOutcome.hashCode());
        result = result * 31 + (this.eligibilityCheckRequired == null ? 0 : this.eligibilityCheckRequired.hashCode());
        result = result * 31 + (this.assessmentDate == null ? 0 : this.assessmentDate.hashCode());
        result = result * 31 + (this.hasPartner == null ? 0 : this.hasPartner.hashCode());
        result = result * 31 + (this.caseType == null ? 0 : this.caseType.hashCode());
        result = result * 31 + (this.dependantChildren == null ? 0 : this.dependantChildren.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Assessment)) {
            return false;
        }
        Assessment rhs = (Assessment)other;
        return (this.assessmentType == rhs.assessmentType || this.assessmentType != null && this.assessmentType.equals((Object)rhs.assessmentType)) && (this.magistrateCourtOutcome == rhs.magistrateCourtOutcome || this.magistrateCourtOutcome != null && this.magistrateCourtOutcome.equals((Object)rhs.magistrateCourtOutcome)) && (this.eligibilityCheckRequired == rhs.eligibilityCheckRequired || this.eligibilityCheckRequired != null && this.eligibilityCheckRequired.equals(rhs.eligibilityCheckRequired)) && (this.assessmentDate == rhs.assessmentDate || this.assessmentDate != null && this.assessmentDate.equals(rhs.assessmentDate)) && (this.hasPartner == rhs.hasPartner || this.hasPartner != null && this.hasPartner.equals(rhs.hasPartner)) && (this.caseType == rhs.caseType || this.caseType != null && this.caseType.equals((Object)rhs.caseType)) && (this.dependantChildren == rhs.dependantChildren || this.dependantChildren != null && this.dependantChildren.equals(rhs.dependantChildren));
    }
}

