/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.meansassessment.stateless;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.meansassessment.stateless.Assessment;
import uk.gov.justice.laa.crime.meansassessment.Income;
import uk.gov.justice.laa.crime.meansassessment.Outgoing;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"assessment", "income", "outgoings"})
public class StatelessApiRequest {
    @JsonProperty(value="assessment")
    @Valid
    @NotNull
    private Assessment assessment;
    @JsonProperty(value="income")
    @Valid
    @NotNull
    private List<Income> income = new ArrayList<Income>();
    @JsonProperty(value="outgoings")
    @Valid
    @NotNull
    private List<Outgoing> outgoings = new ArrayList<Outgoing>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public StatelessApiRequest() {
    }

    public StatelessApiRequest(Assessment assessment, List<Income> income, List<Outgoing> outgoings) {
        this.assessment = assessment;
        this.income = income;
        this.outgoings = outgoings;
    }

    @JsonProperty(value="assessment")
    public Assessment getAssessment() {
        return this.assessment;
    }

    @JsonProperty(value="assessment")
    public void setAssessment(Assessment assessment) {
        this.assessment = assessment;
    }

    public StatelessApiRequest withAssessment(Assessment assessment) {
        this.assessment = assessment;
        return this;
    }

    @JsonProperty(value="income")
    public List<Income> getIncome() {
        return this.income;
    }

    @JsonProperty(value="income")
    public void setIncome(List<Income> income) {
        this.income = income;
    }

    public StatelessApiRequest withIncome(List<Income> income) {
        this.income = income;
        return this;
    }

    @JsonProperty(value="outgoings")
    public List<Outgoing> getOutgoings() {
        return this.outgoings;
    }

    @JsonProperty(value="outgoings")
    public void setOutgoings(List<Outgoing> outgoings) {
        this.outgoings = outgoings;
    }

    public StatelessApiRequest withOutgoings(List<Outgoing> outgoings) {
        this.outgoings = outgoings;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("assessment".equals(name)) {
            if (!(value instanceof Assessment)) {
                throw new IllegalArgumentException("property \"assessment\" is of type \"uk.gov.justice.laa.crime.common.model.meansassessment.stateless.Assessment\", but got " + value.getClass().toString());
            }
            this.setAssessment((Assessment)value);
            return true;
        }
        if ("income".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"income\" is of type \"java.util.List<uk.gov.justice.laa.crime.meansassessment.Income>\", but got " + value.getClass().toString());
            }
            this.setIncome((List)value);
            return true;
        }
        if ("outgoings".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"outgoings\" is of type \"java.util.List<uk.gov.justice.laa.crime.meansassessment.Outgoing>\", but got " + value.getClass().toString());
            }
            this.setOutgoings((List)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("assessment".equals(name)) {
            return this.getAssessment();
        }
        if ("income".equals(name)) {
            return this.getIncome();
        }
        if ("outgoings".equals(name)) {
            return this.getOutgoings();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public StatelessApiRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StatelessApiRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("assessment");
        sb.append('=');
        sb.append(this.assessment == null ? "<null>" : this.assessment);
        sb.append(',');
        sb.append("income");
        sb.append('=');
        sb.append(this.income == null ? "<null>" : this.income);
        sb.append(',');
        sb.append("outgoings");
        sb.append('=');
        sb.append(this.outgoings == null ? "<null>" : this.outgoings);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.income == null ? 0 : this.income.hashCode());
        result = result * 31 + (this.assessment == null ? 0 : this.assessment.hashCode());
        result = result * 31 + (this.outgoings == null ? 0 : this.outgoings.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof StatelessApiRequest)) {
            return false;
        }
        StatelessApiRequest rhs = (StatelessApiRequest)other;
        return (this.income == rhs.income || this.income != null && this.income.equals(rhs.income)) && (this.assessment == rhs.assessment || this.assessment != null && this.assessment.equals(rhs.assessment)) && (this.outgoings == rhs.outgoings || this.outgoings != null && this.outgoings.equals(rhs.outgoings));
    }
}

