/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.proceeding.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.common.ApiCrownCourtOutcome;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiRepOrderCrownCourtOutcome;
import uk.gov.justice.laa.crime.enums.EvidenceFeeLevel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"repOrderDecision", "repId", "repType", "repOrderDate", "withdrawalDate", "sentenceOrderDate", "evidenceFeeLevel", "isImprisoned", "isWarrantIssued", "crownCourtOutcome", "repOrderCrownCourtOutcome"})
public class ApiCrownCourtSummary {
    @JsonProperty(value="repOrderDecision")
    private String repOrderDecision;
    @JsonProperty(value="repId")
    private Integer repId;
    @JsonProperty(value="repType")
    private String repType;
    @JsonProperty(value="repOrderDate")
    private LocalDateTime repOrderDate;
    @JsonProperty(value="withdrawalDate")
    private LocalDateTime withdrawalDate;
    @JsonProperty(value="sentenceOrderDate")
    private LocalDateTime sentenceOrderDate;
    @JsonProperty(value="evidenceFeeLevel")
    @JsonPropertyDescription(value="The evidence fee level")
    @Valid
    private EvidenceFeeLevel evidenceFeeLevel;
    @JsonProperty(value="isImprisoned")
    @JsonPropertyDescription(value="Indicates whether the applicant is imprisoned")
    private Boolean isImprisoned;
    @JsonProperty(value="isWarrantIssued")
    @JsonPropertyDescription(value="Indicates whether the applicant is warrant issued")
    private Boolean isWarrantIssued;
    @JsonProperty(value="crownCourtOutcome")
    @JsonPropertyDescription(value="list of crown court outcome")
    @Valid
    private List<ApiCrownCourtOutcome> crownCourtOutcome = new ArrayList<ApiCrownCourtOutcome>();
    @JsonProperty(value="repOrderCrownCourtOutcome")
    @JsonPropertyDescription(value="list of rep order crown court outcome")
    @Valid
    private List<ApiRepOrderCrownCourtOutcome> repOrderCrownCourtOutcome = new ArrayList<ApiRepOrderCrownCourtOutcome>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiCrownCourtSummary() {
    }

    public ApiCrownCourtSummary(String repOrderDecision, Integer repId, String repType, LocalDateTime repOrderDate, LocalDateTime withdrawalDate, LocalDateTime sentenceOrderDate, EvidenceFeeLevel evidenceFeeLevel, Boolean isImprisoned, Boolean isWarrantIssued, List<ApiCrownCourtOutcome> crownCourtOutcome, List<ApiRepOrderCrownCourtOutcome> repOrderCrownCourtOutcome) {
        this.repOrderDecision = repOrderDecision;
        this.repId = repId;
        this.repType = repType;
        this.repOrderDate = repOrderDate;
        this.withdrawalDate = withdrawalDate;
        this.sentenceOrderDate = sentenceOrderDate;
        this.evidenceFeeLevel = evidenceFeeLevel;
        this.isImprisoned = isImprisoned;
        this.isWarrantIssued = isWarrantIssued;
        this.crownCourtOutcome = crownCourtOutcome;
        this.repOrderCrownCourtOutcome = repOrderCrownCourtOutcome;
    }

    @JsonProperty(value="repOrderDecision")
    public String getRepOrderDecision() {
        return this.repOrderDecision;
    }

    @JsonProperty(value="repOrderDecision")
    public void setRepOrderDecision(String repOrderDecision) {
        this.repOrderDecision = repOrderDecision;
    }

    public ApiCrownCourtSummary withRepOrderDecision(String repOrderDecision) {
        this.repOrderDecision = repOrderDecision;
        return this;
    }

    @JsonProperty(value="repId")
    public Integer getRepId() {
        return this.repId;
    }

    @JsonProperty(value="repId")
    public void setRepId(Integer repId) {
        this.repId = repId;
    }

    public ApiCrownCourtSummary withRepId(Integer repId) {
        this.repId = repId;
        return this;
    }

    @JsonProperty(value="repType")
    public String getRepType() {
        return this.repType;
    }

    @JsonProperty(value="repType")
    public void setRepType(String repType) {
        this.repType = repType;
    }

    public ApiCrownCourtSummary withRepType(String repType) {
        this.repType = repType;
        return this;
    }

    @JsonProperty(value="repOrderDate")
    public LocalDateTime getRepOrderDate() {
        return this.repOrderDate;
    }

    @JsonProperty(value="repOrderDate")
    public void setRepOrderDate(LocalDateTime repOrderDate) {
        this.repOrderDate = repOrderDate;
    }

    public ApiCrownCourtSummary withRepOrderDate(LocalDateTime repOrderDate) {
        this.repOrderDate = repOrderDate;
        return this;
    }

    @JsonProperty(value="withdrawalDate")
    public LocalDateTime getWithdrawalDate() {
        return this.withdrawalDate;
    }

    @JsonProperty(value="withdrawalDate")
    public void setWithdrawalDate(LocalDateTime withdrawalDate) {
        this.withdrawalDate = withdrawalDate;
    }

    public ApiCrownCourtSummary withWithdrawalDate(LocalDateTime withdrawalDate) {
        this.withdrawalDate = withdrawalDate;
        return this;
    }

    @JsonProperty(value="sentenceOrderDate")
    public LocalDateTime getSentenceOrderDate() {
        return this.sentenceOrderDate;
    }

    @JsonProperty(value="sentenceOrderDate")
    public void setSentenceOrderDate(LocalDateTime sentenceOrderDate) {
        this.sentenceOrderDate = sentenceOrderDate;
    }

    public ApiCrownCourtSummary withSentenceOrderDate(LocalDateTime sentenceOrderDate) {
        this.sentenceOrderDate = sentenceOrderDate;
        return this;
    }

    @JsonProperty(value="evidenceFeeLevel")
    public EvidenceFeeLevel getEvidenceFeeLevel() {
        return this.evidenceFeeLevel;
    }

    @JsonProperty(value="evidenceFeeLevel")
    public void setEvidenceFeeLevel(EvidenceFeeLevel evidenceFeeLevel) {
        this.evidenceFeeLevel = evidenceFeeLevel;
    }

    public ApiCrownCourtSummary withEvidenceFeeLevel(EvidenceFeeLevel evidenceFeeLevel) {
        this.evidenceFeeLevel = evidenceFeeLevel;
        return this;
    }

    @JsonProperty(value="isImprisoned")
    public Boolean getIsImprisoned() {
        return this.isImprisoned;
    }

    @JsonProperty(value="isImprisoned")
    public void setIsImprisoned(Boolean isImprisoned) {
        this.isImprisoned = isImprisoned;
    }

    public ApiCrownCourtSummary withIsImprisoned(Boolean isImprisoned) {
        this.isImprisoned = isImprisoned;
        return this;
    }

    @JsonProperty(value="isWarrantIssued")
    public Boolean getIsWarrantIssued() {
        return this.isWarrantIssued;
    }

    @JsonProperty(value="isWarrantIssued")
    public void setIsWarrantIssued(Boolean isWarrantIssued) {
        this.isWarrantIssued = isWarrantIssued;
    }

    public ApiCrownCourtSummary withIsWarrantIssued(Boolean isWarrantIssued) {
        this.isWarrantIssued = isWarrantIssued;
        return this;
    }

    @JsonProperty(value="crownCourtOutcome")
    public List<ApiCrownCourtOutcome> getCrownCourtOutcome() {
        return this.crownCourtOutcome;
    }

    @JsonProperty(value="crownCourtOutcome")
    public void setCrownCourtOutcome(List<ApiCrownCourtOutcome> crownCourtOutcome) {
        this.crownCourtOutcome = crownCourtOutcome;
    }

    public ApiCrownCourtSummary withCrownCourtOutcome(List<ApiCrownCourtOutcome> crownCourtOutcome) {
        this.crownCourtOutcome = crownCourtOutcome;
        return this;
    }

    @JsonProperty(value="repOrderCrownCourtOutcome")
    public List<ApiRepOrderCrownCourtOutcome> getRepOrderCrownCourtOutcome() {
        return this.repOrderCrownCourtOutcome;
    }

    @JsonProperty(value="repOrderCrownCourtOutcome")
    public void setRepOrderCrownCourtOutcome(List<ApiRepOrderCrownCourtOutcome> repOrderCrownCourtOutcome) {
        this.repOrderCrownCourtOutcome = repOrderCrownCourtOutcome;
    }

    public ApiCrownCourtSummary withRepOrderCrownCourtOutcome(List<ApiRepOrderCrownCourtOutcome> repOrderCrownCourtOutcome) {
        this.repOrderCrownCourtOutcome = repOrderCrownCourtOutcome;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("repOrderDecision".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"repOrderDecision\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setRepOrderDecision((String)value);
            return true;
        }
        if ("repId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"repId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setRepId((Integer)value);
            return true;
        }
        if ("repType".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"repType\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setRepType((String)value);
            return true;
        }
        if ("repOrderDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"repOrderDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setRepOrderDate((LocalDateTime)value);
            return true;
        }
        if ("withdrawalDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"withdrawalDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setWithdrawalDate((LocalDateTime)value);
            return true;
        }
        if ("sentenceOrderDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"sentenceOrderDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setSentenceOrderDate((LocalDateTime)value);
            return true;
        }
        if ("evidenceFeeLevel".equals(name)) {
            if (!(value instanceof EvidenceFeeLevel)) {
                throw new IllegalArgumentException("property \"evidenceFeeLevel\" is of type \"uk.gov.justice.laa.crime.enums.EvidenceFeeLevel\", but got " + value.getClass().toString());
            }
            this.setEvidenceFeeLevel((EvidenceFeeLevel)value);
            return true;
        }
        if ("isImprisoned".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"isImprisoned\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setIsImprisoned((Boolean)value);
            return true;
        }
        if ("isWarrantIssued".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"isWarrantIssued\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setIsWarrantIssued((Boolean)value);
            return true;
        }
        if ("crownCourtOutcome".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"crownCourtOutcome\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.common.ApiCrownCourtOutcome>\", but got " + value.getClass().toString());
            }
            this.setCrownCourtOutcome((List)value);
            return true;
        }
        if ("repOrderCrownCourtOutcome".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"repOrderCrownCourtOutcome\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.proceeding.common.ApiRepOrderCrownCourtOutcome>\", but got " + value.getClass().toString());
            }
            this.setRepOrderCrownCourtOutcome((List)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("repOrderDecision".equals(name)) {
            return this.getRepOrderDecision();
        }
        if ("repId".equals(name)) {
            return this.getRepId();
        }
        if ("repType".equals(name)) {
            return this.getRepType();
        }
        if ("repOrderDate".equals(name)) {
            return this.getRepOrderDate();
        }
        if ("withdrawalDate".equals(name)) {
            return this.getWithdrawalDate();
        }
        if ("sentenceOrderDate".equals(name)) {
            return this.getSentenceOrderDate();
        }
        if ("evidenceFeeLevel".equals(name)) {
            return this.getEvidenceFeeLevel();
        }
        if ("isImprisoned".equals(name)) {
            return this.getIsImprisoned();
        }
        if ("isWarrantIssued".equals(name)) {
            return this.getIsWarrantIssued();
        }
        if ("crownCourtOutcome".equals(name)) {
            return this.getCrownCourtOutcome();
        }
        if ("repOrderCrownCourtOutcome".equals(name)) {
            return this.getRepOrderCrownCourtOutcome();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiCrownCourtSummary with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiCrownCourtSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("repOrderDecision");
        sb.append('=');
        sb.append(this.repOrderDecision == null ? "<null>" : this.repOrderDecision);
        sb.append(',');
        sb.append("repId");
        sb.append('=');
        sb.append(this.repId == null ? "<null>" : this.repId);
        sb.append(',');
        sb.append("repType");
        sb.append('=');
        sb.append(this.repType == null ? "<null>" : this.repType);
        sb.append(',');
        sb.append("repOrderDate");
        sb.append('=');
        sb.append(this.repOrderDate == null ? "<null>" : this.repOrderDate);
        sb.append(',');
        sb.append("withdrawalDate");
        sb.append('=');
        sb.append(this.withdrawalDate == null ? "<null>" : this.withdrawalDate);
        sb.append(',');
        sb.append("sentenceOrderDate");
        sb.append('=');
        sb.append(this.sentenceOrderDate == null ? "<null>" : this.sentenceOrderDate);
        sb.append(',');
        sb.append("evidenceFeeLevel");
        sb.append('=');
        sb.append((Object)(this.evidenceFeeLevel == null ? "<null>" : this.evidenceFeeLevel));
        sb.append(',');
        sb.append("isImprisoned");
        sb.append('=');
        sb.append(this.isImprisoned == null ? "<null>" : this.isImprisoned);
        sb.append(',');
        sb.append("isWarrantIssued");
        sb.append('=');
        sb.append(this.isWarrantIssued == null ? "<null>" : this.isWarrantIssued);
        sb.append(',');
        sb.append("crownCourtOutcome");
        sb.append('=');
        sb.append(this.crownCourtOutcome == null ? "<null>" : this.crownCourtOutcome);
        sb.append(',');
        sb.append("repOrderCrownCourtOutcome");
        sb.append('=');
        sb.append(this.repOrderCrownCourtOutcome == null ? "<null>" : this.repOrderCrownCourtOutcome);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.repOrderCrownCourtOutcome == null ? 0 : this.repOrderCrownCourtOutcome.hashCode());
        result = result * 31 + (this.evidenceFeeLevel == null ? 0 : this.evidenceFeeLevel.hashCode());
        result = result * 31 + (this.repType == null ? 0 : this.repType.hashCode());
        result = result * 31 + (this.repId == null ? 0 : this.repId.hashCode());
        result = result * 31 + (this.crownCourtOutcome == null ? 0 : this.crownCourtOutcome.hashCode());
        result = result * 31 + (this.repOrderDate == null ? 0 : this.repOrderDate.hashCode());
        result = result * 31 + (this.withdrawalDate == null ? 0 : this.withdrawalDate.hashCode());
        result = result * 31 + (this.isImprisoned == null ? 0 : this.isImprisoned.hashCode());
        result = result * 31 + (this.repOrderDecision == null ? 0 : this.repOrderDecision.hashCode());
        result = result * 31 + (this.sentenceOrderDate == null ? 0 : this.sentenceOrderDate.hashCode());
        result = result * 31 + (this.isWarrantIssued == null ? 0 : this.isWarrantIssued.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiCrownCourtSummary)) {
            return false;
        }
        ApiCrownCourtSummary rhs = (ApiCrownCourtSummary)other;
        return (this.repOrderCrownCourtOutcome == rhs.repOrderCrownCourtOutcome || this.repOrderCrownCourtOutcome != null && this.repOrderCrownCourtOutcome.equals(rhs.repOrderCrownCourtOutcome)) && (this.evidenceFeeLevel == rhs.evidenceFeeLevel || this.evidenceFeeLevel != null && this.evidenceFeeLevel.equals((Object)rhs.evidenceFeeLevel)) && (this.repType == rhs.repType || this.repType != null && this.repType.equals(rhs.repType)) && (this.repId == rhs.repId || this.repId != null && this.repId.equals(rhs.repId)) && (this.crownCourtOutcome == rhs.crownCourtOutcome || this.crownCourtOutcome != null && this.crownCourtOutcome.equals(rhs.crownCourtOutcome)) && (this.repOrderDate == rhs.repOrderDate || this.repOrderDate != null && this.repOrderDate.equals(rhs.repOrderDate)) && (this.withdrawalDate == rhs.withdrawalDate || this.withdrawalDate != null && this.withdrawalDate.equals(rhs.withdrawalDate)) && (this.isImprisoned == rhs.isImprisoned || this.isImprisoned != null && this.isImprisoned.equals(rhs.isImprisoned)) && (this.repOrderDecision == rhs.repOrderDecision || this.repOrderDecision != null && this.repOrderDecision.equals(rhs.repOrderDecision)) && (this.sentenceOrderDate == rhs.sentenceOrderDate || this.sentenceOrderDate != null && this.sentenceOrderDate.equals(rhs.sentenceOrderDate)) && (this.isWarrantIssued == rhs.isWarrantIssued || this.isWarrantIssued != null && this.isWarrantIssued.equals(rhs.isWarrantIssued));
    }
}

