/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.proceeding.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"decisionResult", "iojResult", "appealTypeCode", "appealTypeDate"})
public class ApiIOJSummary {
    @JsonProperty(value="decisionResult")
    @JsonPropertyDescription(value="The appeal decision result")
    private String decisionResult;
    @JsonProperty(value="iojResult")
    @JsonPropertyDescription(value="The initial Ioj Result")
    @NotNull
    private String iojResult;
    @JsonProperty(value="appealTypeCode")
    @JsonPropertyDescription(value="The appeal type code")
    private String appealTypeCode;
    @JsonProperty(value="appealTypeDate")
    @JsonPropertyDescription(value="The date the appeal type was set")
    private LocalDateTime appealTypeDate;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiIOJSummary() {
    }

    public ApiIOJSummary(String decisionResult, String iojResult, String appealTypeCode, LocalDateTime appealTypeDate) {
        this.decisionResult = decisionResult;
        this.iojResult = iojResult;
        this.appealTypeCode = appealTypeCode;
        this.appealTypeDate = appealTypeDate;
    }

    @JsonProperty(value="decisionResult")
    public String getDecisionResult() {
        return this.decisionResult;
    }

    @JsonProperty(value="decisionResult")
    public void setDecisionResult(String decisionResult) {
        this.decisionResult = decisionResult;
    }

    public ApiIOJSummary withDecisionResult(String decisionResult) {
        this.decisionResult = decisionResult;
        return this;
    }

    @JsonProperty(value="iojResult")
    public String getIojResult() {
        return this.iojResult;
    }

    @JsonProperty(value="iojResult")
    public void setIojResult(String iojResult) {
        this.iojResult = iojResult;
    }

    public ApiIOJSummary withIojResult(String iojResult) {
        this.iojResult = iojResult;
        return this;
    }

    @JsonProperty(value="appealTypeCode")
    public String getAppealTypeCode() {
        return this.appealTypeCode;
    }

    @JsonProperty(value="appealTypeCode")
    public void setAppealTypeCode(String appealTypeCode) {
        this.appealTypeCode = appealTypeCode;
    }

    public ApiIOJSummary withAppealTypeCode(String appealTypeCode) {
        this.appealTypeCode = appealTypeCode;
        return this;
    }

    @JsonProperty(value="appealTypeDate")
    public LocalDateTime getAppealTypeDate() {
        return this.appealTypeDate;
    }

    @JsonProperty(value="appealTypeDate")
    public void setAppealTypeDate(LocalDateTime appealTypeDate) {
        this.appealTypeDate = appealTypeDate;
    }

    public ApiIOJSummary withAppealTypeDate(LocalDateTime appealTypeDate) {
        this.appealTypeDate = appealTypeDate;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("decisionResult".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"decisionResult\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setDecisionResult((String)value);
            return true;
        }
        if ("iojResult".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"iojResult\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setIojResult((String)value);
            return true;
        }
        if ("appealTypeCode".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"appealTypeCode\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setAppealTypeCode((String)value);
            return true;
        }
        if ("appealTypeDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"appealTypeDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setAppealTypeDate((LocalDateTime)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("decisionResult".equals(name)) {
            return this.getDecisionResult();
        }
        if ("iojResult".equals(name)) {
            return this.getIojResult();
        }
        if ("appealTypeCode".equals(name)) {
            return this.getAppealTypeCode();
        }
        if ("appealTypeDate".equals(name)) {
            return this.getAppealTypeDate();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiIOJSummary with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiIOJSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("decisionResult");
        sb.append('=');
        sb.append(this.decisionResult == null ? "<null>" : this.decisionResult);
        sb.append(',');
        sb.append("iojResult");
        sb.append('=');
        sb.append(this.iojResult == null ? "<null>" : this.iojResult);
        sb.append(',');
        sb.append("appealTypeCode");
        sb.append('=');
        sb.append(this.appealTypeCode == null ? "<null>" : this.appealTypeCode);
        sb.append(',');
        sb.append("appealTypeDate");
        sb.append('=');
        sb.append(this.appealTypeDate == null ? "<null>" : this.appealTypeDate);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.iojResult == null ? 0 : this.iojResult.hashCode());
        result = result * 31 + (this.appealTypeCode == null ? 0 : this.appealTypeCode.hashCode());
        result = result * 31 + (this.appealTypeDate == null ? 0 : this.appealTypeDate.hashCode());
        result = result * 31 + (this.decisionResult == null ? 0 : this.decisionResult.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiIOJSummary)) {
            return false;
        }
        ApiIOJSummary rhs = (ApiIOJSummary)other;
        return (this.iojResult == rhs.iojResult || this.iojResult != null && this.iojResult.equals(rhs.iojResult)) && (this.appealTypeCode == rhs.appealTypeCode || this.appealTypeCode != null && this.appealTypeCode.equals(rhs.appealTypeCode)) && (this.appealTypeDate == rhs.appealTypeDate || this.appealTypeDate != null && this.appealTypeDate.equals(rhs.appealTypeDate)) && (this.decisionResult == rhs.decisionResult || this.decisionResult != null && this.decisionResult.equals(rhs.decisionResult));
    }
}

