/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.proceeding.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiCrownCourtSummary;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiFinancialAssessment;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiIOJSummary;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiPassportAssessment;
import uk.gov.justice.laa.crime.enums.CaseType;
import uk.gov.justice.laa.crime.enums.DecisionReason;
import uk.gov.justice.laa.crime.enums.MagCourtOutcome;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"repId", "caseType", "magCourtOutcome", "decisionReason", "decisionDate", "committalDate", "dateReceived", "crownCourtSummary", "iojAppeal", "financialAssessment", "passportAssessment"})
public class ApiProcessRepOrderRequest {
    @JsonProperty(value="repId")
    @JsonPropertyDescription(value="MAAT / Rep Id")
    @NotNull
    private Integer repId;
    @JsonProperty(value="caseType")
    @JsonPropertyDescription(value="The case type")
    @Valid
    @NotNull
    private CaseType caseType;
    @JsonProperty(value="magCourtOutcome")
    @JsonPropertyDescription(value="Magistrate Court Outcome")
    @Valid
    private MagCourtOutcome magCourtOutcome;
    @JsonProperty(value="decisionReason")
    @JsonPropertyDescription(value="Decision Reason")
    @Valid
    private DecisionReason decisionReason;
    @JsonProperty(value="decisionDate")
    @JsonPropertyDescription(value="Decision Date")
    private LocalDateTime decisionDate;
    @JsonProperty(value="committalDate")
    @JsonPropertyDescription(value="Committal Date")
    private LocalDateTime committalDate;
    @JsonProperty(value="dateReceived")
    @JsonPropertyDescription(value="Date Received")
    @NotNull
    private LocalDateTime dateReceived;
    @JsonProperty(value="crownCourtSummary")
    @JsonPropertyDescription(value="Crown Court Summary")
    @Valid
    @NotNull
    private ApiCrownCourtSummary crownCourtSummary;
    @JsonProperty(value="iojAppeal")
    @JsonPropertyDescription(value="Summary of IOJ Data for an Application")
    @Valid
    @NotNull
    private ApiIOJSummary iojAppeal;
    @JsonProperty(value="financialAssessment")
    @JsonPropertyDescription(value="Financial Assessment")
    @Valid
    private ApiFinancialAssessment financialAssessment;
    @JsonProperty(value="passportAssessment")
    @JsonPropertyDescription(value="Passport assessment")
    @Valid
    private ApiPassportAssessment passportAssessment;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiProcessRepOrderRequest() {
    }

    public ApiProcessRepOrderRequest(Integer repId, CaseType caseType, MagCourtOutcome magCourtOutcome, DecisionReason decisionReason, LocalDateTime decisionDate, LocalDateTime committalDate, LocalDateTime dateReceived, ApiCrownCourtSummary crownCourtSummary, ApiIOJSummary iojAppeal, ApiFinancialAssessment financialAssessment, ApiPassportAssessment passportAssessment) {
        this.repId = repId;
        this.caseType = caseType;
        this.magCourtOutcome = magCourtOutcome;
        this.decisionReason = decisionReason;
        this.decisionDate = decisionDate;
        this.committalDate = committalDate;
        this.dateReceived = dateReceived;
        this.crownCourtSummary = crownCourtSummary;
        this.iojAppeal = iojAppeal;
        this.financialAssessment = financialAssessment;
        this.passportAssessment = passportAssessment;
    }

    @JsonProperty(value="repId")
    public Integer getRepId() {
        return this.repId;
    }

    @JsonProperty(value="repId")
    public void setRepId(Integer repId) {
        this.repId = repId;
    }

    public ApiProcessRepOrderRequest withRepId(Integer repId) {
        this.repId = repId;
        return this;
    }

    @JsonProperty(value="caseType")
    public CaseType getCaseType() {
        return this.caseType;
    }

    @JsonProperty(value="caseType")
    public void setCaseType(CaseType caseType) {
        this.caseType = caseType;
    }

    public ApiProcessRepOrderRequest withCaseType(CaseType caseType) {
        this.caseType = caseType;
        return this;
    }

    @JsonProperty(value="magCourtOutcome")
    public MagCourtOutcome getMagCourtOutcome() {
        return this.magCourtOutcome;
    }

    @JsonProperty(value="magCourtOutcome")
    public void setMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
    }

    public ApiProcessRepOrderRequest withMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
        return this;
    }

    @JsonProperty(value="decisionReason")
    public DecisionReason getDecisionReason() {
        return this.decisionReason;
    }

    @JsonProperty(value="decisionReason")
    public void setDecisionReason(DecisionReason decisionReason) {
        this.decisionReason = decisionReason;
    }

    public ApiProcessRepOrderRequest withDecisionReason(DecisionReason decisionReason) {
        this.decisionReason = decisionReason;
        return this;
    }

    @JsonProperty(value="decisionDate")
    public LocalDateTime getDecisionDate() {
        return this.decisionDate;
    }

    @JsonProperty(value="decisionDate")
    public void setDecisionDate(LocalDateTime decisionDate) {
        this.decisionDate = decisionDate;
    }

    public ApiProcessRepOrderRequest withDecisionDate(LocalDateTime decisionDate) {
        this.decisionDate = decisionDate;
        return this;
    }

    @JsonProperty(value="committalDate")
    public LocalDateTime getCommittalDate() {
        return this.committalDate;
    }

    @JsonProperty(value="committalDate")
    public void setCommittalDate(LocalDateTime committalDate) {
        this.committalDate = committalDate;
    }

    public ApiProcessRepOrderRequest withCommittalDate(LocalDateTime committalDate) {
        this.committalDate = committalDate;
        return this;
    }

    @JsonProperty(value="dateReceived")
    public LocalDateTime getDateReceived() {
        return this.dateReceived;
    }

    @JsonProperty(value="dateReceived")
    public void setDateReceived(LocalDateTime dateReceived) {
        this.dateReceived = dateReceived;
    }

    public ApiProcessRepOrderRequest withDateReceived(LocalDateTime dateReceived) {
        this.dateReceived = dateReceived;
        return this;
    }

    @JsonProperty(value="crownCourtSummary")
    public ApiCrownCourtSummary getCrownCourtSummary() {
        return this.crownCourtSummary;
    }

    @JsonProperty(value="crownCourtSummary")
    public void setCrownCourtSummary(ApiCrownCourtSummary crownCourtSummary) {
        this.crownCourtSummary = crownCourtSummary;
    }

    public ApiProcessRepOrderRequest withCrownCourtSummary(ApiCrownCourtSummary crownCourtSummary) {
        this.crownCourtSummary = crownCourtSummary;
        return this;
    }

    @JsonProperty(value="iojAppeal")
    public ApiIOJSummary getIojAppeal() {
        return this.iojAppeal;
    }

    @JsonProperty(value="iojAppeal")
    public void setIojAppeal(ApiIOJSummary iojAppeal) {
        this.iojAppeal = iojAppeal;
    }

    public ApiProcessRepOrderRequest withIojAppeal(ApiIOJSummary iojAppeal) {
        this.iojAppeal = iojAppeal;
        return this;
    }

    @JsonProperty(value="financialAssessment")
    public ApiFinancialAssessment getFinancialAssessment() {
        return this.financialAssessment;
    }

    @JsonProperty(value="financialAssessment")
    public void setFinancialAssessment(ApiFinancialAssessment financialAssessment) {
        this.financialAssessment = financialAssessment;
    }

    public ApiProcessRepOrderRequest withFinancialAssessment(ApiFinancialAssessment financialAssessment) {
        this.financialAssessment = financialAssessment;
        return this;
    }

    @JsonProperty(value="passportAssessment")
    public ApiPassportAssessment getPassportAssessment() {
        return this.passportAssessment;
    }

    @JsonProperty(value="passportAssessment")
    public void setPassportAssessment(ApiPassportAssessment passportAssessment) {
        this.passportAssessment = passportAssessment;
    }

    public ApiProcessRepOrderRequest withPassportAssessment(ApiPassportAssessment passportAssessment) {
        this.passportAssessment = passportAssessment;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("repId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"repId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setRepId((Integer)value);
            return true;
        }
        if ("caseType".equals(name)) {
            if (!(value instanceof CaseType)) {
                throw new IllegalArgumentException("property \"caseType\" is of type \"uk.gov.justice.laa.crime.enums.CaseType\", but got " + value.getClass().toString());
            }
            this.setCaseType((CaseType)value);
            return true;
        }
        if ("magCourtOutcome".equals(name)) {
            if (!(value instanceof MagCourtOutcome)) {
                throw new IllegalArgumentException("property \"magCourtOutcome\" is of type \"uk.gov.justice.laa.crime.enums.MagCourtOutcome\", but got " + value.getClass().toString());
            }
            this.setMagCourtOutcome((MagCourtOutcome)value);
            return true;
        }
        if ("decisionReason".equals(name)) {
            if (!(value instanceof DecisionReason)) {
                throw new IllegalArgumentException("property \"decisionReason\" is of type \"uk.gov.justice.laa.crime.enums.DecisionReason\", but got " + value.getClass().toString());
            }
            this.setDecisionReason((DecisionReason)value);
            return true;
        }
        if ("decisionDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"decisionDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setDecisionDate((LocalDateTime)value);
            return true;
        }
        if ("committalDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"committalDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setCommittalDate((LocalDateTime)value);
            return true;
        }
        if ("dateReceived".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"dateReceived\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setDateReceived((LocalDateTime)value);
            return true;
        }
        if ("crownCourtSummary".equals(name)) {
            if (!(value instanceof ApiCrownCourtSummary)) {
                throw new IllegalArgumentException("property \"crownCourtSummary\" is of type \"uk.gov.justice.laa.crime.common.model.proceeding.common.ApiCrownCourtSummary\", but got " + value.getClass().toString());
            }
            this.setCrownCourtSummary((ApiCrownCourtSummary)value);
            return true;
        }
        if ("iojAppeal".equals(name)) {
            if (!(value instanceof ApiIOJSummary)) {
                throw new IllegalArgumentException("property \"iojAppeal\" is of type \"uk.gov.justice.laa.crime.common.model.proceeding.common.ApiIOJSummary\", but got " + value.getClass().toString());
            }
            this.setIojAppeal((ApiIOJSummary)value);
            return true;
        }
        if ("financialAssessment".equals(name)) {
            if (!(value instanceof ApiFinancialAssessment)) {
                throw new IllegalArgumentException("property \"financialAssessment\" is of type \"uk.gov.justice.laa.crime.common.model.proceeding.common.ApiFinancialAssessment\", but got " + value.getClass().toString());
            }
            this.setFinancialAssessment((ApiFinancialAssessment)value);
            return true;
        }
        if ("passportAssessment".equals(name)) {
            if (!(value instanceof ApiPassportAssessment)) {
                throw new IllegalArgumentException("property \"passportAssessment\" is of type \"uk.gov.justice.laa.crime.common.model.proceeding.common.ApiPassportAssessment\", but got " + value.getClass().toString());
            }
            this.setPassportAssessment((ApiPassportAssessment)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("repId".equals(name)) {
            return this.getRepId();
        }
        if ("caseType".equals(name)) {
            return this.getCaseType();
        }
        if ("magCourtOutcome".equals(name)) {
            return this.getMagCourtOutcome();
        }
        if ("decisionReason".equals(name)) {
            return this.getDecisionReason();
        }
        if ("decisionDate".equals(name)) {
            return this.getDecisionDate();
        }
        if ("committalDate".equals(name)) {
            return this.getCommittalDate();
        }
        if ("dateReceived".equals(name)) {
            return this.getDateReceived();
        }
        if ("crownCourtSummary".equals(name)) {
            return this.getCrownCourtSummary();
        }
        if ("iojAppeal".equals(name)) {
            return this.getIojAppeal();
        }
        if ("financialAssessment".equals(name)) {
            return this.getFinancialAssessment();
        }
        if ("passportAssessment".equals(name)) {
            return this.getPassportAssessment();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiProcessRepOrderRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiProcessRepOrderRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("repId");
        sb.append('=');
        sb.append(this.repId == null ? "<null>" : this.repId);
        sb.append(',');
        sb.append("caseType");
        sb.append('=');
        sb.append((Object)(this.caseType == null ? "<null>" : this.caseType));
        sb.append(',');
        sb.append("magCourtOutcome");
        sb.append('=');
        sb.append((Object)(this.magCourtOutcome == null ? "<null>" : this.magCourtOutcome));
        sb.append(',');
        sb.append("decisionReason");
        sb.append('=');
        sb.append((Object)(this.decisionReason == null ? "<null>" : this.decisionReason));
        sb.append(',');
        sb.append("decisionDate");
        sb.append('=');
        sb.append(this.decisionDate == null ? "<null>" : this.decisionDate);
        sb.append(',');
        sb.append("committalDate");
        sb.append('=');
        sb.append(this.committalDate == null ? "<null>" : this.committalDate);
        sb.append(',');
        sb.append("dateReceived");
        sb.append('=');
        sb.append(this.dateReceived == null ? "<null>" : this.dateReceived);
        sb.append(',');
        sb.append("crownCourtSummary");
        sb.append('=');
        sb.append(this.crownCourtSummary == null ? "<null>" : this.crownCourtSummary);
        sb.append(',');
        sb.append("iojAppeal");
        sb.append('=');
        sb.append(this.iojAppeal == null ? "<null>" : this.iojAppeal);
        sb.append(',');
        sb.append("financialAssessment");
        sb.append('=');
        sb.append(this.financialAssessment == null ? "<null>" : this.financialAssessment);
        sb.append(',');
        sb.append("passportAssessment");
        sb.append('=');
        sb.append(this.passportAssessment == null ? "<null>" : this.passportAssessment);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.iojAppeal == null ? 0 : this.iojAppeal.hashCode());
        result = result * 31 + (this.committalDate == null ? 0 : this.committalDate.hashCode());
        result = result * 31 + (this.repId == null ? 0 : this.repId.hashCode());
        result = result * 31 + (this.caseType == null ? 0 : this.caseType.hashCode());
        result = result * 31 + (this.decisionDate == null ? 0 : this.decisionDate.hashCode());
        result = result * 31 + (this.crownCourtSummary == null ? 0 : this.crownCourtSummary.hashCode());
        result = result * 31 + (this.passportAssessment == null ? 0 : this.passportAssessment.hashCode());
        result = result * 31 + (this.magCourtOutcome == null ? 0 : this.magCourtOutcome.hashCode());
        result = result * 31 + (this.dateReceived == null ? 0 : this.dateReceived.hashCode());
        result = result * 31 + (this.decisionReason == null ? 0 : this.decisionReason.hashCode());
        result = result * 31 + (this.financialAssessment == null ? 0 : this.financialAssessment.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiProcessRepOrderRequest)) {
            return false;
        }
        ApiProcessRepOrderRequest rhs = (ApiProcessRepOrderRequest)other;
        return (this.iojAppeal == rhs.iojAppeal || this.iojAppeal != null && this.iojAppeal.equals(rhs.iojAppeal)) && (this.committalDate == rhs.committalDate || this.committalDate != null && this.committalDate.equals(rhs.committalDate)) && (this.repId == rhs.repId || this.repId != null && this.repId.equals(rhs.repId)) && (this.caseType == rhs.caseType || this.caseType != null && this.caseType.equals((Object)rhs.caseType)) && (this.decisionDate == rhs.decisionDate || this.decisionDate != null && this.decisionDate.equals(rhs.decisionDate)) && (this.crownCourtSummary == rhs.crownCourtSummary || this.crownCourtSummary != null && this.crownCourtSummary.equals(rhs.crownCourtSummary)) && (this.passportAssessment == rhs.passportAssessment || this.passportAssessment != null && this.passportAssessment.equals(rhs.passportAssessment)) && (this.magCourtOutcome == rhs.magCourtOutcome || this.magCourtOutcome != null && this.magCourtOutcome.equals((Object)rhs.magCourtOutcome)) && (this.dateReceived == rhs.dateReceived || this.dateReceived != null && this.dateReceived.equals(rhs.dateReceived)) && (this.decisionReason == rhs.decisionReason || this.decisionReason != null && this.decisionReason.equals((Object)rhs.decisionReason)) && (this.financialAssessment == rhs.financialAssessment || this.financialAssessment != null && this.financialAssessment.equals(rhs.financialAssessment));
    }
}

