/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.proceeding.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import uk.gov.justice.laa.crime.common.model.common.ApiUserSession;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiCrownCourtSummary;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiFinancialAssessment;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiIOJSummary;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiPassportAssessment;
import uk.gov.justice.laa.crime.common.model.proceeding.request.ApiProcessRepOrderRequest;
import uk.gov.justice.laa.crime.enums.CaseType;
import uk.gov.justice.laa.crime.enums.DecisionReason;
import uk.gov.justice.laa.crime.enums.MagCourtOutcome;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"applicantHistoryId", "crownRepId", "isImprisoned", "userSession"})
public class ApiUpdateApplicationRequest
extends ApiProcessRepOrderRequest {
    @JsonProperty(value="applicantHistoryId")
    @JsonPropertyDescription(value="The applicant history Id")
    @NotNull
    private Integer applicantHistoryId;
    @JsonProperty(value="crownRepId")
    @JsonPropertyDescription(value="The Crown Rep ID")
    private Integer crownRepId;
    @JsonProperty(value="isImprisoned")
    @JsonPropertyDescription(value="Indicate whether the applicant is imprisoned")
    @NotNull
    private Boolean isImprisoned;
    @JsonProperty(value="userSession")
    @JsonPropertyDescription(value="Details of a user session")
    @Valid
    @NotNull
    private ApiUserSession userSession;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiUpdateApplicationRequest() {
    }

    public ApiUpdateApplicationRequest(Integer applicantHistoryId, Integer crownRepId, Boolean isImprisoned, ApiUserSession userSession, Integer repId, CaseType caseType, MagCourtOutcome magCourtOutcome, DecisionReason decisionReason, LocalDateTime decisionDate, LocalDateTime committalDate, LocalDateTime dateReceived, ApiCrownCourtSummary crownCourtSummary, ApiIOJSummary iojAppeal, ApiFinancialAssessment financialAssessment, ApiPassportAssessment passportAssessment) {
        super(repId, caseType, magCourtOutcome, decisionReason, decisionDate, committalDate, dateReceived, crownCourtSummary, iojAppeal, financialAssessment, passportAssessment);
        this.applicantHistoryId = applicantHistoryId;
        this.crownRepId = crownRepId;
        this.isImprisoned = isImprisoned;
        this.userSession = userSession;
    }

    @JsonProperty(value="applicantHistoryId")
    public Integer getApplicantHistoryId() {
        return this.applicantHistoryId;
    }

    @JsonProperty(value="applicantHistoryId")
    public void setApplicantHistoryId(Integer applicantHistoryId) {
        this.applicantHistoryId = applicantHistoryId;
    }

    public ApiUpdateApplicationRequest withApplicantHistoryId(Integer applicantHistoryId) {
        this.applicantHistoryId = applicantHistoryId;
        return this;
    }

    @JsonProperty(value="crownRepId")
    public Integer getCrownRepId() {
        return this.crownRepId;
    }

    @JsonProperty(value="crownRepId")
    public void setCrownRepId(Integer crownRepId) {
        this.crownRepId = crownRepId;
    }

    public ApiUpdateApplicationRequest withCrownRepId(Integer crownRepId) {
        this.crownRepId = crownRepId;
        return this;
    }

    @JsonProperty(value="isImprisoned")
    public Boolean getIsImprisoned() {
        return this.isImprisoned;
    }

    @JsonProperty(value="isImprisoned")
    public void setIsImprisoned(Boolean isImprisoned) {
        this.isImprisoned = isImprisoned;
    }

    public ApiUpdateApplicationRequest withIsImprisoned(Boolean isImprisoned) {
        this.isImprisoned = isImprisoned;
        return this;
    }

    @JsonProperty(value="userSession")
    public ApiUserSession getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    public void setUserSession(ApiUserSession userSession) {
        this.userSession = userSession;
    }

    public ApiUpdateApplicationRequest withUserSession(ApiUserSession userSession) {
        this.userSession = userSession;
        return this;
    }

    @Override
    public ApiUpdateApplicationRequest withRepId(Integer repId) {
        super.withRepId(repId);
        return this;
    }

    @Override
    public ApiUpdateApplicationRequest withCaseType(CaseType caseType) {
        super.withCaseType(caseType);
        return this;
    }

    @Override
    public ApiUpdateApplicationRequest withMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        super.withMagCourtOutcome(magCourtOutcome);
        return this;
    }

    @Override
    public ApiUpdateApplicationRequest withDecisionReason(DecisionReason decisionReason) {
        super.withDecisionReason(decisionReason);
        return this;
    }

    @Override
    public ApiUpdateApplicationRequest withDecisionDate(LocalDateTime decisionDate) {
        super.withDecisionDate(decisionDate);
        return this;
    }

    @Override
    public ApiUpdateApplicationRequest withCommittalDate(LocalDateTime committalDate) {
        super.withCommittalDate(committalDate);
        return this;
    }

    @Override
    public ApiUpdateApplicationRequest withDateReceived(LocalDateTime dateReceived) {
        super.withDateReceived(dateReceived);
        return this;
    }

    @Override
    public ApiUpdateApplicationRequest withCrownCourtSummary(ApiCrownCourtSummary crownCourtSummary) {
        super.withCrownCourtSummary(crownCourtSummary);
        return this;
    }

    @Override
    public ApiUpdateApplicationRequest withIojAppeal(ApiIOJSummary iojAppeal) {
        super.withIojAppeal(iojAppeal);
        return this;
    }

    @Override
    public ApiUpdateApplicationRequest withFinancialAssessment(ApiFinancialAssessment financialAssessment) {
        super.withFinancialAssessment(financialAssessment);
        return this;
    }

    @Override
    public ApiUpdateApplicationRequest withPassportAssessment(ApiPassportAssessment passportAssessment) {
        super.withPassportAssessment(passportAssessment);
        return this;
    }

    @Override
    protected boolean declaredProperty(String name, Object value) {
        if ("applicantHistoryId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"applicantHistoryId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setApplicantHistoryId((Integer)value);
            return true;
        }
        if ("crownRepId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"crownRepId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setCrownRepId((Integer)value);
            return true;
        }
        if ("isImprisoned".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"isImprisoned\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setIsImprisoned((Boolean)value);
            return true;
        }
        if ("userSession".equals(name)) {
            if (!(value instanceof ApiUserSession)) {
                throw new IllegalArgumentException("property \"userSession\" is of type \"uk.gov.justice.laa.crime.common.model.common.ApiUserSession\", but got " + value.getClass().toString());
            }
            this.setUserSession((ApiUserSession)value);
            return true;
        }
        return super.declaredProperty(name, value);
    }

    @Override
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("applicantHistoryId".equals(name)) {
            return this.getApplicantHistoryId();
        }
        if ("crownRepId".equals(name)) {
            return this.getCrownRepId();
        }
        if ("isImprisoned".equals(name)) {
            return this.getIsImprisoned();
        }
        if ("userSession".equals(name)) {
            return this.getUserSession();
        }
        return super.declaredPropertyOrNotFound(name, notFoundValue);
    }

    @Override
    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    @Override
    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    @Override
    public ApiUpdateApplicationRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiUpdateApplicationRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("applicantHistoryId");
        sb.append('=');
        sb.append(this.applicantHistoryId == null ? "<null>" : this.applicantHistoryId);
        sb.append(',');
        sb.append("crownRepId");
        sb.append('=');
        sb.append(this.crownRepId == null ? "<null>" : this.crownRepId);
        sb.append(',');
        sb.append("isImprisoned");
        sb.append('=');
        sb.append(this.isImprisoned == null ? "<null>" : this.isImprisoned);
        sb.append(',');
        sb.append("userSession");
        sb.append('=');
        sb.append(this.userSession == null ? "<null>" : this.userSession);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.crownRepId == null ? 0 : this.crownRepId.hashCode());
        result = result * 31 + (this.userSession == null ? 0 : this.userSession.hashCode());
        result = result * 31 + (this.isImprisoned == null ? 0 : this.isImprisoned.hashCode());
        result = result * 31 + (this.applicantHistoryId == null ? 0 : this.applicantHistoryId.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiUpdateApplicationRequest)) {
            return false;
        }
        ApiUpdateApplicationRequest rhs = (ApiUpdateApplicationRequest)other;
        return super.equals(rhs) && (this.crownRepId == rhs.crownRepId || this.crownRepId != null && this.crownRepId.equals(rhs.crownRepId)) && (this.userSession == rhs.userSession || this.userSession != null && this.userSession.equals(rhs.userSession)) && (this.isImprisoned == rhs.isImprisoned || this.isImprisoned != null && this.isImprisoned.equals(rhs.isImprisoned)) && (this.applicantHistoryId == rhs.applicantHistoryId || this.applicantHistoryId != null && this.applicantHistoryId.equals(rhs.applicantHistoryId));
    }
}

