/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.proceeding.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.common.ApiUserSession;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiCapitalEvidence;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiCrownCourtSummary;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiFinancialAssessment;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiIOJSummary;
import uk.gov.justice.laa.crime.common.model.proceeding.common.ApiPassportAssessment;
import uk.gov.justice.laa.crime.common.model.proceeding.request.ApiUpdateApplicationRequest;
import uk.gov.justice.laa.crime.enums.CaseType;
import uk.gov.justice.laa.crime.enums.DecisionReason;
import uk.gov.justice.laa.crime.enums.MagCourtOutcome;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"emstCode", "incomeEvidenceReceivedDate", "capitalEvidenceReceivedDate", "capitalEvidence"})
public class ApiUpdateCrownCourtRequest
extends ApiUpdateApplicationRequest {
    @JsonProperty(value="emstCode")
    @JsonPropertyDescription(value="Emp status code")
    private String emstCode;
    @JsonProperty(value="incomeEvidenceReceivedDate")
    @JsonPropertyDescription(value="Income evidence Received Date")
    private LocalDateTime incomeEvidenceReceivedDate;
    @JsonProperty(value="capitalEvidenceReceivedDate")
    @JsonPropertyDescription(value="Capital evidence Received Date")
    private LocalDateTime capitalEvidenceReceivedDate;
    @JsonProperty(value="capitalEvidence")
    @JsonPropertyDescription(value="List of Capital Evidence")
    @Valid
    private List<ApiCapitalEvidence> capitalEvidence = new ArrayList<ApiCapitalEvidence>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiUpdateCrownCourtRequest() {
    }

    public ApiUpdateCrownCourtRequest(String emstCode, LocalDateTime incomeEvidenceReceivedDate, LocalDateTime capitalEvidenceReceivedDate, List<ApiCapitalEvidence> capitalEvidence, Integer applicantHistoryId, Integer crownRepId, Boolean isImprisoned, ApiUserSession userSession, Integer repId, CaseType caseType, MagCourtOutcome magCourtOutcome, DecisionReason decisionReason, LocalDateTime decisionDate, LocalDateTime committalDate, LocalDateTime dateReceived, ApiCrownCourtSummary crownCourtSummary, ApiIOJSummary iojAppeal, ApiFinancialAssessment financialAssessment, ApiPassportAssessment passportAssessment) {
        super(applicantHistoryId, crownRepId, isImprisoned, userSession, repId, caseType, magCourtOutcome, decisionReason, decisionDate, committalDate, dateReceived, crownCourtSummary, iojAppeal, financialAssessment, passportAssessment);
        this.emstCode = emstCode;
        this.incomeEvidenceReceivedDate = incomeEvidenceReceivedDate;
        this.capitalEvidenceReceivedDate = capitalEvidenceReceivedDate;
        this.capitalEvidence = capitalEvidence;
    }

    @JsonProperty(value="emstCode")
    public String getEmstCode() {
        return this.emstCode;
    }

    @JsonProperty(value="emstCode")
    public void setEmstCode(String emstCode) {
        this.emstCode = emstCode;
    }

    public ApiUpdateCrownCourtRequest withEmstCode(String emstCode) {
        this.emstCode = emstCode;
        return this;
    }

    @JsonProperty(value="incomeEvidenceReceivedDate")
    public LocalDateTime getIncomeEvidenceReceivedDate() {
        return this.incomeEvidenceReceivedDate;
    }

    @JsonProperty(value="incomeEvidenceReceivedDate")
    public void setIncomeEvidenceReceivedDate(LocalDateTime incomeEvidenceReceivedDate) {
        this.incomeEvidenceReceivedDate = incomeEvidenceReceivedDate;
    }

    public ApiUpdateCrownCourtRequest withIncomeEvidenceReceivedDate(LocalDateTime incomeEvidenceReceivedDate) {
        this.incomeEvidenceReceivedDate = incomeEvidenceReceivedDate;
        return this;
    }

    @JsonProperty(value="capitalEvidenceReceivedDate")
    public LocalDateTime getCapitalEvidenceReceivedDate() {
        return this.capitalEvidenceReceivedDate;
    }

    @JsonProperty(value="capitalEvidenceReceivedDate")
    public void setCapitalEvidenceReceivedDate(LocalDateTime capitalEvidenceReceivedDate) {
        this.capitalEvidenceReceivedDate = capitalEvidenceReceivedDate;
    }

    public ApiUpdateCrownCourtRequest withCapitalEvidenceReceivedDate(LocalDateTime capitalEvidenceReceivedDate) {
        this.capitalEvidenceReceivedDate = capitalEvidenceReceivedDate;
        return this;
    }

    @JsonProperty(value="capitalEvidence")
    public List<ApiCapitalEvidence> getCapitalEvidence() {
        return this.capitalEvidence;
    }

    @JsonProperty(value="capitalEvidence")
    public void setCapitalEvidence(List<ApiCapitalEvidence> capitalEvidence) {
        this.capitalEvidence = capitalEvidence;
    }

    public ApiUpdateCrownCourtRequest withCapitalEvidence(List<ApiCapitalEvidence> capitalEvidence) {
        this.capitalEvidence = capitalEvidence;
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withApplicantHistoryId(Integer applicantHistoryId) {
        super.withApplicantHistoryId(applicantHistoryId);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withCrownRepId(Integer crownRepId) {
        super.withCrownRepId(crownRepId);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withIsImprisoned(Boolean isImprisoned) {
        super.withIsImprisoned(isImprisoned);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withUserSession(ApiUserSession userSession) {
        super.withUserSession(userSession);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withRepId(Integer repId) {
        super.withRepId(repId);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withCaseType(CaseType caseType) {
        super.withCaseType(caseType);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        super.withMagCourtOutcome(magCourtOutcome);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withDecisionReason(DecisionReason decisionReason) {
        super.withDecisionReason(decisionReason);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withDecisionDate(LocalDateTime decisionDate) {
        super.withDecisionDate(decisionDate);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withCommittalDate(LocalDateTime committalDate) {
        super.withCommittalDate(committalDate);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withDateReceived(LocalDateTime dateReceived) {
        super.withDateReceived(dateReceived);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withCrownCourtSummary(ApiCrownCourtSummary crownCourtSummary) {
        super.withCrownCourtSummary(crownCourtSummary);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withIojAppeal(ApiIOJSummary iojAppeal) {
        super.withIojAppeal(iojAppeal);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withFinancialAssessment(ApiFinancialAssessment financialAssessment) {
        super.withFinancialAssessment(financialAssessment);
        return this;
    }

    @Override
    public ApiUpdateCrownCourtRequest withPassportAssessment(ApiPassportAssessment passportAssessment) {
        super.withPassportAssessment(passportAssessment);
        return this;
    }

    @Override
    protected boolean declaredProperty(String name, Object value) {
        if ("emstCode".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"emstCode\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setEmstCode((String)value);
            return true;
        }
        if ("incomeEvidenceReceivedDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"incomeEvidenceReceivedDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setIncomeEvidenceReceivedDate((LocalDateTime)value);
            return true;
        }
        if ("capitalEvidenceReceivedDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"capitalEvidenceReceivedDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setCapitalEvidenceReceivedDate((LocalDateTime)value);
            return true;
        }
        if ("capitalEvidence".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"capitalEvidence\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.proceeding.common.ApiCapitalEvidence>\", but got " + value.getClass().toString());
            }
            this.setCapitalEvidence((List)value);
            return true;
        }
        return super.declaredProperty(name, value);
    }

    @Override
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("emstCode".equals(name)) {
            return this.getEmstCode();
        }
        if ("incomeEvidenceReceivedDate".equals(name)) {
            return this.getIncomeEvidenceReceivedDate();
        }
        if ("capitalEvidenceReceivedDate".equals(name)) {
            return this.getCapitalEvidenceReceivedDate();
        }
        if ("capitalEvidence".equals(name)) {
            return this.getCapitalEvidence();
        }
        return super.declaredPropertyOrNotFound(name, notFoundValue);
    }

    @Override
    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    @Override
    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    @Override
    public ApiUpdateCrownCourtRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiUpdateCrownCourtRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("emstCode");
        sb.append('=');
        sb.append(this.emstCode == null ? "<null>" : this.emstCode);
        sb.append(',');
        sb.append("incomeEvidenceReceivedDate");
        sb.append('=');
        sb.append(this.incomeEvidenceReceivedDate == null ? "<null>" : this.incomeEvidenceReceivedDate);
        sb.append(',');
        sb.append("capitalEvidenceReceivedDate");
        sb.append('=');
        sb.append(this.capitalEvidenceReceivedDate == null ? "<null>" : this.capitalEvidenceReceivedDate);
        sb.append(',');
        sb.append("capitalEvidence");
        sb.append('=');
        sb.append(this.capitalEvidence == null ? "<null>" : this.capitalEvidence);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.emstCode == null ? 0 : this.emstCode.hashCode());
        result = result * 31 + (this.capitalEvidenceReceivedDate == null ? 0 : this.capitalEvidenceReceivedDate.hashCode());
        result = result * 31 + (this.capitalEvidence == null ? 0 : this.capitalEvidence.hashCode());
        result = result * 31 + (this.incomeEvidenceReceivedDate == null ? 0 : this.incomeEvidenceReceivedDate.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiUpdateCrownCourtRequest)) {
            return false;
        }
        ApiUpdateCrownCourtRequest rhs = (ApiUpdateCrownCourtRequest)other;
        return super.equals(rhs) && (this.emstCode == rhs.emstCode || this.emstCode != null && this.emstCode.equals(rhs.emstCode)) && (this.capitalEvidenceReceivedDate == rhs.capitalEvidenceReceivedDate || this.capitalEvidenceReceivedDate != null && this.capitalEvidenceReceivedDate.equals(rhs.capitalEvidenceReceivedDate)) && (this.capitalEvidence == rhs.capitalEvidence || this.capitalEvidence != null && this.capitalEvidence.equals(rhs.capitalEvidence)) && (this.incomeEvidenceReceivedDate == rhs.incomeEvidenceReceivedDate || this.incomeEvidenceReceivedDate != null && this.incomeEvidenceReceivedDate.equals(rhs.incomeEvidenceReceivedDate));
    }
}

