/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.tracking;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.gov.justice.laa.crime.common.model.tracking.Hardship;
import uk.gov.justice.laa.crime.common.model.tracking.Ioj;
import uk.gov.justice.laa.crime.common.model.tracking.MeansAssessment;
import uk.gov.justice.laa.crime.common.model.tracking.Passport;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"usn", "maat_ref", "action", "action_key_id", "case_id", "case_type", "ioj", "passport", "means_assessment", "hardship", "assessment_id", "assessment_type", "dwp_result", "rep_decision", "cc_rep_decision", "mags_outcome", "request_source", "user_created"})
public class ApplicationTrackingOutputResult {
    @JsonProperty(value="usn")
    @JsonPropertyDescription(value="USN number")
    @NotNull
    private Integer usn;
    @JsonProperty(value="maat_ref")
    @JsonPropertyDescription(value="MAAT / Rep Id")
    @NotNull
    private Integer maatRef;
    @JsonProperty(value="action")
    @JsonPropertyDescription(value="Get or Save_Application or Save_Means_Full/Save_Means_Init or Save_Passport")
    private Action action;
    @JsonProperty(value="action_key_id")
    @JsonPropertyDescription(value="Maat_ref or Finance assessment id or Passport assessment id")
    private Integer actionKeyId;
    @JsonProperty(value="case_id")
    private String caseId;
    @JsonProperty(value="case_type")
    private CaseType caseType;
    @JsonProperty(value="ioj")
    @Valid
    @NotNull
    private Ioj ioj;
    @JsonProperty(value="passport")
    @Valid
    @NotNull
    private Passport passport;
    @JsonProperty(value="means_assessment")
    @Valid
    @NotNull
    private MeansAssessment meansAssessment;
    @JsonProperty(value="hardship")
    @Valid
    @NotNull
    private Hardship hardship;
    @JsonProperty(value="assessment_id")
    @JsonPropertyDescription(value="IOJ Id or Finance assessment id or Passport assessment id or Hardship ID")
    private Integer assessmentId;
    @JsonProperty(value="assessment_type")
    @JsonPropertyDescription(value="IOJ type or Finance assessment type or Passport assessment type or Hardship type")
    private AssessmentType assessmentType;
    @JsonProperty(value="dwp_result")
    @JsonPropertyDescription(value="DWP Result")
    private String dwpResult;
    @JsonProperty(value="rep_decision")
    @JsonPropertyDescription(value="Rep Decision")
    private String repDecision;
    @JsonProperty(value="cc_rep_decision")
    @JsonPropertyDescription(value="CC Rep Decision")
    private String ccRepDecision;
    @JsonProperty(value="mags_outcome")
    @JsonPropertyDescription(value="Magistrate Outcome")
    private String magsOutcome;
    @JsonProperty(value="request_source")
    @JsonPropertyDescription(value="Source of the Request")
    @NotNull
    private RequestSource requestSource;
    @JsonProperty(value="user_created")
    @JsonPropertyDescription(value="User created")
    private String userCreated;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApplicationTrackingOutputResult() {
    }

    public ApplicationTrackingOutputResult(Integer usn, Integer maatRef, Action action, Integer actionKeyId, String caseId, CaseType caseType, Ioj ioj, Passport passport, MeansAssessment meansAssessment, Hardship hardship, Integer assessmentId, AssessmentType assessmentType, String dwpResult, String repDecision, String ccRepDecision, String magsOutcome, RequestSource requestSource, String userCreated) {
        this.usn = usn;
        this.maatRef = maatRef;
        this.action = action;
        this.actionKeyId = actionKeyId;
        this.caseId = caseId;
        this.caseType = caseType;
        this.ioj = ioj;
        this.passport = passport;
        this.meansAssessment = meansAssessment;
        this.hardship = hardship;
        this.assessmentId = assessmentId;
        this.assessmentType = assessmentType;
        this.dwpResult = dwpResult;
        this.repDecision = repDecision;
        this.ccRepDecision = ccRepDecision;
        this.magsOutcome = magsOutcome;
        this.requestSource = requestSource;
        this.userCreated = userCreated;
    }

    @JsonProperty(value="usn")
    public Integer getUsn() {
        return this.usn;
    }

    @JsonProperty(value="usn")
    public void setUsn(Integer usn) {
        this.usn = usn;
    }

    public ApplicationTrackingOutputResult withUsn(Integer usn) {
        this.usn = usn;
        return this;
    }

    @JsonProperty(value="maat_ref")
    public Integer getMaatRef() {
        return this.maatRef;
    }

    @JsonProperty(value="maat_ref")
    public void setMaatRef(Integer maatRef) {
        this.maatRef = maatRef;
    }

    public ApplicationTrackingOutputResult withMaatRef(Integer maatRef) {
        this.maatRef = maatRef;
        return this;
    }

    @JsonProperty(value="action")
    public Action getAction() {
        return this.action;
    }

    @JsonProperty(value="action")
    public void setAction(Action action) {
        this.action = action;
    }

    public ApplicationTrackingOutputResult withAction(Action action) {
        this.action = action;
        return this;
    }

    @JsonProperty(value="action_key_id")
    public Integer getActionKeyId() {
        return this.actionKeyId;
    }

    @JsonProperty(value="action_key_id")
    public void setActionKeyId(Integer actionKeyId) {
        this.actionKeyId = actionKeyId;
    }

    public ApplicationTrackingOutputResult withActionKeyId(Integer actionKeyId) {
        this.actionKeyId = actionKeyId;
        return this;
    }

    @JsonProperty(value="case_id")
    public String getCaseId() {
        return this.caseId;
    }

    @JsonProperty(value="case_id")
    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public ApplicationTrackingOutputResult withCaseId(String caseId) {
        this.caseId = caseId;
        return this;
    }

    @JsonProperty(value="case_type")
    public CaseType getCaseType() {
        return this.caseType;
    }

    @JsonProperty(value="case_type")
    public void setCaseType(CaseType caseType) {
        this.caseType = caseType;
    }

    public ApplicationTrackingOutputResult withCaseType(CaseType caseType) {
        this.caseType = caseType;
        return this;
    }

    @JsonProperty(value="ioj")
    public Ioj getIoj() {
        return this.ioj;
    }

    @JsonProperty(value="ioj")
    public void setIoj(Ioj ioj) {
        this.ioj = ioj;
    }

    public ApplicationTrackingOutputResult withIoj(Ioj ioj) {
        this.ioj = ioj;
        return this;
    }

    @JsonProperty(value="passport")
    public Passport getPassport() {
        return this.passport;
    }

    @JsonProperty(value="passport")
    public void setPassport(Passport passport) {
        this.passport = passport;
    }

    public ApplicationTrackingOutputResult withPassport(Passport passport) {
        this.passport = passport;
        return this;
    }

    @JsonProperty(value="means_assessment")
    public MeansAssessment getMeansAssessment() {
        return this.meansAssessment;
    }

    @JsonProperty(value="means_assessment")
    public void setMeansAssessment(MeansAssessment meansAssessment) {
        this.meansAssessment = meansAssessment;
    }

    public ApplicationTrackingOutputResult withMeansAssessment(MeansAssessment meansAssessment) {
        this.meansAssessment = meansAssessment;
        return this;
    }

    @JsonProperty(value="hardship")
    public Hardship getHardship() {
        return this.hardship;
    }

    @JsonProperty(value="hardship")
    public void setHardship(Hardship hardship) {
        this.hardship = hardship;
    }

    public ApplicationTrackingOutputResult withHardship(Hardship hardship) {
        this.hardship = hardship;
        return this;
    }

    @JsonProperty(value="assessment_id")
    public Integer getAssessmentId() {
        return this.assessmentId;
    }

    @JsonProperty(value="assessment_id")
    public void setAssessmentId(Integer assessmentId) {
        this.assessmentId = assessmentId;
    }

    public ApplicationTrackingOutputResult withAssessmentId(Integer assessmentId) {
        this.assessmentId = assessmentId;
        return this;
    }

    @JsonProperty(value="assessment_type")
    public AssessmentType getAssessmentType() {
        return this.assessmentType;
    }

    @JsonProperty(value="assessment_type")
    public void setAssessmentType(AssessmentType assessmentType) {
        this.assessmentType = assessmentType;
    }

    public ApplicationTrackingOutputResult withAssessmentType(AssessmentType assessmentType) {
        this.assessmentType = assessmentType;
        return this;
    }

    @JsonProperty(value="dwp_result")
    public String getDwpResult() {
        return this.dwpResult;
    }

    @JsonProperty(value="dwp_result")
    public void setDwpResult(String dwpResult) {
        this.dwpResult = dwpResult;
    }

    public ApplicationTrackingOutputResult withDwpResult(String dwpResult) {
        this.dwpResult = dwpResult;
        return this;
    }

    @JsonProperty(value="rep_decision")
    public String getRepDecision() {
        return this.repDecision;
    }

    @JsonProperty(value="rep_decision")
    public void setRepDecision(String repDecision) {
        this.repDecision = repDecision;
    }

    public ApplicationTrackingOutputResult withRepDecision(String repDecision) {
        this.repDecision = repDecision;
        return this;
    }

    @JsonProperty(value="cc_rep_decision")
    public String getCcRepDecision() {
        return this.ccRepDecision;
    }

    @JsonProperty(value="cc_rep_decision")
    public void setCcRepDecision(String ccRepDecision) {
        this.ccRepDecision = ccRepDecision;
    }

    public ApplicationTrackingOutputResult withCcRepDecision(String ccRepDecision) {
        this.ccRepDecision = ccRepDecision;
        return this;
    }

    @JsonProperty(value="mags_outcome")
    public String getMagsOutcome() {
        return this.magsOutcome;
    }

    @JsonProperty(value="mags_outcome")
    public void setMagsOutcome(String magsOutcome) {
        this.magsOutcome = magsOutcome;
    }

    public ApplicationTrackingOutputResult withMagsOutcome(String magsOutcome) {
        this.magsOutcome = magsOutcome;
        return this;
    }

    @JsonProperty(value="request_source")
    public RequestSource getRequestSource() {
        return this.requestSource;
    }

    @JsonProperty(value="request_source")
    public void setRequestSource(RequestSource requestSource) {
        this.requestSource = requestSource;
    }

    public ApplicationTrackingOutputResult withRequestSource(RequestSource requestSource) {
        this.requestSource = requestSource;
        return this;
    }

    @JsonProperty(value="user_created")
    public String getUserCreated() {
        return this.userCreated;
    }

    @JsonProperty(value="user_created")
    public void setUserCreated(String userCreated) {
        this.userCreated = userCreated;
    }

    public ApplicationTrackingOutputResult withUserCreated(String userCreated) {
        this.userCreated = userCreated;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ApplicationTrackingOutputResult withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("usn".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"usn\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setUsn((Integer)value);
            return true;
        }
        if ("maat_ref".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"maat_ref\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setMaatRef((Integer)value);
            return true;
        }
        if ("action".equals(name)) {
            if (!(value instanceof Action)) {
                throw new IllegalArgumentException("property \"action\" is of type \"uk.gov.justice.laa.crime.common.model.tracking.ApplicationTrackingOutputResult.Action\", but got " + value.getClass().toString());
            }
            this.setAction((Action)((Object)value));
            return true;
        }
        if ("action_key_id".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"action_key_id\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setActionKeyId((Integer)value);
            return true;
        }
        if ("case_id".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"case_id\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setCaseId((String)value);
            return true;
        }
        if ("case_type".equals(name)) {
            if (!(value instanceof CaseType)) {
                throw new IllegalArgumentException("property \"case_type\" is of type \"uk.gov.justice.laa.crime.common.model.tracking.ApplicationTrackingOutputResult.CaseType\", but got " + value.getClass().toString());
            }
            this.setCaseType((CaseType)((Object)value));
            return true;
        }
        if ("ioj".equals(name)) {
            if (!(value instanceof Ioj)) {
                throw new IllegalArgumentException("property \"ioj\" is of type \"uk.gov.justice.laa.crime.common.model.tracking.Ioj\", but got " + value.getClass().toString());
            }
            this.setIoj((Ioj)value);
            return true;
        }
        if ("passport".equals(name)) {
            if (!(value instanceof Passport)) {
                throw new IllegalArgumentException("property \"passport\" is of type \"uk.gov.justice.laa.crime.common.model.tracking.Passport\", but got " + value.getClass().toString());
            }
            this.setPassport((Passport)value);
            return true;
        }
        if ("means_assessment".equals(name)) {
            if (!(value instanceof MeansAssessment)) {
                throw new IllegalArgumentException("property \"means_assessment\" is of type \"uk.gov.justice.laa.crime.common.model.tracking.MeansAssessment\", but got " + value.getClass().toString());
            }
            this.setMeansAssessment((MeansAssessment)value);
            return true;
        }
        if ("hardship".equals(name)) {
            if (!(value instanceof Hardship)) {
                throw new IllegalArgumentException("property \"hardship\" is of type \"uk.gov.justice.laa.crime.common.model.tracking.Hardship\", but got " + value.getClass().toString());
            }
            this.setHardship((Hardship)value);
            return true;
        }
        if ("assessment_id".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"assessment_id\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setAssessmentId((Integer)value);
            return true;
        }
        if ("assessment_type".equals(name)) {
            if (!(value instanceof AssessmentType)) {
                throw new IllegalArgumentException("property \"assessment_type\" is of type \"uk.gov.justice.laa.crime.common.model.tracking.ApplicationTrackingOutputResult.AssessmentType\", but got " + value.getClass().toString());
            }
            this.setAssessmentType((AssessmentType)((Object)value));
            return true;
        }
        if ("dwp_result".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"dwp_result\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setDwpResult((String)value);
            return true;
        }
        if ("rep_decision".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"rep_decision\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setRepDecision((String)value);
            return true;
        }
        if ("cc_rep_decision".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"cc_rep_decision\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setCcRepDecision((String)value);
            return true;
        }
        if ("mags_outcome".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"mags_outcome\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setMagsOutcome((String)value);
            return true;
        }
        if ("request_source".equals(name)) {
            if (!(value instanceof RequestSource)) {
                throw new IllegalArgumentException("property \"request_source\" is of type \"uk.gov.justice.laa.crime.common.model.tracking.ApplicationTrackingOutputResult.RequestSource\", but got " + value.getClass().toString());
            }
            this.setRequestSource((RequestSource)((Object)value));
            return true;
        }
        if ("user_created".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"user_created\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUserCreated((String)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("usn".equals(name)) {
            return this.getUsn();
        }
        if ("maat_ref".equals(name)) {
            return this.getMaatRef();
        }
        if ("action".equals(name)) {
            return this.getAction();
        }
        if ("action_key_id".equals(name)) {
            return this.getActionKeyId();
        }
        if ("case_id".equals(name)) {
            return this.getCaseId();
        }
        if ("case_type".equals(name)) {
            return this.getCaseType();
        }
        if ("ioj".equals(name)) {
            return this.getIoj();
        }
        if ("passport".equals(name)) {
            return this.getPassport();
        }
        if ("means_assessment".equals(name)) {
            return this.getMeansAssessment();
        }
        if ("hardship".equals(name)) {
            return this.getHardship();
        }
        if ("assessment_id".equals(name)) {
            return this.getAssessmentId();
        }
        if ("assessment_type".equals(name)) {
            return this.getAssessmentType();
        }
        if ("dwp_result".equals(name)) {
            return this.getDwpResult();
        }
        if ("rep_decision".equals(name)) {
            return this.getRepDecision();
        }
        if ("cc_rep_decision".equals(name)) {
            return this.getCcRepDecision();
        }
        if ("mags_outcome".equals(name)) {
            return this.getMagsOutcome();
        }
        if ("request_source".equals(name)) {
            return this.getRequestSource();
        }
        if ("user_created".equals(name)) {
            return this.getUserCreated();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public ApplicationTrackingOutputResult with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApplicationTrackingOutputResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("usn");
        sb.append('=');
        sb.append(this.usn == null ? "<null>" : this.usn);
        sb.append(',');
        sb.append("maatRef");
        sb.append('=');
        sb.append(this.maatRef == null ? "<null>" : this.maatRef);
        sb.append(',');
        sb.append("action");
        sb.append('=');
        sb.append(this.action == null ? "<null>" : this.action);
        sb.append(',');
        sb.append("actionKeyId");
        sb.append('=');
        sb.append(this.actionKeyId == null ? "<null>" : this.actionKeyId);
        sb.append(',');
        sb.append("caseId");
        sb.append('=');
        sb.append(this.caseId == null ? "<null>" : this.caseId);
        sb.append(',');
        sb.append("caseType");
        sb.append('=');
        sb.append(this.caseType == null ? "<null>" : this.caseType);
        sb.append(',');
        sb.append("ioj");
        sb.append('=');
        sb.append(this.ioj == null ? "<null>" : this.ioj);
        sb.append(',');
        sb.append("passport");
        sb.append('=');
        sb.append(this.passport == null ? "<null>" : this.passport);
        sb.append(',');
        sb.append("meansAssessment");
        sb.append('=');
        sb.append(this.meansAssessment == null ? "<null>" : this.meansAssessment);
        sb.append(',');
        sb.append("hardship");
        sb.append('=');
        sb.append(this.hardship == null ? "<null>" : this.hardship);
        sb.append(',');
        sb.append("assessmentId");
        sb.append('=');
        sb.append(this.assessmentId == null ? "<null>" : this.assessmentId);
        sb.append(',');
        sb.append("assessmentType");
        sb.append('=');
        sb.append(this.assessmentType == null ? "<null>" : this.assessmentType);
        sb.append(',');
        sb.append("dwpResult");
        sb.append('=');
        sb.append(this.dwpResult == null ? "<null>" : this.dwpResult);
        sb.append(',');
        sb.append("repDecision");
        sb.append('=');
        sb.append(this.repDecision == null ? "<null>" : this.repDecision);
        sb.append(',');
        sb.append("ccRepDecision");
        sb.append('=');
        sb.append(this.ccRepDecision == null ? "<null>" : this.ccRepDecision);
        sb.append(',');
        sb.append("magsOutcome");
        sb.append('=');
        sb.append(this.magsOutcome == null ? "<null>" : this.magsOutcome);
        sb.append(',');
        sb.append("requestSource");
        sb.append('=');
        sb.append(this.requestSource == null ? "<null>" : this.requestSource);
        sb.append(',');
        sb.append("userCreated");
        sb.append('=');
        sb.append(this.userCreated == null ? "<null>" : this.userCreated);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.actionKeyId == null ? 0 : this.actionKeyId.hashCode());
        result = result * 31 + (this.assessmentType == null ? 0 : this.assessmentType.hashCode());
        result = result * 31 + (this.ioj == null ? 0 : this.ioj.hashCode());
        result = result * 31 + (this.ccRepDecision == null ? 0 : this.ccRepDecision.hashCode());
        result = result * 31 + (this.dwpResult == null ? 0 : this.dwpResult.hashCode());
        result = result * 31 + (this.requestSource == null ? 0 : this.requestSource.hashCode());
        result = result * 31 + (this.repDecision == null ? 0 : this.repDecision.hashCode());
        result = result * 31 + (this.userCreated == null ? 0 : this.userCreated.hashCode());
        result = result * 31 + (this.caseType == null ? 0 : this.caseType.hashCode());
        result = result * 31 + (this.usn == null ? 0 : this.usn.hashCode());
        result = result * 31 + (this.hardship == null ? 0 : this.hardship.hashCode());
        result = result * 31 + (this.passport == null ? 0 : this.passport.hashCode());
        result = result * 31 + (this.maatRef == null ? 0 : this.maatRef.hashCode());
        result = result * 31 + (this.caseId == null ? 0 : this.caseId.hashCode());
        result = result * 31 + (this.meansAssessment == null ? 0 : this.meansAssessment.hashCode());
        result = result * 31 + (this.action == null ? 0 : this.action.hashCode());
        result = result * 31 + (this.magsOutcome == null ? 0 : this.magsOutcome.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.assessmentId == null ? 0 : this.assessmentId.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApplicationTrackingOutputResult)) {
            return false;
        }
        ApplicationTrackingOutputResult rhs = (ApplicationTrackingOutputResult)other;
        return (this.actionKeyId == rhs.actionKeyId || this.actionKeyId != null && this.actionKeyId.equals(rhs.actionKeyId)) && (this.assessmentType == rhs.assessmentType || this.assessmentType != null && this.assessmentType.equals((Object)rhs.assessmentType)) && (this.ioj == rhs.ioj || this.ioj != null && this.ioj.equals(rhs.ioj)) && (this.ccRepDecision == rhs.ccRepDecision || this.ccRepDecision != null && this.ccRepDecision.equals(rhs.ccRepDecision)) && (this.dwpResult == rhs.dwpResult || this.dwpResult != null && this.dwpResult.equals(rhs.dwpResult)) && (this.requestSource == rhs.requestSource || this.requestSource != null && this.requestSource.equals((Object)rhs.requestSource)) && (this.repDecision == rhs.repDecision || this.repDecision != null && this.repDecision.equals(rhs.repDecision)) && (this.userCreated == rhs.userCreated || this.userCreated != null && this.userCreated.equals(rhs.userCreated)) && (this.caseType == rhs.caseType || this.caseType != null && this.caseType.equals((Object)rhs.caseType)) && (this.usn == rhs.usn || this.usn != null && this.usn.equals(rhs.usn)) && (this.hardship == rhs.hardship || this.hardship != null && this.hardship.equals(rhs.hardship)) && (this.passport == rhs.passport || this.passport != null && this.passport.equals(rhs.passport)) && (this.maatRef == rhs.maatRef || this.maatRef != null && this.maatRef.equals(rhs.maatRef)) && (this.caseId == rhs.caseId || this.caseId != null && this.caseId.equals(rhs.caseId)) && (this.meansAssessment == rhs.meansAssessment || this.meansAssessment != null && this.meansAssessment.equals(rhs.meansAssessment)) && (this.action == rhs.action || this.action != null && this.action.equals((Object)rhs.action)) && (this.magsOutcome == rhs.magsOutcome || this.magsOutcome != null && this.magsOutcome.equals(rhs.magsOutcome)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.assessmentId == rhs.assessmentId || this.assessmentId != null && this.assessmentId.equals(rhs.assessmentId));
    }

    public static enum Action {
        GET("Get"),
        SAVE_APPLICATION("Save_Application"),
        SAVE_MEANS_FULL("Save_Means_Full"),
        SAVE_MEANS_INIT("Save_Means_Init"),
        SAVE_PASSPORT("Save_Passport");

        private final String value;
        private static final Map<String, Action> CONSTANTS;

        private Action(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Action fromValue(String value) {
            Action constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Action>();
            for (Action c : Action.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CaseType {
        INDICTABLE("INDICTABLE"),
        SUMMARY_ONLY("SUMMARY ONLY"),
        CC_ALREADY("CC ALREADY"),
        APPEAL_CC("APPEAL CC"),
        COMMITAL("COMMITAL"),
        EITHER_WAY("EITHER WAY");

        private final String value;
        private static final Map<String, CaseType> CONSTANTS;

        private CaseType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CaseType fromValue(String value) {
            CaseType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CaseType>();
            for (CaseType c : CaseType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AssessmentType {
        MCHARDSHIP("MCHARDSHIP"),
        MEANS_INIT("MEANS_INIT"),
        CCHARDSHIP("CCHARDSHIP"),
        IOJ("IOJ"),
        MEANS_FULL("MEANS_FULL"),
        PASSPORT("PASSPORT");

        private final String value;
        private static final Map<String, AssessmentType> CONSTANTS;

        private AssessmentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AssessmentType fromValue(String value) {
            AssessmentType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AssessmentType>();
            for (AssessmentType c : AssessmentType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum RequestSource {
        CREATE_APPLICATION("create_application"),
        PASSPORT_IOJ("passport_ioj"),
        MEANS_ASSESSMENT("means_assessment"),
        HARDSHIP("hardship"),
        CROWN_COURT("crown_court"),
        CAPITAL_AND_EQUITY("capital_and_equity");

        private final String value;
        private static final Map<String, RequestSource> CONSTANTS;

        private RequestSource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static RequestSource fromValue(String value) {
            RequestSource constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, RequestSource>();
            for (RequestSource c : RequestSource.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

