/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.tracking;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"iojId", "ioj_result", "ioj_reason", "ioj_appeal_result", "ioj_assessor_name", "app_created_date"})
public class Ioj {
    @JsonProperty(value="iojId")
    private Integer iojId;
    @JsonProperty(value="ioj_result")
    private String iojResult;
    @JsonProperty(value="ioj_reason")
    @JsonPropertyDescription(value="IOJ Notes")
    private String iojReason;
    @JsonProperty(value="ioj_appeal_result")
    private IojAppealResult iojAppealResult;
    @JsonProperty(value="ioj_assessor_name")
    private String iojAssessorName;
    @JsonProperty(value="app_created_date")
    @JsonPropertyDescription(value="Date of application created")
    private LocalDateTime appCreatedDate;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public Ioj() {
    }

    public Ioj(Integer iojId, String iojResult, String iojReason, IojAppealResult iojAppealResult, String iojAssessorName, LocalDateTime appCreatedDate) {
        this.iojId = iojId;
        this.iojResult = iojResult;
        this.iojReason = iojReason;
        this.iojAppealResult = iojAppealResult;
        this.iojAssessorName = iojAssessorName;
        this.appCreatedDate = appCreatedDate;
    }

    @JsonProperty(value="iojId")
    public Integer getIojId() {
        return this.iojId;
    }

    @JsonProperty(value="iojId")
    public void setIojId(Integer iojId) {
        this.iojId = iojId;
    }

    public Ioj withIojId(Integer iojId) {
        this.iojId = iojId;
        return this;
    }

    @JsonProperty(value="ioj_result")
    public String getIojResult() {
        return this.iojResult;
    }

    @JsonProperty(value="ioj_result")
    public void setIojResult(String iojResult) {
        this.iojResult = iojResult;
    }

    public Ioj withIojResult(String iojResult) {
        this.iojResult = iojResult;
        return this;
    }

    @JsonProperty(value="ioj_reason")
    public String getIojReason() {
        return this.iojReason;
    }

    @JsonProperty(value="ioj_reason")
    public void setIojReason(String iojReason) {
        this.iojReason = iojReason;
    }

    public Ioj withIojReason(String iojReason) {
        this.iojReason = iojReason;
        return this;
    }

    @JsonProperty(value="ioj_appeal_result")
    public IojAppealResult getIojAppealResult() {
        return this.iojAppealResult;
    }

    @JsonProperty(value="ioj_appeal_result")
    public void setIojAppealResult(IojAppealResult iojAppealResult) {
        this.iojAppealResult = iojAppealResult;
    }

    public Ioj withIojAppealResult(IojAppealResult iojAppealResult) {
        this.iojAppealResult = iojAppealResult;
        return this;
    }

    @JsonProperty(value="ioj_assessor_name")
    public String getIojAssessorName() {
        return this.iojAssessorName;
    }

    @JsonProperty(value="ioj_assessor_name")
    public void setIojAssessorName(String iojAssessorName) {
        this.iojAssessorName = iojAssessorName;
    }

    public Ioj withIojAssessorName(String iojAssessorName) {
        this.iojAssessorName = iojAssessorName;
        return this;
    }

    @JsonProperty(value="app_created_date")
    public LocalDateTime getAppCreatedDate() {
        return this.appCreatedDate;
    }

    @JsonProperty(value="app_created_date")
    public void setAppCreatedDate(LocalDateTime appCreatedDate) {
        this.appCreatedDate = appCreatedDate;
    }

    public Ioj withAppCreatedDate(LocalDateTime appCreatedDate) {
        this.appCreatedDate = appCreatedDate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Ioj withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("iojId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"iojId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setIojId((Integer)value);
            return true;
        }
        if ("ioj_result".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"ioj_result\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setIojResult((String)value);
            return true;
        }
        if ("ioj_reason".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"ioj_reason\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setIojReason((String)value);
            return true;
        }
        if ("ioj_appeal_result".equals(name)) {
            if (!(value instanceof IojAppealResult)) {
                throw new IllegalArgumentException("property \"ioj_appeal_result\" is of type \"uk.gov.justice.laa.crime.common.model.tracking.Ioj.IojAppealResult\", but got " + value.getClass().toString());
            }
            this.setIojAppealResult((IojAppealResult)((Object)value));
            return true;
        }
        if ("ioj_assessor_name".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"ioj_assessor_name\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setIojAssessorName((String)value);
            return true;
        }
        if ("app_created_date".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"app_created_date\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setAppCreatedDate((LocalDateTime)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("iojId".equals(name)) {
            return this.getIojId();
        }
        if ("ioj_result".equals(name)) {
            return this.getIojResult();
        }
        if ("ioj_reason".equals(name)) {
            return this.getIojReason();
        }
        if ("ioj_appeal_result".equals(name)) {
            return this.getIojAppealResult();
        }
        if ("ioj_assessor_name".equals(name)) {
            return this.getIojAssessorName();
        }
        if ("app_created_date".equals(name)) {
            return this.getAppCreatedDate();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public Ioj with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Ioj.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("iojId");
        sb.append('=');
        sb.append(this.iojId == null ? "<null>" : this.iojId);
        sb.append(',');
        sb.append("iojResult");
        sb.append('=');
        sb.append(this.iojResult == null ? "<null>" : this.iojResult);
        sb.append(',');
        sb.append("iojReason");
        sb.append('=');
        sb.append(this.iojReason == null ? "<null>" : this.iojReason);
        sb.append(',');
        sb.append("iojAppealResult");
        sb.append('=');
        sb.append(this.iojAppealResult == null ? "<null>" : this.iojAppealResult);
        sb.append(',');
        sb.append("iojAssessorName");
        sb.append('=');
        sb.append(this.iojAssessorName == null ? "<null>" : this.iojAssessorName);
        sb.append(',');
        sb.append("appCreatedDate");
        sb.append('=');
        sb.append(this.appCreatedDate == null ? "<null>" : this.appCreatedDate);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.iojAssessorName == null ? 0 : this.iojAssessorName.hashCode());
        result = result * 31 + (this.iojId == null ? 0 : this.iojId.hashCode());
        result = result * 31 + (this.appCreatedDate == null ? 0 : this.appCreatedDate.hashCode());
        result = result * 31 + (this.iojAppealResult == null ? 0 : this.iojAppealResult.hashCode());
        result = result * 31 + (this.iojResult == null ? 0 : this.iojResult.hashCode());
        result = result * 31 + (this.iojReason == null ? 0 : this.iojReason.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Ioj)) {
            return false;
        }
        Ioj rhs = (Ioj)other;
        return (this.iojAssessorName == rhs.iojAssessorName || this.iojAssessorName != null && this.iojAssessorName.equals(rhs.iojAssessorName)) && (this.iojId == rhs.iojId || this.iojId != null && this.iojId.equals(rhs.iojId)) && (this.appCreatedDate == rhs.appCreatedDate || this.appCreatedDate != null && this.appCreatedDate.equals(rhs.appCreatedDate)) && (this.iojAppealResult == rhs.iojAppealResult || this.iojAppealResult != null && this.iojAppealResult.equals((Object)rhs.iojAppealResult)) && (this.iojResult == rhs.iojResult || this.iojResult != null && this.iojResult.equals(rhs.iojResult)) && (this.iojReason == rhs.iojReason || this.iojReason != null && this.iojReason.equals(rhs.iojReason)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }

    public static enum IojAppealResult {
        PASS("PASS"),
        FAIL("FAIL");

        private final String value;
        private static final Map<String, IojAppealResult> CONSTANTS;

        private IojAppealResult(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static IojAppealResult fromValue(String value) {
            IojAppealResult constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, IojAppealResult>();
            for (IojAppealResult c : IojAppealResult.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

