/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.tracking;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"passportId", "passport_result", "passport_assessor_name", "passport_created_date"})
public class Passport {
    @JsonProperty(value="passportId")
    private Integer passportId;
    @JsonProperty(value="passport_result")
    private PassportResult passportResult;
    @JsonProperty(value="passport_assessor_name")
    private String passportAssessorName;
    @JsonProperty(value="passport_created_date")
    @JsonPropertyDescription(value="Date of passport created")
    private LocalDateTime passportCreatedDate;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public Passport() {
    }

    public Passport(Integer passportId, PassportResult passportResult, String passportAssessorName, LocalDateTime passportCreatedDate) {
        this.passportId = passportId;
        this.passportResult = passportResult;
        this.passportAssessorName = passportAssessorName;
        this.passportCreatedDate = passportCreatedDate;
    }

    @JsonProperty(value="passportId")
    public Integer getPassportId() {
        return this.passportId;
    }

    @JsonProperty(value="passportId")
    public void setPassportId(Integer passportId) {
        this.passportId = passportId;
    }

    public Passport withPassportId(Integer passportId) {
        this.passportId = passportId;
        return this;
    }

    @JsonProperty(value="passport_result")
    public PassportResult getPassportResult() {
        return this.passportResult;
    }

    @JsonProperty(value="passport_result")
    public void setPassportResult(PassportResult passportResult) {
        this.passportResult = passportResult;
    }

    public Passport withPassportResult(PassportResult passportResult) {
        this.passportResult = passportResult;
        return this;
    }

    @JsonProperty(value="passport_assessor_name")
    public String getPassportAssessorName() {
        return this.passportAssessorName;
    }

    @JsonProperty(value="passport_assessor_name")
    public void setPassportAssessorName(String passportAssessorName) {
        this.passportAssessorName = passportAssessorName;
    }

    public Passport withPassportAssessorName(String passportAssessorName) {
        this.passportAssessorName = passportAssessorName;
        return this;
    }

    @JsonProperty(value="passport_created_date")
    public LocalDateTime getPassportCreatedDate() {
        return this.passportCreatedDate;
    }

    @JsonProperty(value="passport_created_date")
    public void setPassportCreatedDate(LocalDateTime passportCreatedDate) {
        this.passportCreatedDate = passportCreatedDate;
    }

    public Passport withPassportCreatedDate(LocalDateTime passportCreatedDate) {
        this.passportCreatedDate = passportCreatedDate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Passport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("passportId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"passportId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setPassportId((Integer)value);
            return true;
        }
        if ("passport_result".equals(name)) {
            if (!(value instanceof PassportResult)) {
                throw new IllegalArgumentException("property \"passport_result\" is of type \"uk.gov.justice.laa.crime.common.model.tracking.Passport.PassportResult\", but got " + value.getClass().toString());
            }
            this.setPassportResult((PassportResult)((Object)value));
            return true;
        }
        if ("passport_assessor_name".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"passport_assessor_name\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setPassportAssessorName((String)value);
            return true;
        }
        if ("passport_created_date".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"passport_created_date\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setPassportCreatedDate((LocalDateTime)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("passportId".equals(name)) {
            return this.getPassportId();
        }
        if ("passport_result".equals(name)) {
            return this.getPassportResult();
        }
        if ("passport_assessor_name".equals(name)) {
            return this.getPassportAssessorName();
        }
        if ("passport_created_date".equals(name)) {
            return this.getPassportCreatedDate();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public Passport with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Passport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("passportId");
        sb.append('=');
        sb.append(this.passportId == null ? "<null>" : this.passportId);
        sb.append(',');
        sb.append("passportResult");
        sb.append('=');
        sb.append(this.passportResult == null ? "<null>" : this.passportResult);
        sb.append(',');
        sb.append("passportAssessorName");
        sb.append('=');
        sb.append(this.passportAssessorName == null ? "<null>" : this.passportAssessorName);
        sb.append(',');
        sb.append("passportCreatedDate");
        sb.append('=');
        sb.append(this.passportCreatedDate == null ? "<null>" : this.passportCreatedDate);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.passportCreatedDate == null ? 0 : this.passportCreatedDate.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.passportAssessorName == null ? 0 : this.passportAssessorName.hashCode());
        result = result * 31 + (this.passportId == null ? 0 : this.passportId.hashCode());
        result = result * 31 + (this.passportResult == null ? 0 : this.passportResult.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Passport)) {
            return false;
        }
        Passport rhs = (Passport)other;
        return (this.passportCreatedDate == rhs.passportCreatedDate || this.passportCreatedDate != null && this.passportCreatedDate.equals(rhs.passportCreatedDate)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.passportAssessorName == rhs.passportAssessorName || this.passportAssessorName != null && this.passportAssessorName.equals(rhs.passportAssessorName)) && (this.passportId == rhs.passportId || this.passportId != null && this.passportId.equals(rhs.passportId)) && (this.passportResult == rhs.passportResult || this.passportResult != null && this.passportResult.equals((Object)rhs.passportResult));
    }

    public static enum PassportResult {
        PASS("PASS"),
        FAIL("FAIL"),
        FAIL_CONTINUE("FAIL CONTINUE"),
        TEMP("TEMP");

        private final String value;
        private static final Map<String, PassportResult> CONSTANTS;

        private PassportResult(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static PassportResult fromValue(String value) {
            PassportResult constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, PassportResult>();
            for (PassportResult c : PassportResult.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

