/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.csv.validator.ui;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import resource.Resource$;
import resource.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Unit$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.swing.Component;
import scala.swing.FileChooser;
import scala.swing.SimpleSwingApplication;
import scala.swing.Swing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scalax.file.Path;
import scalax.file.Path$;
import uk.gov.nationalarchives.csv.validator.ProgressCallback;
import uk.gov.nationalarchives.csv.validator.api.TextFile;
import uk.gov.nationalarchives.csv.validator.api.TextFile$;
import uk.gov.nationalarchives.csv.validator.cmd.CsvValidatorCmdApp$;
import uk.gov.nationalarchives.csv.validator.ui.CsvValidatorUi;
import uk.gov.nationalarchives.csv.validator.ui.CsvValidatorUi$;
import uk.gov.nationalarchives.csv.validator.ui.SJXFrame;
import uk.gov.nationalarchives.csv.validator.ui.SJXTaskPane$;

public final class CsvValidatorUi$
extends SimpleSwingApplication {
    public static final CsvValidatorUi$ MODULE$;
    private File settingsFile;
    private File userDir;
    private volatile byte bitmap$0;

    static {
        new CsvValidatorUi$();
    }

    private File settingsFile$lzycompute() {
        CsvValidatorUi$ csvValidatorUi$ = this;
        synchronized (csvValidatorUi$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.settingsFile = new File(new StringBuilder().append((Object)System.getProperty("user.home")).append((Object)"/.csv-validator/csv-validator.properties").toString());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.settingsFile;
        }
    }

    private File userDir$lzycompute() {
        CsvValidatorUi$ csvValidatorUi$ = this;
        synchronized (csvValidatorUi$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.userDir = new File(System.getProperty("user.dir"));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.userDir;
        }
    }

    public void startup(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            JOptionPane.showMessageDialog(this.top().peer(), new StringBuilder().append((Object)"Unable to set native look and feel: ").append((Object)unsupportedLookAndFeelException.getMessage()).toString(), "Look and Feel Warning", 2);
        }
        super.startup(args);
    }

    public SJXFrame top() {
        return new SJXFrame(){
            {
                this.title_$eq("CSV Validator");
                this.peer().setDefaultCloseOperation(3);
                CsvValidatorUi.SettingsPanel settings = new CsvValidatorUi.SettingsPanel();
                settings.settingsGroup().reactions().$plus$eq(SJXTaskPane$.MODULE$.onViewStateChanged((Function0<BoxedUnit>)new Serializable(this, settings){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final CsvValidatorUi.SettingsPanel settings$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Dimension newSize = this.settings$1.settingsGroup().collapsed() ? new Dimension((int)this.$outer.size().getWidth(), (int)(this.$outer.size().getHeight() - this.settings$1.size().getHeight())) : new Dimension((int)this.$outer.size().getWidth(), (int)(this.$outer.size().getHeight() + this.settings$1.size().getHeight()));
                        this.$outer.size_$eq(newSize);
                        this.$outer.pack();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.settings$1 = settings$1;
                    }
                }));
                this.contents_$eq((Component)new CsvValidatorUi.ContentPanel(settings));
            }
        };
    }

    public String uk$gov$nationalarchives$csv$validator$ui$CsvValidatorUi$$getShortVersion() {
        return (String)this.extractFromManifest((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Attributes attributes) {
                return attributes.getValue("Implementation-Version");
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "UNKNOWN";
            }
        });
    }

    public Seq<Tuple2<String, String>> uk$gov$nationalarchives$csv$validator$ui$CsvValidatorUi$$getLongVersion() {
        return (Seq)this.extractFromManifest((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<String, String>> apply(Attributes attributes) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Version", (Object)attributes.getValue("Implementation-Version")), new Tuple2((Object)"Revision", (Object)attributes.getValue("Git-Commit")), new Tuple2((Object)"Build Timestamp", (Object)attributes.getValue("Build-Timestamp"))}));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<String, String>> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Version", (Object)"UNKNOWN")}));
            }
        });
    }

    private <T> Option<T> extractFromManifest(Function1<Attributes, T> extractor) {
        None$ none$;
        String className;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String classPath = clazz.getResource(className = new StringBuilder().append((Object)clazz.getSimpleName()).append((Object)".class").toString()).toString();
        if (classPath.startsWith("jar")) {
            String manifestPath = new StringBuilder().append((Object)classPath.substring(0, classPath.lastIndexOf("!") + 1)).append((Object)"/META-INF/MANIFEST.MF").toString();
            none$ = package$.MODULE$.managed((Function0)new Serializable(manifestPath){
                public static final long serialVersionUID = 0L;
                private final String manifestPath$1;

                public final InputStream apply() {
                    return new URL(this.manifestPath$1).openStream();
                }
                {
                    this.manifestPath$1 = manifestPath$1;
                }
            }, Resource$.MODULE$.closeableResource(), ManifestFactory$.MODULE$.classType(InputStream.class)).map((Function1)new Serializable(extractor){
                public static final long serialVersionUID = 0L;
                private final Function1 extractor$1;

                public final T apply(InputStream is) {
                    Manifest manifest = new Manifest(is);
                    return (T)this.extractor$1.apply((Object)manifest.getMainAttributes());
                }
                {
                    this.extractor$1 = extractor$1;
                }
            }).opt();
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void uk$gov$nationalarchives$csv$validator$ui$CsvValidatorUi$$displayWait(Function0<BoxedUnit> suspendUi, Function1<Function1<String, BoxedUnit>, BoxedUnit> action, Function1<String, BoxedUnit> output, Function0<BoxedUnit> resumeUi) {
        suspendUi.apply$mcV$sp();
        Future fAction = Future$.MODULE$.apply((Function0)new Serializable(action, output){
            public static final long serialVersionUID = 0L;
            private final Function1 action$1;
            private final Function1 output$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.action$1.apply((Object)this.output$1);
            }
            {
                this.action$1 = action$1;
                this.output$1 = output$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        fAction.onComplete((Function1)new Serializable(output, resumeUi){
            public static final long serialVersionUID = 0L;
            private final Function1 output$1;
            private final Function0 resumeUi$1;

            public final void apply(Try<BoxedUnit> x0$1) {
                Try<BoxedUnit> try_;
                block4: {
                    block3: {
                        block2: {
                            try_ = x0$1;
                            if (!(try_ instanceof Success)) break block2;
                            Swing$.MODULE$.onEDT(this.resumeUi$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(try_ instanceof Failure)) break block4;
                        Failure failure = (Failure)try_;
                        Throwable t = failure.exception();
                        t.printStackTrace();
                        this.output$1.apply((Object)t.toString());
                        Swing$.MODULE$.onEDT(this.resumeUi$1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(try_);
            }
            {
                this.output$1 = output$1;
                this.resumeUi$1 = resumeUi$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public void uk$gov$nationalarchives$csv$validator$ui$CsvValidatorUi$$validate(String csvFilePath, Charset csvEncoding, String csvSchemaFilePath, Charset csvSchemaEncoding, boolean failOnFirstError, List<Tuple2<String, String>> pathSubstitutions2, boolean enforceCaseSensitivePathChecks, Option<ProgressCallback> progress, boolean validateEncoding, Function1<String, BoxedUnit> output) {
        output.apply((Object)"");
        output.apply(CsvValidatorCmdApp$.MODULE$.validate(new TextFile((Path)Path$.MODULE$.fromString(csvFilePath), csvEncoding, validateEncoding), new TextFile((Path)Path$.MODULE$.fromString(csvSchemaFilePath), csvSchemaEncoding, TextFile$.MODULE$.apply$default$3()), failOnFirstError, pathSubstitutions2, enforceCaseSensitivePathChecks, false, progress)._1());
    }

    /*
     * WARNING - void declaration
     */
    public void uk$gov$nationalarchives$csv$validator$ui$CsvValidatorUi$$saveToFile(String s, File f) {
        PrintWriter printWriter = new PrintWriter(f);
        try {
            printWriter.write(s);
            printWriter.close();
            return;
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
    }

    public File settingsFile() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.settingsFile$lzycompute() : this.settingsFile;
    }

    public File userDir() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.userDir$lzycompute() : this.userDir;
    }

    public Option<CsvValidatorUi.Settings> uk$gov$nationalarchives$csv$validator$ui$CsvValidatorUi$$loadSettings() {
        None$ none$;
        if (this.settingsFile().exists()) {
            Properties props = new Properties();
            none$ = package$.MODULE$.managed((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final FileInputStream apply() {
                    return new FileInputStream(CsvValidatorUi$.MODULE$.settingsFile());
                }
            }, Resource$.MODULE$.closeableResource(), ManifestFactory$.MODULE$.classType(FileInputStream.class)).map((Function1)new Serializable(props){
                public static final long serialVersionUID = 0L;
                private final Properties props$1;

                public final CsvValidatorUi.Settings apply(FileInputStream is) {
                    this.props$1.load(is);
                    return new CsvValidatorUi.Settings(new File(this.props$1.getProperty("last.csv.path")), new File(this.props$1.getProperty("last.csv.uk.gov.nationalarchives.csv.validator.schema.path")), new File(this.props$1.getProperty("last.report.path")));
                }
                {
                    this.props$1 = props$1;
                }
            }).opt();
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void saveSettings(CsvValidatorUi.Settings settings) {
        Object object = this.settingsFile().exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.settingsFile().getParentFile().mkdirs());
        Properties props = new Properties();
        props.setProperty("last.csv.path", settings.lastCsvPath().getAbsolutePath());
        props.setProperty("last.csv.uk.gov.nationalarchives.csv.validator.schema.path", settings.lastCsvSchemaPath().getAbsolutePath());
        props.setProperty("last.report.path", settings.lastReportPath().getAbsolutePath());
        package$.MODULE$.managed((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FileOutputStream apply() {
                return new FileOutputStream(CsvValidatorUi$.MODULE$.settingsFile());
            }
        }, Resource$.MODULE$.closeableResource(), ManifestFactory$.MODULE$.classType(FileOutputStream.class)).map((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$2;

            public final void apply(FileOutputStream os) {
                this.props$2.store(os, "CSV Validator");
            }
            {
                this.props$2 = props$2;
            }
        }).opt().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Unit$ apply() {
                return Unit$.MODULE$;
            }
        });
    }

    public void updateLastPath(FileChooser fileChooser, Function1<File, CsvValidatorUi.Settings> sink) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)fileChooser.selectedFile());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    File selection = (File)some.x();
                    this.saveSettings((CsvValidatorUi.Settings)sink.apply((Object)selection.getParentFile()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    private CsvValidatorUi$() {
        MODULE$ = this;
    }
}

