/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.utf8.validator;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteCountingInputStream
extends FilterInputStream {
    private long byteCount = 0L;

    public ByteCountingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        this.byteCount += (long)read;
        return read;
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        ++this.byteCount;
        return c;
    }

    public long getByteCount() {
        return this.byteCount;
    }
}

