/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.utf8.validator;

import java.io.PrintStream;
import uk.gov.nationalarchives.utf8.validator.ValidationException;
import uk.gov.nationalarchives.utf8.validator.ValidationHandler;

public class PrintingValidationHandler
implements ValidationHandler {
    private final boolean failFast;
    private final PrintStream output;
    private boolean errored = false;

    public PrintingValidationHandler(boolean failFast, PrintStream output) {
        this.failFast = failFast;
        this.output = output;
    }

    @Override
    public void error(String message, long byteOffset) throws ValidationException {
        this.errored = true;
        if (this.failFast) {
            throw new ValidationException(message, byteOffset);
        }
        this.output.println("[ERROR] " + message + " @ byte position: " + byteOffset);
    }

    public boolean isErrored() {
        return this.errored;
    }
}

