/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.utf8.validator;

import java.io.File;
import java.io.IOException;
import uk.gov.nationalarchives.utf8.validator.ExitCode;
import uk.gov.nationalarchives.utf8.validator.PrintingValidationHandler;
import uk.gov.nationalarchives.utf8.validator.Utf8Validator;
import uk.gov.nationalarchives.utf8.validator.ValidationException;

public class Utf8ValidateCmd {
    static final String VERSION = "1.2";

    public static void main(String[] args) {
        File f;
        boolean failFast;
        if (args.length < 1) {
            System.out.println("UTF8 Validator version: 1.2");
            System.out.println("Useage: utf8validate [options] <file>");
            System.out.println("");
            System.out.println("\t-f | --fail-fast");
            System.out.println("\t\tStops on the first validation error rather than reporting all errors");
            System.out.println("");
            System.exit(ExitCode.INVALID_ARGS.getCode());
        }
        if (args[0].equals("-f") || args[0].equals("--fail-fast")) {
            failFast = true;
            f = new File(args[1]);
        } else {
            failFast = false;
            f = new File(args[0]);
        }
        if (!f.exists()) {
            System.out.println("File: " + f.getPath() + " does not exist!");
            System.exit(ExitCode.INVALID_ARGS.getCode());
        }
        PrintingValidationHandler handler = new PrintingValidationHandler(failFast, System.out);
        ExitCode result = ExitCode.OK;
        long start = System.currentTimeMillis();
        System.out.println("Validating: " + f.getPath());
        try {
            new Utf8Validator(handler).validate(f);
            if (!failFast && handler.isErrored()) {
                result = ExitCode.VALIDATION_ERROR;
            } else {
                System.out.println("Valid OK (took " + (System.currentTimeMillis() - start) + "ms)");
                result = ExitCode.OK;
            }
        }
        catch (ValidationException ve) {
            System.out.println(ve.getMessage());
            result = ExitCode.VALIDATION_ERROR;
        }
        catch (IOException ioe) {
            System.err.println("[ERROR]" + ioe.getMessage());
            result = ExitCode.IO_ERROR;
        }
        System.exit(result.getCode());
    }
}

