/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.utf8.validator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import uk.gov.nationalarchives.utf8.validator.ByteCountingInputStream;
import uk.gov.nationalarchives.utf8.validator.ValidationException;
import uk.gov.nationalarchives.utf8.validator.ValidationHandler;

public class Utf8Validator {
    private ValidationHandler handler;

    public Utf8Validator(ValidationHandler handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(File f) throws IOException, ValidationException {
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(f));
            this.validate(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void validate(InputStream is) throws IOException, ValidationException {
        ByteCountingInputStream bis = new ByteCountingInputStream(is);
        BitSet fourByteChar = new BitSet(8);
        fourByteChar.set(0, 4);
        BitSet threeByteChar = new BitSet(8);
        threeByteChar.set(0, 3);
        BitSet twoByteChar = new BitSet(8);
        twoByteChar.set(0, 2);
        int b = -1;
        while ((b = bis.read()) > -1) {
            BitSet bs = this.toBitSet((byte)b);
            if (this.startsWith(bs, fourByteChar)) {
                this.checkRemainingBytes(bis, 3);
                continue;
            }
            if (this.startsWith(bs, threeByteChar)) {
                this.checkRemainingBytes(bis, 2);
                continue;
            }
            if (this.startsWith(bs, twoByteChar)) {
                this.checkRemainingBytes(bis, 1);
                continue;
            }
            this.checkSingleByteChar(bs, bis.getByteCount());
        }
    }

    private void checkSingleByteChar(BitSet bs, long byteOffset) throws ValidationException {
        if (bs.get(0)) {
            this.handler.error("Invalid single byte UTF-8 character ", byteOffset);
        }
    }

    private void checkRemainingBytes(ByteCountingInputStream is, int nRemainingBytes) throws IOException, ValidationException {
        byte[] remain = new byte[nRemainingBytes];
        int read = is.read(remain);
        if (read != nRemainingBytes) {
            this.handler.error("Invalid UTF-8 Sequence, expecting: " + (nRemainingBytes + 1) + "bytes, but got: " + (read + 1) + "bytes - reached end of stream.", -1L);
        }
        for (int i = 0; i < nRemainingBytes; ++i) {
            BitSet bs = this.toBitSet(remain[i]);
            if (bs.get(0) && !bs.get(1)) continue;
            this.handler.error("Invalid UTF-8 sequence, byte " + (i + 2) + " of " + (nRemainingBytes + 1) + " byte multibyte sequence.", is.getByteCount() - (long)nRemainingBytes + (long)i + 1L);
        }
    }

    private boolean startsWith(BitSet bs, BitSet cmp) {
        BitSet nCmp = (BitSet)cmp.clone();
        nCmp.and(bs);
        return nCmp.equals(cmp);
    }

    private BitSet toBitSet(byte b) {
        BitSet bs = new BitSet(8);
        for (int i = 0; i < 8; ++i) {
            if ((b & 1 << i % 8) <= 0) continue;
            bs.set(8 - i - 1);
        }
        return bs;
    }
}

